/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;

class Ruler
extends JComponent {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int SIZE = 30;
    public int orientation;
    private int increment;
    private int units;
    private double scale = 1.0;

    public Ruler(int n) {
        this.orientation = n;
        this.increment = this.units = 80;
    }

    public void setScale(double d) {
        this.scale = d;
    }

    public int getIncrement() {
        return this.increment;
    }

    public void setPreferredHeight(int n) {
        this.setPreferredSize(new Dimension(30, n));
    }

    public void setPreferredWidth(int n) {
        this.setPreferredSize(new Dimension(n, 30));
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.orientation == 0) {
            graphics2D.scale(this.scale, 1.0);
        } else {
            graphics2D.scale(1.0, this.scale);
        }
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(Color.lightGray);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(Color.black);
        int n = 0;
        int n2 = 0;
        int n3 = 7;
        String string = null;
        if (this.orientation == 0) {
            n2 = rectangle.x / this.increment * this.increment;
            n = ((rectangle.x + rectangle.width) / this.increment + 1) * this.increment;
        } else {
            n2 = rectangle.y / this.increment * this.increment;
            n = ((rectangle.y + rectangle.height) / this.increment + 1) * this.increment;
        }
        if (n2 == 0) {
            n3 = 10;
            if (this.orientation == 0) {
                graphics.drawLine(0, 29, 0, 30 - n3 - 1);
            } else {
                graphics.drawLine(29, 0, 30 - n3 - 1, 0);
            }
            n2 = this.increment;
        }
        for (int i = n2; i < n; i += this.increment) {
            if (i % this.units == 0) {
                n3 = 10;
                string = Integer.toString(i / this.units);
            } else {
                n3 = 7;
                string = null;
            }
            if (n3 == 0) continue;
            if (this.orientation == 0) {
                graphics.drawLine(i, 29, i, 30 - n3 - 1);
                if (string == null) continue;
                graphics.drawString(string, i - 3, 16);
                continue;
            }
            graphics.drawLine(29, i, 30 - n3 - 1, i);
            if (string == null) continue;
            graphics.drawString(string, 6, i + 3);
        }
    }
}

