/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFCommon;
import com.platform.LSFJobFlow.api.JFConfigManager;
import com.platform.LSFJobFlow.api.JFEvent;
import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFFilter;
import com.platform.LSFJobFlow.api.JFFlow;
import com.platform.LSFJobFlow.api.JFFlowInstance;
import com.platform.LSFJobFlow.api.JFFlowManager;
import com.platform.LSFJobFlow.api.JFHandler;
import com.platform.LSFJobFlow.api.JFJob;
import com.platform.LSFJobFlow.api.JFJobArray;
import com.platform.LSFJobFlow.api.JFJobArrayInstance;
import com.platform.LSFJobFlow.api.JFJobInstance;
import com.platform.LSFJobFlow.api.JFLoginManager;
import com.platform.LSFJobFlow.api.JFPseudoFlowInstance;
import com.platform.LSFJobFlow.api.JFUser;
import com.platform.LSFJobFlow.api.JFVersion;
import com.platform.LSFJobFlow.ui.Debug;
import com.platform.LSFJobFlow.ui.JFErrorMsgDialog;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.login.FailedLoginException;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;

public class JFUtility {
    public static final String GLOBAL_VIEW = JFResourceBundle.getString("HEADER_GLOBAL_VIEW");
    public static final String INTERNAL_INVALID = "INTERNAL_INVALID";
    public static final String INTERNAL_IN_GLOBAL_VIEW = "INTERNAL_IN_GLOBAL_VIEW";
    public static final String INTERNAL_ONHOLD_STATE = "INTERNAL_ONHOLD_STATE";
    private static boolean s_isAIX_JRE1_3_x = false;
    private static boolean s_isLinux = false;
    private static final int MAX_SUBSTITUTIONS = 10;
    private static final String VARIABLE_DELIMITER_BEGIN = "#{";
    private static final String VARIABLE_DELIMITER_END = "}";

    public static boolean isAIX_JRE_1_3_x() {
        return s_isAIX_JRE1_3_x;
    }

    public static boolean isLinux() {
        return s_isLinux;
    }

    public static void showPopup(JPopupMenu p, Component c, int x, int y) {
        if (null == p || null == c) {
            return;
        }
        Point pt = c.getLocationOnScreen();
        int mx = pt.x + x;
        int my = pt.y + y;
        Dimension sizePopup = p.getPreferredSize();
        Dimension sizeScreen = Toolkit.getDefaultToolkit().getScreenSize();
        if (null == sizePopup || null == sizeScreen) {
            return;
        }
        if (mx + sizePopup.width > sizeScreen.width) {
            x -= sizePopup.width;
        }
        if (my + sizePopup.height > sizeScreen.height) {
            y -= sizePopup.height;
        }
        if (my < 0) {
            y = -pt.y + 5;
        }
        p.show(c, x, y);
    }

    public static boolean isValidJobFlowIdentity(String name) {
        return JFUtility.isValidJobFlowIdentity(name, false);
    }

    public static boolean isValidJobFlowIdentity(String name, boolean allowVarInName) {
        if (name == null || name.length() == 0) {
            return false;
        }
        if (!(allowVarInName || name.indexOf(VARIABLE_DELIMITER_BEGIN) < 0 && name.indexOf(VARIABLE_DELIMITER_END) < 0)) {
            return false;
        }
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            if (JFUtility.isValidCharForJobFlowIdentity(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidFlowNameIdentity(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        if (name.indexOf(VARIABLE_DELIMITER_BEGIN) >= 0 || name.indexOf(VARIABLE_DELIMITER_END) >= 0) {
            return false;
        }
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            if (JFUtility.isValidCharForJobFlowIdentity(c)) continue;
            return false;
        }
        return true;
    }

    public static String makeValidJobFlowIdentity(String nameStr, char subChar) {
        if (nameStr == null) {
            return null;
        }
        if (!JFUtility.isValidCharForJobFlowIdentity(subChar)) {
            return null;
        }
        int slen = nameStr.length();
        for (int i = 0; i < slen; ++i) {
            char c = nameStr.charAt(i);
            if (JFUtility.isValidCharForJobFlowIdentity(c)) continue;
            nameStr = nameStr.replace(c, subChar);
        }
        return nameStr;
    }

    private static boolean isValidCharForJobFlowIdentity(char c) {
        return Character.isLetterOrDigit(c) || c == '_' || c == '-' || c == '.' || c == '#' || c == '{' || c == '}' || c >= '\u0080';
    }

    public static boolean isValidProxyEventName(String name) {
        return JFEvent.isValidProxyName((String)name);
    }

    public static void registerApplicationName(String applicationName) {
        System.setProperty("app.name", applicationName);
    }

    public static String getErrMsgTitle() {
        return System.getProperty("app.name", JFResourceBundle.getString("Message"));
    }

    public static void showAppException(Component parentComponent, Exception exception) {
        if (exception == null) {
            return;
        }
        Frame mainFrame = JFUtility.getMainFrame(parentComponent);
        JFErrorMsgDialog errorDlg = new JFErrorMsgDialog(mainFrame, exception);
        errorDlg.setLocationRelativeTo(mainFrame);
        errorDlg.show();
        Debug.printStackTrace(exception);
    }

    public static void showAppErrorMsg(Component parentComponent, String errorMsg) {
        JFUtility.showAppErrorMsg(parentComponent, errorMsg, null);
    }

    public static void showAppErrorMsg(Component parentComponent, String errorMsg, String title) {
        if (errorMsg == null) {
            return;
        }
        Frame mainFrame = JFUtility.getMainFrame(parentComponent);
        JFErrorMsgDialog errorDlg = new JFErrorMsgDialog(mainFrame, errorMsg);
        errorDlg.setLocationRelativeTo(mainFrame);
        if (title != null) {
            errorDlg.setTitle(title);
        }
        errorDlg.show();
    }

    public static void showAppInfoMsg(Component parentComponent, String message) {
        String title = System.getProperty("app.name", JFResourceBundle.getString("Information"));
        JOptionPane optionPane = new JOptionPane(message, 1);
        JDialog dialog = optionPane.createDialog(parentComponent, title);
        dialog.setResizable(false);
        dialog.show();
    }

    public static void showAppWarningMsg(Component parentComponent, String message) {
        JFUtility.showAppWarningMsg(parentComponent, message, null);
    }

    public static void showAppWarningMsg(Component parentComponent, String message, String title) {
        if (title == null) {
            title = System.getProperty("app.name", JFResourceBundle.getString("Warning"));
        }
        JOptionPane optionPane = new JOptionPane(message, 2);
        JDialog dialog = optionPane.createDialog(parentComponent, title);
        dialog.setResizable(false);
        dialog.show();
    }

    public static String getShortInstanceName(String name) {
        if (name == null) {
            return null;
        }
        int lastIndex = name.lastIndexOf(":");
        if (lastIndex != -1) {
            return name.substring(lastIndex + 1, name.length());
        }
        return name;
    }

    public static String decodeXML(String attrString) {
        String ret = JFUtility.replaceString(attrString, "&amp;", "&");
        ret = JFUtility.replaceString(ret, "&lt;", "<");
        ret = JFUtility.replaceString(ret, "&gt;", ">");
        ret = JFUtility.replaceString(ret, "&quot;", "\"");
        ret = JFUtility.replaceString(ret, "&apos;", "'");
        ret = JFUtility.replaceString(ret, "<newline>", " ");
        return ret;
    }

    static String replaceString(String oldstring, String substr0, String substr1) {
        if (oldstring == null) {
            return null;
        }
        if (substr0 == null || substr0.length() <= 0 || substr1 == null) {
            return oldstring;
        }
        int len0 = substr0.length();
        int len1 = substr1.length();
        StringBuffer ret = new StringBuffer();
        int index = 0;
        for (String curstring = oldstring; curstring != null; curstring = curstring.substring(index + len0)) {
            index = curstring.indexOf(substr0);
            if (index < 0) {
                ret.append(curstring);
                break;
            }
            ret.append(curstring.substring(0, index));
            ret.append(substr1);
        }
        return ret.toString();
    }

    public static int getIndex(String[] array, String item) {
        if (array == null || array.length == 0 || item == null) {
            return -1;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!item.equals(array[i])) continue;
            return i;
        }
        return -1;
    }

    public static Frame getMainFrame(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof Frame) {
            return (Frame)component;
        }
        for (Container parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof Frame)) continue;
            return (Frame)parent;
        }
        return null;
    }

    public static boolean disableFlowArray() {
        return false;
    }

    public static boolean isValidExpression(String expr, int min, int max) {
        if (expr == null || expr.length() == 0) {
            return false;
        }
        expr.trim();
        if (expr.equals("*")) {
            return true;
        }
        StringTokenizer tokens = new StringTokenizer(expr, ",");
        String token = null;
        int val = 0;
        int val2 = 0;
        int len = 0;
        int idx = 0;
        String item1 = null;
        String item2 = null;
        for (int i = 0; i < expr.length(); ++i) {
            if (expr.charAt(i) != ',') continue;
            ++val;
        }
        if (val + 1 != tokens.countTokens()) {
            return false;
        }
        while (tokens.hasMoreTokens()) {
            token = tokens.nextToken();
            if (token == null || token.length() == 0) {
                return false;
            }
            token.trim();
            if (token.indexOf(43) != -1) {
                return false;
            }
            idx = token.indexOf(45);
            len = token.length();
            if (idx == 0 || idx == len) {
                return false;
            }
            if (idx != -1) {
                item1 = token.substring(0, idx);
                item2 = token.substring(idx + 1, len);
            } else {
                item1 = token;
                item2 = null;
            }
            try {
                val = Integer.parseInt(item1, 10);
                if (val < min || val > max) {
                    return false;
                }
                if (item2 == null || (val2 = Integer.parseInt(item2, 10)) > val && val2 <= max) continue;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public static boolean hasRerunHandler(JFJob def) {
        if (def == null) {
            return false;
        }
        JFHandler[] handlers = def.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            if (handlers[i].getAction() != 1) continue;
            return true;
        }
        return false;
    }

    public static boolean hasRerunHandler(JFJobInstance instance) {
        if (instance == null) {
            return false;
        }
        return JFUtility.hasRerunHandler(instance.getJobDefinition());
    }

    public static boolean hasRerunHandler(JFJobArray def) {
        if (def == null) {
            return false;
        }
        JFJob jobDef = def.getJobDefinition();
        if (jobDef == null) {
            return false;
        }
        JFHandler[] handlers = jobDef.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            if (handlers[i].getAction() != 1) continue;
            return true;
        }
        return false;
    }

    public static boolean hasRerunHandler(JFJobArrayInstance instance) {
        if (instance == null) {
            return false;
        }
        return JFUtility.hasRerunHandler(instance.getJobArrayDefinition());
    }

    public static boolean hasRerunHandler(JFFlow def) {
        if (def == null) {
            return false;
        }
        JFHandler[] handlers = def.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            if (handlers[i].getAction() != 1) continue;
            return true;
        }
        return false;
    }

    public static boolean hasRerunHandler(JFFlowInstance instance) {
        if (instance == null) {
            return false;
        }
        return JFUtility.hasRerunHandler(instance.getFlowDefinition());
    }

    public static String alignString(String s, int len) {
        if (s == null) {
            s = "";
        }
        if (s.length() >= len) {
            return "*" + s.substring(s.length() - len + 2) + " ";
        }
        char[] spaces = new char[len];
        Arrays.fill(spaces, ' ');
        return (s + new String(spaces)).substring(0, len - 1) + " ";
    }

    public static String getUserByFlowName(String flowName) {
        if (flowName == null) {
            return null;
        }
        String user = null;
        int idx = flowName.indexOf(58);
        user = idx != -1 ? flowName.substring(0, idx) : JFLoginManager.getUserName();
        return user;
    }

    public static void login(Component parentComponent) throws Exception {
        while (true) {
            try {
                JFLoginManager.login((boolean)false);
            }
            catch (FailedLoginException e) {
                if (!JFConfigManager.isExternalLogin()) {
                    throw e;
                }
                JFUtility.showAppException(parentComponent, e);
                continue;
            }
            break;
        }
    }

    public static String getTemplateCaption(String captionKey) {
        if (captionKey == null) {
            return null;
        }
        String caption = JFResourceBundle.getString("JFTemplateTableModel$MSG_" + captionKey);
        if (caption == null || caption.equals("") || caption.equals("JFTemplateTableModel$MSG_" + captionKey)) {
            return captionKey;
        }
        return caption;
    }

    public static List getPseudoFlowInstanceList(String userid, Set flowNames, int count, boolean noUnknownStates) throws JFException, IOException {
        JFFilter userFilter = null;
        if (userid != null && userid.length() != 0) {
            userFilter = new JFFilter();
            userFilter.setUser(userid);
        }
        JFFlowManager flowMgr = new JFFlowManager();
        Object[] pseudoInstances = flowMgr.getPseudoInstances(userFilter);
        Arrays.sort(pseudoInstances);
        boolean oldServer = false;
        JFVersion sVersion = JFConfigManager.getServerVersion((boolean)false);
        if (sVersion != null && sVersion.compareTo("6.1") < 0) {
            oldServer = true;
        }
        int numInstances = pseudoInstances.length;
        HashMap<String, Integer> flowCountMap = new HashMap<String, Integer>();
        ArrayList<Object> pseudoInstanceList = new ArrayList<Object>();
        int flowCount = 0;
        for (int i = numInstances - 1; i >= 0; --i) {
            Object aPseudoInstance = pseudoInstances[i];
            if (noUnknownStates && aPseudoInstance.getState() > 6) continue;
            String thisFlowName = aPseudoInstance.getFlowName();
            String normalizedName = JFUtility.normalizeFlowName(thisFlowName);
            if (flowNames != null && !flowNames.contains(normalizedName)) continue;
            Object o = flowCountMap.get(thisFlowName);
            flowCount = o == null ? 1 : (Integer)o + 1;
            flowCountMap.put(thisFlowName, new Integer(flowCount));
            if (count != 0 && flowCount > count) continue;
            if (!oldServer) {
                pseudoInstanceList.add(aPseudoInstance);
                continue;
            }
            JFFlowInstance fi = flowMgr.getInstance(aPseudoInstance.getInstanceId());
            pseudoInstanceList.add(new JFPseudoFlowInstance(fi));
        }
        return pseudoInstanceList;
    }

    public static String normalizeFlowName(String flowName) {
        if (flowName == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(flowName, ":");
        if (tok.countTokens() < 2) {
            return flowName;
        }
        String user = tok.nextToken();
        String flow = tok.nextToken();
        String jsUser = new JFUser(user).toJSUserName();
        int posDomain = jsUser.indexOf("\\");
        if (posDomain == -1) {
            return jsUser + ":" + flow;
        }
        String domain = jsUser.substring(0, posDomain);
        String userOnly = jsUser.substring(posDomain + 1);
        return domain.toUpperCase() + "\\" + userOnly.toLowerCase() + ":" + flow;
    }

    public static String substituteVariables(String strIn, Properties props, String defaultValue) {
        int pos2;
        int pos1;
        String strOut = strIn;
        int nSearchPos = strOut.length();
        for (int nCount = 0; nCount < 10 && (pos1 = strOut.lastIndexOf(VARIABLE_DELIMITER_BEGIN, nSearchPos)) != -1 && (pos2 = strOut.indexOf(VARIABLE_DELIMITER_END, pos1 + 2)) != -1; ++nCount) {
            String strPrefix = strOut.substring(0, pos1);
            String strVar = strOut.substring(pos1 + VARIABLE_DELIMITER_BEGIN.length(), pos2);
            String strSuffix = strOut.substring(pos2 + VARIABLE_DELIMITER_END.length());
            String strValue = defaultValue;
            if (props != null) {
                strValue = props.getProperty(strVar, defaultValue);
            }
            if (strValue == null) {
                strValue = props != null && JFConfigManager.isDefaultEmptyValueEnabled() ? "" : VARIABLE_DELIMITER_BEGIN + strVar + VARIABLE_DELIMITER_END;
            }
            strOut = strPrefix + strValue + strSuffix;
            nSearchPos = pos1 - 1;
        }
        return strOut;
    }

    public static boolean verifyNonZeroCodes(JTextField input) {
        int val = 0;
        String value = null;
        value = input.getText();
        if (value != null) {
            String[] values = value.split(" ");
            value = "";
            for (int i = 0; i < values.length; ++i) {
                values[i] = values[i].trim();
                if (values[i].length() <= 0) continue;
                value = value + values[i] + " ";
                try {
                    if (JFCommon.isValidVarRef((String)values[i], (String)"\\d*") || (val = Integer.parseInt(values[i])) <= 255 && val >= 1) continue;
                    throw new Exception();
                }
                catch (JFException jfe) {
                    JFUtility.showAppErrorMsg(input, jfe.getMessage());
                    return false;
                }
                catch (Exception e) {
                    JFUtility.showAppErrorMsg(input, JFResourceBundle.getString("ERR_nonZeroCodesFLD"));
                    return false;
                }
            }
            input.setText(value.trim());
        }
        return true;
    }

    public static boolean verifyArbitraryString(JTextField input) {
        String value = null;
        value = input.getText();
        if (value != null) {
            value = value.trim();
            input.setText(value);
            if (value.length() > 0) {
                try {
                    if (JFCommon.isValidVarRef((String)value, (String)".*")) {
                        return true;
                    }
                }
                catch (JFException jfe) {
                    JFUtility.showAppErrorMsg(input, jfe.getMessage());
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean verifyPositiveInteger(JTextField input, String msg) {
        int val = 0;
        String value = null;
        value = input.getText();
        if (value != null) {
            value = value.trim();
            input.setText(value);
            if (value.length() > 0) {
                try {
                    if (JFCommon.isValidVarRef((String)value, (String)"\\d*")) {
                        return true;
                    }
                    val = Integer.parseInt(value);
                    if (val <= 0) {
                        throw new Exception();
                    }
                }
                catch (JFException jfe) {
                    JFUtility.showAppErrorMsg(input, jfe.getMessage());
                    return false;
                }
                catch (Exception e) {
                    JFUtility.showAppErrorMsg(input, msg);
                    return false;
                }
            }
        }
        return true;
    }

    static {
        String jreVersion = System.getProperty("java.version");
        String os = System.getProperty("os.name");
        if (!jreVersion.startsWith("1.4") && os.toUpperCase().startsWith("AIX")) {
            s_isAIX_JRE1_3_x = true;
        }
        if (os.toUpperCase().startsWith("LINUX")) {
            s_isLinux = true;
        }
    }
}

