/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSF.security.LSFUser;
import com.platform.LSFJobFlow.api.JFLoginManager;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.security.Principal;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class JFUsernamePasswordDialog
extends JDialog {
    private String m_username;
    private char[] m_password;
    private boolean m_cancelled = false;
    private JPanel jPanel1;
    private JButton m_Cancel;
    private JButton m_OK;
    private JPasswordField m_passwordBox;
    private JLabel m_passwordLabel;
    private JTextField m_usernameBox;
    private JLabel m_usernameLabel;

    public JFUsernamePasswordDialog(Frame frame) {
        super(frame, true);
        this.initComponents();
        try {
            Set<Principal> set = JFLoginManager.getOldSubject().getPrincipals();
            if (!set.isEmpty()) {
                this.m_username = ((LSFUser)set.iterator().next()).getName();
            }
        }
        catch (Exception exception) {
            this.m_username = null;
            this.m_password = null;
        }
        this.m_usernameBox.setText(this.m_username);
        this.m_passwordBox.setText(null);
        this.getRootPane().setDefaultButton(this.m_OK);
        this.m_usernameBox.requestFocus();
    }

    public String getUsername() {
        return this.m_username;
    }

    public char[] getPassword() {
        return this.m_password;
    }

    public boolean cancelled() {
        return this.m_cancelled;
    }

    private void initComponents() {
        this.m_usernameBox = new JTextField();
        this.m_usernameLabel = new JLabel();
        this.m_passwordLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.m_OK = new JButton();
        this.m_Cancel = new JButton();
        this.m_passwordBox = new JPasswordField();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle(JFResourceBundle.getString("Login"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                JFUsernamePasswordDialog.this.closeDialog(windowEvent);
            }
        });
        this.m_usernameBox.setColumns(20);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.m_usernameBox, gridBagConstraints);
        this.m_usernameLabel.setText(JFResourceBundle.getString("User_name_"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.m_usernameLabel, gridBagConstraints);
        this.m_passwordLabel.setText(JFResourceBundle.getString("Password_"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.m_passwordLabel, gridBagConstraints);
        this.m_OK.setText(JFResourceBundle.getString("OK"));
        this.m_OK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFUsernamePasswordDialog.this.m_OKActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.m_OK);
        this.m_Cancel.setText(JFResourceBundle.getString("Cancel"));
        this.m_Cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFUsernamePasswordDialog.this.m_CancelActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.m_Cancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.m_passwordBox, gridBagConstraints);
        this.pack();
    }

    private void m_CancelActionPerformed(ActionEvent actionEvent) {
        this.m_cancelled = true;
        this.setVisible(false);
        this.dispose();
    }

    private void m_OKActionPerformed(ActionEvent actionEvent) {
        this.m_username = new String(this.m_usernameBox.getText());
        this.m_password = this.m_passwordBox.getPassword();
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.m_cancelled = true;
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] stringArray) {
    }
}

