/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFTemplateDef;
import com.platform.LSFJobFlow.api.JFTemplateManager;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class JFTemplateSelectionDialog
extends JDialog {
    public static final String ARRAY_STRING = " (Array)";
    private JFTemplateDef[] m_templateDef;
    private DefaultListModel listModel;
    private JLabel JFTemplateSelectionDialogLabel;
    private JScrollPane JFTemplateSelectionScrollPane;
    private JList JFTemplateSelectionList;
    private JPanel jPanel1;
    private JButton OKButton;
    private JButton CancelButton;

    public JFTemplateSelectionDialog(Frame frame) {
        super(frame, true);
        this.initComponents();
        this.populateList();
        this.getRootPane().setDefaultButton(this.CancelButton);
    }

    private void populateList() {
        this.listModel = new DefaultListModel();
        this.m_templateDef = JFTemplateManager.getInstance().getTemplates();
        int n = this.m_templateDef.length;
        for (int i = 0; i < n; ++i) {
            this.listModel.addElement(this.m_templateDef[i].getName());
            if (!this.m_templateDef[i].isSupportArray()) continue;
            this.listModel.addElement(this.m_templateDef[i].getName() + ARRAY_STRING);
        }
        this.JFTemplateSelectionList.setModel(this.listModel);
    }

    public boolean isArraySelected() {
        return ((String)this.JFTemplateSelectionList.getSelectedValue()).endsWith(ARRAY_STRING);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    public JFTemplateDef getSelectedTemplate() {
        String string = (String)this.JFTemplateSelectionList.getSelectedValue();
        if (string != null) {
            string = this.removeSuffix(string, ARRAY_STRING);
            return JFTemplateManager.getInstance().getTemplate(string);
        }
        return null;
    }

    private String removeSuffix(String string, String string2) {
        if (this.isArraySelected()) {
            int n = string.length() - string2.length();
            return string.substring(0, n);
        }
        return string;
    }

    private void initComponents() {
        this.JFTemplateSelectionDialogLabel = new JLabel();
        this.JFTemplateSelectionScrollPane = new JScrollPane();
        this.JFTemplateSelectionList = new JList();
        this.jPanel1 = new JPanel();
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle(JFResourceBundle.getString("Insert_Application"));
        this.setModal(true);
        this.setName("JFTemplate");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                JFTemplateSelectionDialog.this.closeDialog(windowEvent);
            }
        });
        this.JFTemplateSelectionDialogLabel.setText(JFResourceBundle.getString("Available_applications"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 36;
        gridBagConstraints.ipady = 14;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.JFTemplateSelectionDialogLabel, gridBagConstraints);
        this.JFTemplateSelectionScrollPane.setBackground(Color.white);
        this.JFTemplateSelectionScrollPane.setPreferredSize(new Dimension(50, 50));
        this.JFTemplateSelectionScrollPane.getViewport().setView(this.JFTemplateSelectionList);
        this.JFTemplateSelectionList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"test1", "test2", "test3", "test4", "test5", "test6", "a", "b", "c"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int n) {
                return this.strings[n];
            }
        });
        this.JFTemplateSelectionList.setSelectionMode(0);
        this.JFTemplateSelectionScrollPane.setViewportView(this.JFTemplateSelectionList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 260;
        gridBagConstraints.ipady = 50;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.JFTemplateSelectionScrollPane, gridBagConstraints);
        this.OKButton.setText(JFResourceBundle.getString("OK"));
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFTemplateSelectionDialog.this.OKButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.OKButton);
        this.CancelButton.setText(JFResourceBundle.getString("Cancel"));
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFTemplateSelectionDialog.this.CancelButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.CancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void OKButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void CancelButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] stringArray) {
        new JFTemplateSelectionDialog(new JFrame()).show();
    }
}

