/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.ui.JFPrintOptionsManager;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.text.MessageFormat;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;

public class JFTablePrinter
implements Printable {
    private static final int COLUMN_INTERVAL = 2;
    private static final int HEADER_INTERVAL = 10;
    private static final int ROW_INTERVAL = 5;
    private JTable m_table;
    private String m_title;
    private int m_maxNumPage = 20;
    private Font m_titleFont;
    private Font m_headerFont;
    private Font m_tableFont;
    private int m_titleY = 0;
    private int m_headerY = 0;
    private int m_tableY = 0;
    private int m_rowsPerPage = 0;
    private int m_contentRowH = 0;
    private int m_pageNumberFontHeight = 0;
    private int hPage = 0;
    private int wPage = 0;

    public JFTablePrinter(JTable jTable, String string) {
        if (jTable == null) {
            throw new NullPointerException(JFResourceBundle.getString("Parameter_printTable_is_null!"));
        }
        if (string == null) {
            throw new NullPointerException(JFResourceBundle.getString("Parameter_title_is_null!"));
        }
        this.m_table = jTable;
        this.m_title = string;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        Object object;
        Object object2;
        int n2;
        if (n == 0) {
            this.m_pageNumberFontHeight = 0;
            if (JFPrintOptionsManager.getInstance().isPrintPageNumber()) {
                this.m_pageNumberFontHeight = graphics.getFontMetrics().getHeight() + 2;
            }
            this.wPage = (int)pageFormat.getImageableWidth();
            this.hPage = (int)pageFormat.getImageableHeight() - this.m_pageNumberFontHeight;
            this.m_tableFont = this.m_table.getFont();
            this.m_titleFont = this.m_tableFont.deriveFont(1, 18.0f);
            this.m_headerFont = this.m_tableFont.deriveFont(1);
            graphics.setFont(this.m_titleFont);
            this.m_titleY = graphics.getFontMetrics().getAscent();
            int n3 = graphics.getFontMetrics().getDescent();
            graphics.setFont(this.m_headerFont);
            this.m_headerY = this.m_titleY + n3 + 10 + graphics.getFontMetrics().getAscent();
            n3 = graphics.getFontMetrics().getDescent();
            graphics.setFont(this.m_tableFont);
            this.m_tableY = this.m_headerY + n3 + 5 + graphics.getFontMetrics().getAscent();
            this.m_contentRowH = graphics.getFontMetrics().getHeight() + 5;
            this.m_rowsPerPage = (this.hPage - this.m_headerY - n3) / this.m_contentRowH;
            this.m_maxNumPage = Math.max((int)Math.ceil((double)this.m_table.getRowCount() / (double)this.m_rowsPerPage), 1);
        }
        if (n >= this.m_maxNumPage) {
            return 1;
        }
        graphics.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        graphics.setColor(Color.black);
        graphics.setFont(this.m_titleFont);
        graphics.drawString(this.m_title, 0, this.m_titleY);
        graphics.setFont(this.m_headerFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        TableColumnModel tableColumnModel = this.m_table.getColumnModel();
        int[] nArray = this.getTableColumnWidth(tableColumnModel, this.wPage);
        int[] nArray2 = this.getTableColumnPositionX(nArray);
        int n4 = tableColumnModel.getColumnCount();
        for (n2 = 0; n2 < n4; ++n2) {
            object2 = (String)tableColumnModel.getColumn(n2).getIdentifier();
            object2 = this.getPrintString((String)object2, nArray[n2], fontMetrics);
            graphics.drawString((String)object2, nArray2[n2], this.m_headerY);
        }
        graphics.setFont(this.m_tableFont);
        fontMetrics = graphics.getFontMetrics();
        object2 = this.m_table.getModel();
        int n5 = n * this.m_rowsPerPage;
        int n6 = Math.min(this.m_table.getRowCount(), n5 + this.m_rowsPerPage);
        int n7 = this.m_tableY;
        for (int i = n5; i < n6; ++i) {
            for (n2 = 0; n2 < n4; ++n2) {
                object = object2.getValueAt(i, n2).toString();
                object = this.getPrintString((String)object, nArray[n2], fontMetrics);
                graphics.drawString((String)object, nArray2[n2], n7);
            }
            n7 += this.m_contentRowH;
        }
        if (this.m_pageNumberFontHeight > 0) {
            object = new Object[]{String.valueOf(n + 1)};
            String string = JFResourceBundle.getString("Page_A");
            MessageFormat messageFormat = new MessageFormat(string);
            graphics.drawString(messageFormat.format(object), 0, this.hPage + this.m_pageNumberFontHeight - graphics.getFontMetrics().getDescent());
        }
        System.gc();
        return 0;
    }

    private int[] getTableColumnWidth(TableColumnModel tableColumnModel, int n) {
        if (tableColumnModel == null) {
            return null;
        }
        int n2 = tableColumnModel.getColumnCount();
        int n3 = n - 2 * (n2 - 1);
        int[] nArray = new int[n2];
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            nArray[i] = tableColumnModel.getColumn(i).getWidth();
            n4 += nArray[i];
        }
        int[] nArray2 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray2[i] = (int)((double)(nArray[i] * n) / (double)n4);
        }
        return nArray2;
    }

    private int[] getTableColumnPositionX(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return null;
        }
        int n = nArray.length;
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = i == 0 ? 0 : nArray2[i - 1] + nArray[i - 1] + 2;
        }
        return nArray2;
    }

    private String getPrintString(String string, int n, FontMetrics fontMetrics) {
        if (string == null) {
            return null;
        }
        if (fontMetrics == null) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        while (fontMetrics.charsWidth(cArray, 0, n2) > n && --n2 > 0) {
        }
        if (n2 > 0 && n2 != cArray.length) {
            cArray[n2 - 1] = 42;
        }
        return new String(cArray, 0, n2);
    }
}

