/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFDynamicFlow;
import com.platform.LSFJobFlow.api.JFFlow;
import com.platform.LSFJobFlow.api.JFJob;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import com.platform.LSFJobFlow.ui.JFUtility;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class JFStandardOutputBean
extends JPanel {
    public static final String DEFAULT_STDERR_FILE = "error.#{JS_FLOW_FULL_NAME}.%J";
    public static final String DEFAULT_STDOUT_FILE = "output.#{JS_FLOW_FULL_NAME}.%J";
    public static final String DEFAULT_LOCAL_STDERR_FILE = "error.#{JS_FLOW_FULL_NAME}";
    public static final String DEFAULT_LOCAL_STDOUT_FILE = "output.#{JS_FLOW_FULL_NAME}";
    public static final int JOB_TYPE_LSF = 0;
    public static final int JOB_TYPE_LOCAL = 1;
    public static final int JOB_TYPE_ARRAY = 2;
    public boolean isWindows = false;
    private JLabel autoIndexStderrLabel;
    private JLabel autoIndexStdoutLabel;
    private ButtonGroup createStderrButtonGroup;
    private JLabel createStderrLabel;
    private ButtonGroup createStdoutButtonGroup;
    private JLabel createStdoutLabel;
    private JLabel directoryStderrLabel;
    private JLabel directoryStdoutLabel;
    private JPanel dynamicStderrPanel;
    private JPanel dynamicStdoutPanel;
    private ButtonGroup dynamicSubFlowStderrButtonGroup;
    private ButtonGroup dynamicSubFlowStdoutButtonGroup;
    private JPanel fileErrorDetailsPanel;
    private JPanel fileOutputDetailsPanel;
    private JLabel filenameStderrLabel;
    private JLabel filenameStdoutLabel;
    private JPanel overrideErrorPanel;
    private JPanel overrideOutputPanel;
    private JRadioButton overrideParentStderrRadioBtn;
    private JRadioButton overrideParentStdoutRadioBtn;
    private JCheckBox overrideStderrCheckbox;
    private JCheckBox overrideStdoutCheckbox;
    private JCheckBox stderrAutoIndexCheckbox;
    private JTextField stderrDirTextbox;
    private JRadioButton stderrDisableCreate;
    private JRadioButton stderrEnableCreate;
    private JTextField stderrFileTextbox;
    private JLabel stderrFileTitle;
    private JPanel stderrPanel;
    private JCheckBox stdoutAutoIndexCheckbox;
    private JTextField stdoutDirTextbox;
    private JRadioButton stdoutDisableCreate;
    private JRadioButton stdoutEnableCreate;
    private JTextField stdoutFileTextbox;
    private JLabel stdoutFileTitle;
    private JPanel stdoutPanel;
    private JRadioButton useInsertedStderrRadioBtn;
    private JRadioButton useInsertedStdoutRadioBtn;
    private JRadioButton useParentStderrRadioBtn;
    private JRadioButton useParentStdoutRadioBtn;
    private JLabel workingDirStderrLabel;
    private JLabel workingDirStdoutLabel;

    public JFStandardOutputBean() {
        this.initComponents();
        this.stdoutFileTextbox.setText(DEFAULT_STDOUT_FILE);
        this.stderrFileTextbox.setText(DEFAULT_STDERR_FILE);
        if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
            this.isWindows = true;
        }
    }

    public void showFieldsForStaticFlow() {
        this.stdoutPanel.remove(this.dynamicStdoutPanel);
        this.stdoutPanel.setPreferredSize(new Dimension(430, 180));
        this.overrideOutputPanel.setVisible(false);
        this.createStdoutLabel.setText(JFResourceBundle.getString("Stdout_create_flow"));
        this.overrideStderrCheckbox.setText(JFResourceBundle.getString("Stdout_override_flow"));
        this.fileOutputDetailsPanel.setVisible(false);
        this.stdoutAutoIndexCheckbox.setSelected(true);
        this.stdoutPanel.revalidate();
        this.stderrPanel.remove(this.dynamicStderrPanel);
        this.stderrPanel.setPreferredSize(new Dimension(430, 180));
        this.overrideErrorPanel.setVisible(false);
        this.createStderrLabel.setText(JFResourceBundle.getString("Stderr_create_flow"));
        this.overrideStderrCheckbox.setText(JFResourceBundle.getString("Stderr_override_flow"));
        this.fileErrorDetailsPanel.setVisible(false);
        this.stderrAutoIndexCheckbox.setSelected(true);
        this.stderrPanel.revalidate();
        this.setPreferredSize(new Dimension(860, 180));
        this.createStdoutLabel.setToolTipText(JFResourceBundle.getString("SubFlowAttrDialog$TIP_stdoutCreate"));
        this.createStderrLabel.setToolTipText(JFResourceBundle.getString("SubFlowAttrDialog$TIP_stderrCreate"));
        this.createStdoutLabel.setText(JFResourceBundle.getString("Stdout_create_subflow"));
        this.createStderrLabel.setText(JFResourceBundle.getString("Stderr_create_subflow"));
        this.overrideStdoutCheckbox.setText(JFResourceBundle.getString("Stdout_override_flow"));
        this.overrideStderrCheckbox.setText(JFResourceBundle.getString("Stderr_override_flow"));
        this.directoryStdoutLabel.setToolTipText(JFResourceBundle.getString("FlowAttrDialog$TIP_stdoutDir"));
        this.directoryStderrLabel.setToolTipText(JFResourceBundle.getString("FlowAttrDialog$TIP_stderrDir"));
        this.autoIndexStdoutLabel.setToolTipText(JFResourceBundle.getString("SubFlowAttrDialog$TIP_stdoutAutoIndex"));
        this.autoIndexStderrLabel.setToolTipText(JFResourceBundle.getString("SubFlowAttrDialog$TIP_stderrAutoIndex"));
        this.revalidate();
    }

    public void showFieldsForDynamicFlow() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.overrideStdoutCheckbox.setVisible(false);
        this.createStdoutLabel.setText(JFResourceBundle.getString("Stdout_create_subflow"));
        this.createStdoutLabel.setMinimumSize(new Dimension(410, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        this.overrideOutputPanel.add((Component)this.stdoutEnableCreate, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.overrideOutputPanel.add((Component)this.stdoutDisableCreate, gridBagConstraints);
        this.overrideOutputPanel.setVisible(false);
        this.fileOutputDetailsPanel.setVisible(false);
        this.stdoutPanel.revalidate();
        this.overrideOutputPanel.revalidate();
        this.overrideStderrCheckbox.setVisible(false);
        this.createStderrLabel.setText(JFResourceBundle.getString("Stderr_create_subflow"));
        this.createStderrLabel.setMinimumSize(new Dimension(400, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        this.overrideErrorPanel.add((Component)this.stderrEnableCreate, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.overrideErrorPanel.add((Component)this.stderrDisableCreate, gridBagConstraints);
        this.overrideErrorPanel.setVisible(false);
        this.fileErrorDetailsPanel.setVisible(false);
        this.stderrPanel.revalidate();
        this.overrideErrorPanel.revalidate();
        this.setPreferredSize(new Dimension(860, 290));
        this.createStdoutLabel.setToolTipText(JFResourceBundle.getString("SubFlowAttrDialog$TIP_stdoutCreate"));
        this.createStderrLabel.setToolTipText(JFResourceBundle.getString("SubFlowAttrDialog$TIP_stderrCreate"));
        this.createStdoutLabel.setText(JFResourceBundle.getString("Stdout_create_subflow"));
        this.createStderrLabel.setText(JFResourceBundle.getString("Stderr_create_subflow"));
        this.directoryStdoutLabel.setToolTipText(JFResourceBundle.getString("FlowAttrDialog$TIP_stdoutDir"));
        this.directoryStderrLabel.setToolTipText(JFResourceBundle.getString("FlowAttrDialog$TIP_stderrDir"));
        this.autoIndexStdoutLabel.setToolTipText(JFResourceBundle.getString("SubFlowAttrDialog$TIP_stdoutAutoIndex"));
        this.autoIndexStderrLabel.setToolTipText(JFResourceBundle.getString("SubFlowAttrDialog$TIP_stderrAutoIndex"));
        this.revalidate();
    }

    public void showFieldsForMainFlow() {
        this.overrideStdoutCheckbox.setVisible(false);
        this.createStdoutLabel.setText(JFResourceBundle.getString("Stdout_create_flow"));
        this.overrideOutputPanel.setVisible(true);
        this.stdoutPanel.setPreferredSize(new Dimension(430, 150));
        this.autoIndexStdoutLabel.setText(JFResourceBundle.getString("Stdout_auto_job_index_main"));
        this.stdoutAutoIndexCheckbox.setSelected(true);
        this.stdoutPanel.revalidate();
        this.overrideStderrCheckbox.setVisible(false);
        this.createStderrLabel.setText(JFResourceBundle.getString("Stderr_create_flow"));
        this.overrideErrorPanel.setVisible(true);
        this.fileErrorDetailsPanel.setVisible(false);
        this.stderrPanel.setPreferredSize(new Dimension(430, 150));
        this.autoIndexStderrLabel.setText(JFResourceBundle.getString("Stderr_auto_job_index_main"));
        this.stderrAutoIndexCheckbox.setSelected(true);
        this.stderrPanel.revalidate();
        this.setPreferredSize(new Dimension(860, 150));
        this.directoryStdoutLabel.setToolTipText(JFResourceBundle.getString("FlowAttrDialog$TIP_stdoutDir"));
        this.directoryStderrLabel.setToolTipText(JFResourceBundle.getString("FlowAttrDialog$TIP_stderrDir"));
        this.autoIndexStdoutLabel.setToolTipText(JFResourceBundle.getString("FlowAttrDialog$TIP_stdoutAutoIndex"));
        this.autoIndexStderrLabel.setToolTipText(JFResourceBundle.getString("FlowAttrDialog$TIP_stderrAutoIndex"));
        this.revalidate();
    }

    public void showFieldsForJob() {
        this.stdoutPanel.remove(this.dynamicStdoutPanel);
        this.stdoutAutoIndexCheckbox.setVisible(false);
        this.autoIndexStdoutLabel.setVisible(false);
        this.workingDirStdoutLabel.setVisible(false);
        this.directoryStdoutLabel.setVisible(false);
        this.stdoutDirTextbox.setVisible(false);
        this.stdoutPanel.setPreferredSize(new Dimension(430, 150));
        this.overrideOutputPanel.setVisible(false);
        this.fileOutputDetailsPanel.setVisible(false);
        this.filenameStdoutLabel.setText(JFResourceBundle.getString("File_"));
        this.stdoutPanel.revalidate();
        this.stderrPanel.remove(this.dynamicStderrPanel);
        this.stderrAutoIndexCheckbox.setVisible(false);
        this.autoIndexStderrLabel.setVisible(false);
        this.workingDirStderrLabel.setVisible(false);
        this.directoryStderrLabel.setVisible(false);
        this.stderrDirTextbox.setVisible(false);
        this.stderrPanel.setPreferredSize(new Dimension(430, 150));
        this.overrideErrorPanel.setVisible(false);
        this.fileErrorDetailsPanel.setVisible(false);
        this.filenameStderrLabel.setText(JFResourceBundle.getString("File_"));
        this.stderrPanel.revalidate();
        this.setPreferredSize(new Dimension(860, 155));
        this.createStdoutLabel.setToolTipText(JFResourceBundle.getString("JobDefinitionBean$TIP_stdoutCreate"));
        this.createStderrLabel.setToolTipText(JFResourceBundle.getString("JobDefinitionBean$TIP_stderrCreate"));
        this.overrideStdoutCheckbox.setToolTipText(JFResourceBundle.getString("JobDefinitionBean$TIP_stdoutOverride"));
        this.overrideStderrCheckbox.setToolTipText(JFResourceBundle.getString("JobDefinitionBean$TIP_stderrOverride"));
        this.revalidate();
    }

    private void initBeanFields(Properties properties, int n) {
        if (properties == null || properties.size() <= 0) {
            return;
        }
        String string = properties.getProperty("Stdout", "");
        String string2 = properties.getProperty("Stderr", "");
        if ("No".equals(properties.getProperty("CreateStdout")) || string == "") {
            this.stdoutDisableCreate.setSelected(true);
        } else {
            this.stdoutEnableCreate.setSelected(true);
        }
        if ("No".equals(properties.getProperty("CreateStderr")) || string2 == "") {
            this.stderrDisableCreate.setSelected(true);
        } else {
            this.stderrEnableCreate.setSelected(true);
        }
        if ("Yes".equals(properties.getProperty("StdoutOverride"))) {
            this.setStdoutOverrideCheckbox(true);
        } else if ("No".equals(properties.getProperty("StdoutOverride"))) {
            this.setStdoutOverrideCheckbox(false);
        } else if (string != "") {
            this.setStdoutOverrideCheckbox(true);
        } else {
            this.setStdoutOverrideCheckbox(false);
        }
        if ("Yes".equals(properties.getProperty("StderrOverride"))) {
            this.setStderrOverrideCheckbox(true);
        } else if ("No".equals(properties.getProperty("StderrOverride"))) {
            this.setStderrOverrideCheckbox(false);
        } else if (string2 != "") {
            this.setStderrOverrideCheckbox(true);
        } else {
            this.setStderrOverrideCheckbox(false);
        }
        if ("".equals(string)) {
            if (n == 2) {
                this.stdoutFileTextbox.setText("output.#{JS_FLOW_FULL_NAME}.%J[%I]");
            } else if (n == 1) {
                this.stdoutFileTextbox.setText(DEFAULT_LOCAL_STDOUT_FILE);
            } else {
                this.stdoutFileTextbox.setText(DEFAULT_STDOUT_FILE);
            }
        } else {
            this.stdoutFileTextbox.setText(string);
        }
        if ("".equals(string2)) {
            if (n == 2) {
                this.stderrFileTextbox.setText("error.#{JS_FLOW_FULL_NAME}.%J[%I]");
            } else if (n == 1) {
                this.stderrFileTextbox.setText(DEFAULT_LOCAL_STDERR_FILE);
            } else {
                this.stderrFileTextbox.setText(DEFAULT_STDERR_FILE);
            }
        } else {
            this.stderrFileTextbox.setText(string2);
        }
    }

    void populateFieldsForJob(JFJob jFJob, int n) {
        Properties properties = jFJob.getAttributes();
        if (properties == null || properties.size() <= 0) {
            return;
        }
        this.initBeanFields(properties, n);
    }

    void populateFieldsForDynamicFlow(JFDynamicFlow jFDynamicFlow) {
        if (jFDynamicFlow == null) {
            return;
        }
        if ("Yes".equals(jFDynamicFlow.getAttribute("FlowCreateStdout"))) {
            this.setStdoutCreate(true);
        } else {
            this.setStdoutCreate(false);
        }
        if ("Yes".equals(jFDynamicFlow.getAttribute("FlowCreateStderr"))) {
            this.setStderrCreate(true);
        } else {
            this.setStderrCreate(false);
        }
        String string = jFDynamicFlow.getAttribute("FlowStdout");
        if ("".equals(string)) {
            this.stdoutFileTextbox.setText(DEFAULT_STDOUT_FILE);
        } else {
            this.stdoutFileTextbox.setText(string);
        }
        string = jFDynamicFlow.getAttribute("FlowStderr");
        if ("".equals(string)) {
            this.stderrFileTextbox.setText(DEFAULT_STDERR_FILE);
        } else {
            this.stderrFileTextbox.setText(string);
        }
        this.stdoutDirTextbox.setText(jFDynamicFlow.getAttribute("FlowStdoutDir"));
        this.stderrDirTextbox.setText(jFDynamicFlow.getAttribute("FlowStderrDir"));
        if ("Yes".equals(jFDynamicFlow.getAttribute("FlowStdoutAutoIndex"))) {
            this.stdoutAutoIndexCheckbox.setSelected(true);
        } else {
            this.stdoutAutoIndexCheckbox.setSelected(false);
        }
        if ("Yes".equals(jFDynamicFlow.getAttribute("FlowStderrAutoIndex"))) {
            this.stderrAutoIndexCheckbox.setSelected(true);
        } else {
            this.stderrAutoIndexCheckbox.setSelected(false);
        }
        this.setStdoutDynamicFileCreation(jFDynamicFlow.getAttribute("FlowUseStdoutFrom"));
        this.setStderrDynamicFileCreation(jFDynamicFlow.getAttribute("FlowUseStderrFrom"));
    }

    void populateFieldsForFlow(JFFlow jFFlow) {
        this.populateFieldsForMainFlow(jFFlow);
        if ("Yes".equals(jFFlow.getAttribute("FlowOverrideStdout"))) {
            this.setStdoutOverrideCheckbox(true);
        } else {
            this.setStdoutOverrideCheckbox(false);
        }
        if ("Yes".equals(jFFlow.getAttribute("FlowOverrideStderr"))) {
            this.setStderrOverrideCheckbox(true);
        } else {
            this.setStderrOverrideCheckbox(false);
        }
        if (jFFlow.getAttribute("FlowUseStdoutFrom") != null && !"".equals(jFFlow.getAttribute("FlowUseStdoutFrom"))) {
            this.setStdoutOverrideCheckbox(true);
            if (!"Override".equals(jFFlow.getAttribute("FlowUseStdoutFrom"))) {
                this.overrideStdoutCheckbox.setSelected(false);
            }
        }
        if (jFFlow.getAttribute("FlowUseStderrFrom") != null && !"".equals(jFFlow.getAttribute("FlowUseStderrFrom"))) {
            this.setStderrOverrideCheckbox(true);
            if (!"Override".equals(jFFlow.getAttribute("FlowUseStderrFrom"))) {
                this.overrideStderrCheckbox.setSelected(false);
            }
        }
    }

    void populateFieldsForMainFlow(JFFlow jFFlow) {
        if ("Yes".equals(jFFlow.getAttribute("FlowCreateStdout"))) {
            this.stdoutEnableCreate.setSelected(true);
            this.fileOutputDetailsPanel.setVisible(true);
        } else {
            this.stdoutEnableCreate.setSelected(false);
            this.fileOutputDetailsPanel.setVisible(false);
        }
        if ("Yes".equals(jFFlow.getAttribute("FlowCreateStderr"))) {
            this.stderrEnableCreate.setSelected(true);
            this.fileErrorDetailsPanel.setVisible(true);
        } else {
            this.stderrEnableCreate.setSelected(false);
            this.fileErrorDetailsPanel.setVisible(false);
        }
        if ("".equals(jFFlow.getAttribute("FlowStdout"))) {
            this.stdoutFileTextbox.setText(DEFAULT_STDOUT_FILE);
        } else {
            this.stdoutFileTextbox.setText(jFFlow.getAttribute("FlowStdout"));
        }
        if ("".equals(jFFlow.getAttribute("FlowStderr"))) {
            this.stderrFileTextbox.setText(DEFAULT_STDERR_FILE);
        } else {
            this.stderrFileTextbox.setText(jFFlow.getAttribute("FlowStderr"));
        }
        this.stdoutDirTextbox.setText(jFFlow.getAttribute("FlowStdoutDir"));
        this.stderrDirTextbox.setText(jFFlow.getAttribute("FlowStderrDir"));
        if ("Yes".equals(jFFlow.getAttribute("FlowStdoutAutoIndex"))) {
            this.stdoutAutoIndexCheckbox.setSelected(true);
        } else {
            this.stdoutAutoIndexCheckbox.setSelected(false);
        }
        if ("Yes".equals(jFFlow.getAttribute("FlowStderrAutoIndex"))) {
            this.stderrAutoIndexCheckbox.setSelected(true);
        } else {
            this.stderrAutoIndexCheckbox.setSelected(false);
        }
    }

    public void resetDefault() {
        this.setStdoutOverrideCheckbox(false);
        this.setStderrOverrideCheckbox(false);
        this.setStdoutCreate(false);
        this.setStderrCreate(false);
        this.stdoutFileTextbox.setText(DEFAULT_STDOUT_FILE);
        this.stderrFileTextbox.setText(DEFAULT_STDERR_FILE);
    }

    boolean fieldsMatchJob(JFJob jFJob) {
        boolean bl = true;
        Properties properties = jFJob.getAttributes();
        bl = this.stderrFileTextbox.getText().equals(properties.getProperty("Stderr")) && this.stdoutFileTextbox.getText().equals(properties.getProperty("Stdout")) && this.stderrEnableCreate.isSelected() == "Yes".equals(jFJob.getAttribute("CreateStderr")) && this.stdoutEnableCreate.isSelected() == "Yes".equals(jFJob.getAttribute("CreateStdout")) && this.overrideStderrCheckbox.isSelected() == "Yes".equals(jFJob.getAttribute("StderrOverride")) && this.overrideStdoutCheckbox.isSelected() == "Yes".equals(jFJob.getAttribute("StdoutOverride"));
        return bl;
    }

    public boolean isDirty(Properties properties) {
        if (!(properties.getProperty("FlowStdout").equals(this.getStdoutFile()) && properties.getProperty("FlowStderr").equals(this.getStderrFile()) && properties.getProperty("FlowStdoutDir").equals(this.getStdoutDir()) && properties.getProperty("FlowStderrDir").equals(this.getStderrDir()))) {
            return true;
        }
        if (this.getStdoutOverrideCheckbox() && properties.getProperty("FlowOverrideStdout") != "Yes") {
            return true;
        }
        if (!this.getStdoutOverrideCheckbox() && properties.getProperty("FlowOverrideStdout") != "No") {
            return true;
        }
        if (this.getStderrOverrideCheckbox() && properties.getProperty("FlowOverrideStderr") != "Yes") {
            return true;
        }
        if (!this.getStderrOverrideCheckbox() && properties.getProperty("FlowOverrideStderr") != "No") {
            return true;
        }
        if (this.getStdoutCreate() && properties.getProperty("FlowCreateStdout") != "Yes") {
            return true;
        }
        if (!this.getStdoutCreate() && properties.getProperty("FlowCreateStdout") != "No") {
            return true;
        }
        if (this.getStderrCreate() && properties.getProperty("FlowCreateStderr") != "Yes") {
            return true;
        }
        if (!this.getStderrCreate() && properties.getProperty("FlowCreateStderr") != "No") {
            return true;
        }
        if (this.getStdoutAutoJobIndexCheckbox() && properties.getProperty("FlowStdoutAutoIndex") != "Yes") {
            return true;
        }
        if (!this.getStdoutAutoJobIndexCheckbox() && properties.getProperty("FlowStdoutAutoIndex") != "No") {
            return true;
        }
        if (this.getStderrAutoJobIndexCheckbox() && properties.getProperty("FlowStderrAutoIndex") != "Yes") {
            return true;
        }
        return !this.getStderrAutoJobIndexCheckbox() && properties.getProperty("FlowStderrAutoIndex") != "No";
    }

    public String getStdoutFile() {
        return this.stdoutFileTextbox.getText();
    }

    public boolean getStdoutOverrideCheckbox() {
        return this.overrideStdoutCheckbox.isSelected();
    }

    public boolean getStdoutCreate() {
        return this.stdoutEnableCreate.isSelected();
    }

    public String getStdoutDir() {
        return this.stdoutDirTextbox.getText();
    }

    public boolean getStdoutAutoJobIndexCheckbox() {
        return this.stdoutAutoIndexCheckbox.isSelected();
    }

    public String getStdoutDynamicFileCreation() {
        if (this.useInsertedStdoutRadioBtn.isSelected()) {
            return "InsertedFlow";
        }
        if (this.overrideParentStdoutRadioBtn.isSelected()) {
            return "Override";
        }
        return "ParentFlow";
    }

    public void setStdoutFile(String string) {
        this.stdoutFileTextbox.setText(string);
    }

    public void setStdoutOverrideCheckbox(boolean bl) {
        this.overrideStdoutCheckbox.setSelected(bl);
        this.overrideStdoutCheckboxActionPerformed(null);
    }

    public void setStdoutCreate(boolean bl) {
        this.stdoutEnableCreate.setSelected(bl);
        this.stdoutDisableCreate.setSelected(!bl);
        if (bl) {
            this.stdoutEnableCreateActionPerformed(null);
        } else {
            this.stdoutDisableCreateActionPerformed(null);
        }
    }

    public void setStdoutDir(String string) {
        this.stdoutDirTextbox.setText(string);
    }

    public void setStdoutAutoIndexCheckbox(boolean bl) {
        this.stdoutAutoIndexCheckbox.setSelected(bl);
    }

    public void setStdoutDynamicFileCreation(String string) {
        if ("InsertedFlow".equals(string)) {
            this.useInsertedStdoutRadioBtn.setSelected(true);
            this.useInsertedStdoutRadioBtnActionPerformed(null);
        } else if ("ParentFlow".equals(string)) {
            this.useParentStdoutRadioBtn.setSelected(true);
            this.useParentStdoutRadioBtnActionPerformed(null);
        } else if ("Override".equals(string)) {
            this.overrideParentStdoutRadioBtn.setSelected(true);
            this.overrideParentStdoutRadioBtnActionPerformed(null);
        }
    }

    public String getStderrFile() {
        return this.stderrFileTextbox.getText();
    }

    public boolean getStderrOverrideCheckbox() {
        return this.overrideStderrCheckbox.isSelected();
    }

    public boolean getStderrCreate() {
        return this.stderrEnableCreate.isSelected();
    }

    public String getStderrDir() {
        return this.stderrDirTextbox.getText();
    }

    public boolean getStderrAutoJobIndexCheckbox() {
        return this.stderrAutoIndexCheckbox.isSelected();
    }

    public String getStderrDynamicFileCreation() {
        if (this.useInsertedStderrRadioBtn.isSelected()) {
            return "InsertedFlow";
        }
        if (this.overrideParentStderrRadioBtn.isSelected()) {
            return "Override";
        }
        return "ParentFlow";
    }

    public void setStderrFile(String string) {
        this.stderrFileTextbox.setText(string);
    }

    public void setStderrOverrideCheckbox(boolean bl) {
        this.overrideStderrCheckbox.setSelected(bl);
        if (this.overrideStderrCheckbox.isSelected()) {
            this.overrideErrorPanel.setVisible(true);
            if (this.stderrEnableCreate.isSelected()) {
                this.fileErrorDetailsPanel.setVisible(true);
            } else {
                this.fileErrorDetailsPanel.setVisible(false);
            }
        } else {
            this.hideOverrideStderrPanel();
        }
    }

    public void setStderrCreate(boolean bl) {
        this.stderrEnableCreate.setSelected(bl);
        this.stderrDisableCreate.setSelected(!bl);
        if (bl) {
            this.stderrEnableCreateActionPerformed(null);
        } else {
            this.stderrDisableCreateActionPerformed(null);
        }
    }

    public void setStderrDir(String string) {
        this.stderrDirTextbox.setText(string);
    }

    public void setStderrAutoIndexCheckbox(boolean bl) {
        this.stderrAutoIndexCheckbox.setSelected(bl);
    }

    public void setStderrDynamicFileCreation(String string) {
        if ("InsertedFlow".equals(string)) {
            this.useInsertedStderrRadioBtn.setSelected(true);
            this.useInsertedStderrRadioBtnActionPerformed(null);
        } else if ("ParentFlow".equals(string)) {
            this.useParentStderrRadioBtn.setSelected(true);
            this.useParentStderrRadioBtnActionPerformed(null);
        } else if ("Override".equals(string)) {
            this.overrideParentStderrRadioBtn.setSelected(true);
            this.overrideParentStderrRadioBtnActionPerformed(null);
        }
    }

    void setEditable(boolean bl) {
        this.dynamicStdoutPanel.setEnabled(bl);
        this.dynamicStderrPanel.setEnabled(bl);
        this.overrideOutputPanel.setEnabled(bl);
        this.overrideErrorPanel.setEnabled(bl);
        this.overrideStdoutCheckbox.setEnabled(bl);
        this.overrideStderrCheckbox.setEnabled(bl);
        this.stdoutEnableCreate.setEnabled(bl);
        this.stderrEnableCreate.setEnabled(bl);
        this.stdoutDisableCreate.setEnabled(bl);
        this.stderrDisableCreate.setEnabled(bl);
        this.stdoutDirTextbox.setEditable(bl);
        this.stderrDirTextbox.setEditable(bl);
        this.stderrFileTextbox.setEditable(bl);
        this.stdoutFileTextbox.setEditable(bl);
        this.stdoutAutoIndexCheckbox.setEnabled(bl);
        this.stderrAutoIndexCheckbox.setEnabled(bl);
        this.overrideParentStdoutRadioBtn.setEnabled(bl);
        this.useParentStdoutRadioBtn.setEnabled(bl);
        this.useInsertedStdoutRadioBtn.setEnabled(bl);
        this.overrideParentStderrRadioBtn.setEnabled(bl);
        this.useParentStderrRadioBtn.setEnabled(bl);
        this.useInsertedStderrRadioBtn.setEnabled(bl);
    }

    public boolean hasValidFields(boolean bl) {
        if (this.stdoutEnableCreate.isSelected() && this.stdoutFileTextbox.getText().trim().length() <= 0) {
            if (bl) {
                JFUtility.showAppErrorMsg(this, JFResourceBundle.getString("Stdout_empty_error"));
            }
            return false;
        }
        if (this.stderrEnableCreate.isSelected() && this.stderrFileTextbox.getText().trim().length() <= 0) {
            if (bl) {
                JFUtility.showAppErrorMsg(this, JFResourceBundle.getString("Stderr_empty_error"));
            }
            return false;
        }
        if ((this.getStdoutOverrideCheckbox() && this.overrideStdoutCheckbox.isVisible() || !this.overrideStdoutCheckbox.isVisible()) && this.getStdoutCreate() && (this.getStdoutFile().indexOf("/") >= 0 || this.isWindows && this.getStdoutFile().indexOf("\\") >= 0)) {
            JFUtility.showAppWarningMsg(this, JFResourceBundle.getString("JobDefinitionBean$WARNING_stdoutFileContainsPath"));
        }
        if ((this.getStderrOverrideCheckbox() && this.overrideStderrCheckbox.isVisible() || !this.overrideStdoutCheckbox.isVisible()) && this.getStderrCreate() && (this.getStderrFile().indexOf("/") >= 0 || this.isWindows && this.getStderrFile().indexOf("\\") >= 0)) {
            JFUtility.showAppWarningMsg(this, JFResourceBundle.getString("JobDefinitionBean$WARNING_stderrFileContainsPath"));
        }
        return true;
    }

    private void initComponents() {
        this.createStdoutButtonGroup = new ButtonGroup();
        this.dynamicSubFlowStdoutButtonGroup = new ButtonGroup();
        this.dynamicSubFlowStderrButtonGroup = new ButtonGroup();
        this.createStderrButtonGroup = new ButtonGroup();
        this.stdoutPanel = new JPanel();
        this.dynamicStdoutPanel = new JPanel();
        this.useParentStdoutRadioBtn = new JRadioButton();
        this.stdoutFileTitle = new JLabel();
        this.useInsertedStdoutRadioBtn = new JRadioButton();
        this.overrideParentStdoutRadioBtn = new JRadioButton();
        this.overrideStdoutCheckbox = new JCheckBox();
        this.overrideOutputPanel = new JPanel();
        this.createStdoutLabel = new JLabel();
        this.stdoutDisableCreate = new JRadioButton();
        this.stdoutEnableCreate = new JRadioButton();
        this.fileOutputDetailsPanel = new JPanel();
        this.workingDirStdoutLabel = new JLabel();
        this.stdoutAutoIndexCheckbox = new JCheckBox();
        this.autoIndexStdoutLabel = new JLabel();
        this.stdoutFileTextbox = new JTextField();
        this.filenameStdoutLabel = new JLabel();
        this.stdoutDirTextbox = new JTextField();
        this.directoryStdoutLabel = new JLabel();
        this.stderrPanel = new JPanel();
        this.dynamicStderrPanel = new JPanel();
        this.useParentStderrRadioBtn = new JRadioButton();
        this.useInsertedStderrRadioBtn = new JRadioButton();
        this.stderrFileTitle = new JLabel();
        this.overrideParentStderrRadioBtn = new JRadioButton();
        this.overrideErrorPanel = new JPanel();
        this.createStderrLabel = new JLabel();
        this.stderrDisableCreate = new JRadioButton();
        this.stderrEnableCreate = new JRadioButton();
        this.fileErrorDetailsPanel = new JPanel();
        this.workingDirStderrLabel = new JLabel();
        this.autoIndexStderrLabel = new JLabel();
        this.stderrAutoIndexCheckbox = new JCheckBox();
        this.stderrFileTextbox = new JTextField();
        this.filenameStderrLabel = new JLabel();
        this.stderrDirTextbox = new JTextField();
        this.directoryStderrLabel = new JLabel();
        this.overrideStderrCheckbox = new JCheckBox();
        this.setMinimumSize(new Dimension(860, 270));
        this.setName("");
        this.setPreferredSize(new Dimension(860, 270));
        this.setLayout(new GridBagLayout());
        this.stdoutPanel.setBorder(BorderFactory.createTitledBorder("Output Files"));
        this.stdoutPanel.setMinimumSize(new Dimension(430, 200));
        this.stdoutPanel.setPreferredSize(new Dimension(430, 260));
        this.stdoutPanel.setLayout(new GridBagLayout());
        this.dynamicStdoutPanel.setLayout(new GridBagLayout());
        this.dynamicSubFlowStdoutButtonGroup.add(this.useParentStdoutRadioBtn);
        this.useParentStdoutRadioBtn.setSelected(true);
        this.useParentStdoutRadioBtn.setText(JFResourceBundle.getString("Stdout_dynamic_use_parent"));
        this.useParentStdoutRadioBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFStandardOutputBean.this.useParentStdoutRadioBtnActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.dynamicStdoutPanel.add((Component)this.useParentStdoutRadioBtn, gridBagConstraints);
        this.stdoutFileTitle.setHorizontalAlignment(2);
        this.stdoutFileTitle.setText("Output file creation settings:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.dynamicStdoutPanel.add((Component)this.stdoutFileTitle, gridBagConstraints);
        this.stdoutFileTitle.getAccessibleContext().setAccessibleName(JFResourceBundle.getString("Stdout_dynamic_settings"));
        this.dynamicSubFlowStdoutButtonGroup.add(this.useInsertedStdoutRadioBtn);
        this.useInsertedStdoutRadioBtn.setText(JFResourceBundle.getString("Stdout_dynamic_use_insert"));
        this.useInsertedStdoutRadioBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFStandardOutputBean.this.useInsertedStdoutRadioBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.dynamicStdoutPanel.add((Component)this.useInsertedStdoutRadioBtn, gridBagConstraints);
        this.dynamicSubFlowStdoutButtonGroup.add(this.overrideParentStdoutRadioBtn);
        this.overrideParentStdoutRadioBtn.setText(JFResourceBundle.getString("Stdout_dynamic_use_override"));
        this.overrideParentStdoutRadioBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFStandardOutputBean.this.overrideParentStdoutRadioBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.dynamicStdoutPanel.add((Component)this.overrideParentStdoutRadioBtn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.stdoutPanel.add((Component)this.dynamicStdoutPanel, gridBagConstraints);
        this.overrideStdoutCheckbox.setText(JFResourceBundle.getString("Stdout_override"));
        this.overrideStdoutCheckbox.setToolTipText(JFResourceBundle.getString("FlowAttrDialog$TIP_stdoutOverride"));
        this.overrideStdoutCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFStandardOutputBean.this.overrideStdoutCheckboxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.stdoutPanel.add((Component)this.overrideStdoutCheckbox, gridBagConstraints);
        this.overrideOutputPanel.setAlignmentX(0.0f);
        this.overrideOutputPanel.setMaximumSize(new Dimension(280, 90));
        this.overrideOutputPanel.setMinimumSize(new Dimension(280, 50));
        this.overrideOutputPanel.setPreferredSize(new Dimension(280, 50));
        this.overrideOutputPanel.setLayout(new GridBagLayout());
        this.createStdoutLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/platform/LSFJobFlow/ui/resources/tooltip.gif")));
        this.createStdoutLabel.setText(JFResourceBundle.getString("Stdout_create"));
        this.createStdoutLabel.setToolTipText(JFResourceBundle.getString("JobDefinitionBean$TIP_stdoutCreate"));
        this.createStdoutLabel.setHorizontalTextPosition(10);
        this.createStdoutLabel.setIconTextGap(2);
        this.createStdoutLabel.setMaximumSize(new Dimension(355, 16));
        this.createStdoutLabel.setMinimumSize(new Dimension(355, 16));
        this.createStdoutLabel.setName("");
        this.createStdoutLabel.setPreferredSize(new Dimension(355, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.overrideOutputPanel.add((Component)this.createStdoutLabel, gridBagConstraints);
        this.createStdoutButtonGroup.add(this.stdoutDisableCreate);
        this.stdoutDisableCreate.setSelected(true);
        this.stdoutDisableCreate.setText(JFResourceBundle.getString("No"));
        this.stdoutDisableCreate.setHorizontalAlignment(11);
        this.stdoutDisableCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFStandardOutputBean.this.stdoutDisableCreateActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.overrideOutputPanel.add((Component)this.stdoutDisableCreate, gridBagConstraints);
        this.stdoutDisableCreate.getAccessibleContext().setAccessibleName("disableCreate");
        this.createStdoutButtonGroup.add(this.stdoutEnableCreate);
        this.stdoutEnableCreate.setText(JFResourceBundle.getString("Yes"));
        this.stdoutEnableCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFStandardOutputBean.this.stdoutEnableCreateActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.overrideOutputPanel.add((Component)this.stdoutEnableCreate, gridBagConstraints);
        this.stdoutEnableCreate.getAccessibleContext().setAccessibleName("enableCreate");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.stdoutPanel.add((Component)this.overrideOutputPanel, gridBagConstraints);
        this.fileOutputDetailsPanel.setAlignmentX(0.0f);
        this.fileOutputDetailsPanel.setAlignmentY(0.0f);
        this.fileOutputDetailsPanel.setMinimumSize(new Dimension(420, 75));
        this.fileOutputDetailsPanel.setPreferredSize(new Dimension(420, 75));
        this.fileOutputDetailsPanel.setLayout(new GridBagLayout());
        this.workingDirStdoutLabel.setText(JFResourceBundle.getString("Stdout_working_dir"));
        this.workingDirStdoutLabel.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.fileOutputDetailsPanel.add((Component)this.workingDirStdoutLabel, gridBagConstraints);
        this.stdoutAutoIndexCheckbox.setSelected(true);
        this.stdoutAutoIndexCheckbox.setVerticalAlignment(1);
        this.stdoutAutoIndexCheckbox.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.fileOutputDetailsPanel.add((Component)this.stdoutAutoIndexCheckbox, gridBagConstraints);
        this.autoIndexStdoutLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/platform/LSFJobFlow/ui/resources/tooltip.gif")));
        this.autoIndexStdoutLabel.setText(JFResourceBundle.getString("Stdout_auto_job_index"));
        this.autoIndexStdoutLabel.setHorizontalTextPosition(2);
        this.autoIndexStdoutLabel.setMinimumSize(new Dimension(286, 26));
        this.autoIndexStdoutLabel.setPreferredSize(new Dimension(285, 26));
        this.autoIndexStdoutLabel.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 30, 2, 0);
        this.fileOutputDetailsPanel.add((Component)this.autoIndexStdoutLabel, gridBagConstraints);
        this.autoIndexStdoutLabel.getAccessibleContext().setAccessibleName(JFResourceBundle.getString("Stdout_auto_job_index"));
        this.stdoutFileTextbox.setMinimumSize(new Dimension(200, 20));
        this.stdoutFileTextbox.setPreferredSize(new Dimension(300, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        this.fileOutputDetailsPanel.add((Component)this.stdoutFileTextbox, gridBagConstraints);
        this.filenameStdoutLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/platform/LSFJobFlow/ui/resources/tooltip.gif")));
        this.filenameStdoutLabel.setText(JFResourceBundle.getString("Stdout_file_name_"));
        this.filenameStdoutLabel.setToolTipText(JFResourceBundle.getString("JobDefinitionBean$TIP_outputFileFLD"));
        this.filenameStdoutLabel.setHorizontalTextPosition(2);
        this.filenameStdoutLabel.setMaximumSize(new Dimension(100, 14));
        this.filenameStdoutLabel.setMinimumSize(new Dimension(86, 14));
        this.filenameStdoutLabel.setPreferredSize(new Dimension(86, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.fileOutputDetailsPanel.add((Component)this.filenameStdoutLabel, gridBagConstraints);
        this.stdoutDirTextbox.setMaximumSize(new Dimension(155, 20));
        this.stdoutDirTextbox.setMinimumSize(new Dimension(155, 20));
        this.stdoutDirTextbox.setPreferredSize(new Dimension(155, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        this.fileOutputDetailsPanel.add((Component)this.stdoutDirTextbox, gridBagConstraints);
        this.directoryStdoutLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/platform/LSFJobFlow/ui/resources/tooltip.gif")));
        this.directoryStdoutLabel.setText(JFResourceBundle.getString("Stdout_working_dir_"));
        this.directoryStdoutLabel.setHorizontalTextPosition(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.fileOutputDetailsPanel.add((Component)this.directoryStdoutLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weighty = 1.0;
        this.stdoutPanel.add((Component)this.fileOutputDetailsPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.stdoutPanel, gridBagConstraints);
        this.stdoutPanel.getAccessibleContext().setAccessibleName(JFResourceBundle.getString("Output_file"));
        this.stderrPanel.setBorder(BorderFactory.createTitledBorder("Error Files"));
        this.stderrPanel.setMinimumSize(new Dimension(430, 200));
        this.stderrPanel.setPreferredSize(new Dimension(430, 260));
        this.stderrPanel.setLayout(new GridBagLayout());
        this.dynamicStderrPanel.setLayout(new GridBagLayout());
        this.dynamicSubFlowStderrButtonGroup.add(this.useParentStderrRadioBtn);
        this.useParentStderrRadioBtn.setSelected(true);
        this.useParentStderrRadioBtn.setText(JFResourceBundle.getString("Stdout_dynamic_use_parent"));
        this.useParentStderrRadioBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFStandardOutputBean.this.useParentStderrRadioBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.dynamicStderrPanel.add((Component)this.useParentStderrRadioBtn, gridBagConstraints);
        this.dynamicSubFlowStderrButtonGroup.add(this.useInsertedStderrRadioBtn);
        this.useInsertedStderrRadioBtn.setText(JFResourceBundle.getString("Stdout_dynamic_use_insert"));
        this.useInsertedStderrRadioBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFStandardOutputBean.this.useInsertedStderrRadioBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.dynamicStderrPanel.add((Component)this.useInsertedStderrRadioBtn, gridBagConstraints);
        this.stderrFileTitle.setHorizontalAlignment(2);
        this.stderrFileTitle.setText("Error file creation settings:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.dynamicStderrPanel.add((Component)this.stderrFileTitle, gridBagConstraints);
        this.stderrFileTitle.getAccessibleContext().setAccessibleName(JFResourceBundle.getString("Stderr_dynamic_settings"));
        this.dynamicSubFlowStderrButtonGroup.add(this.overrideParentStderrRadioBtn);
        this.overrideParentStderrRadioBtn.setText(JFResourceBundle.getString("Stdout_dynamic_use_override"));
        this.overrideParentStderrRadioBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFStandardOutputBean.this.overrideParentStderrRadioBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.dynamicStderrPanel.add((Component)this.overrideParentStderrRadioBtn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.stderrPanel.add((Component)this.dynamicStderrPanel, gridBagConstraints);
        this.overrideErrorPanel.setAlignmentX(0.0f);
        this.overrideErrorPanel.setMaximumSize(new Dimension(280, 90));
        this.overrideErrorPanel.setMinimumSize(new Dimension(280, 50));
        this.overrideErrorPanel.setPreferredSize(new Dimension(280, 50));
        this.overrideErrorPanel.setLayout(new GridBagLayout());
        this.createStderrLabel.setHorizontalAlignment(2);
        this.createStderrLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/platform/LSFJobFlow/ui/resources/tooltip.gif")));
        this.createStderrLabel.setText(JFResourceBundle.getString("Stderr_create"));
        this.createStderrLabel.setToolTipText(JFResourceBundle.getString("FlowAttrDialog$TIP_stderrOverride"));
        this.createStderrLabel.setHorizontalTextPosition(2);
        this.createStderrLabel.setIconTextGap(2);
        this.createStderrLabel.setMaximumSize(new Dimension(355, 16));
        this.createStderrLabel.setMinimumSize(new Dimension(355, 16));
        this.createStderrLabel.setPreferredSize(new Dimension(355, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.overrideErrorPanel.add((Component)this.createStderrLabel, gridBagConstraints);
        this.createStderrButtonGroup.add(this.stderrDisableCreate);
        this.stderrDisableCreate.setSelected(true);
        this.stderrDisableCreate.setText(JFResourceBundle.getString("No"));
        this.stderrDisableCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFStandardOutputBean.this.stderrDisableCreateActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.overrideErrorPanel.add((Component)this.stderrDisableCreate, gridBagConstraints);
        this.createStderrButtonGroup.add(this.stderrEnableCreate);
        this.stderrEnableCreate.setText(JFResourceBundle.getString("Yes"));
        this.stderrEnableCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFStandardOutputBean.this.stderrEnableCreateActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.overrideErrorPanel.add((Component)this.stderrEnableCreate, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.stderrPanel.add((Component)this.overrideErrorPanel, gridBagConstraints);
        this.fileErrorDetailsPanel.setAlignmentX(0.0f);
        this.fileErrorDetailsPanel.setAlignmentY(0.0f);
        this.fileErrorDetailsPanel.setMinimumSize(new Dimension(420, 75));
        this.fileErrorDetailsPanel.setPreferredSize(new Dimension(420, 75));
        this.fileErrorDetailsPanel.setLayout(new GridBagLayout());
        this.workingDirStderrLabel.setText(JFResourceBundle.getString("Stdout_working_dir"));
        this.workingDirStderrLabel.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.fileErrorDetailsPanel.add((Component)this.workingDirStderrLabel, gridBagConstraints);
        this.autoIndexStderrLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/platform/LSFJobFlow/ui/resources/tooltip.gif")));
        this.autoIndexStderrLabel.setText(JFResourceBundle.getString("Stderr_auto_job_index"));
        this.autoIndexStderrLabel.setHorizontalTextPosition(2);
        this.autoIndexStderrLabel.setMaximumSize(new Dimension(285, 26));
        this.autoIndexStderrLabel.setMinimumSize(new Dimension(285, 26));
        this.autoIndexStderrLabel.setPreferredSize(new Dimension(285, 26));
        this.autoIndexStderrLabel.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 30, 2, 0);
        this.fileErrorDetailsPanel.add((Component)this.autoIndexStderrLabel, gridBagConstraints);
        this.autoIndexStderrLabel.getAccessibleContext().setAccessibleName(JFResourceBundle.getString("Stdout_auto_job_index"));
        this.stderrAutoIndexCheckbox.setSelected(true);
        this.stderrAutoIndexCheckbox.setVerticalAlignment(1);
        this.stderrAutoIndexCheckbox.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.fileErrorDetailsPanel.add((Component)this.stderrAutoIndexCheckbox, gridBagConstraints);
        this.stderrFileTextbox.setMinimumSize(new Dimension(200, 20));
        this.stderrFileTextbox.setPreferredSize(new Dimension(300, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        this.fileErrorDetailsPanel.add((Component)this.stderrFileTextbox, gridBagConstraints);
        this.filenameStderrLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/platform/LSFJobFlow/ui/resources/tooltip.gif")));
        this.filenameStderrLabel.setText(JFResourceBundle.getString("Stdout_file_name_"));
        this.filenameStderrLabel.setToolTipText(JFResourceBundle.getString("JobDefinitionBean$TIP_errFileFLD"));
        this.filenameStderrLabel.setHorizontalTextPosition(2);
        this.filenameStderrLabel.setMaximumSize(new Dimension(100, 14));
        this.filenameStderrLabel.setMinimumSize(new Dimension(86, 14));
        this.filenameStderrLabel.setPreferredSize(new Dimension(86, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.fileErrorDetailsPanel.add((Component)this.filenameStderrLabel, gridBagConstraints);
        this.stderrDirTextbox.setMaximumSize(new Dimension(155, 20));
        this.stderrDirTextbox.setMinimumSize(new Dimension(155, 20));
        this.stderrDirTextbox.setPreferredSize(new Dimension(155, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        this.fileErrorDetailsPanel.add((Component)this.stderrDirTextbox, gridBagConstraints);
        this.directoryStderrLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/platform/LSFJobFlow/ui/resources/tooltip.gif")));
        this.directoryStderrLabel.setText(JFResourceBundle.getString("Stdout_working_dir_"));
        this.directoryStderrLabel.setHorizontalTextPosition(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.fileErrorDetailsPanel.add((Component)this.directoryStderrLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        this.stderrPanel.add((Component)this.fileErrorDetailsPanel, gridBagConstraints);
        this.overrideStderrCheckbox.setText(JFResourceBundle.getString("Stderr_override"));
        this.overrideStderrCheckbox.setToolTipText(JFResourceBundle.getString("FlowAttrDialog$TIP_stderrOverridee"));
        this.overrideStderrCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFStandardOutputBean.this.overrideStderrCheckboxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.stderrPanel.add((Component)this.overrideStderrCheckbox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.stderrPanel, gridBagConstraints);
        this.stderrPanel.getAccessibleContext().setAccessibleName(JFResourceBundle.getString("Error_file"));
    }

    private void stderrEnableCreateActionPerformed(ActionEvent actionEvent) {
        if (this.stderrEnableCreate.isSelected()) {
            this.fileErrorDetailsPanel.setVisible(true);
        }
    }

    private void stderrDisableCreateActionPerformed(ActionEvent actionEvent) {
        if (!this.stderrEnableCreate.isSelected()) {
            this.fileErrorDetailsPanel.setVisible(false);
        }
    }

    private void stdoutDisableCreateActionPerformed(ActionEvent actionEvent) {
        if (!this.stdoutEnableCreate.isSelected()) {
            this.fileOutputDetailsPanel.setVisible(false);
        }
    }

    private void stdoutEnableCreateActionPerformed(ActionEvent actionEvent) {
        if (this.stdoutEnableCreate.isSelected()) {
            this.fileOutputDetailsPanel.setVisible(true);
        }
    }

    private void overrideStdoutCheckboxActionPerformed(ActionEvent actionEvent) {
        if (this.overrideStdoutCheckbox.isSelected()) {
            this.overrideOutputPanel.setVisible(true);
            if (this.stdoutEnableCreate.isSelected()) {
                this.fileOutputDetailsPanel.setVisible(true);
            } else {
                this.fileOutputDetailsPanel.setVisible(false);
            }
        } else {
            this.hideOverrideStdoutPanel();
        }
    }

    private void overrideStderrCheckboxActionPerformed(ActionEvent actionEvent) {
        if (this.overrideStderrCheckbox.isSelected()) {
            this.overrideErrorPanel.setVisible(true);
            if (this.stderrEnableCreate.isSelected()) {
                this.fileErrorDetailsPanel.setVisible(true);
            } else {
                this.fileErrorDetailsPanel.setVisible(false);
            }
        } else {
            this.hideOverrideStderrPanel();
        }
    }

    private void overrideParentStderrRadioBtnActionPerformed(ActionEvent actionEvent) {
        if (this.overrideParentStderrRadioBtn.isSelected()) {
            this.overrideErrorPanel.setVisible(true);
            if (this.stderrEnableCreate.isSelected()) {
                this.fileErrorDetailsPanel.setVisible(true);
            } else {
                this.fileErrorDetailsPanel.setVisible(false);
            }
        }
    }

    private void overrideParentStdoutRadioBtnActionPerformed(ActionEvent actionEvent) {
        if (this.overrideParentStdoutRadioBtn.isSelected()) {
            this.overrideOutputPanel.setVisible(true);
            if (this.stdoutEnableCreate.isSelected()) {
                this.fileOutputDetailsPanel.setVisible(true);
            } else {
                this.fileOutputDetailsPanel.setVisible(false);
            }
        }
    }

    private void useInsertedStdoutRadioBtnActionPerformed(ActionEvent actionEvent) {
        this.hideOverrideStdoutPanel();
    }

    private void useParentStdoutRadioBtnActionPerformed(ActionEvent actionEvent) {
        this.hideOverrideStdoutPanel();
    }

    private void useInsertedStderrRadioBtnActionPerformed(ActionEvent actionEvent) {
        this.hideOverrideStderrPanel();
    }

    private void useParentStderrRadioBtnActionPerformed(ActionEvent actionEvent) {
        this.hideOverrideStderrPanel();
    }

    private void hideOverrideStdoutPanel() {
        this.overrideOutputPanel.setVisible(false);
        this.fileOutputDetailsPanel.setVisible(false);
    }

    private void hideOverrideStderrPanel() {
        this.overrideErrorPanel.setVisible(false);
        this.fileErrorDetailsPanel.setVisible(false);
    }
}

