/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFJob;
import com.platform.LSFJobFlow.api.JFLoginManager;
import com.platform.LSFJobFlow.api.JFUser;
import com.platform.LSFJobFlow.ui.JFDescriptionPane;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import com.platform.LSFJobFlow.ui.JFUtility;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class JFManualJobDefinitionBean
extends JPanel {
    static final String ERR_WIN_TITLE = JFResourceBundle.getString("ManualJobDefinitionBean$TITLE_inputErrWin");
    private int curSeqNo = 0;
    private boolean m_editable = false;
    private boolean m_isJFAdmin = false;
    private String m_currentUserName;
    private JFJob jobDef = null;
    private BeanInputVerifier beanInputVerifier = null;
    private JTextField addressFLD;
    private JFDescriptionPane jFDescriptionPane;
    private JFDescriptionPane jFMessagePane;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextField nameFLD;
    private JTextField nonZeroCodesFLD;

    public JFManualJobDefinitionBean() {
        this.initComponents();
        this.setInputAccessibleInfo();
        this.m_editable = true;
        this.m_currentUserName = JFLoginManager.getUserName();
        this.curSeqNo = 0;
        this.beanInputVerifier = new BeanInputVerifier();
        this.nonZeroCodesFLD.setInputVerifier(this.beanInputVerifier);
        this.reset();
    }

    public void reset() {
        if (this.jobDef != null) {
            this.nameFLD.setText(this.jobDef.getName());
        }
        this.addressFLD.setText(new JFUser(this.m_currentUserName).getName());
        this.nonZeroCodesFLD.setText("");
        this.jFDescriptionPane.setText("");
        this.jFMessagePane.setText("");
    }

    public void reset(String string) {
        this.reset();
        if (string != null) {
            this.nameFLD.setText(string);
        }
    }

    JFJob getDefaultJob(String string) throws Exception {
        this.reset(string);
        return this.createJob(null);
    }

    JFJob getDefaultJob() throws Exception {
        return this.getDefaultJob("M" + String.valueOf(++this.curSeqNo));
    }

    public void setJobDefinition(JFJob jFJob) {
        this.jobDef = jFJob;
        this.reset();
        if (jFJob == null) {
            return;
        }
        this.nameFLD.setText(jFJob.getName());
        this.addressFLD.setText(jFJob.getAttribute("NotificationAddress"));
        this.nonZeroCodesFLD.setText(jFJob.getAttribute("NonZeroSuccessExitCodes"));
        this.jFDescriptionPane.setText(jFJob.getAttribute("Description"));
        this.jFMessagePane.setText(jFJob.getAttribute("NotificationMessage"));
    }

    public void updateDefinition() throws Exception {
        if (!this.m_editable) {
            throw new Exception(JFResourceBundle.getString("ManualJobDefinitionBean$ERR_nonEditableErr"));
        }
        if (this.jobDef == null) {
            throw new Exception(JFResourceBundle.getString("ManualJobDefinitionBean$ERR_noJobDefErr"));
        }
        this.jobDef = this.createJob(this.jobDef);
    }

    public JFJob getJobDefinition() throws Exception {
        return this.createJob(null);
    }

    JFJob createJob(JFJob jFJob) throws Exception {
        JFJob jFJob2 = null;
        String string = this.nameFLD.getText();
        if (!JFUtility.isValidJobFlowIdentity(string)) {
            throw new Exception(JFResourceBundle.getString("ManualJobDefinitionBean$ERR_jobNameInvalid"));
        }
        if (jFJob == null) {
            jFJob2 = new JFJob(string.trim(), "manual");
        } else {
            jFJob2 = jFJob;
            jFJob2.setName(string);
            jFJob2.removeAllAttributes();
        }
        jFJob2.setAttribute("UserName", this.m_currentUserName);
        if (this.addressFLD.getText() != null) {
            jFJob2.setAttribute("NotificationAddress", this.addressFLD.getText().trim());
        }
        if (this.jFMessagePane.getText() != null) {
            jFJob2.setAttribute("NotificationMessage", this.jFMessagePane.getText().trim());
        }
        if (this.jFDescriptionPane.getText() != null) {
            jFJob2.setAttribute("Description", this.jFDescriptionPane.getText().trim());
        }
        if (this.nonZeroCodesFLD.getText() != null) {
            jFJob2.setAttribute("NonZeroSuccessExitCodes", this.nonZeroCodesFLD.getText().trim());
        }
        jFJob2.validate();
        return jFJob2;
    }

    public JPanel getBeanPanel() {
        return this;
    }

    public void setEditable(boolean bl) {
        this.m_editable = bl;
        this.nameFLD.setEnabled(bl);
        this.nameFLD.setEnabled(bl);
        this.nameFLD.setOpaque(bl);
        this.addressFLD.setEditable(bl);
        this.addressFLD.setEnabled(bl);
        this.addressFLD.setOpaque(bl);
        this.nonZeroCodesFLD.setEditable(bl);
        this.nonZeroCodesFLD.setEnabled(bl);
        this.nonZeroCodesFLD.setOpaque(bl);
        this.jFDescriptionPane.setEditable(bl);
        this.jFDescriptionPane.setEnabled(bl);
        this.jFDescriptionPane.setOpaque(bl);
        this.jFMessagePane.setEditable(bl);
        this.jFMessagePane.setEnabled(bl);
        this.jFMessagePane.setOpaque(bl);
    }

    public void setJFAdmin(boolean bl) {
        this.m_isJFAdmin = bl;
    }

    private void setInputAccessibleInfo() {
        this.jLabel4.setLabelFor(this.nameFLD);
        this.nameFLD.getAccessibleContext().setAccessibleName(this.jLabel4.getText());
        this.nameFLD.getAccessibleContext().setAccessibleDescription(this.nameFLD.getToolTipText());
        this.jLabel1.setLabelFor(this.addressFLD);
        this.addressFLD.getAccessibleContext().setAccessibleName(this.jLabel1.getText());
        this.addressFLD.getAccessibleContext().setAccessibleDescription(this.addressFLD.getToolTipText());
        this.jLabel3.setLabelFor(this.nonZeroCodesFLD);
        this.nonZeroCodesFLD.getAccessibleContext().setAccessibleName(this.jLabel3.getText());
        this.nonZeroCodesFLD.getAccessibleContext().setAccessibleDescription(this.nonZeroCodesFLD.getToolTipText());
        this.jLabel5.setLabelFor(this.jScrollPane2);
        this.jScrollPane2.getAccessibleContext().setAccessibleName(this.jLabel5.getText());
        this.jScrollPane2.getAccessibleContext().setAccessibleDescription(this.jScrollPane2.getToolTipText());
        this.jLabel2.setLabelFor(this.jScrollPane1);
        this.jScrollPane1.getAccessibleContext().setAccessibleName(this.jLabel2.getText());
        this.jScrollPane1.getAccessibleContext().setAccessibleDescription(this.jScrollPane1.getToolTipText());
    }

    private void initComponents() {
        this.jLabel4 = new JLabel();
        this.nameFLD = new JTextField();
        this.jLabel1 = new JLabel();
        this.addressFLD = new JTextField();
        this.jLabel3 = new JLabel();
        this.nonZeroCodesFLD = new JTextField();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jFDescriptionPane = new JFDescriptionPane();
        this.jLabel5 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jFMessagePane = new JFDescriptionPane();
        this.setBorder(BorderFactory.createTitledBorder(JFResourceBundle.getString("Define_manual_job")));
        this.setMinimumSize(new Dimension(495, 326));
        this.setPreferredSize(new Dimension(521, 340));
        this.setLayout(new GridBagLayout());
        this.jLabel4.setText(JFResourceBundle.getString("Job_name_"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.nameFLD.setToolTipText(JFResourceBundle.getString("ManualJobDefinitionBean$TIP_nameFLD"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.nameFLD, gridBagConstraints);
        this.jLabel1.setText(JFResourceBundle.getString("Email_address_"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.addressFLD.setColumns(10);
        this.addressFLD.setToolTipText(JFResourceBundle.getString("ManualJobDefinitionBean$TIP_addressFLD"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.addressFLD, gridBagConstraints);
        this.jLabel3.setText(JFResourceBundle.getString("Non_zero_exit_codes_"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.nonZeroCodesFLD.setColumns(10);
        this.nonZeroCodesFLD.setToolTipText(JFResourceBundle.getString("JobDefinitionBean$TIP_nonZeroCodesFLD"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.nonZeroCodesFLD, gridBagConstraints);
        this.jLabel2.setText(JFResourceBundle.getString("Description_"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jScrollPane1.setToolTipText(JFResourceBundle.getString("JFManualJobDefinition$TIP_descriptionFLD"));
        this.jScrollPane1.setMinimumSize(new Dimension(300, 100));
        this.jScrollPane1.setPreferredSize(new Dimension(300, 100));
        this.jFDescriptionPane.setToolTipText(JFResourceBundle.getString("JFManualJobDefinition$TIP_descriptionFLD"));
        this.jScrollPane1.setViewportView(this.jFDescriptionPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabel5.setText(JFResourceBundle.getString("Message_"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel5, gridBagConstraints);
        this.jScrollPane2.setToolTipText(JFResourceBundle.getString("JFManualJobDefinition$TIP_messageFLD"));
        this.jScrollPane2.setMinimumSize(new Dimension(300, 100));
        this.jScrollPane2.setPreferredSize(new Dimension(300, 100));
        this.jFMessagePane.setToolTipText(JFResourceBundle.getString("JFManualJobDefinition$TIP_messageFLD"));
        this.jScrollPane2.setViewportView(this.jFMessagePane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jScrollPane2, gridBagConstraints);
    }

    class BeanInputVerifier
    extends InputVerifier {
        BeanInputVerifier() {
        }

        @Override
        public boolean verify(JComponent jComponent) {
            if (jComponent == JFManualJobDefinitionBean.this.nonZeroCodesFLD) {
                return JFUtility.verifyNonZeroCodes((JTextField)jComponent);
            }
            return true;
        }
    }
}

