/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFJob;
import com.platform.LSFJobFlow.api.JFUserGroup;
import com.platform.LSFJobFlow.ui.JFJobDefinitionDialog;
import com.platform.LSFJobFlow.ui.JFLocalJobDefinitionBean;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import com.platform.LSFJobFlow.ui.JFUtility;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JFLocalJobDefinitionDialog
extends JDialog {
    private JFLocalJobDefinitionBean jFLocalJobDefinitionBean1;
    private JPanel jPanel1;
    private JButton m_cancelButton;
    private JButton m_okButton;
    private boolean m_isEditable;
    private boolean m_jobIsModified;
    private JFJob m_jobDef;

    public JFLocalJobDefinitionDialog(Frame frame) {
        super(frame, true);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.m_okButton);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.m_okButton = new JButton();
        this.m_cancelButton = new JButton();
        this.m_cancelButton.setVerifyInputWhenFocusTarget(false);
        this.jFLocalJobDefinitionBean1 = new JFLocalJobDefinitionBean();
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.m_okButton.setText(JFResourceBundle.getString("OK"));
        this.m_okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFLocalJobDefinitionDialog.this.m_okButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.m_okButton);
        this.m_cancelButton.setText(JFResourceBundle.getString("Cancel"));
        this.m_cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFLocalJobDefinitionDialog.this.m_cancelButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.m_cancelButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.getContentPane().add((Component)this.jFLocalJobDefinitionBean1, new GridBagConstraints());
        this.pack();
    }

    private void m_cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.m_jobIsModified = false;
        this.setVisible(false);
        this.dispose();
    }

    private void m_okButtonActionPerformed(ActionEvent actionEvent) {
        if (this.m_isEditable) {
            try {
                if (!this.jFLocalJobDefinitionBean1.fieldsMatchJob(this.m_jobDef)) {
                    this.m_jobIsModified = true;
                }
                this.jFLocalJobDefinitionBean1.updateJobFromFields(this.m_jobDef);
            }
            catch (Exception exception) {
                JFUtility.showAppErrorMsg(JFUtility.getMainFrame(this), exception.getMessage());
                return;
            }
        }
        this.setVisible(false);
        this.dispose();
    }

    public boolean openJob(JFJob jFJob, boolean bl) {
        if (jFJob == null || this.jFLocalJobDefinitionBean1 == null) {
            return false;
        }
        this.m_jobIsModified = false;
        this.setEditable(bl);
        this.m_jobDef = jFJob;
        this.jFLocalJobDefinitionBean1.populateFieldsForJob(jFJob);
        if (!JFUtility.isLinux()) {
            this.pack();
        }
        this.show();
        return this.m_jobIsModified;
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new JFLocalJobDefinitionDialog(new JFrame()).setVisible(true);
            }
        });
    }

    private void setEditable(boolean bl) {
        this.m_isEditable = bl;
        this.jFLocalJobDefinitionBean1.setEditable(bl);
        this.m_cancelButton.setVisible(bl);
        if (bl) {
            this.setTitle(JFJobDefinitionDialog.PRODUCT_TITLE + " - " + JFResourceBundle.getString("Edit_local_job"));
        } else {
            this.setTitle(JFJobDefinitionDialog.PRODUCT_TITLE + " - " + JFResourceBundle.getString("View_local_job"));
        }
        this.getRootPane().setDefaultButton(this.m_okButton);
    }

    public void setJobOwner(String string) {
        if (this.jFLocalJobDefinitionBean1 != null) {
            this.jFLocalJobDefinitionBean1.setJobOwner(string);
        }
    }

    public void setJFAdmin(boolean bl) {
        if (this.jFLocalJobDefinitionBean1 != null) {
            this.jFLocalJobDefinitionBean1.setJFAdmin(bl);
        }
    }

    public void setLSFUserGroups(List<JFUserGroup> list) {
        if (this.jFLocalJobDefinitionBean1 != null) {
            this.jFLocalJobDefinitionBean1.setLSFUserGroups(list);
        }
    }
}

