/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFCommon;
import com.platform.LSFJobFlow.api.JFEvent;
import com.platform.LSFJobFlow.api.JFJob;
import com.platform.LSFJobFlow.api.JFJobEvent;
import com.platform.LSFJobFlow.api.JFJobExceptionEvent;
import com.platform.LSFJobFlow.ui.JFDescriptionPane;
import com.platform.LSFJobFlow.ui.JFEventBeanINF;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class JFJobEventBean
extends JPanel
implements JFEventBeanINF {
    JFEvent m_event = null;
    boolean m_editable = false;
    DefaultComboBoxModel operatorsTranslate = new DefaultComboBoxModel<String>(new String[]{">", ">=", "==", "<", "<=", "!="});
    private static DefaultComboBoxModel modelForLocalJob = new DefaultComboBoxModel<String>(new String[]{JFResourceBundle.getString("Completes_successfully"), JFResourceBundle.getString("Fails"), JFResourceBundle.getString("Ends_with_any_exit_code"), JFResourceBundle.getString("Ends_with_exit_code")});
    private static DefaultComboBoxModel modelForRegularJob = new DefaultComboBoxModel<String>(new String[]{JFResourceBundle.getString("Completes_successfully"), JFResourceBundle.getString("Fails"), JFResourceBundle.getString("Ends_with_any_exit_code"), JFResourceBundle.getString("Ends_with_exit_code"), JFResourceBundle.getString("Submitted"), JFResourceBundle.getString("Starts"), JFResourceBundle.getString("Runs_more_than"), JFResourceBundle.getString("Runs_less_than"), JFResourceBundle.getString("Misses_scheduled_time"), JFResourceBundle.getString("Fails_to_start"), JFResourceBundle.getString("Cannot_run")});
    private static DefaultComboBoxModel modelForOtherBatchJob = new DefaultComboBoxModel<String>(new String[]{JFResourceBundle.getString("Completes_successfully"), JFResourceBundle.getString("Fails"), JFResourceBundle.getString("Ends_with_any_exit_code"), JFResourceBundle.getString("Ends_with_exit_code")});
    private JFDescriptionPane descriptionPane;
    private JTextField eventSourceFLD;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JComboBox jobEventTypeFLD;
    private JTextField m_exitExpFLD;
    private JTextField m_minutesFLD;
    private JLabel m_minutesLabel;
    private JComboBox opFLD;

    public JFJobEventBean() {
        this.initComponents();
        this.setInputAccessibleInfo();
    }

    @Override
    public void reset() {
        this.m_event = null;
        this.eventSourceFLD.setText("");
        this.m_exitExpFLD.setText("");
        this.m_minutesFLD.setText("");
        this.jobEventTypeFLD.setSelectedIndex(0);
        this.opFLD.setSelectedIndex(0);
        this.jobEventTypeFLD.setEnabled(this.m_editable);
        this.jobEventTypeFLD.setOpaque(this.m_editable);
    }

    @Override
    public void setEvent(JFEvent jFEvent) throws Exception {
        this.reset();
        if (jFEvent == null) {
            return;
        }
        if (!(jFEvent instanceof JFJobEvent) && !(jFEvent instanceof JFJobExceptionEvent)) {
            throw new Exception(JFResourceBundle.getString("JobEventBean$ERR_parameterErr"));
        }
        this.descriptionPane.setText(jFEvent.getAttribute("Description"));
        int n = 0;
        if (jFEvent instanceof JFJobEvent) {
            JFJobEvent jFJobEvent = (JFJobEvent)jFEvent;
            this.eventSourceFLD.setText(jFJobEvent.getEventJob().getName());
            n = jFJobEvent.getEventType();
            String string = ((JFJobEvent)jFEvent).getEventJob().getExecutionType();
            if ("manual".equals(string)) {
                this.jobEventTypeFLD.setModel(modelForLocalJob);
            } else if ("local".equals(string)) {
                this.jobEventTypeFLD.setModel(modelForLocalJob);
            } else if ("otherbatch".equals(string)) {
                this.jobEventTypeFLD.setModel(modelForOtherBatchJob);
            }
            switch (n) {
                case 0: {
                    this.jobEventTypeFLD.setSelectedIndex(0);
                    break;
                }
                case 5: {
                    this.jobEventTypeFLD.setSelectedIndex(1);
                    break;
                }
                case 1: {
                    this.jobEventTypeFLD.setSelectedIndex(2);
                    break;
                }
                case 3: {
                    this.jobEventTypeFLD.setSelectedIndex(3);
                    this.opFLD.setSelectedIndex(this.operatorsTranslate.getIndexOf(jFJobEvent.getComparisonOp()));
                    this.m_exitExpFLD.setText(JFCommon.integerArrayToString((int[])jFJobEvent.getComparisonValues()));
                    break;
                }
                case 4: {
                    this.jobEventTypeFLD.setSelectedIndex(4);
                    break;
                }
                case 2: {
                    this.jobEventTypeFLD.setSelectedIndex(5);
                    break;
                }
                default: {
                    throw new Exception(JFResourceBundle.getString("JobEventBean$ERR_invalidEventType"));
                }
            }
            this.m_event = jFJobEvent;
        } else {
            JFJobExceptionEvent jFJobExceptionEvent = (JFJobExceptionEvent)jFEvent;
            this.eventSourceFLD.setText(jFJobExceptionEvent.getEventJob().getName());
            n = jFJobExceptionEvent.getEventType();
            switch (n) {
                case 3: {
                    this.jobEventTypeFLD.setSelectedIndex(6);
                    this.m_minutesFLD.setText(String.valueOf(jFJobExceptionEvent.getValue()));
                    break;
                }
                case 4: {
                    this.jobEventTypeFLD.setSelectedIndex(7);
                    this.m_minutesFLD.setText(String.valueOf(jFJobExceptionEvent.getValue()));
                    break;
                }
                case 0: {
                    this.jobEventTypeFLD.setSelectedIndex(8);
                    break;
                }
                case 1: {
                    this.jobEventTypeFLD.setSelectedIndex(9);
                    break;
                }
                case 2: {
                    this.jobEventTypeFLD.setSelectedIndex(10);
                    break;
                }
                default: {
                    throw new Exception(JFResourceBundle.getString("JFEventBean$ERR_invalidEventType"));
                }
            }
            this.m_event = jFJobExceptionEvent;
        }
        this.descriptionPane.setText(this.m_event.getAttribute("Description"));
    }

    @Override
    public JFEvent getEvent() throws Exception {
        int n = this.jobEventTypeFLD.getSelectedIndex();
        JFJob jFJob = this.m_event instanceof JFJobEvent ? ((JFJobEvent)this.m_event).getEventJob() : ((JFJobExceptionEvent)this.m_event).getEventJob();
        switch (n) {
            case 0: {
                this.m_event = new JFJobEvent(jFJob, 0);
                break;
            }
            case 1: {
                this.m_event = new JFJobEvent(jFJob, 5);
                break;
            }
            case 2: {
                this.m_event = new JFJobEvent(jFJob, 1);
                break;
            }
            case 3: {
                String string = (String)this.operatorsTranslate.getElementAt(this.opFLD.getSelectedIndex());
                int[] nArray = null;
                try {
                    nArray = JFCommon.stringToIntegerArray((String)this.m_exitExpFLD.getText());
                }
                catch (Exception exception) {
                    throw new Exception(JFResourceBundle.getString("JobEventBean$ERR_invalidExpr"));
                }
                this.m_event = new JFJobEvent(jFJob, string, nArray);
                break;
            }
            case 4: {
                this.m_event = new JFJobEvent(jFJob, 4);
                break;
            }
            case 5: {
                this.m_event = new JFJobEvent(jFJob, 2);
                break;
            }
            case 6: {
                int n2;
                try {
                    n2 = Integer.parseInt(this.m_minutesFLD.getText());
                }
                catch (Exception exception) {
                    throw new Exception(JFResourceBundle.getString("JobEventBean$ERR_invalidMinute"));
                }
                if (n2 < 1) {
                    throw new Exception(JFResourceBundle.getString("JobEventBean$ERR_MinuteLessThanOne"));
                }
                this.m_event = new JFJobExceptionEvent(jFJob, 3, n2);
                break;
            }
            case 7: {
                int n3;
                try {
                    n3 = Integer.parseInt(this.m_minutesFLD.getText());
                }
                catch (Exception exception) {
                    throw new Exception(JFResourceBundle.getString("JobEventBean$ERR_invalidMinute"));
                }
                if (n3 < 1) {
                    throw new Exception(JFResourceBundle.getString("JobEventBean$ERR_MinuteLessThanOne"));
                }
                this.m_event = new JFJobExceptionEvent(jFJob, 4, n3);
                break;
            }
            case 8: {
                this.m_event = new JFJobExceptionEvent(jFJob, 0);
                break;
            }
            case 9: {
                this.m_event = new JFJobExceptionEvent(jFJob, 1);
                break;
            }
            case 10: {
                this.m_event = new JFJobExceptionEvent(jFJob, 2);
                break;
            }
            default: {
                this.m_event = null;
            }
        }
        if (this.descriptionPane.getText() != null) {
            this.m_event.setAttribute("PositionX", "1");
            this.m_event.setAttribute("PositionY", "1");
            this.m_event.setAttribute("Description", this.descriptionPane.getText());
        }
        return this.m_event;
    }

    @Override
    public JPanel getBeanPanel() {
        return this;
    }

    @Override
    public void setEditable(boolean bl) {
        this.m_editable = bl;
        this.jobEventTypeFLD.setEnabled(bl);
        this.jobEventTypeFLD.setOpaque(bl);
        this.opFLD.setEnabled(bl);
        this.opFLD.setOpaque(bl);
        this.m_exitExpFLD.setEnabled(bl);
        this.m_exitExpFLD.setOpaque(bl);
        this.descriptionPane.setEditable(bl);
        this.descriptionPane.setOpaque(bl);
        this.m_minutesFLD.setEnabled(bl);
        this.m_minutesFLD.setOpaque(bl);
    }

    @Override
    public String getSupportedEventTypeName() {
        return "Job Event";
    }

    @Override
    public void showAllComponents() {
        this.m_minutesFLD.setVisible(true);
        this.m_minutesLabel.setVisible(true);
        this.opFLD.setVisible(true);
        this.m_exitExpFLD.setVisible(true);
    }

    private void setInputAccessibleInfo() {
        this.jLabel1.setLabelFor(this.eventSourceFLD);
        this.eventSourceFLD.getAccessibleContext().setAccessibleName(this.jLabel1.getText());
        this.eventSourceFLD.getAccessibleContext().setAccessibleDescription(this.eventSourceFLD.getToolTipText());
        this.jLabel2.setLabelFor(this.jobEventTypeFLD);
        this.jobEventTypeFLD.getAccessibleContext().setAccessibleName(this.jLabel2.getText());
        this.jobEventTypeFLD.getAccessibleContext().setAccessibleDescription(this.jobEventTypeFLD.getToolTipText());
        this.m_exitExpFLD.getAccessibleContext().setAccessibleDescription(this.m_exitExpFLD.getToolTipText());
        this.m_minutesLabel.setLabelFor(this.m_minutesFLD);
        this.m_minutesFLD.getAccessibleContext().setAccessibleName(this.m_minutesLabel.getText());
        this.m_minutesFLD.getAccessibleContext().setAccessibleDescription(this.m_minutesFLD.getToolTipText());
        this.jLabel4.setLabelFor(this.jScrollPane1);
        this.jScrollPane1.getAccessibleContext().setAccessibleName(this.jLabel4.getText());
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.eventSourceFLD = new JTextField();
        this.jobEventTypeFLD = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.descriptionPane = new JFDescriptionPane();
        this.opFLD = new JComboBox();
        this.m_exitExpFLD = new JTextField();
        this.m_minutesFLD = new JTextField();
        this.m_minutesLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(JFResourceBundle.getString("Trigger_event_when_")));
        this.jLabel1.setText(JFResourceBundle.getString("Job_name_"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.eventSourceFLD.setColumns(10);
        this.eventSourceFLD.setEditable(false);
        this.eventSourceFLD.setToolTipText(JFResourceBundle.getString("JFJobEventBean$TIP_jobNameFLD"));
        this.eventSourceFLD.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.eventSourceFLD, gridBagConstraints);
        this.jobEventTypeFLD.setModel(modelForRegularJob);
        this.jobEventTypeFLD.setToolTipText(JFResourceBundle.getString("JFJobEventBean$TIP_eventTypeFLD"));
        this.jobEventTypeFLD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFJobEventBean.this.jobEventTypeFLDActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jobEventTypeFLD, gridBagConstraints);
        this.jLabel2.setText(JFResourceBundle.getString("Event_type_"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel4.setText(JFResourceBundle.getString("Description_"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.jScrollPane1.setMinimumSize(new Dimension(300, 100));
        this.descriptionPane.setPreferredSize(new Dimension(300, 100));
        this.jScrollPane1.setViewportView(this.descriptionPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.opFLD.setModel(new DefaultComboBoxModel<String>(new String[]{JFResourceBundle.getString("Greater_than"), JFResourceBundle.getString("Greater_than_or_equal_to"), JFResourceBundle.getString("Equal_to"), JFResourceBundle.getString("Less_than"), JFResourceBundle.getString("Less_than_or_equal_to"), JFResourceBundle.getString("Not_equal_to")}));
        this.opFLD.setToolTipText(JFResourceBundle.getString("JFJobEventBean$TIP_opFLD"));
        this.opFLD.setMinimumSize(new Dimension(166, 26));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.opFLD, gridBagConstraints);
        this.m_exitExpFLD.setColumns(7);
        this.m_exitExpFLD.setToolTipText(JFResourceBundle.getString("JFJobEventBean$TIP_exitExpFLD"));
        this.m_exitExpFLD.setMinimumSize(new Dimension(77, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.m_exitExpFLD, gridBagConstraints);
        this.m_minutesFLD.setColumns(10);
        this.m_minutesFLD.setText("jTextField1");
        this.m_minutesFLD.setMinimumSize(new Dimension(166, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.m_minutesFLD, gridBagConstraints);
        this.m_minutesLabel.setText(JFResourceBundle.getString("minutes"));
        this.m_minutesLabel.setMaximumSize(new Dimension(77, 17));
        this.m_minutesLabel.setMinimumSize(new Dimension(77, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.m_minutesLabel, gridBagConstraints);
    }

    private void jobEventTypeFLDActionPerformed(ActionEvent actionEvent) {
        switch (this.jobEventTypeFLD.getSelectedIndex()) {
            case 3: {
                this.opFLD.setVisible(true);
                this.m_exitExpFLD.setVisible(true);
                this.m_minutesFLD.setVisible(false);
                this.m_minutesLabel.setVisible(false);
                if (!this.m_editable) break;
                this.m_exitExpFLD.requestFocus();
                break;
            }
            case 6: 
            case 7: {
                this.m_minutesFLD.setVisible(true);
                this.m_minutesLabel.setVisible(true);
                this.opFLD.setVisible(false);
                this.m_exitExpFLD.setVisible(false);
                if (!this.m_editable) break;
                this.m_minutesFLD.requestFocus();
                break;
            }
            default: {
                this.m_minutesFLD.setVisible(false);
                this.m_minutesLabel.setVisible(false);
                this.opFLD.setVisible(false);
                this.m_exitExpFLD.setVisible(false);
            }
        }
    }
}

