/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFConfigManager;
import com.platform.LSFJobFlow.api.JFFlow;
import com.platform.LSFJobFlow.api.JFJob;
import com.platform.LSFJobFlow.api.JFJobArray;
import com.platform.LSFJobFlow.api.JFLoginManager;
import com.platform.LSFJobFlow.api.JFUserGroup;
import com.platform.LSFJobFlow.ui.JFJobDefinitionBean;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import com.platform.LSFJobFlow.ui.JFUtility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;

public class JFJobDefinitionDialog
extends JDialog {
    static final String PRODUCT_TITLE = JFResourceBundle.getString("JobDefinitionDialog$TITLE");
    boolean m_editable = true;
    boolean m_isJobArray = false;
    JFJob m_jobDef = null;
    JFJobArray m_jobArrayDef = null;
    boolean m_isOKPressed = false;
    boolean m_isJFAdmin = false;
    private JFFlow currentFlow = null;
    private List<JFUserGroup> m_lsfUserGroups = null;
    private JFJobDefinitionBean jobDefinitionBean;
    private JPanel jPanel1;
    private JButton okButton;
    private JButton cancelButton;
    private JButton resetButton;

    public JFJobDefinitionDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        if (this.jobDefinitionBean != null) {
            this.jobDefinitionBean.setJFAdmin(this.m_isJFAdmin);
            this.jobDefinitionBean.setAdvancedPresubmitVisible(true);
            this.jobDefinitionBean.setLSFUserGroups(this.m_lsfUserGroups);
        }
        this.m_editable = true;
        this.setEditable(this.m_editable);
        this.m_isJobArray = false;
        this.m_jobDef = null;
        this.m_jobArrayDef = null;
        this.getRootPane().setDefaultButton(this.okButton);
    }

    public void setAvailableJobs(String string) {
        if (string == null) {
            string = "";
        }
        List list = this.currentFlow.availableJobs(string);
        this.jobDefinitionBean.setAvailableJobs(list);
    }

    public void setCurrentFlow(JFFlow jFFlow) {
        this.currentFlow = jFFlow;
    }

    public JFFlow getCurrentFlow() {
        return this.currentFlow;
    }

    public void setFullFlowName(String string) {
        this.jobDefinitionBean.setFullFlowName(string);
    }

    public void refresh() {
        if (this.jobDefinitionBean != null) {
            this.jobDefinitionBean.populate();
        }
    }

    public JFJob createNewJob(String string) {
        this.m_isJobArray = false;
        this.m_editable = true;
        this.jobDefinitionBean.setJobArrayFlag(this.m_isJobArray);
        this.jobDefinitionBean.reset(string);
        this.setEditable(true);
        this.m_jobDef = null;
        this.m_jobArrayDef = null;
        this.setTitle(PRODUCT_TITLE + " - " + JFResourceBundle.getString("Create_job"));
        if (!JFUtility.isLinux()) {
            this.pack();
        }
        this.show();
        return this.m_jobDef;
    }

    public JFJobArray createNewJobArray(String string) {
        this.m_isJobArray = true;
        this.m_editable = true;
        this.jobDefinitionBean.setJobArrayFlag(true);
        this.jobDefinitionBean.reset(string);
        this.setEditable(true);
        this.m_jobDef = null;
        this.m_jobArrayDef = null;
        this.setTitle(PRODUCT_TITLE + " - " + JFResourceBundle.getString("Create_job_array"));
        if (!JFUtility.isLinux()) {
            this.pack();
        }
        this.show();
        return this.m_jobArrayDef;
    }

    public void setJobsName(Vector vector) {
        this.jobDefinitionBean.setJobsName(vector);
    }

    public void setHostList(String[] stringArray) {
        this.jobDefinitionBean.setHostList(stringArray);
    }

    public void setHostSpecList(String[] stringArray) {
        this.jobDefinitionBean.setHostSpecList(stringArray);
    }

    public void setQueueList(String[] stringArray) {
        this.jobDefinitionBean.setQueueList(stringArray);
    }

    public void setMainFlowOwner(String string) {
        this.jobDefinitionBean.setMainFlowOwner(string);
    }

    public boolean openJob(JFJob jFJob, boolean bl) {
        if (jFJob == null || this.jobDefinitionBean == null) {
            return false;
        }
        this.m_editable = bl;
        this.m_isJobArray = false;
        this.m_jobArrayDef = null;
        this.m_jobDef = jFJob;
        if (bl) {
            this.setTitle(PRODUCT_TITLE + " - " + JFResourceBundle.getString("Edit_job"));
        } else {
            this.setTitle(PRODUCT_TITLE + " - " + JFResourceBundle.getString("View_job"));
        }
        this.setEditable(bl);
        this.jobDefinitionBean.setJobDefinition(jFJob);
        this.m_isOKPressed = false;
        if (!JFUtility.isLinux()) {
            this.pack();
        }
        this.show();
        int n = this.jobDefinitionBean.getCancelOrContinue();
        if (bl && this.m_isOKPressed || bl && n == 1) {
            this.copyExtraAttributes(this.m_jobDef, jFJob);
            return !jFJob.equals(this.m_jobDef);
        }
        return false;
    }

    public boolean openJobArray(JFJobArray jFJobArray, boolean bl) {
        if (jFJobArray == null || this.jobDefinitionBean == null) {
            return false;
        }
        this.m_editable = bl;
        this.m_isJobArray = true;
        this.m_jobArrayDef = jFJobArray;
        this.m_jobDef = null;
        if (bl) {
            this.setTitle(PRODUCT_TITLE + " - " + JFResourceBundle.getString("Edit_job_array"));
        } else {
            this.setTitle(PRODUCT_TITLE + " - " + JFResourceBundle.getString("View_job_array"));
        }
        this.setEditable(bl);
        this.jobDefinitionBean.setJobArrayDefinition(jFJobArray);
        this.m_isOKPressed = false;
        if (!JFUtility.isLinux()) {
            this.pack();
        }
        this.show();
        int n = this.jobDefinitionBean.getCancelOrContinue();
        if (bl && this.m_isOKPressed || bl && n == 1) {
            this.copyExtraAttributes(this.m_jobArrayDef.getJobDefinition(), jFJobArray.getJobDefinition());
            return !jFJobArray.equals(this.m_jobArrayDef);
        }
        return false;
    }

    public void reset() {
        if (this.jobDefinitionBean != null) {
            this.jobDefinitionBean.reset();
        }
        if (this.m_isJobArray) {
            this.setAvailableJobs(this.m_jobArrayDef.getName());
        } else {
            this.setAvailableJobs(this.m_jobDef.getName());
        }
    }

    void copyExtraAttributes(JFJob jFJob, JFJob jFJob2) {
        if (jFJob == null || jFJob2 == null) {
            return;
        }
        jFJob2.setAttribute("ImplementRefer", jFJob.getAttribute("ImplementRefer"));
        jFJob2.setAttribute("Name", jFJob.getAttribute("Name"));
        jFJob2.setAttribute("ImplementType", jFJob.getAttribute("ImplementType"));
        jFJob2.setAttribute("SearchKey", jFJob.getAttribute("SearchKey"));
        jFJob2.setAttribute("Overridable", jFJob.getAttribute("Overridable"));
        jFJob2.setAttribute("Visible", jFJob.getAttribute("Visible"));
        jFJob2.setAttribute("PositionX", jFJob.getAttribute("PositionX"));
        jFJob2.setAttribute("PositionY", jFJob.getAttribute("PositionY"));
    }

    public void setJFAdmin(boolean bl) {
        this.m_isJFAdmin = bl;
        if (this.jobDefinitionBean != null) {
            this.jobDefinitionBean.setJFAdmin(this.m_isJFAdmin);
        }
    }

    public void setLSFUserGroups(List<JFUserGroup> list) {
        this.m_lsfUserGroups = list;
        if (this.jobDefinitionBean != null) {
            this.jobDefinitionBean.setLSFUserGroups(this.m_lsfUserGroups);
        }
    }

    private void setEditable(boolean bl) {
        if (bl) {
            this.jobDefinitionBean.setEditable(true);
            this.cancelButton.setVisible(true);
            this.resetButton.setVisible(true);
        } else {
            this.jobDefinitionBean.setEditable(false);
            this.cancelButton.setVisible(false);
            this.resetButton.setVisible(false);
        }
        this.getRootPane().setDefaultButton(this.okButton);
    }

    private void initComponents() {
        this.jobDefinitionBean = new JFJobDefinitionBean();
        this.jPanel1 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.resetButton = new JButton();
        this.setTitle(JFResourceBundle.getString("JobDefinitionDialog$TITLE_NEWJOB"));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                JFJobDefinitionDialog.this.closeDialog(windowEvent);
            }
        });
        this.getContentPane().add((Component)this.jobDefinitionBean, "Center");
        this.jPanel1.setBorder(new LineBorder(Color.black));
        this.okButton.setText(JFResourceBundle.getString("OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFJobDefinitionDialog.this.okButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.okButton);
        this.cancelButton.setText(JFResourceBundle.getString("Cancel"));
        this.cancelButton.setVerifyInputWhenFocusTarget(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFJobDefinitionDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.cancelButton);
        this.resetButton.setText(JFResourceBundle.getString("Reset"));
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFJobDefinitionDialog.this.resetButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.resetButton);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.pack();
    }

    private void resetButtonActionPerformed(ActionEvent actionEvent) {
        this.jobDefinitionBean.reset();
        if (this.m_isJobArray) {
            this.setAvailableJobs(this.m_jobArrayDef.getName());
        } else {
            this.setAvailableJobs(this.m_jobDef.getName());
        }
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        this.m_isOKPressed = true;
        if (this.jobDefinitionBean == null || !this.m_editable) {
            this.setVisible(false);
            return;
        }
        try {
            if (this.m_isJobArray) {
                if (this.m_jobArrayDef != null) {
                    this.m_jobArrayDef = (JFJobArray)this.m_jobArrayDef.clone();
                    this.jobDefinitionBean.updateDefinition();
                } else {
                    this.m_jobArrayDef = this.jobDefinitionBean.getJobArrayDefinition();
                }
            } else if (this.m_jobDef != null) {
                this.m_jobDef = (JFJob)this.m_jobDef.clone();
                this.jobDefinitionBean.updateDefinition();
            } else {
                this.m_jobDef = this.jobDefinitionBean.getJobDefinition();
            }
            if (this.jobDefinitionBean != null && this.jobDefinitionBean.getCloseFlag()) {
                this.setVisible(false);
                this.dispose();
            }
        }
        catch (Exception exception) {
            JFUtility.showAppException(this, exception);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.m_isOKPressed = false;
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.m_isOKPressed = false;
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] stringArray) {
        try {
            JFConfigManager.init();
            JFLoginManager.login((boolean)false);
            JFJobDefinitionDialog jFJobDefinitionDialog = new JFJobDefinitionDialog((Frame)new JFrame(), true);
            JFJob jFJob = new JFJob("Job1");
            jFJob.setAttribute("JobCmdLine", "echo abc");
            jFJobDefinitionDialog.openJob(jFJob, true);
            if (stringArray.length > 0 && stringArray[0].equals("disable")) {
                jFJobDefinitionDialog.setCommandLineEditable(false);
                jFJobDefinitionDialog.setJobNameEditable(false);
            }
            jFJobDefinitionDialog.show();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.getMessage());
        }
    }

    public void setCommandLineEditable(boolean bl) {
        this.jobDefinitionBean.setCommandLineEditable(bl);
    }

    public void setJobNameEditable(boolean bl) {
        this.jobDefinitionBean.setJobNameEditable(bl);
    }

    public void setJobOwner(String string) {
        if (this.jobDefinitionBean != null) {
            this.jobDefinitionBean.setJobOwner(string);
        }
    }
}

