/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFEvent;
import com.platform.LSFJobFlow.ui.JFEventBeanINF;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import com.platform.LSFJobFlow.ui.JFUtility;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JFEventDialog
extends JDialog {
    JFEventBeanINF m_curEventBean = null;
    JFEvent m_newEvent = null;
    boolean m_editable = false;
    private JPanel commandPanel;
    private JButton okButton;
    private JButton cancelButton;

    public JFEventDialog(Frame frame, boolean bl, JFEventBeanINF jFEventBeanINF) {
        super(frame, bl);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
        if (jFEventBeanINF == null) {
            throw new NullPointerException(JFResourceBundle.getString("JFEventDialog$ERR_nullEventBean"));
        }
        this.m_curEventBean = jFEventBeanINF;
        this.m_curEventBean.showAllComponents();
        this.getContentPane().add((Component)this.m_curEventBean.getBeanPanel(), "Center");
        Dimension dimension = this.m_curEventBean.getBeanPanel().getPreferredSize();
        Dimension dimension2 = this.commandPanel.getPreferredSize();
        Dimension dimension3 = new Dimension((int)dimension.getWidth(), (int)(dimension.getHeight() + dimension2.getHeight()));
        this.setPreferredSize(dimension3);
        this.setMinimumSize(dimension3);
        this.setSize(dimension3);
        this.pack();
        this.m_newEvent = null;
    }

    public JFEvent openEvent(JFEvent jFEvent, boolean bl) {
        if (this.m_curEventBean == null) {
            return null;
        }
        this.m_curEventBean.setEditable(bl);
        this.m_editable = bl;
        this.cancelButton.setVisible(this.m_editable);
        try {
            this.m_curEventBean.setEvent(jFEvent);
        }
        catch (Exception exception) {
            JFUtility.showAppException(this.getParent(), exception);
        }
        String string = this.m_curEventBean.getSupportedEventTypeName();
        if (string == null || string.length() == 0) {
            this.setTitle(JFResourceBundle.getString("Event_Definition"));
        } else {
            Object[] objectArray = new Object[]{string.trim()};
            String string2 = JFResourceBundle.getString("A_Definition");
            MessageFormat messageFormat = new MessageFormat(string2);
            this.setTitle(messageFormat.format(objectArray));
        }
        this.setVisible(true);
        if (this.m_newEvent != null && this.m_newEvent.equals((Object)jFEvent)) {
            return null;
        }
        return this.m_newEvent;
    }

    public JFEvent newEvent() {
        if (this.m_curEventBean == null) {
            return null;
        }
        this.m_curEventBean.setEditable(true);
        this.m_curEventBean.reset();
        this.m_editable = true;
        this.cancelButton.setVisible(this.m_editable);
        this.setVisible(true);
        return this.m_newEvent;
    }

    private void initComponents() {
        this.commandPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setTitle(JFResourceBundle.getString("EventDialog$TITLE"));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                JFEventDialog.this.closeDialog(windowEvent);
            }
        });
        this.okButton.setText(JFResourceBundle.getString("OK"));
        this.commandPanel.setMinimumSize(new Dimension(129, 32));
        this.commandPanel.setPreferredSize(new Dimension(129, 32));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFEventDialog.this.okButtonActionPerformed(actionEvent);
            }
        });
        this.commandPanel.add(this.okButton);
        this.cancelButton.setText(JFResourceBundle.getString("Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFEventDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.commandPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.commandPanel, "South");
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        if (this.m_editable) {
            try {
                this.m_newEvent = this.m_curEventBean.getEvent();
                this.setVisible(false);
                this.dispose();
            }
            catch (Exception exception) {
                JFUtility.showAppException(this.getParent(), exception);
            }
        } else {
            this.m_newEvent = null;
            this.setVisible(false);
            this.dispose();
        }
        this.getParent().repaint();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] stringArray) {
        new JFEventDialog((Frame)new JFrame(), true, (JFEventBeanINF)null).show();
    }
}

