/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.ui.AbstractImageShape;
import com.platform.LSFJobFlow.ui.EventShape;
import com.platform.LSFJobFlow.ui.FlowDiagram;
import com.platform.LSFJobFlow.ui.JFInternalProxyEventShape;
import com.platform.LSFJobFlow.ui.JFPrintOptionsManager;
import com.platform.LSFJobFlow.ui.JFUtility;
import com.platform.LSFJobFlow.ui.JobFlowShapeINF;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.JPanel;

public class JFDiagramPanel
extends JPanel
implements Printable {
    FlowDiagram flowDiagram = null;
    Graphics2D g2 = null;
    JobFlowShapeINF lastSelectedShape = null;
    JobFlowShapeINF curSelectedShape = null;
    double scale_x = 1.0;
    double scale_y = 1.0;
    BufferedImage m_bi = null;
    int m_maxNumPage = 10;
    private int m_printRows = 0;
    private int m_printColumns = 0;
    private int m_pageNumberFontHeight = 0;

    public JFDiagramPanel() {
        this.initComponents();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.g2 = (Graphics2D)graphics;
        if (!JFUtility.isAIX_JRE_1_3_x()) {
            this.g2.scale(this.scale_x, this.scale_y);
        }
        if (this.flowDiagram != null) {
            this.flowDiagram.drawDiagram(this.g2);
        }
    }

    public void setFlowDiagram(FlowDiagram flowDiagram) {
        this.flowDiagram = flowDiagram;
        this.lastSelectedShape = null;
        this.curSelectedShape = flowDiagram != null ? flowDiagram.getCurrentSelectedShape() : null;
    }

    public void setScale(double d, double d2) {
        this.scale_x = d;
        this.scale_y = d2;
    }

    public JobFlowShapeINF getShape(int n, int n2) {
        if (this.flowDiagram == null) {
            return null;
        }
        Iterator iterator = this.flowDiagram.getShapes();
        JobFlowShapeINF jobFlowShapeINF = null;
        LinkedList<JobFlowShapeINF> linkedList = new LinkedList<JobFlowShapeINF>();
        this.g2 = (Graphics2D)this.getGraphics();
        while (iterator.hasNext()) {
            jobFlowShapeINF = (JobFlowShapeINF)iterator.next();
            if (!jobFlowShapeINF.contains(n, n2, this.g2)) continue;
            if (jobFlowShapeINF instanceof JFInternalProxyEventShape) {
                linkedList.add(jobFlowShapeINF);
                continue;
            }
            return jobFlowShapeINF;
        }
        if (jobFlowShapeINF == null) {
            return null;
        }
        JFInternalProxyEventShape jFInternalProxyEventShape = null;
        Iterator iterator2 = linkedList.iterator();
        if (!iterator2.hasNext()) {
            return null;
        }
        jFInternalProxyEventShape = (JFInternalProxyEventShape)iterator2.next();
        while (iterator2.hasNext()) {
            JFInternalProxyEventShape jFInternalProxyEventShape2 = (JFInternalProxyEventShape)iterator2.next();
            if (jFInternalProxyEventShape2.distanceSq(n, n2) >= jFInternalProxyEventShape.distanceSq(n, n2)) continue;
            jFInternalProxyEventShape = jFInternalProxyEventShape2;
        }
        return jFInternalProxyEventShape;
    }

    public void drawShape(JobFlowShapeINF jobFlowShapeINF) {
        if (jobFlowShapeINF == null) {
            return;
        }
        this.g2 = (Graphics2D)this.getGraphics();
        if (!JFUtility.isAIX_JRE_1_3_x()) {
            this.g2.scale(this.scale_x, this.scale_y);
        }
        jobFlowShapeINF.erase(this.g2);
        jobFlowShapeINF.draw(this.g2);
    }

    public void eraseShape(JobFlowShapeINF jobFlowShapeINF) {
        if (jobFlowShapeINF == null) {
            return;
        }
        this.g2 = (Graphics2D)this.getGraphics();
        if (!JFUtility.isAIX_JRE_1_3_x()) {
            this.g2.scale(this.scale_x, this.scale_y);
        }
        jobFlowShapeINF.erase(this.g2);
    }

    public void redrawShape(JobFlowShapeINF jobFlowShapeINF) {
        if (jobFlowShapeINF == null) {
            return;
        }
        this.g2 = (Graphics2D)this.getGraphics();
        if (this.g2 == null) {
            return;
        }
        if (!JFUtility.isAIX_JRE_1_3_x()) {
            this.g2.scale(this.scale_x, this.scale_y);
        }
        jobFlowShapeINF.erase(this.g2);
        jobFlowShapeINF.draw(this.g2);
    }

    public void selectShape(JobFlowShapeINF jobFlowShapeINF) {
        this.g2 = (Graphics2D)this.getGraphics();
        if (this.g2 == null) {
            return;
        }
        if (!JFUtility.isAIX_JRE_1_3_x()) {
            this.g2.scale(this.scale_x, this.scale_y);
        }
        this.lastSelectedShape = this.curSelectedShape;
        this.curSelectedShape = jobFlowShapeINF;
        if (this.lastSelectedShape != null) {
            this.lastSelectedShape.setSelected(false);
            this.hideShape(this.lastSelectedShape);
            this.lastSelectedShape.draw(this.g2);
        }
        if (this.curSelectedShape != null) {
            if (JFUtility.isAIX_JRE_1_3_x()) {
                this.hideShape(this.curSelectedShape);
            }
            this.curSelectedShape.setSelected(true);
            this.curSelectedShape.draw(this.g2);
        }
    }

    public void hideShape(JobFlowShapeINF jobFlowShapeINF) {
        if (jobFlowShapeINF == null) {
            return;
        }
        this.g2 = (Graphics2D)this.getGraphics();
        if (!JFUtility.isAIX_JRE_1_3_x()) {
            this.g2.scale(this.scale_x, this.scale_y);
        }
        jobFlowShapeINF.erase(this.g2);
        if (this.flowDiagram == null) {
            return;
        }
        Iterator iterator = this.flowDiagram.getShapes();
        JobFlowShapeINF jobFlowShapeINF2 = null;
        while (iterator.hasNext()) {
            jobFlowShapeINF2 = (JobFlowShapeINF)iterator.next();
            if (jobFlowShapeINF2 == jobFlowShapeINF || !jobFlowShapeINF2.intersects(jobFlowShapeINF, this.g2)) continue;
            jobFlowShapeINF2.draw(this.g2);
        }
    }

    public void resetSelection() {
        this.lastSelectedShape = null;
        this.curSelectedShape = null;
    }

    public void addShape(JobFlowShapeINF jobFlowShapeINF) {
        if (jobFlowShapeINF == null) {
            return;
        }
        if (this.flowDiagram != null) {
            this.flowDiagram.addShape(jobFlowShapeINF);
        }
        this.selectShape(jobFlowShapeINF);
    }

    public Vector deleteShape(JobFlowShapeINF jobFlowShapeINF) {
        Vector vector = null;
        if (jobFlowShapeINF == null) {
            return null;
        }
        this.g2 = (Graphics2D)this.getGraphics();
        if (!JFUtility.isAIX_JRE_1_3_x()) {
            this.g2.scale(this.scale_x, this.scale_y);
        }
        if (jobFlowShapeINF instanceof AbstractImageShape) {
            if (this.flowDiagram != null) {
                vector = this.flowDiagram.getDeletedShapes((AbstractImageShape)jobFlowShapeINF);
            } else {
                vector = new Vector();
                vector.add(jobFlowShapeINF);
            }
            JobFlowShapeINF jobFlowShapeINF2 = null;
            for (int i = 0; i < vector.size(); ++i) {
                jobFlowShapeINF2 = (JobFlowShapeINF)vector.get(i);
                jobFlowShapeINF2.erase(this.g2);
            }
            this.redrawOverlappedShapes(vector);
        } else if (jobFlowShapeINF instanceof EventShape) {
            jobFlowShapeINF.erase(this.g2);
        }
        if (this.flowDiagram != null) {
            this.flowDiagram.deleteShape(jobFlowShapeINF);
        }
        this.lastSelectedShape = null;
        this.curSelectedShape = null;
        return vector;
    }

    public void redrawOverlappedShapes(Vector vector) {
        if (vector == null || vector.size() <= 0) {
            return;
        }
        if (this.flowDiagram == null) {
            return;
        }
        Iterator iterator = this.flowDiagram.getShapes();
        Iterator iterator2 = null;
        JobFlowShapeINF jobFlowShapeINF3 = null;
        JobFlowShapeINF jobFlowShapeINF2 = null;
        block0: while (iterator.hasNext()) {
            jobFlowShapeINF2 = (JobFlowShapeINF)iterator.next();
            if (jobFlowShapeINF2 == null || vector.contains(jobFlowShapeINF2)) continue;
            for (JobFlowShapeINF jobFlowShapeINF3 : vector) {
                if (!jobFlowShapeINF3.intersects(jobFlowShapeINF2, this.g2)) continue;
                jobFlowShapeINF2.draw(this.g2);
                continue block0;
            }
        }
    }

    public void moveAbstractImage(int n, int n2, AbstractImageShape abstractImageShape) {
        if (abstractImageShape == null) {
            return;
        }
        this.g2 = (Graphics2D)this.getGraphics();
        if (!JFUtility.isAIX_JRE_1_3_x()) {
            this.g2.scale(this.scale_x, this.scale_y);
        }
        Vector vector = null;
        if (this.flowDiagram != null) {
            vector = this.flowDiagram.getDeletedShapes(abstractImageShape);
        } else {
            vector = new Vector();
            vector.add(abstractImageShape);
        }
        Iterator iterator = vector.iterator();
        JobFlowShapeINF jobFlowShapeINF = null;
        while (iterator.hasNext()) {
            jobFlowShapeINF = (JobFlowShapeINF)iterator.next();
            jobFlowShapeINF.erase(this.g2);
        }
        this.redrawOverlappedShapes(vector);
        abstractImageShape.move(n, n2);
        iterator = vector.iterator();
        jobFlowShapeINF = null;
        while (iterator.hasNext()) {
            jobFlowShapeINF = (JobFlowShapeINF)iterator.next();
            jobFlowShapeINF.draw(this.g2);
        }
    }

    public int getPrintRows() {
        return this.m_printRows;
    }

    public int getPrintColumns() {
        return this.m_printColumns;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        if (n == 0) {
            this.m_bi = this.convertToImage(graphics);
            if (this.m_bi == null) {
                return 1;
            }
            this.m_pageNumberFontHeight = 0;
            if (JFPrintOptionsManager.getInstance().isPrintPageNumber()) {
                this.m_pageNumberFontHeight = graphics.getFontMetrics().getHeight() + 2;
            }
            n5 = (int)pageFormat.getImageableWidth();
            n4 = (int)pageFormat.getImageableHeight() - this.m_pageNumberFontHeight;
            n3 = this.m_bi.getWidth(this);
            n2 = this.m_bi.getHeight(this);
            if (n3 == 0 || n2 == 0) {
                return 1;
            }
            this.m_printColumns = Math.max((int)Math.ceil((double)n3 / (double)n5), 1);
            this.m_printRows = Math.max((int)Math.ceil((double)n2 / (double)n4), 1);
            this.m_maxNumPage = this.m_printRows * this.m_printColumns;
        }
        if (n >= this.m_maxNumPage) {
            return 1;
        }
        graphics.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        n5 = (int)pageFormat.getImageableWidth();
        n4 = (int)pageFormat.getImageableHeight() - this.m_pageNumberFontHeight;
        n3 = this.m_bi.getWidth(this);
        n2 = this.m_bi.getHeight(this);
        if (n3 == 0 || n2 == 0) {
            return 1;
        }
        int n6 = n % this.m_printColumns;
        int n7 = n / this.m_printColumns;
        int n8 = n6 * n5;
        int n9 = n7 * n4;
        int n10 = Math.min(n5, n3 - n8);
        int n11 = Math.min(n4, n2 - n9);
        graphics.drawImage(this.m_bi, 0, 0, n10, n11, n8, n9, n8 + n10, n9 + n11, this);
        if (this.m_pageNumberFontHeight > 0) {
            graphics.setColor(Color.black);
            graphics.drawString("Page " + String.valueOf(n7 + 1) + ":" + String.valueOf(n6 + 1), 0, n4 + this.m_pageNumberFontHeight - graphics.getFontMetrics().getDescent());
        }
        System.gc();
        return 0;
    }

    protected BufferedImage convertToImage(Graphics graphics) {
        if (this.flowDiagram == null) {
            return null;
        }
        Dimension dimension = this.flowDiagram.getDimension((Graphics2D)graphics);
        if (dimension == null) {
            return null;
        }
        this.setDoubleBuffered(false);
        BufferedImage bufferedImage = new BufferedImage((int)((double)dimension.width * this.scale_x), (int)((double)dimension.height * this.scale_y), 13);
        Graphics graphics2 = bufferedImage.getGraphics();
        graphics2.setFont(graphics.getFont());
        if (this.curSelectedShape != null) {
            this.curSelectedShape.setSelected(false);
        }
        this.paint(graphics2);
        if (this.curSelectedShape != null) {
            this.curSelectedShape.setSelected(true);
        }
        return bufferedImage;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }
}

