/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFAdminManager;
import com.platform.LSFJobFlow.api.JFAlarmDef;
import com.platform.LSFJobFlow.api.JFJob;
import com.platform.LSFJobFlow.api.JFLoginManager;
import com.platform.LSFJobFlow.ui.JFAlarmDefinitionDetailsDialog;
import com.platform.LSFJobFlow.ui.JFDescriptionPane;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import com.platform.LSFJobFlow.ui.JFUtility;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class JFAlarmDefinitionBean
extends JPanel
implements ActionListener {
    static final String ERR_WIN_TITLE = JFResourceBundle.getString("AlarmDefinitionBean$TITLE_inputErrWin");
    public static final String Name = "Name";
    public static final String AlarmDef = "AlarmDef";
    public static final String AlarmNotifiType = "AlarmType";
    public static final String AlarmNotifiTypeCMD = "CMD";
    public static final String AlarmNotifiTypeEMAIL = "EMAIL";
    public static final String Output = "Output";
    public static final String Description = "Description";
    private boolean m_editable = false;
    private boolean m_isJFAdmin = false;
    private JFJob jobDef = null;
    private ArrayList m_alarmNames = null;
    private boolean m_daemonExists = true;
    private String m_currentUserName;
    private JLabel jLabel1;
    private JTextField nameFLD;
    private JLabel jLabel2;
    private JButton refreshButton;
    private JButton m_alarmDetailsButton;
    private JTextArea cmdOutputTextArea;
    private JScrollPane cmdOutputScrollPane;
    private JLabel cmdOutputLabel;
    private JComboBox alarmTypeFLD;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JFDescriptionPane jFDescriptionPane;

    public JFAlarmDefinitionBean() {
        this.initComponents();
        this.setInputAccessibleInfo();
        this.refreshButton.addActionListener(this);
        this.m_alarmDetailsButton.addActionListener(this);
        this.m_editable = true;
        this.m_currentUserName = JFLoginManager.getUserName();
        this.initAlarmsFromDaemon();
        this.reset();
    }

    public void refresh() {
        ArrayList arrayList = this.m_alarmNames;
        this.initAlarmsFromDaemon();
        if (this.isDaemonAvailable()) {
            this.alarmTypeFLD.setModel(new DefaultComboBoxModel<String>(this.m_alarmNames.toArray(new String[0])));
            if (this.alarmTypeFLD.getItemCount() > 0) {
                this.alarmTypeFLD.setSelectedIndex(0);
            } else {
                this.alarmTypeFLD.setSelectedItem("");
            }
        } else {
            this.m_alarmNames = arrayList;
        }
    }

    private JFrame getMainFrame() {
        JFrame jFrame = null;
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof JFrame)) continue;
            jFrame = (JFrame)container;
            break;
        }
        return jFrame;
    }

    private void showAlarmDetails() {
        String string = (String)this.alarmTypeFLD.getSelectedItem();
        if (string != null && string.length() > 0) {
            try {
                JFAdminManager jFAdminManager = new JFAdminManager();
                this.m_daemonExists = true;
                JFAlarmDef[] jFAlarmDefArray = jFAdminManager.getAlarmDefinitions();
                for (int i = 0; i < jFAlarmDefArray.length; ++i) {
                    if (!string.equals(jFAlarmDefArray[i].getName())) continue;
                    JFAlarmDefinitionDetailsDialog jFAlarmDefinitionDetailsDialog = new JFAlarmDefinitionDetailsDialog(this.getMainFrame(), true, jFAlarmDefArray[i].getName(), jFAlarmDefArray[i].getNotificationMethod(), jFAlarmDefArray[i].getNotificationAddress(), jFAlarmDefArray[i].getDescription());
                    jFAlarmDefinitionDetailsDialog.setLocationRelativeTo(this);
                    jFAlarmDefinitionDetailsDialog.show();
                    return;
                }
            }
            catch (Exception exception) {
                this.m_daemonExists = false;
                return;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.refreshButton) {
            this.refresh();
        } else if (actionEvent.getSource() == this.m_alarmDetailsButton) {
            this.showAlarmDetails();
        }
    }

    public void reset() {
        if (this.jobDef != null) {
            this.nameFLD.setText(this.jobDef.getName());
        }
        this.refresh();
        this.alarmTypeFLD.setEditable(false);
        this.jFDescriptionPane.setText("");
    }

    public void setJobDefinition(JFJob jFJob) {
        this.jobDef = jFJob;
        this.reset();
        if (jFJob == null) {
            return;
        }
        this.nameFLD.setText(jFJob.getName());
        String string = jFJob.getAttribute(AlarmDef);
        if (string != null && string != "") {
            int n;
            for (n = 0; n < this.m_alarmNames.size() && !string.equals(this.m_alarmNames.get(n)); ++n) {
            }
            if (n < this.m_alarmNames.size()) {
                this.alarmTypeFLD.setSelectedIndex(n);
            } else if (this.m_editable) {
                this.alarmTypeFLD.setSelectedItem(null);
                this.alarmTypeFLD.getEditor().setItem(string);
            } else {
                DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.alarmTypeFLD.getModel();
                defaultComboBoxModel.addElement(string);
                this.alarmTypeFLD.setSelectedItem(string);
            }
        }
        this.setCommandOutputVisible();
        this.jFDescriptionPane.setText(jFJob.getAttribute(Description));
        this.jFDescriptionPane.setCaretPosition(0);
    }

    public void updateDefinition() throws Exception {
        if (!this.m_editable) {
            throw new Exception(JFResourceBundle.getString("AlarmDefinitionBean$ERR_nonEditableErr"));
        }
        if (this.jobDef == null) {
            throw new Exception(JFResourceBundle.getString("AlarmDefinitionBean$ERR_noJobDefErr"));
        }
        this.jobDef = this.createJob(this.jobDef);
    }

    public JFJob getJobDefinition() throws Exception {
        return this.createJob(null);
    }

    JFJob createJob(JFJob jFJob) throws Exception {
        JFJob jFJob2 = null;
        String string = this.nameFLD.getText();
        if (!JFUtility.isValidJobFlowIdentity(string)) {
            throw new Exception(JFResourceBundle.getString("AlarmDefinitionBean$ERR_jobNameInvalid"));
        }
        if (jFJob == null) {
            jFJob2 = new JFJob(string.trim(), "alarm");
        } else {
            jFJob2 = jFJob;
            jFJob2.setName(string);
            jFJob2.removeAllAttributes();
        }
        jFJob2.setUserName(this.m_currentUserName);
        String string2 = (String)this.alarmTypeFLD.getSelectedItem();
        if (string2 == null || string2.length() == 0) {
            throw new Exception(JFResourceBundle.getString("AlarmDefinitionBean$ERR_alarmTypeInvalid"));
        }
        if (this.alarmTypeFLD.getItemCount() == 0 || this.alarmTypeFLD.getSelectedIndex() < 0) {
            jFJob2.setAttribute(AlarmDef, string2);
        } else {
            jFJob2.setAttribute(AlarmDef, (String)this.m_alarmNames.get(this.alarmTypeFLD.getSelectedIndex()));
        }
        if (this.jFDescriptionPane.getText() != null) {
            jFJob2.setAttribute(Description, this.jFDescriptionPane.getText().trim());
        }
        return jFJob2;
    }

    public JPanel getBeanPanel() {
        return this;
    }

    public void setEditable(boolean bl) {
        this.m_editable = bl;
        this.nameFLD.setEditable(bl);
        this.nameFLD.setEnabled(bl);
        this.nameFLD.setOpaque(bl);
        this.alarmTypeFLD.setEnabled(bl);
        this.alarmTypeFLD.setOpaque(bl);
        this.jFDescriptionPane.setEditable(bl);
        this.jFDescriptionPane.setEnabled(bl);
        this.jFDescriptionPane.setOpaque(bl);
        this.refreshButton.setEnabled(bl);
        this.setCommandOutputVisible();
    }

    public void setJFAdmin(boolean bl) {
        this.m_isJFAdmin = bl;
    }

    public String[] getAlarmNames() {
        if (this.m_alarmNames == null) {
            this.initAlarmsFromDaemon();
        }
        return this.m_alarmNames.toArray(new String[0]);
    }

    public boolean isDaemonAvailable() {
        return this.m_daemonExists;
    }

    public void initAlarmsFromDaemon() {
        this.m_alarmNames = new ArrayList();
        try {
            JFAdminManager jFAdminManager = new JFAdminManager();
            this.m_daemonExists = true;
            JFAlarmDef[] jFAlarmDefArray = jFAdminManager.getAlarmDefinitions();
            for (int i = 0; i < jFAlarmDefArray.length; ++i) {
                this.m_alarmNames.add(jFAlarmDefArray[i].getName());
            }
        }
        catch (Exception exception) {
            this.m_daemonExists = false;
            return;
        }
    }

    private void setInputAccessibleInfo() {
        this.jLabel1.setLabelFor(this.nameFLD);
        this.nameFLD.getAccessibleContext().setAccessibleName(this.jLabel1.getText());
        this.nameFLD.getAccessibleContext().setAccessibleDescription(this.nameFLD.getToolTipText());
        this.jLabel2.setLabelFor(this.alarmTypeFLD);
        this.alarmTypeFLD.getAccessibleContext().setAccessibleName(this.jLabel2.getText());
        this.alarmTypeFLD.getAccessibleContext().setAccessibleDescription(this.alarmTypeFLD.getToolTipText());
        this.jLabel3.setLabelFor(this.jFDescriptionPane);
        this.jFDescriptionPane.getAccessibleContext().setAccessibleName(this.jLabel3.getText());
        this.jFDescriptionPane.getAccessibleContext().setAccessibleDescription(this.jFDescriptionPane.getToolTipText());
        this.cmdOutputLabel.setLabelFor(this.cmdOutputScrollPane);
        this.cmdOutputScrollPane.getAccessibleContext().setAccessibleName(this.cmdOutputLabel.getText());
        this.cmdOutputScrollPane.getAccessibleContext().setAccessibleDescription(this.cmdOutputScrollPane.getToolTipText());
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.nameFLD = new JTextField();
        this.jLabel2 = new JLabel();
        this.alarmTypeFLD = new JComboBox();
        this.refreshButton = new JButton();
        this.m_alarmDetailsButton = new JButton();
        this.jLabel3 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jFDescriptionPane = new JFDescriptionPane();
        this.cmdOutputTextArea = new JTextArea();
        this.cmdOutputScrollPane = new JScrollPane(this.cmdOutputTextArea);
        this.cmdOutputLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder(JFResourceBundle.getString("Define_Alarm")));
        this.jLabel1.setText(JFResourceBundle.getString("Name_"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.nameFLD.setToolTipText(JFResourceBundle.getString("AlarmDefinitionBean$TIP_alarmNameFLD"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridwidth = 4;
        this.add((Component)this.nameFLD, gridBagConstraints);
        this.jLabel2.setText(JFResourceBundle.getString("Alarm_type") + ":");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.alarmTypeFLD.setToolTipText(JFResourceBundle.getString("AlarmDefinitionBean$TIP_alarmTypeFLD"));
        this.alarmTypeFLD.setModel(new DefaultComboBoxModel<String>(new String[]{"None"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.alarmTypeFLD, gridBagConstraints);
        this.m_alarmDetailsButton.setText(JFResourceBundle.getString("Detail..."));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.m_alarmDetailsButton, gridBagConstraints);
        this.refreshButton.setText(JFResourceBundle.getString("Refresh"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.refreshButton, gridBagConstraints);
        this.jLabel3.setText(JFResourceBundle.getString("Description_"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jScrollPane1.setPreferredSize(new Dimension(300, 60));
        this.jFDescriptionPane.setToolTipText(JFResourceBundle.getString("AlarmDefinitionBean$TIP_descriptionFLD"));
        this.jScrollPane1.setViewportView(this.jFDescriptionPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.cmdOutputTextArea.setColumns(30);
        this.cmdOutputTextArea.setLineWrap(true);
        this.cmdOutputTextArea.setRows(10);
        this.cmdOutputTextArea.setTabSize(4);
        this.cmdOutputLabel.setText(JFResourceBundle.getString("Command_Output_"));
        this.cmdOutputTextArea.setEditable(false);
        this.cmdOutputTextArea.setEnabled(false);
        this.cmdOutputTextArea.setOpaque(false);
        this.cmdOutputScrollPane.setPreferredSize(new Dimension(300, 300));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.cmdOutputLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.cmdOutputScrollPane, gridBagConstraints);
    }

    private void setCommandOutputVisible() {
        String string;
        this.cmdOutputLabel.setVisible(false);
        this.cmdOutputTextArea.setVisible(false);
        this.cmdOutputScrollPane.setVisible(false);
        if (this.jobDef != null && (string = this.jobDef.getAttribute(AlarmNotifiType)) != null && string == AlarmNotifiTypeCMD) {
            this.cmdOutputLabel.setVisible(!this.m_editable);
            this.cmdOutputTextArea.setVisible(!this.m_editable);
            this.cmdOutputScrollPane.setVisible(!this.m_editable);
            this.cmdOutputTextArea.setText(this.jobDef.getAttribute(Output));
        }
    }
}

