/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFFlow;
import com.platform.LSFJobFlow.api.JFFlowArray;
import com.platform.LSFJobFlow.api.JFFlowArrayInstance;
import com.platform.LSFJobFlow.ui.AbstractImageShape;
import com.platform.LSFJobFlow.ui.FlowDiagram;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import com.platform.LSFJobFlow.ui.JFUtility;
import java.awt.Image;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

class FlowArrayShape
extends AbstractImageShape {
    boolean m_isModified = false;
    JFFlowArray m_flowArrayDef = null;
    FlowDiagram m_flowDiagram = null;
    JFFlowArrayInstance m_flowArrayInst;
    public static final int VAR_NAME_LEN = 26;
    public static final int VAR_VALUE_LEN = 29;

    public FlowArrayShape(JFFlowArray jFFlowArray, int n, int n2) {
        super(n, n2, false);
        this.m_flowArrayDef = jFFlowArray;
        this.m_flowDiagram = new FlowDiagram(jFFlowArray.getFlowDefinition(), n, n2);
        this.name = this.m_flowArrayDef.getName();
        this.curImage = this.imageLoader.getFlowArrayDefImage(this.m_flowArrayDef);
        this.isDummyShape = false;
        if (!this.isCompletelyDefined()) {
            this.isDummyShape = true;
        }
    }

    public FlowArrayShape(String string, int n, int n2) {
        super(string, n, n2);
        this.m_flowArrayDef = new JFFlowArray(string, new JFFlow(string), null, null);
        this.m_flowDiagram = new FlowDiagram(this.m_flowArrayDef.getFlowDefinition(), n, n2);
        this.curImage = this.imageLoader.getFlowArrayDefImage(this.m_flowArrayDef);
    }

    public FlowArrayShape(JFFlowArrayInstance jFFlowArrayInstance, int n, int n2) {
        super(n, n2, true);
        this.m_flowArrayInst = jFFlowArrayInstance;
        this.owner = jFFlowArrayInstance.getOwner();
        this.name = jFFlowArrayInstance.getName();
        this.name = JFUtility.getShortInstanceName(jFFlowArrayInstance.getName());
        if (jFFlowArrayInstance != null) {
            this.m_flowArrayDef = jFFlowArrayInstance.getFlowArrayDefinition();
            this.m_flowDiagram = new FlowDiagram(this.m_flowArrayDef.getFlowDefinition(), n, n2);
            switch (jFFlowArrayInstance.getState()) {
                case 0: {
                    this.state = 2;
                    break;
                }
                case 1: {
                    this.state = 4;
                    break;
                }
                case 5: {
                    this.state = 8;
                    break;
                }
                case 2: {
                    this.state = 6;
                    break;
                }
                case 4: {
                    this.state = 7;
                    break;
                }
                case 3: {
                    this.state = 9;
                    break;
                }
                case 6: {
                    this.state = 3;
                    break;
                }
                default: {
                    this.state = -1;
                }
            }
        }
        this.curImage = this.imageLoader.getFlowArrayInstanceImage(jFFlowArrayInstance);
    }

    public String getDescription() {
        return this.m_flowDiagram.getDescription();
    }

    public void setDescription(String string) {
        this.m_flowDiagram.setDescription(string);
    }

    public String getFirstElement() {
        return this.m_flowArrayDef.getFirstElement();
    }

    public void setFirstElement(String string) {
        if (!string.equals(this.m_flowArrayDef.getFirstElement())) {
            this.m_isModified = true;
        }
        this.m_flowArrayDef.setFirstElement(string);
        this.isDummyShape = !this.isCompletelyDefined();
    }

    public void setExclusive(boolean bl) {
        this.m_flowDiagram.setExclusive(bl);
    }

    public boolean isExclusive() {
        return this.m_flowDiagram.isExclusive();
    }

    public void setDefaultUpdateType(String string) {
        this.m_flowDiagram.setDefaultUpdateType(string);
    }

    public String getDefaultUpdateType() {
        return this.m_flowDiagram.getDefaultUpdateType();
    }

    public String getLastElement() {
        return this.m_flowArrayDef.getLastElement();
    }

    public void setLastElement(String string) {
        if (!string.equals(this.m_flowArrayDef.getLastElement())) {
            this.m_isModified = true;
        }
        this.m_flowArrayDef.setLastElement(string);
        this.isDummyShape = !this.isCompletelyDefined();
    }

    public boolean isModified() {
        return this.m_isModified || this.m_flowDiagram.isModified();
    }

    public void setModified(boolean bl) {
        this.m_isModified = bl;
        this.m_flowDiagram.setModifiedFlag(bl);
    }

    protected boolean isCompletelyDefined() {
        String string = this.m_flowArrayDef.getFirstElement();
        String string2 = this.m_flowArrayDef.getLastElement();
        return string != null && !string.equals("") && string2 != null && !string2.equals("");
    }

    public FlowDiagram getFlowDiagram() {
        return this.m_flowDiagram;
    }

    public JFFlowArray getDef() {
        JFFlow jFFlow = this.m_flowDiagram.getFlowDefObj();
        this.m_flowArrayDef.setFlowDefinition(jFFlow);
        jFFlow.setAttribute("PositionX", String.valueOf(this.x));
        jFFlow.setAttribute("PositionY", String.valueOf(this.y));
        return this.m_flowArrayDef;
    }

    @Override
    public void setName(String string) {
        this.name = string;
        this.m_flowArrayDef.setName(string);
        this.m_flowDiagram.setName(string);
    }

    public JFFlowArrayInstance getInstance() {
        return this.m_flowArrayInst;
    }

    public boolean updateImage() {
        Image image = this.imageLoader.getFlowArrayDefImage(this.getDef());
        if (this.curImage == image) {
            return false;
        }
        this.curImage = image;
        return true;
    }

    @Override
    public String toString() {
        return "Flow array[" + this.name + "]";
    }

    @Override
    public String getTipString() {
        if (this.isInstance) {
            Object[] objectArray = new Object[]{this.toString(), this.getCurStateString()};
            String string = JFResourceBundle.getString("A_is_B");
            MessageFormat messageFormat = new MessageFormat(string);
            return messageFormat.format(objectArray);
        }
        return this.toString();
    }

    @Override
    public String getRuntimeAttributesStr() {
        if (this.m_flowArrayInst == null) {
            return null;
        }
        String string = "[" + JFResourceBundle.getString("Flow_Array_name") + "] : " + this.name;
        if (this.owner != null) {
            string = string + "\n" + JFUtility.alignString("[" + JFResourceBundle.getString("Flow_owner") + "]", 20) + ": " + this.owner;
        }
        string = string + "\n[" + JFResourceBundle.getString("State") + "]           : " + this.getCurStateString();
        if (this.state == 6 || this.state == 9) {
            string = string + "\n[" + JFResourceBundle.getString("Exit_code") + "]       : " + String.valueOf(this.m_flowArrayInst.getExitCode());
        }
        if (this.m_flowArrayInst.getStartTime() != null) {
            string = string + "\n[" + JFResourceBundle.getString("Start_time") + "]      : " + this.m_flowArrayInst.getStartTime().toString();
        }
        if (this.m_flowArrayInst.getFinishTime() != null) {
            string = string + "\n[" + JFResourceBundle.getString("Finish_time") + "]     : " + this.m_flowArrayInst.getFinishTime().toString();
        }
        int n = this.m_flowArrayInst.getFirstIndex();
        int n2 = this.m_flowArrayInst.getLastIndex();
        for (int i = n; i <= n2; ++i) {
            String string2;
            String string3;
            Vector<Object> vector;
            Enumeration<Object> enumeration;
            string = string + "\n";
            string = string + "\nFlow Index " + i + " : ";
            string = string + "\n";
            string = string + "\n[" + JFResourceBundle.getString("Local_Variables") + "] : ";
            Properties properties = this.m_flowArrayInst.getLocalVariables(i);
            if (properties == null || properties.size() == 0) {
                string = string + "<" + JFResourceBundle.getString("None") + ">";
            } else {
                string = string + "\n" + JFUtility.alignString(JFResourceBundle.getString("NAME"), 26) + JFResourceBundle.getString("VALUE");
                string = string + "\n----------------------------------------------------";
                enumeration = properties.propertyNames();
                vector = new Vector<Object>();
                while (enumeration.hasMoreElements()) {
                    vector.add(enumeration.nextElement());
                }
                Collections.sort(vector);
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    string3 = (String)enumeration.nextElement();
                    string2 = properties.getProperty(string3);
                    string = string + "\n" + JFUtility.alignString(string3, 26) + string2;
                }
            }
            string = string + "\n";
            string = string + "\n[" + JFResourceBundle.getString("Input_Variables") + "] : ";
            properties = this.m_flowArrayInst.getInputVariables(i);
            if (properties == null || properties.size() == 0) {
                string = string + "<" + JFResourceBundle.getString("None") + ">";
                continue;
            }
            string = string + "\n" + JFUtility.alignString(JFResourceBundle.getString("NAME"), 26) + JFResourceBundle.getString("VALUE");
            string = string + "\n----------------------------------------------------";
            enumeration = properties.propertyNames();
            vector = new Vector();
            while (enumeration.hasMoreElements()) {
                vector.add(enumeration.nextElement());
            }
            Collections.sort(vector);
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                string3 = (String)enumeration.nextElement();
                string2 = properties.getProperty(string3);
                string = string + "\n" + JFUtility.alignString(string3, 26) + string2;
            }
        }
        return string;
    }

    @Override
    public void update() {
        this.updateState();
    }

    private void updateState() {
        int n = this.m_flowArrayInst.getState();
        switch (n) {
            case 0: {
                this.state = 2;
                break;
            }
            case 1: {
                this.state = 4;
                break;
            }
            case 5: {
                this.state = 8;
                break;
            }
            case 2: {
                this.state = 6;
                break;
            }
            case 4: {
                this.state = 7;
                break;
            }
            case 3: {
                this.state = 9;
                break;
            }
            case 6: {
                this.state = 3;
                break;
            }
            default: {
                this.state = -1;
            }
        }
    }
}

