/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.transforms;

import com.sas.collection.StringListInterface;
import com.sas.util.Strings;
import com.sas.util.Util;
import com.sas.util.transforms.TransformInputOutputInterface;
import java.util.Enumeration;

public class StringListInterfaceToStringTransform
implements TransformInputOutputInterface {
    static final long serialVersionUID = 2088989163438011867L;
    private char delimiter;
    private boolean alwaysQuote;
    public static final StringListInterfaceToStringTransform defaultInstance = new StringListInterfaceToStringTransform();

    protected static char defaultDelimiterChar() {
        return Util.getListDelimiterChar();
    }

    public StringListInterfaceToStringTransform() {
        this(StringListInterfaceToStringTransform.defaultDelimiterChar(), true);
    }

    public StringListInterfaceToStringTransform(char delimiter, boolean alwaysQuote) {
        this.delimiter = delimiter;
        this.alwaysQuote = alwaysQuote;
    }

    public Object transform(Object object) {
        if (object == null) {
            return "null";
        }
        StringListInterface stringList = (StringListInterface)object;
        StringBuffer buffer = new StringBuffer(256);
        Enumeration items = stringList.getItems();
        boolean needDelimiter = false;
        while (items.hasMoreElements()) {
            boolean special;
            String item = (String)items.nextElement();
            if (needDelimiter) {
                buffer.append(this.delimiter);
            }
            needDelimiter = true;
            if (item == null) {
                buffer.append("null");
                continue;
            }
            if ("null".equals(item)) {
                buffer.append("\"null\"");
                continue;
            }
            boolean bl = special = item.indexOf(this.delimiter) > -1 || Strings.needsQuoting((String)item);
            if (!special && !this.alwaysQuote) {
                buffer.append(item);
                continue;
            }
            buffer.append(Strings.quote((String)item));
        }
        return buffer.toString();
    }

    public Class getInputClass() {
        return StringListInterface.class;
    }

    public Class getOutputClass() {
        return String.class;
    }
}

