/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.transforms;

import com.sas.util.CharBuffer;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;

public class EchoCharacterTransform
implements TransformInterface {
    char _echoChar;
    public static final EchoCharacterTransform defaultInstance = new EchoCharacterTransform();

    public EchoCharacterTransform() {
        this('*');
    }

    public EchoCharacterTransform(char ch) {
        this.setEchoChar(ch);
    }

    public char getEchoChar() {
        return this._echoChar;
    }

    public void setEchoChar(char ch) {
        this._echoChar = ch;
    }

    public Object transform(Object input) throws TransformException {
        if (input == null) {
            return null;
        }
        if (!(input instanceof String)) {
            throw new TransformException("Input value is not of type String: " + input.getClass());
        }
        String s = (String)input;
        char echoChar = this.getEchoChar();
        CharBuffer cbuf = new CharBuffer();
        int cnt = s.length();
        for (int i = 0; i < cnt; ++i) {
            cbuf.append(echoChar);
        }
        return cbuf.toString();
    }
}

