/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.transforms;

import com.sas.text.SASFormat;
import com.sas.util.DateTimeMonitor;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;

public abstract class BaseFormatTransform
implements TransformInterface {
    protected Format format;
    protected String SASpattern;

    public BaseFormatTransform() {
        this(null);
    }

    public BaseFormatTransform(Format format) {
        this.setFormat(format);
    }

    public void setFormat(Format newFormat) {
        this.format = newFormat;
    }

    public Format getFormat() {
        return this.format;
    }

    public abstract Object transform(Object var1) throws TransformException;

    public void setDecimalFormat(String pattern) {
        if (pattern != null) {
            this.setSASFormat(null);
            this.setDateFormat(null);
            this.setFormat(new DecimalFormat(pattern));
        }
    }

    public String getDecimalFormat() {
        if (this.format instanceof DecimalFormat) {
            return ((DecimalFormat)this.format).toPattern();
        }
        return null;
    }

    public void setDateFormat(String pattern) {
        if (pattern != null) {
            this.setSASFormat(null);
            this.setDecimalFormat(null);
            SimpleDateFormat fmt = new SimpleDateFormat(pattern);
            fmt.setTimeZone(DateTimeMonitor.defaultTimeZone);
            this.setFormat(fmt);
        }
    }

    public String getDateFormat() {
        if (this.format instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)this.format).toPattern();
        }
        return null;
    }

    public void setSASFormat(String pattern) {
        if (pattern == null) {
            this.SASpattern = null;
        } else {
            this.SASpattern = pattern;
            this.setDateFormat(null);
            this.setDecimalFormat(null);
            this.setFormat((Format)SASFormat.getInstance((String)pattern));
        }
    }

    public String getSASFormat() {
        return this.SASpattern;
    }
}

