/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.Component;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.util.RB;
import com.sas.util.TimerInterface;

public class Timer
extends Component
implements TimerInterface {
    public static final String RB_KEY = "Timer.";
    static final long serialVersionUID = 7664296915838404607L;
    private boolean running;
    private long startTime;
    private long stopTime;
    public static Long Zero = new Long(0L);

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.shortDescription = RB.getStringResource((String)RB_KEY, (String)"description.txt");
        ebi.defaultOutputPropertyName = "running";
        ebi.defaultInputPropertyName = "running";
        return ebi;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof Timer) {
            return this.equals((Timer)object);
        }
        return false;
    }

    public boolean equals(Timer t) {
        if (this == t) {
            return true;
        }
        if (null == t) {
            return false;
        }
        return this.isRunning() == t.isRunning() && this.getStartTime() == t.getStartTime() && this.getStopTime() == t.getStopTime();
    }

    public int hashCode() {
        return 677 + ((int)this.startTime & 0xFFFF) + ((int)this.stopTime & 0xFFFF) + (this.running ? 5432 : 7771);
    }

    @Override
    public synchronized void start() {
        long oldStart = this.startTime;
        boolean oldRunning = this.running;
        this.startTime = System.currentTimeMillis();
        this.stopTime = 0L;
        this.running = true;
        if (this.anyPropertyChangeListeners()) {
            if (!oldRunning) {
                this.firePropertyChange("running", Boolean.FALSE, Boolean.TRUE);
            }
            if (this.startTime != oldStart) {
                this.firePropertyChange("startTime", new Long(oldStart), new Long(this.startTime));
            }
        }
    }

    @Override
    public synchronized void stop() {
        long time = System.currentTimeMillis();
        if (!this.running) {
            return;
        }
        this.stopTime = time;
        this.running = false;
        long duration = this.getDuration();
        if (this.anyPropertyChangeListeners()) {
            this.firePropertyChange("running", Boolean.TRUE, Boolean.FALSE);
            this.firePropertyChange("stopTime", Zero, new Long(this.stopTime));
            if (duration > 0L) {
                this.firePropertyChange("duration", Zero, new Long(duration));
            }
        }
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getStopTime() {
        return this.stopTime;
    }

    @Override
    public long getDuration() {
        if (this.startTime == 0L) {
            return 0L;
        }
        if (this.running) {
            return System.currentTimeMillis() - this.startTime;
        }
        return this.stopTime - this.startTime;
    }

    @Override
    public final synchronized void setRunning(boolean running) {
        if (this.running == running) {
            return;
        }
        if (running) {
            this.start();
        } else {
            this.stop();
        }
    }

    public String toString() {
        return "Timer@" + System.identityHashCode(this) + "(startTime=" + this.getStartTime() + ", stopTime=" + this.getStopTime() + ", running=" + this.isRunning() + ", duration=" + this.getDuration() + ")";
    }
}

