/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.security.BaseSecuritySupport;
import com.sas.util.SimpleCommand;
import com.sas.util.ThreadedCommand;
import com.sas.util.TimedCommandInterface;
import com.sas.util.TimedOutException;
import java.lang.reflect.InvocationTargetException;
import java.security.PrivilegedAction;

public class TimedCommand
implements TimedCommandInterface,
ThreadedCommand {
    static final boolean DEBUG = false;
    protected SimpleCommand command;
    protected SimpleCommand cleanupCommand;
    protected long timeoutInMillis;
    private static final int ONE_MILLION = 1000000;
    protected int maxWaitInNanos;
    protected transient TimedCommandThread tThread;
    protected boolean useStop;
    protected boolean finishOnCompletion;
    protected transient Thread thread;
    protected Object cleanupArg;

    public TimedCommand() {
        this(null, Long.MAX_VALUE, false, null);
    }

    public TimedCommand(SimpleCommand command, long timeoutInMillis, boolean finishOnCompletion, SimpleCommand cleanupCommand) {
        this(command, timeoutInMillis, finishOnCompletion, cleanupCommand, false);
    }

    public TimedCommand(SimpleCommand command, long timeoutInMillis, boolean finishOnCompletion, SimpleCommand cleanupCommand, boolean useStop) {
        this.configure(command, timeoutInMillis, finishOnCompletion, cleanupCommand, useStop);
    }

    public void configure(SimpleCommand command, long timeoutInMillis, boolean finishOnCompletion, SimpleCommand cleanupCommand) {
        this.configure(command, timeoutInMillis, finishOnCompletion, cleanupCommand, false);
    }

    public void configure(SimpleCommand command, long timeoutInMillis, boolean finishOnCompletion, SimpleCommand cleanupCommand, boolean useStop) {
        this.setCommand(command);
        this.setTimeout(timeoutInMillis);
        this.setFinishOnCompletion(finishOnCompletion);
        this.setCleanupCommand(cleanupCommand);
        this.useStop(useStop);
    }

    public synchronized void setCommand(SimpleCommand command) {
        this.command = command;
    }

    public SimpleCommand getCommand() {
        return this.command;
    }

    public synchronized void setCleanupCommand(SimpleCommand cleanupCommand) {
        this.cleanupCommand = cleanupCommand;
    }

    public SimpleCommand getCleanupCommand() {
        return this.cleanupCommand;
    }

    public synchronized void setTimeout(long timeoutInMillis) {
        this.timeoutInMillis = timeoutInMillis;
    }

    public long getTimeout() {
        return this.timeoutInMillis;
    }

    public void setMaxWaitTime(int maxWaitTime) {
        this.maxWaitInNanos = maxWaitTime;
    }

    public int getMaxWaitTime() {
        return this.maxWaitInNanos;
    }

    public boolean useStop() {
        return this.useStop;
    }

    public synchronized void useStop(boolean useStop) {
        this.useStop = useStop;
    }

    public void setFinishOnCompletion(boolean state) {
        this.finishOnCompletion = state;
        if (this.tThread != null) {
            this.tThread.stop = state;
        }
    }

    public boolean getFinishOnCompletion() {
        return this.finishOnCompletion;
    }

    public synchronized void execute(Object arg) {
        try {
            this.run(arg);
        }
        catch (TimedOutException timedOutException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void run(Object arg) throws InterruptedException, InvocationTargetException, TimedOutException {
        Exception e;
        this.cleanupArg = arg;
        this.thread = Thread.currentThread();
        Thread.interrupted();
        if (this.tThread == null) {
            this.tThread = (TimedCommandThread)BaseSecuritySupport.securitySupport.doThreadPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new TimedCommandThread(TimedCommand.this);
                }
            });
            this.tThread.arg = arg;
            this.tThread.stop = this.finishOnCompletion;
            this.tThread.start();
        } else {
            this.tThread.arg = arg;
        }
        this.waitFor(this.getTimeout());
        if (this.tThread != null && (e = this.tThread.getCaughtException()) != null) {
            this.cleanup(this.cleanupArg);
            if (e instanceof InvocationTargetException) {
                throw (InvocationTargetException)e;
            }
            throw new InvocationTargetException(e);
        }
        if (this.getFinishOnCompletion()) {
            this.tThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitFor(long timeOut) throws InterruptedException, InvocationTargetException, TimedOutException {
        TimedCommandThread timedCommandThread = this.tThread;
        synchronized (timedCommandThread) {
            try {
                this.tThread.interrupt();
                this.tThread.wait(timeOut);
                if (this.isRunning()) {
                    this.interruptCommandThread();
                    this.rendezvous();
                    this.cleanup(this.cleanupArg);
                    throw new TimedOutException();
                }
            }
            catch (InterruptedException e) {
                if (this.isRunning()) {
                    this.interruptCommandThread();
                    this.rendezvous();
                    this.cleanup(this.cleanupArg);
                }
                throw e;
            }
        }
    }

    private void rendezvous() throws TimedOutException {
        if (this.tThread != null) {
            try {
                if (this.getMaxWaitTime() > 0) {
                    int ns = this.getMaxWaitTime();
                    long ms = ns / 1000000;
                    this.tThread.wait(ms, ns %= 1000000);
                    if (this.isRunning()) {
                        this.tThread.stop = true;
                        this.tThread.setCleanupCommand(this.getCleanupCommand());
                        this.tThread.setCleanupCommandArg(this.cleanupArg);
                        this.tThread = null;
                        throw new TimedOutException();
                    }
                } else {
                    this.tThread.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void interrupt(Object arg) {
        this.cleanupArg = arg;
        this.interrupt();
    }

    @Override
    public void interrupt() {
        this.thread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void interruptCommandThread() {
        TimedCommandThread timedCommandThread = this.tThread;
        synchronized (timedCommandThread) {
            if (this.isRunning()) {
                Thread.interrupted();
                if (this.command instanceof TimedCommandInterface) {
                    ((TimedCommandInterface)this.command).interrupt();
                }
                if (this.isRunning()) {
                    if (this.useStop()) {
                        this.tThread.stop = true;
                        this.tThread.stop();
                        this.tThread = null;
                        this.cleanup(this.cleanupArg);
                    } else {
                        this.tThread.interrupt();
                    }
                }
            }
        }
    }

    protected boolean isRunning() {
        return this.tThread != null && this.tThread.isRunning();
    }

    protected void cleanup(Object arg) {
        if (this.getCleanupCommand() != null) {
            this.getCleanupCommand().execute(arg);
        }
        if (this.getFinishOnCompletion()) {
            this.tThread = null;
        }
    }

    public void finalize() throws Throwable {
        if (this.tThread != null && this.tThread.isAlive()) {
            this.tThread.stop = true;
            this.tThread.interrupt();
        }
        super.finalize();
    }

    public String toString() {
        return "TimedCommand " + this.getTimeout() + "ms " + this.getCommand();
    }

    static void log(String s) {
        System.out.println(s);
        System.out.flush();
    }

    static class TimedCommandThread
    extends Thread {
        static final String NOT_STARTED = "NOT_STARTED";
        static final String RUNNING = "RUNNING";
        static final String COMPLETED = "COMPLETED";
        static final String INTERRUPTED = "INTERRUPTED";
        static final String CAUGHT_EXCEPTION = "CAUGHT_EXCEPTION";
        static final String TIMED_OUT = "TIMED_OUT";
        static final String SLEEPING = "SLEEPING";
        static final String STOPPING = "STOPPING";
        static final String STOPPED = "STOPPED";
        TimedCommand timedCommand;
        Object arg;
        Exception caughtException;
        boolean stop;
        String state;
        String commandState;
        SimpleCommand cleanupCommand;
        Object cleanupCommandArg;
        String rendezvous;
        static int threadNum;
        int threadNumber;

        TimedCommandThread(TimedCommand TimedCommand2) {
            super("TimedCommandThread");
            this.setStates(NOT_STARTED, NOT_STARTED);
            this.timedCommand = TimedCommand2;
            this.arg = this.arg;
            this.setDaemon(true);
            this.threadNumber = threadNum++;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.sleep();
            do {
                this.caughtException = null;
                long startTime = System.currentTimeMillis();
                try {
                    this.setStates(RUNNING, RUNNING);
                    SimpleCommand command = this.timedCommand.getCommand();
                    Thread.interrupted();
                    if (command instanceof TimedCommandInterface) {
                        ((TimedCommandInterface)command).run(this.arg);
                    } else {
                        command.execute(this.arg);
                    }
                    if (Thread.interrupted()) {
                        this.setStates(INTERRUPTED, INTERRUPTED);
                    } else {
                        this.setStates(COMPLETED, COMPLETED);
                    }
                }
                catch (InvocationTargetException e) {
                    this.setStates(CAUGHT_EXCEPTION, CAUGHT_EXCEPTION);
                    this.caughtException = e;
                }
                catch (TimedOutException e) {
                    this.setStates(TIMED_OUT, TIMED_OUT);
                    this.caughtException = e;
                }
                catch (InterruptedException e) {
                    TimedCommand.log("TimedCommandThread was interrupted:");
                    e.printStackTrace();
                    this.setStates(INTERRUPTED, INTERRUPTED);
                    this.caughtException = e;
                }
                long duration = System.currentTimeMillis() - startTime;
                if (this.stop) {
                    this.rendezvous(STOPPING);
                    if (this.getCleanupCommand() == null) continue;
                    try {
                        this.getCleanupCommand().execute(this.arg);
                    }
                    finally {
                        this.setCleanupCommand(null);
                    }
                } else {
                    this.rendezvous(SLEEPING);
                    this.sleep();
                }
            } while (!this.stop);
            this.setState(STOPPED);
        }

        public synchronized void setCleanupCommand(SimpleCommand cleanupCommand) {
            this.cleanupCommand = cleanupCommand;
        }

        public SimpleCommand getCleanupCommand() {
            return this.cleanupCommand;
        }

        public synchronized void setCleanupCommandArg(Object arg) {
            this.cleanupCommandArg = arg;
        }

        public Object getCleanupCommandArg() {
            return this.cleanupCommandArg;
        }

        void sleep() {
            try {
                Thread.sleep(Long.MAX_VALUE);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
            Thread.interrupted();
        }

        private synchronized void rendezvous(String newState) {
            this.notify();
            this.setState(newState);
        }

        synchronized void setStates(String state, String commandState) {
            this.state = state;
            this.commandState = commandState;
        }

        synchronized void setState(String state) {
            this.state = state;
        }

        boolean isRunning() {
            return this.isAlive() && this.state == RUNNING;
        }

        Exception getCaughtException() {
            return this.caughtException;
        }

        @Override
        public String toString() {
            return "TimedCommandThread #" + this.threadNumber + ", " + this.commandState + ", " + this.state + " " + (this.timedCommand == null ? "no command" : this.timedCommand.toString());
        }
    }
}

