/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.ComponentInterface;
import com.sas.text.Message;
import com.sas.util.errorhandlers.ErrorHandlerInterface;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;

public class SystemLog
implements ErrorHandlerInterface {
    public static SystemLog noteLog;
    public static SystemLog errorLog;
    public static SystemLog warningLog;
    protected PrintWriter stream;
    protected boolean logStackTraces;
    protected boolean timestampUsed;
    protected DateFormat timestamp;

    public static void logNote(String msg) {
        noteLog.printToLog("Note", msg);
    }

    public static void logError(String msg) {
        errorLog.printToLog("Error", msg);
    }

    public static void logWarning(String msg) {
        warningLog.printToLog("Warning", msg);
    }

    public static void logException(String msg, Throwable throwable) {
        boolean temp = errorLog.getLogStackTraces();
        errorLog.setLogStackTraces(false);
        errorLog.printToLog("Exception", msg);
        errorLog.setLogStackTraces(temp);
        throwable.printStackTrace(errorLog.getPrintWriter());
        errorLog.getPrintWriter().flush();
    }

    public SystemLog() {
        this(new PrintWriter(System.err));
    }

    public SystemLog(PrintWriter stream) {
        this.setPrintWriter(stream);
    }

    public PrintWriter getPrintWriter() {
        return this.stream;
    }

    public void setPrintWriter(PrintWriter stream) {
        this.stream = stream;
    }

    public boolean getLogStackTraces() {
        return this.logStackTraces;
    }

    public void setLogStackTraces(boolean logStackTraces) {
        this.logStackTraces = logStackTraces;
    }

    public boolean isTimestampUsed() {
        return this.timestampUsed;
    }

    public void setTimestampUsed(boolean timestampUsed) {
        this.timestampUsed = timestampUsed;
    }

    public DateFormat getTimestamp() {
        if (this.timestamp == null) {
            this.timestamp = DateFormat.getDateTimeInstance();
        }
        return this.timestamp;
    }

    public void setTimestamp(DateFormat timestamp) {
        this.timestamp = timestamp;
    }

    public void printStackTrace() {
        Throwable t = new Throwable();
        t.printStackTrace(this.getPrintWriter());
    }

    @Override
    public void handleError(ComponentInterface component, Message message, String messageCode) {
        this.printToLog("Error", message.toString());
    }

    public void printToLog(String type, String msg) {
        PrintWriter writer = this.getPrintWriter();
        if (type != null && type.length() != 0) {
            writer.print(type);
            writer.print(" : ");
        }
        if (this.timestampUsed) {
            Date date = new Date();
            writer.print(this.getTimestamp().format(date));
            writer.print(" : ");
        }
        writer.println(msg);
        if (this.getLogStackTraces()) {
            this.printStackTrace();
        }
        writer.flush();
    }

    public void clear() {
    }

    static {
        SystemLog logWithStackTraces = new SystemLog();
        logWithStackTraces.setLogStackTraces(true);
        logWithStackTraces.setTimestampUsed(true);
        errorLog = logWithStackTraces;
        SystemLog logWithoutStackTraces = new SystemLog();
        logWithoutStackTraces.setLogStackTraces(false);
        logWithoutStackTraces.setTimestampUsed(true);
        noteLog = logWithoutStackTraces;
        warningLog = logWithoutStackTraces;
    }
}

