/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.util.Comparator;
import com.sas.util.IndexedSetInterface;

public class Sort {
    final IndexedSetInterface a;
    final Object[] b;
    int[] permutation;
    int[] mpermutation;
    final java.util.Comparator comparator;
    public static final int MERGE_SORT = 0;
    public static final int QUICK_SORT = 1;
    public static final int HEAP_SORT = 2;
    private static final int LAST_ALGORITHM = 2;
    private int algorithm;

    public Sort(IndexedSetInterface collection, Comparator comparator, int algorithm) {
        this(collection, (java.util.Comparator)comparator, algorithm);
    }

    public Sort(IndexedSetInterface collection, java.util.Comparator comparator, int algorithm) {
        this.a = collection;
        this.comparator = comparator;
        if (algorithm < 0 || algorithm > 2) {
            throw new IllegalArgumentException("(algorithm < 0 || algorithm > LAST_ALGORITHM)");
        }
        this.algorithm = algorithm;
        this.b = algorithm == 0 ? new Object[this.a.count()] : null;
    }

    public Sort(IndexedSetInterface collection, Comparator comparator) {
        this(collection, (java.util.Comparator)comparator);
    }

    public Sort(IndexedSetInterface collection, java.util.Comparator comparator) {
        this.a = collection;
        this.comparator = comparator;
        this.algorithm = 0;
        this.b = new Object[this.a.count()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sort(int start, int end) {
        IndexedSetInterface indexedSetInterface = this.a;
        synchronized (indexedSetInterface) {
            switch (this.algorithm) {
                case 1: {
                    this.quickSort(start, end - 1);
                    break;
                }
                case 0: {
                    this.mergeSort(start, end);
                    break;
                }
                default: {
                    this.heapSort(start, end - 1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sort(int start, int end, int[] permutation) {
        try {
            this.permutation = permutation;
            if (this.algorithm == 0 && permutation != null) {
                this.mpermutation = new int[this.a.count()];
            }
            this.sort(start, end);
        }
        finally {
            this.permutation = null;
            this.mpermutation = null;
        }
    }

    public void sort() {
        this.sort(0, this.a.count());
    }

    private void heapSort(int start, int end) {
        int n = end - start + 1;
        int l = start + n / 2 + 1;
        int r = end;
        while (l > start) {
            this.sift(start, --l, r);
        }
        while (r > start) {
            Object x = this.a.get(start);
            this.a.set(start, this.a.get(r));
            this.a.set(r, x);
            if (this.permutation != null) {
                int p = this.permutation[start];
                this.permutation[start] = this.permutation[r];
                this.permutation[r] = p;
            }
            this.sift(start, l, --r);
        }
    }

    private void sift(int start, int l, int r) {
        int i = l;
        int j = start + 2 * (l - start) + 1;
        Object x = this.a.get(i);
        int p = 0;
        if (this.permutation != null) {
            p = this.permutation[i];
        }
        while (j <= r) {
            Object a_j1;
            Object a_j = this.a.get(j);
            if (j < r && this.comparator.compare(a_j, a_j1 = this.a.get(j + 1)) < 0) {
                ++j;
                a_j = a_j1;
            }
            if (this.comparator.compare(x, a_j) >= 0) break;
            this.a.set(i, a_j);
            if (this.permutation != null) {
                this.permutation[i] = this.permutation[j];
            }
            i = j;
            j = start + 2 * (i - start) + 1;
        }
        this.a.set(i, x);
        if (this.permutation != null) {
            this.permutation[i] = p;
        }
    }

    private void quickSort(int start, int end) {
        int lo = start;
        int hi = end;
        if (end > start) {
            Object mid = this.a.get((start + end) / 2);
            while (lo <= hi) {
                while (lo < end && this.comparator.compare(this.a.get(lo), mid) < 0) {
                    ++lo;
                }
                while (hi > start && this.comparator.compare(this.a.get(hi), mid) > 0) {
                    --hi;
                }
                if (lo > hi) continue;
                Object temp = this.a.get(lo);
                this.a.set(lo, this.a.get(hi));
                this.a.set(hi, temp);
                if (this.permutation != null) {
                    int p = this.permutation[lo];
                    this.permutation[lo] = this.permutation[hi];
                    this.permutation[hi] = p;
                }
                ++lo;
                --hi;
            }
            if (start < hi) {
                this.quickSort(start, hi);
            }
            if (lo < end) {
                this.quickSort(lo, end);
            }
        }
    }

    private void mergeSort(int start, int end) {
        int end_1 = end - 1;
        if (start >= end_1) {
            return;
        }
        if (start == end - 2) {
            Object o2;
            Object o1 = this.a.get(start);
            int result = this.comparator.compare(o1, o2 = this.a.get(end_1));
            if (result > 0) {
                this.a.set(start, o2);
                this.a.set(end_1, o1);
                if (this.permutation != null) {
                    int p = this.permutation[start];
                    this.permutation[start] = this.permutation[end_1];
                    this.permutation[end_1] = p;
                }
            }
        } else {
            int mid = start + (end - start) / 2;
            this.mergeSort(start, mid);
            this.mergeSort(mid, end);
            this.merge(start, mid, end);
        }
    }

    private void merge(int start, int mid, int end) {
        int leftRunIndex = start;
        int rightRunIndex = mid;
        int bIndex = start;
        while (leftRunIndex < mid && rightRunIndex < end) {
            Object o2;
            Object o1 = this.a.get(leftRunIndex);
            int result = this.comparator.compare(o1, o2 = this.a.get(rightRunIndex));
            if (result <= 0) {
                if (this.mpermutation != null) {
                    this.mpermutation[bIndex] = this.permutation[leftRunIndex];
                }
                this.b[bIndex++] = o1;
                ++leftRunIndex;
                continue;
            }
            if (this.mpermutation != null) {
                this.mpermutation[bIndex] = this.permutation[rightRunIndex];
            }
            this.b[bIndex++] = o2;
            ++rightRunIndex;
        }
        while (leftRunIndex < mid) {
            if (this.mpermutation != null) {
                this.mpermutation[bIndex] = this.permutation[leftRunIndex];
            }
            this.b[bIndex++] = this.a.get(leftRunIndex++);
        }
        while (rightRunIndex < end) {
            if (this.mpermutation != null) {
                this.mpermutation[bIndex] = this.permutation[rightRunIndex];
            }
            this.b[bIndex++] = this.a.get(rightRunIndex++);
        }
        for (int i = start; i < end; ++i) {
            this.a.set(i, this.b[i]);
        }
        if (this.mpermutation != null) {
            System.arraycopy(this.mpermutation, start, this.permutation, start, end - start);
        }
    }
}

