/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.util.IndexedGetInterface;
import com.sas.util.PredicateInterface;
import com.sas.util.StringPredicateInterface;
import java.io.Serializable;
import java.util.Enumeration;

public class PrefixPredicate
implements PredicateInterface,
StringPredicateInterface,
Serializable {
    static final long serialVersionUID = -7258935290920315127L;
    private String prefix;

    public PrefixPredicate(String prefix) {
        this.prefix = prefix;
    }

    public boolean predicate(Object object) {
        if (object == null) {
            return false;
        }
        return object.toString().startsWith(this.prefix);
    }

    @Override
    public boolean predicate(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith(this.prefix);
    }

    public void setPrefix(String newPrefix) {
        this.prefix = newPrefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int findItemByPrefix(Enumeration enumer, int startIndex) {
        if (startIndex >= 0 && enumer != null) {
            int index = 0;
            while (enumer.hasMoreElements()) {
                Object item = enumer.nextElement();
                if (index >= startIndex && this.predicate(item)) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    public int findItemByPrefix(IndexedGetInterface collection, int startIndex) {
        if (startIndex >= 0 && collection != null) {
            int count = collection.count();
            for (int i = startIndex; i < count; ++i) {
                Object item = collection.get(i);
                if (!this.predicate(item)) continue;
                return i;
            }
        }
        return -1;
    }
}

