/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.util.NumericRangeSegment;
import java.awt.Color;

public class InterpolatedNumericRangeSegment
extends NumericRangeSegment {
    private Object maxValue;
    private boolean isDouble;

    public InterpolatedNumericRangeSegment() {
        this(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, false, true, null, null);
    }

    public InterpolatedNumericRangeSegment(double min, double max) {
        this(min, max, false, true, null, null);
    }

    public InterpolatedNumericRangeSegment(double min, double max, Object minValue, Object maxValue) {
        this(min, max, false, true, minValue, maxValue);
    }

    public InterpolatedNumericRangeSegment(double min, double max, boolean minExcl, boolean maxExcl, Object minValue, Object maxValue) {
        this.setMin(min);
        this.setMax(max);
        this.setMinExclude(minExcl);
        this.setMaxExclude(maxExcl);
        if (minValue != null && maxValue != null) {
            if (!(minValue instanceof Double) || !(maxValue instanceof Double)) {
                if (!(minValue instanceof Color) || !(maxValue instanceof Color)) {
                    throw new RuntimeException("Invalid minValue or maxValue");
                }
                this.isDouble = false;
            } else {
                this.isDouble = true;
            }
        }
        this.setValue(minValue);
        this.maxValue = maxValue;
    }

    public void setMinValue(Object value) {
        this.value = value;
    }

    public Object getMinValue() {
        return this.value;
    }

    public void setMaxValue(Object value) {
        this.maxValue = value;
    }

    public Object getMaxValue() {
        return this.maxValue;
    }

    public Object getValue(Object value) {
        if (value != null) {
            double min = this.getMin();
            double max = this.getMax();
            double normalizedValue = ((Double)value - min) / (max - min);
            if (this.isDouble) {
                Double outMin = (Double)this.value;
                Double outMax = (Double)this.maxValue;
                return new Double(outMin + (outMax - outMin) * normalizedValue);
            }
            Color color1 = (Color)this.value;
            Color color2 = (Color)this.maxValue;
            return new Color((float)((double)color1.getRed() / 255.0 + normalizedValue * (double)(color2.getRed() - color1.getRed()) / 255.0), (float)((double)color1.getGreen() / 255.0 + normalizedValue * (double)(color2.getGreen() - color1.getGreen()) / 255.0), (float)((double)color1.getBlue() / 255.0 + normalizedValue * (double)(color2.getBlue() - color1.getBlue()) / 255.0));
        }
        return null;
    }
}

