/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.GlobalInfoTable;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.lang.StringData;
import com.sas.util.Alarm;
import com.sas.util.AlarmEvent;
import com.sas.util.AlarmListener;
import com.sas.util.RB;
import com.sas.util.TimeIntervals;
import com.sas.util.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateTimeMonitor
extends StringData
implements AlarmListener,
TimeIntervals {
    static final long serialVersionUID = -2542597514411336942L;
    public static final String RB_KEY = "DateTimeMonitor.";
    protected transient DateFormat dateTimeFormat;
    protected transient Date date;
    private String dtClassName;
    private String dtPattern;
    protected Alarm alarm;
    public static TimeZone defaultTimeZone = TimeZone.getDefault();
    private DateFormat serializedDateTimeFormat;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "dateTime"}, {"Default value", ""}, {"Description", RB.getStringResource((String)RB_KEY, (String)"dateTime.pd.txt")}, {"Property editor class", "com.sas.beans.editors.DateTimeEditor"}}, {{"Name", "format"}, {"Default value", ""}, {"Description", RB.getStringResource((String)RB_KEY, (String)"format.pd.txt")}, {"Property editor class", "com.sas.beans.editors.DateFormatEditor"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.shortDescription = RB.getStringResource((String)RB_KEY, (String)"description.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public DateTimeMonitor() {
        this(DateFormat.getDateTimeInstance(), -1L, -1L);
        this.dateTimeFormat.setTimeZone(defaultTimeZone);
    }

    public DateTimeMonitor(DateFormat dateTimeFormat, Calendar calendar) {
        this(dateTimeFormat, calendar, -1L, -1L);
    }

    public DateTimeMonitor(DateFormat dateTimeFormat) {
        this(dateTimeFormat, -1L, -1L);
    }

    public DateTimeMonitor(int format) {
        this(DateFormat.getDateTimeInstance(format, format), -1L, -1L);
        this.dateTimeFormat.setTimeZone(defaultTimeZone);
    }

    public DateTimeMonitor(DateFormat dateTimeFormat, Calendar calendar, long delay, long interval) {
        this(dateTimeFormat, delay, interval);
    }

    public DateTimeMonitor(DateFormat dateTimeFormat, long delay, long interval) {
        this.dateTimeFormat = dateTimeFormat;
        this.date = new Date();
        this.setText(dateTimeFormat.format(this.date));
        this.alarm = this.newAlarm(delay < 0L ? this.getDelay() : delay, interval <= 0L ? this.getInterval() : interval);
    }

    protected Alarm newAlarm(long delay, long interval) {
        if (this.alarm != null) {
            this.alarm.removeAlarmListener(this);
            this.alarm.stop();
        }
        Alarm a = new Alarm((AlarmListener)this, delay, interval, 0);
        a.addAlarmListener(this);
        return a;
    }

    public DateTimeMonitor(String format) {
        this.dateTimeFormat = new SimpleDateFormat(format);
        this.dateTimeFormat.setTimeZone(defaultTimeZone);
        this.alarm = this.newAlarm(this.getDelay(), this.getInterval());
    }

    public DateFormat getFormat() {
        return this.dateTimeFormat;
    }

    public void setFormat(DateFormat format) {
        DateFormat oldFormat = this.dateTimeFormat;
        if (!Util.equal((Object)oldFormat, (Object)format)) {
            format.format(this.date);
            format.format(this.date);
            this.dateTimeFormat = format;
            this.firePropertyChange("format", oldFormat, this.dateTimeFormat);
            this.update();
        }
    }

    protected long getDelay() {
        return 1000L;
    }

    public long getInterval() {
        return this.alarm == null ? 1000L : this.alarm.getInterval();
    }

    public void setInterval(long interval) {
        this.alarm.setInterval(interval);
        if (interval < this.getDelay()) {
            this.alarm.setDelay(interval);
        }
    }

    public Date getDateTime() {
        return this.date;
    }

    @Override
    public void fireAlarm(AlarmEvent event) {
        Date oldDate = this.date;
        this.date = new Date();
        this.firePropertyChange("datetime", oldDate, this.date);
        this.update();
    }

    public void update() {
        this.setText(this.dateTimeFormat.format(this.date));
    }

    public void stop() {
        this.alarm.stop();
    }

    public void start() {
        this.alarm.start();
    }

    public boolean isAlarmRunning() {
        return this.alarm.isRunning();
    }

    @Override
    public void validateObject() {
        this.update();
        long delay = Math.min(this.getDelay(), this.getInterval());
        if (this.alarm == null) {
            this.alarm = this.newAlarm(delay, this.getInterval());
        } else {
            this.alarm.setDelay(delay);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.dateTimeFormat = this.serializedDateTimeFormat;
        if (this.serializedDateTimeFormat == null) {
            Class dtClass = GlobalInfoTable.loadClass((String)this.dtClassName);
            try {
                this.dateTimeFormat = (SimpleDateFormat)dtClass.newInstance();
                if (this.dateTimeFormat != null && this.dateTimeFormat instanceof SimpleDateFormat && this.dtPattern != null) {
                    ((SimpleDateFormat)this.dateTimeFormat).applyLocalizedPattern(this.dtPattern);
                }
            }
            catch (Exception e) {
                if (this.dtPattern == null) {
                    this.dateTimeFormat = this.getInterval() >= 43200000L ? DateFormat.getDateInstance(2) : DateFormat.getTimeInstance(2);
                }
                this.dateTimeFormat = new SimpleDateFormat(this.dtPattern);
            }
        }
        if (this.dateTimeFormat != null) {
            this.dateTimeFormat.setTimeZone(defaultTimeZone);
        }
        this.date = new Date();
        if (this.alarm != null) {
            this.alarm.addAlarmListener(this);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this.serializedDateTimeFormat = this.dateTimeFormat;
        this.dtPattern = null;
        if (this.dateTimeFormat != null && this.dateTimeFormat instanceof SimpleDateFormat) {
            this.dtPattern = ((SimpleDateFormat)this.dateTimeFormat).toLocalizedPattern();
        }
        this.dtClassName = this.dateTimeFormat.getClass().getName();
        stream.defaultWriteObject();
    }
}

