/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.util.AlarmEvent;
import com.sas.util.AlarmListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public final class AlarmListenerList
implements Serializable,
AlarmListener {
    static final long serialVersionUID = 5200241973607034648L;
    private int numberOfListeners;
    private AlarmListener[] listenerList;
    private static AlarmListener[] emptyListenerList;
    private AlarmListener[] listeners;
    private int increment;
    private static final int DEFAULT_INCREMENT = 8;
    private boolean reThrowExceptions;
    private boolean logExceptions;

    public AlarmListenerList() {
        this(8, true, false);
    }

    public AlarmListenerList(int initialIncrement, boolean logExceptions, boolean reThrowExceptions) {
        this.increment = initialIncrement <= 0 ? 8 : initialIncrement;
        this.logExceptions = logExceptions;
        this.reThrowExceptions = reThrowExceptions;
    }

    public AlarmListenerList(int initialIncrement) {
        this(initialIncrement, true, false);
    }

    public int count() {
        return this.numberOfListeners;
    }

    public void setExceptionLoggingEnabled(boolean logExceptions) {
        this.logExceptions = logExceptions;
    }

    public boolean isExceptionLoggingEnabled() {
        return this.logExceptions;
    }

    protected void handleException(RuntimeException exception) {
        if (this.isExceptionLoggingEnabled()) {
            System.err.println(exception.getMessage());
            exception.printStackTrace(System.err);
        }
        if (this.isExceptionReThrown()) {
            throw exception;
        }
    }

    public void setExceptionReThrown(boolean reThrow) {
        this.reThrowExceptions = reThrow;
    }

    public boolean isExceptionReThrown() {
        return this.reThrowExceptions;
    }

    private int indexOf(AlarmListener listener) {
        if (this.listenerList != null) {
            for (int i = 0; i < this.numberOfListeners; ++i) {
                if (this.listenerList[i] != listener) continue;
                return i;
            }
        }
        return -1;
    }

    public synchronized void add(AlarmListener listener) {
        if (listener == null) {
            return;
        }
        if (this.indexOf(listener) != -1) {
            return;
        }
        this.listeners = null;
        if (this.listenerList == null || this.numberOfListeners >= this.listenerList.length) {
            if (this.numberOfListeners > 4 * this.increment) {
                this.increment *= 2;
            }
            AlarmListener[] newListenerList = new AlarmListener[this.numberOfListeners + this.increment];
            if (this.listenerList != null) {
                System.arraycopy(this.listenerList, 0, newListenerList, 0, this.numberOfListeners);
            }
            this.listenerList = newListenerList;
        }
        this.listenerList[this.numberOfListeners++] = listener;
    }

    public synchronized AlarmListener[] getListeners() {
        if (this.listeners == null) {
            if (this.numberOfListeners > 0) {
                this.listeners = new AlarmListener[this.numberOfListeners];
                System.arraycopy(this.listenerList, 0, this.listeners, 0, this.numberOfListeners);
            } else {
                if (emptyListenerList == null) {
                    emptyListenerList = new AlarmListener[0];
                }
                return emptyListenerList;
            }
        }
        return this.listeners;
    }

    public synchronized void remove(AlarmListener listener) {
        int index = this.indexOf(listener);
        if (index == -1) {
            return;
        }
        this.listeners = null;
        --this.numberOfListeners;
        if (this.numberOfListeners == 0) {
            if (emptyListenerList == null) {
                emptyListenerList = new AlarmListener[0];
            }
            this.listenerList = null;
            return;
        }
        this.listenerList[index] = null;
        while (index < this.numberOfListeners) {
            this.listenerList[index++] = this.listenerList[index];
        }
    }

    @Override
    public void fireAlarm(AlarmEvent event) {
        if (this.numberOfListeners == 0) {
            return;
        }
        for (AlarmListener listener : this.getListeners()) {
            try {
                listener.fireAlarm(event);
            }
            catch (RuntimeException exception) {
                this.handleException(exception);
            }
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.numberOfListeners == 0) {
            this.listenerList = null;
        }
    }
}

