/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.Component;
import com.sas.ComponentInterface;
import com.sas.ComponentInterfaceSupport;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.security.BaseSecuritySupport;
import com.sas.util.AlarmEvent;
import com.sas.util.AlarmInterface;
import com.sas.util.AlarmListener;
import com.sas.util.AlarmListenerList;
import com.sas.util.RB;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivilegedAction;
import java.util.Calendar;

public class Alarm
extends Component
implements AlarmInterface {
    static final String RB_KEY = "Alarm.";
    static final long serialVersionUID = -7254859743934077641L;
    protected long interval;
    protected long timeLastFired;
    protected long delay;
    protected transient long internalDelay;
    protected long startTime;
    protected long stopTime;
    protected int count;
    protected transient AlarmThread alarmThread;
    private AlarmEvent alarmEvent;
    private transient AlarmListenerList allAlarmListeners;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        String[][][] propertyMetadata = new String[][][]{{{"Name", "startTime"}, {"Hidden", "true"}}, {{"Name", "stopTime"}, {"Hidden", "true"}}};
        ebi.shortDescription = RB.getStringResource((String)RB_KEY, (String)"description.txt");
        ebi.defaultOutputPropertyName = "running";
        ebi.defaultInputPropertyName = "running";
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public Alarm() {
        this.reset();
        this.alarmEvent = new AlarmEvent(this);
    }

    public Alarm(AlarmListener listener, long millisecondDelay, long intervalMillis, int count) {
        this.init(listener, millisecondDelay, intervalMillis, count);
    }

    protected void init(AlarmListener listener, long millisecondDelay, long intervalMillis, int alarmCount) {
        if (listener != null) {
            this.addAlarmListener(listener);
        }
        this.delay = millisecondDelay;
        this.interval = intervalMillis;
        this.alarmThread = null;
        this.startTime = 0L;
        this.stopTime = 0L;
        this.count = alarmCount;
        this.reset();
        this.start();
    }

    public Alarm(AlarmListener listener, long startTimeMillis, long stopTimeMillis, long intervalMillis) {
        this.setStartTime(startTimeMillis);
        this.setStopTime(stopTimeMillis);
        this.setInterval(intervalMillis);
        this.reset();
        this.start();
    }

    public Alarm(AlarmListener listener, Calendar startDateTime, long intervalMillis, int count) {
        long current;
        long calTime;
        long initialDelay = 0L;
        if (startDateTime != null && (calTime = startDateTime.getTime().getTime()) >= (current = System.currentTimeMillis())) {
            initialDelay = calTime - current;
        }
        this.init(listener, initialDelay, intervalMillis, count);
    }

    public Alarm(AlarmListener listener, Calendar startDateTime, Calendar stopDateTime, long intervalMillis) {
        if (startDateTime != null) {
            this.setStartTime(startDateTime.getTime().getTime());
        }
        if (stopDateTime != null) {
            this.setStopTime(stopDateTime.getTime().getTime());
        }
        this.setInterval(intervalMillis);
        this.resetCount();
        this.reset();
        this.start();
    }

    protected synchronized void resetCount() {
        if (this.startTime != 0L && this.stopTime > this.startTime && this.interval > 0L) {
            this.setCount((int)((this.stopTime - this.startTime) / this.interval) + 1);
        }
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public synchronized void setStartTime(long startTimeMillis) {
        if (this.isRunning()) {
            return;
        }
        if (this.startTime != startTimeMillis) {
            long oldStartTime = this.startTime;
            this.startTime = startTimeMillis;
            this.firePropertyChange("startTime", oldStartTime, this.startTime);
        }
        this.resetCount();
    }

    @Override
    public long getStopTime() {
        return this.stopTime;
    }

    @Override
    public synchronized void setStopTime(long stopTimeMillis) {
        long oldStopTime = this.stopTime;
        this.stopTime = stopTimeMillis;
        this.firePropertyChange("stopTime", oldStopTime, this.stopTime);
        if (this.stopTime < System.currentTimeMillis() && this.isRunning()) {
            this.stop();
        }
        this.resetCount();
    }

    @Override
    public synchronized boolean isRunning() {
        return this.alarmThread != null && this.alarmThread.isAlive() && this.internalDelay >= 0L;
    }

    @Override
    public final synchronized void setRunning(boolean running) {
        if (this.isRunning() == running) {
            return;
        }
        if (running) {
            this.start();
        } else {
            this.stop();
        }
    }

    @Override
    public synchronized long getDuration() {
        if (this.stopTime > 0L && !this.isRunning()) {
            return this.stopTime - this.startTime;
        }
        if (this.startTime == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.startTime;
    }

    @Override
    public long getInterval() {
        return this.interval;
    }

    @Override
    public synchronized void setInterval(long intervalMillis) {
        if (this.interval != intervalMillis) {
            long oldInterval = this.interval;
            this.interval = intervalMillis;
            if (this.interval < oldInterval && this.isRunning()) {
                long now = System.currentTimeMillis();
                this.internalDelay = this.timeLastFired + this.interval < now ? 0L : Math.max(0L, this.timeLastFired + this.interval - now);
                this.alarmThread.interrupt();
            }
            this.firePropertyChange("interval", oldInterval, this.interval);
        }
    }

    @Override
    public synchronized void setDelay(long millisecondDelay) {
        if (this.delay != millisecondDelay) {
            long oldDelay = this.interval;
            this.delay = millisecondDelay;
            this.firePropertyChange("delay", oldDelay, this.delay);
            if (this.isRunning()) {
                this.alarmThread.interrupt();
            }
        }
    }

    @Override
    public synchronized void setCount(int alarmCount) {
        if (alarmCount != this.count) {
            int oldCount = this.count;
            this.count = alarmCount;
            this.firePropertyChange("count", oldCount, this.count);
        }
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public long getDelay() {
        return this.delay;
    }

    @Override
    public synchronized void start() {
        long oldStart = this.startTime;
        long currentTime = System.currentTimeMillis();
        if (this.startTime > currentTime) {
            this.internalDelay = this.startTime - currentTime;
            this.resetCount();
        } else {
            this.startTime = currentTime;
            if (!this.isRunning()) {
                this.internalDelay = this.delay;
            }
            this.firePropertyChange("startTime", oldStart, this.startTime);
        }
        if (this.isRunning()) {
            return;
        }
        if (this.internalDelay < 0L) {
            this.internalDelay = 0L;
        }
        if (this.stopTime <= currentTime) {
            this.stopTime = 0L;
        }
        this.alarmThread = (AlarmThread)BaseSecuritySupport.securitySupport.doThreadPrivileged(new PrivilegedAction(){

            public Object run() {
                return new AlarmThread(Alarm.this);
            }
        });
        this.alarmThread.start();
        this.firePropertyChange("running", Boolean.FALSE, Boolean.TRUE);
    }

    @Override
    public synchronized void stop() {
        if (this.isRunning()) {
            this.internalStop();
        }
    }

    private void internalStop() {
        if (this.alarmThread != null) {
            this.alarmThread.stopAlarmThread();
        }
        this.alarmThread = null;
        this.internalDelay = -1L;
        this.onStop();
    }

    protected synchronized void onStop() {
        this.firePropertyChange("running", Boolean.TRUE, Boolean.FALSE);
        long currentTime = System.currentTimeMillis();
        if (currentTime > this.stopTime) {
            long oldStop = this.stopTime;
            this.stopTime = currentTime;
            this.firePropertyChange("stopTime", oldStop, this.stopTime);
        }
    }

    @Override
    public void addAlarmListener(AlarmListener listener) {
        if (this.allAlarmListeners == null) {
            this.allAlarmListeners = new AlarmListenerList();
        }
        this.allAlarmListeners.add(listener);
    }

    @Override
    public void removeAlarmListener(AlarmListener listener) {
        if (this.allAlarmListeners != null) {
            this.allAlarmListeners.remove(listener);
        }
    }

    private void firePropertyChange(String propertyName, long oldValue, long newValue) {
        ComponentInterfaceSupport.firePropertyChange((ComponentInterface)this, propertyName, oldValue, newValue);
    }

    protected void reset() {
        this.timeLastFired = System.currentTimeMillis();
    }

    protected synchronized void fireAlarm(AlarmEvent event) {
        if (this.allAlarmListeners == null) {
            return;
        }
        this.allAlarmListeners.fireAlarm(event);
    }

    protected int decrementCount() {
        if (!this.isDesignTime()) {
            this.setCount(this.count - 1);
        }
        return this.getCount();
    }

    protected synchronized void triggerAlarm() {
        if (this.isRunning()) {
            boolean fireAgain;
            this.reset();
            if (this.allAlarmListeners != null) {
                this.fireAlarm(this.alarmEvent);
            }
            long currentTime = System.currentTimeMillis();
            boolean bl = fireAgain = this.interval > 0L && (this.stopTime == 0L || this.stopTime > 0L && currentTime <= this.stopTime + this.interval / 2L) && (this.count == 0 || this.decrementCount() > 0);
            if (fireAgain) {
                long fireTime = this.timeLastFired + this.interval;
                if (fireTime < currentTime) {
                    long nIntervals = (currentTime - this.timeLastFired) / this.interval;
                    this.timeLastFired += nIntervals * this.interval;
                    fireTime = this.timeLastFired + this.interval;
                }
                this.internalDelay = fireTime - currentTime;
            } else {
                this.internalStop();
            }
        }
    }

    public String toString() {
        return "Alarm@" + System.identityHashCode(this) + "(startTime=" + this.getStartTime() + ", stopTime=" + this.getStopTime() + ", running=" + this.isRunning() + ", count=" + this.getCount() + ", interval=" + this.getInterval() + ", duration=" + this.getDuration() + ")";
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        boolean wasRunning = stream.readBoolean();
        long currentTime = System.currentTimeMillis();
        if (wasRunning && (this.stopTime == 0L || this.stopTime > currentTime)) {
            this.start();
        }
        this.alarmEvent = new AlarmEvent(this);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeBoolean(this.isRunning());
    }

    protected class AlarmThread
    extends Thread {
        Alarm alarm;

        protected AlarmThread(Alarm alarm) {
            super(AlarmThread.class.getName());
            this.alarm = alarm;
            this.setDaemon(true);
        }

        protected void stopAlarmThread() {
            this.alarm = null;
        }

        @Override
        public void run() {
            while (this.alarm != null && this.alarm.internalDelay >= 0L) {
                try {
                    AlarmThread.sleep(this.alarm.internalDelay);
                    if (this.alarm == null) {
                        return;
                    }
                    this.alarm.triggerAlarm();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

