/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.datawizard;

import com.sas.sasserver.datawizard.StackCheckerFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Vector;

public class StackChecker
extends Writer {
    protected Vector m_stack;
    protected StackCheckerFilter m_filter;

    public StackChecker(StackCheckerFilter filter) {
        this.m_filter = filter;
    }

    public StackChecker() {
        this.m_filter = new BaseStackChecker();
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.m_stack == null) {
            this.m_stack = new Vector();
        }
        this.m_stack.addElement(new String(cbuf));
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    public boolean checkStack(Object clientData) {
        boolean rc = false;
        if (this.m_stack != null) {
            this.m_stack.removeAllElements();
            this.m_stack = null;
        }
        Throwable t = new Throwable();
        PrintWriter pw = new PrintWriter(this);
        t.printStackTrace(pw);
        if (this.m_stack != null) {
            for (int i = 0; i < this.m_stack.size() && !(rc = this.m_filter.acceptStackLine((String)this.m_stack.elementAt(i), clientData)); ++i) {
            }
        }
        return rc;
    }

    class BaseStackChecker
    implements StackCheckerFilter {
        public BaseStackChecker() {
            new StackChecker(this);
        }

        @Override
        public boolean acceptStackLine(String line, Object clientData) {
            boolean rc = false;
            if (line.indexOf((String)clientData) > 0) {
                rc = true;
            }
            return rc;
        }
    }
}

