/*
 * Decompiled with CFR 0.152.
 */
package com.sas.models;

import com.sas.collection.OrderedCollection;
import com.sas.models.NodeInterface;
import com.sas.models.SimpleNodeInterface;
import com.sas.models.TreeNode;
import com.sas.util.Util;

public class TreeNodeAdaptor
extends TreeNode {
    protected OrderedCollection children;
    protected NodeInterface node;
    protected SimpleNodeInterface[] returnArray;
    protected SimpleNodeInterface[] childArray;

    public TreeNodeAdaptor(NodeInterface node, String name) {
        this.node = node;
        this.name = name;
        this.setText(node.getNodeText());
    }

    public TreeNodeAdaptor(NodeInterface node) {
        this(node, "TreeNodeAdaptor");
        this.setText(node.getNodeText());
    }

    @Override
    public int getNodeChildCount() {
        return this.node.getNodeChildCount();
    }

    public void createChildArray() {
        this.childArray = new SimpleNodeInterface[this.getNodeChildCount()];
        SimpleNodeInterface[] tmpArray = this.node.getNodeChildren(0, this.getNodeChildCount());
        int cnt = this.getNodeChildCount();
        for (int i = 0; i < cnt; ++i) {
            TreeNodeAdaptor newNode = new TreeNodeAdaptor((NodeInterface)tmpArray[i], "TreeAdaptor_" + Util.getNumber());
            this.childArray[i] = newNode;
        }
    }

    @Override
    public SimpleNodeInterface getNodeChild(int i) {
        if (this.childArray == null) {
            this.createChildArray();
        }
        return this.childArray[i];
    }

    @Override
    public SimpleNodeInterface[] getNodeChildren(int startIndex, int count) {
        if (this.childArray == null) {
            this.createChildArray();
        }
        SimpleNodeInterface[] children = new SimpleNodeInterface[count];
        System.arraycopy(this.childArray, startIndex, children, 0, count);
        return children;
    }
}

