/*
 * Decompiled with CFR 0.152.
 */
package com.sas.models;

import com.sas.collection.PropertyBag;
import com.sas.models.RangeSegmentInterface;
import java.awt.Color;
import java.io.Serializable;

public class RangeSegment
extends PropertyBag
implements RangeSegmentInterface,
Serializable {
    static final long serialVersionUID = -8415135169936891927L;
    public static final String COLOR = "COLOR";
    protected Number min;
    protected Number max;

    public RangeSegment(Number minimum, Number maximum) {
        this(minimum, maximum, null);
    }

    public RangeSegment(Number minimum, Number maximum, Color col) {
        this.min = minimum;
        this.max = maximum;
        double minDouble = this.min.doubleValue();
        double maxDouble = this.max.doubleValue();
        if (maxDouble < minDouble) {
            this.max = new Double(minDouble);
        }
        if (col != null) {
            this.set(COLOR, col);
        } else {
            this.set(COLOR, Color.white);
        }
    }

    @Override
    public Number getMinimumNumber() {
        return this.min;
    }

    @Override
    public Number getMaximumNumber() {
        return this.max;
    }

    @Override
    public void setMinimumNumber(Number newMin) {
        this.min = newMin;
    }

    @Override
    public void setMaximumNumber(Number newMax) {
        this.max = newMax;
    }

    public Color getColor() {
        return (Color)this.get(COLOR);
    }

    public void setColor(Color newColor) {
        this.set(COLOR, newColor);
    }
}

