/*
 * Decompiled with CFR 0.152.
 */
package com.sas.models;

import com.sas.collection.OrderedCollection;
import com.sas.models.ClassNode;
import com.sas.models.Node;
import com.sas.models.NodeInterface;
import com.sas.models.SimpleNodeInterface;
import com.sas.util.PredicateInterface;
import com.sas.util.StringComparator;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class PackageNode
extends Node {
    protected OrderedCollection children;
    protected String packageName;
    protected String classPath;
    protected boolean archiveFilesSearched;
    protected PredicateInterface classFilter;
    protected boolean onlyContainPackages;

    public PackageNode(String packageName, String classPath, boolean archiveFilesSearched, PredicateInterface classFilter, boolean onlyContainPackages) {
        super(packageName);
        this.packageName = packageName;
        this.classPath = classPath;
        this.archiveFilesSearched = archiveFilesSearched;
        this.classFilter = classFilter;
        this.onlyContainPackages = onlyContainPackages;
    }

    @Override
    public String getNodeText() {
        String nodeText = super.getNodeText();
        int index = nodeText.lastIndexOf("/");
        if (index > 0) {
            nodeText = nodeText.substring(index + 1, nodeText.length());
        }
        return nodeText;
    }

    protected boolean isNodeIncluded(String partialName, String fullName, String fullFileName) {
        if (this.classFilter != null) {
            String[] names = new String[]{partialName, fullName, fullFileName};
            return this.classFilter.predicate((Object)names);
        }
        return true;
    }

    protected NodeInterface createClassNode(String text, String expandedText, String fileName, String classPathDirectory, String zipFileName) {
        ClassNode node = new ClassNode(text, expandedText, fileName, classPathDirectory, zipFileName);
        return node;
    }

    public OrderedCollection getChildren() {
        if (this.children != null) {
            return this.children;
        }
        OrderedCollection children = new OrderedCollection();
        children.initialize();
        Hashtable<String, String> subpackages = new Hashtable<String, String>();
        StringTokenizer classPathParts = new StringTokenizer(this.classPath, ";");
        while (classPathParts.hasMoreElements()) {
            String[] files;
            String fileName = (String)classPathParts.nextElement();
            try {
                File file = new File(fileName);
                fileName = file.getCanonicalPath();
            }
            catch (IOException file) {
                // empty catch block
            }
            boolean isArchiveFile = false;
            if (fileName.endsWith(".zip") || fileName.endsWith(".jar") || fileName.endsWith(".cab")) {
                isArchiveFile = true;
            }
            if (this.archiveFilesSearched && (fileName.endsWith(".zip") || fileName.endsWith(".jar"))) {
                try {
                    ZipFile zipFile = new ZipFile(fileName);
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry zipEntry = entries.nextElement();
                        String zipEntryName = zipEntry.getName();
                        if (!zipEntryName.startsWith(this.packageName)) continue;
                        int offset = this.packageName.length();
                        if (offset > 0) {
                            ++offset;
                        }
                        if (offset >= zipEntryName.length()) continue;
                        String partialName = "";
                        try {
                            partialName = zipEntryName.substring(offset, zipEntryName.length());
                        }
                        catch (IndexOutOfBoundsException e) {
                            System.out.println("packageName = " + this.packageName + "|");
                            System.out.println("zipEntryName = " + zipEntryName + "|");
                            System.out.println("offset = " + offset);
                            System.out.println("zipEntryName.length() = " + zipEntryName.length());
                            throw e;
                        }
                        int separatorIndex = partialName.indexOf(47);
                        if (separatorIndex >= 0) {
                            String partialPackage;
                            String subpackageName = partialPackage = partialName.substring(0, separatorIndex);
                            if (this.packageName != "") {
                                subpackageName = this.packageName + "/" + partialPackage;
                            }
                            subpackages.put(subpackageName, "");
                            continue;
                        }
                        if (!partialName.endsWith(".class")) continue;
                        String partialNameWithoutDotClass = partialName.substring(0, partialName.length() - 6);
                        if (this.onlyContainPackages || !this.isNodeIncluded(partialNameWithoutDotClass, this.fileNameToClassName(zipEntryName), zipEntryName)) continue;
                        NodeInterface newNode = this.createClassNode(partialNameWithoutDotClass, this.fileNameToClassName(zipEntryName), zipEntryName, null, fileName);
                        this.addChild(children, newNode);
                    }
                    zipFile.close();
                }
                catch (Exception zipFile) {}
                continue;
            }
            if (this.archiveFilesSearched && fileName.endsWith(".cab") || isArchiveFile) continue;
            String directoryName = fileName;
            if (this.packageName != "") {
                directoryName = fileName + File.separator + this.packageName;
            }
            File directory = new File(directoryName);
            File classPathDirectory = new File(fileName);
            String directoryCanonicalPath = directoryName;
            try {
                directoryCanonicalPath = classPathDirectory.getCanonicalPath();
            }
            catch (IOException offset) {
                // empty catch block
            }
            if ((files = directory.list()) == null) continue;
            for (int i = 0; i < files.length; ++i) {
                String innerFileName = files[i];
                if (innerFileName.endsWith(".class")) {
                    String fullFileName = directoryName + File.separator + innerFileName;
                    try {
                        File file = new File(fullFileName);
                        fullFileName = file.getCanonicalPath();
                    }
                    catch (IOException file) {
                        // empty catch block
                    }
                    String className = files[i];
                    String partialNameWithoutDotClass = className.substring(0, className.length() - 6);
                    if (this.onlyContainPackages || !this.isNodeIncluded(partialNameWithoutDotClass, className, fullFileName)) continue;
                    String fullClassName = this.packageName.length() == 0 ? partialNameWithoutDotClass : this.packageName + "." + partialNameWithoutDotClass;
                    NodeInterface newNode = this.createClassNode(partialNameWithoutDotClass, this.fileNameToClassName(fullClassName), fullFileName, directoryCanonicalPath, null);
                    this.addChild(children, newNode);
                    continue;
                }
                String innerDirectoryName = directoryName + "/" + innerFileName;
                File innerFile = new File(innerDirectoryName);
                if (!innerFile.isDirectory()) continue;
                String newPackageNodeName = innerFileName;
                if (this.packageName != "") {
                    newPackageNodeName = this.packageName + "/" + innerFileName;
                }
                subpackages.put(newPackageNodeName, "");
            }
        }
        Enumeration subpackageEnum = subpackages.keys();
        while (subpackageEnum.hasMoreElements()) {
            String subpackageName = (String)subpackageEnum.nextElement();
            PackageNode subPackageNode = new PackageNode(subpackageName, this.classPath, this.archiveFilesSearched, this.classFilter, this.onlyContainPackages);
            if (subPackageNode.isLeafNode()) continue;
            children.add(subPackageNode);
        }
        OrderedCollection orderedChildren = new OrderedCollection();
        orderedChildren.initialize();
        orderedChildren.addItems(children.getItems());
        orderedChildren.sort(StringComparator.defaultInstance);
        this.children = orderedChildren;
        return orderedChildren;
    }

    protected void addChild(OrderedCollection children, NodeInterface child) {
        Enumeration childrenEnum = children.getItems();
        while (childrenEnum.hasMoreElements()) {
            NodeInterface node = (NodeInterface)childrenEnum.nextElement();
            if (!node.getNodeText().equals(child.getNodeText())) continue;
            return;
        }
        children.add(child);
    }

    @Override
    public boolean isLeafNode() {
        if (this.archiveFilesSearched) {
            return false;
        }
        OrderedCollection children = this.getChildren();
        Enumeration childrenEnum = children.getItems();
        while (childrenEnum.hasMoreElements()) {
            boolean childIsLeafNode;
            Object child = childrenEnum.nextElement();
            if (child instanceof ClassNode) {
                return false;
            }
            if (!(child instanceof PackageNode) || (childIsLeafNode = ((PackageNode)child).isLeafNode())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int countNodeChildren(int maxCount) {
        int count = this.getNodeChildCount();
        if (count > maxCount) {
            count = maxCount;
        }
        return count;
    }

    @Override
    public int getNodeChildCount() {
        OrderedCollection children = this.getChildren();
        return children.count();
    }

    @Override
    public SimpleNodeInterface getNodeChild(int index) {
        OrderedCollection children = this.getChildren();
        return (SimpleNodeInterface)children.get(index);
    }

    @Override
    public SimpleNodeInterface[] getNodeChildren(int index, int count) {
        OrderedCollection children = this.getChildren();
        if (index + count > children.count()) {
            System.out.println("Index = " + index);
            System.out.println("Count = " + count);
            System.out.println("Child count = " + children.count());
            throw new IllegalArgumentException("Index + count exceeds number of children");
        }
        SimpleNodeInterface[] childArray = new SimpleNodeInterface[count];
        Enumeration childEnum = children.getItems(index, count);
        int i = 0;
        while (childEnum.hasMoreElements()) {
            childArray[i++] = (SimpleNodeInterface)childEnum.nextElement();
        }
        return childArray;
    }

    protected String fileNameToClassName(String fileName) {
        StringBuffer fileNameBuffer = new StringBuffer(fileName);
        for (int i = 0; i < fileNameBuffer.length(); ++i) {
            if (fileNameBuffer.charAt(i) != '/' && fileNameBuffer.charAt(i) != '\\') continue;
            fileNameBuffer.setCharAt(i, '.');
        }
        fileName = fileNameBuffer.toString();
        if (fileName.endsWith(".class")) {
            fileName = fileName.substring(0, fileName.length() - 6);
        }
        return fileName;
    }
}

