/*
 * Decompiled with CFR 0.152.
 */
package com.sas.models;

import com.sas.Component;
import com.sas.ComponentInterfaceSupport;
import com.sas.models.NodeInterface;
import com.sas.models.PackageNode;
import com.sas.models.TreeInterface;
import com.sas.util.PredicateInterface;
import java.io.File;
import java.util.StringTokenizer;

public class ClassPathClasses
extends Component
implements TreeInterface {
    static final long serialVersionUID = 9046911927788749143L;
    protected String classPath;
    protected boolean zipFilesSearched;
    protected PredicateInterface classFilter;
    protected String rootNodeText;
    protected boolean onlyContainPackages;
    protected boolean extensionJarsIncluded;

    public ClassPathClasses() {
        this(System.getProperty("java.class.path"));
    }

    public ClassPathClasses(String classPath) {
        this.classPath = classPath;
        this.zipFilesSearched = true;
        this.rootNodeText = "Classes";
        this.onlyContainPackages = false;
        this.extensionJarsIncluded = true;
    }

    @Override
    public NodeInterface getRoot() {
        this.classPath = this.prependExtension(this.classPath);
        PackageNode node = new PackageNode("", this.classPath, this.getArchiveFilesSearched(), this.classFilter, this.onlyContainPackages);
        node.setNodeText(this.rootNodeText);
        return node;
    }

    public boolean getArchiveFilesSearched() {
        return this.zipFilesSearched;
    }

    public void setArchiveFilesSearched(boolean zipFilesSearched) {
        if (this.zipFilesSearched != zipFilesSearched) {
            this.zipFilesSearched = zipFilesSearched;
            ComponentInterfaceSupport.firePropertyChange(this, "ZIPFilesSearched", zipFilesSearched);
        }
    }

    public boolean getExtensionJarsIncluded() {
        return this.extensionJarsIncluded;
    }

    public void setExtensionJarsIncluded(boolean extensionJarsIncluded) {
        if (this.extensionJarsIncluded != extensionJarsIncluded) {
            this.extensionJarsIncluded = extensionJarsIncluded;
            ComponentInterfaceSupport.firePropertyChange(this, "extensionJarsIncluded", extensionJarsIncluded);
        }
    }

    public PredicateInterface getClassFilter() {
        return this.classFilter;
    }

    public void setClassFilter(PredicateInterface classFilter) {
        if (this.classFilter != classFilter) {
            PredicateInterface oldFilter = this.classFilter;
            this.classFilter = classFilter;
            this.firePropertyChange("classFilter", oldFilter, classFilter);
        }
    }

    public String getRootNodeText() {
        return this.rootNodeText;
    }

    public void setRootNodeText(String rootNodeText) {
        String oldText = this.rootNodeText;
        if (oldText != null && !oldText.equals(rootNodeText)) {
            this.rootNodeText = rootNodeText;
            this.firePropertyChange("rootNodeText", oldText, rootNodeText);
        }
    }

    public boolean getOnlyContainPackages() {
        return this.onlyContainPackages;
    }

    public void setOnlyContainPackages(boolean onlyContainPackages) {
        this.onlyContainPackages = onlyContainPackages;
    }

    private String prependExtension(String classPath) {
        if (this.getExtensionJarsIncluded()) {
            String newPath = "";
            StringTokenizer extensionPathParts = new StringTokenizer(System.getProperty("java.ext.dirs"), ";");
            while (extensionPathParts.hasMoreElements()) {
                String fileName = (String)extensionPathParts.nextElement();
                File tmpfile = new File(fileName);
                File[] nameOfFile = tmpfile.listFiles();
                if (nameOfFile == null) continue;
                for (int x = 0; x < nameOfFile.length; ++x) {
                    newPath = newPath + nameOfFile[x];
                    newPath = newPath + ";";
                }
                classPath = newPath + classPath;
            }
        }
        return classPath;
    }
}

