/*
 * Decompiled with CFR 0.152.
 */
package com.sas.models;

import com.sas.Component;
import com.sas.PublicClonable;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.OrderedCollection;
import com.sas.lang.LongDataInterface;
import com.sas.models.BoundedNumberInterface;
import com.sas.models.RB;
import com.sas.text.Message;
import com.sas.util.validators.ValidationInterface;
import java.io.IOException;
import java.io.ObjectInputStream;

public class BoundedLong
extends Component
implements BoundedNumberInterface,
PublicClonable,
LongDataInterface,
ValidationInterface {
    static final long serialVersionUID = 7174659173572813376L;
    private long blockIncrement;
    private long unitIncrement;
    private long minimum;
    private long maximum;
    private long value;
    private String validationMessage;
    private Message validationMessageObj;
    protected String validationMessageCode;
    protected static OrderedCollection messages;
    public static final String valueBelowMin = "BoundedLong.ValueBelowMin";
    public static final String valueAboveMax = "BoundedLong.ValueAboveMax";
    public static final String invalidFormat = "BoundedLong.InvalidFormat";
    public static final String onlyValidateString = "BoundedLong.OnlyValidateString";
    protected static final int VALUE_BELOW_MIN = 0;
    protected static final int VALUE_ABOVE_MAX = 1;
    protected static final int INVALID_FORMAT = 2;
    protected static final int ONLY_VALIDATE_STRING = 3;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "blockIncrement"}, {"Default value", "10"}, {"Short description", "block increment"}, {"Description", "Block amount the value increments"}}, {{"Name", "maximum"}, {"Default value", "100"}, {"Short description", "maximum"}, {"Description", "Maximum amount of range value"}}, {{"Name", "minimum"}, {"Default value", "0"}, {"Short description", "minimum"}, {"Description", "Minimum amount of range value"}}, {{"Name", "unitIncrement"}, {"Default value", "1"}, {"Short description", "unit increment"}, {"Description", "Unit amount the value increments"}}, {{"Name", "value"}, {"Default value", "0"}, {"Short description", "value"}, {"Description", "Value of range"}}, {{"Name", "validationMessage"}, {"Hidden", "true"}}, {{"Name", "validationMessageCode"}, {"Hidden", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "value";
        ebi.defaultOutputPropertyName = "value";
        ebi.shortDescription = "Long constrained within a range";
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public BoundedLong() {
        this.initializeComponent();
        this.createValidationMessages();
    }

    public BoundedLong(long value, long min, long max) {
        this.initializeComponent();
        this.createValidationMessages();
        long range = max - min;
        long unit = this.unitIncrement;
        long block = this.blockIncrement;
        if (range > 0L && this.unitIncrement > range) {
            unit = 1L;
        }
        if (range > 0L && this.blockIncrement > range) {
            block = 1L;
        }
        this.setValues(value, min, max, unit, block);
    }

    public BoundedLong(long value, long min, long max, long unit, long block) {
        this.initializeComponent();
        this.createValidationMessages();
        this.setValues(value, min, max, unit, block);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof BoundedLong) {
            return this.equals((BoundedLong)object);
        }
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Object clone = super.clone();
        BoundedLong range = (BoundedLong)clone;
        range.setValues(this.getValue(), this.getMinimum(), this.getMaximum(), this.getUnitIncrement(), this.getBlockIncrement());
        return range;
    }

    public boolean equals(BoundedLong otherRange) {
        if (otherRange == null) {
            return false;
        }
        return this.getMinimum() == otherRange.getMinimum() && this.getValue() == otherRange.getValue() && this.getMaximum() == otherRange.getMaximum() && this.getBlockIncrement() == otherRange.getBlockIncrement() && this.getUnitIncrement() == otherRange.getUnitIncrement();
    }

    public String toString() {
        return "com.sas.models.BoundedLong[" + this.getMinimum() + "," + this.getValue() + "," + this.getMaximum() + "]," + this.getUnitIncrement() + "," + this.getBlockIncrement();
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        this.blockIncrement = 10L;
        this.unitIncrement = 1L;
        this.maximum = 100L;
        this.minimum = 0L;
        this.value = 0L;
    }

    public final long getLongData() {
        return this.getValue();
    }

    public final void setLongData(long newValue) {
        this.setValue(newValue);
    }

    public long getMaximum() {
        return this.maximum;
    }

    public long getMinimum() {
        return this.minimum;
    }

    public long getBlockIncrement() {
        return this.blockIncrement;
    }

    public long getUnitIncrement() {
        return this.unitIncrement;
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public Number incrementBy(int increment, int incrementType) {
        long incrementAmount = incrementType == 0 ? this.getUnitIncrement() : this.getBlockIncrement();
        if (this.getValue() == this.getMinimum() && increment < 0 || this.getValue() == this.getMaximum() && increment > 0) {
            return this.getNumberValue();
        }
        long incrementValue = (long)increment * incrementAmount;
        long newValue = this.getValue() + incrementValue;
        long closestMinValue = this.getMinimum() - incrementValue;
        long closestMaxValue = this.getMaximum() - incrementValue;
        if (this.getValue() < closestMinValue && increment < 0) {
            this.setValue(this.getMinimum());
        } else if (this.getValue() > closestMaxValue && increment > 0) {
            this.setValue(this.getMaximum());
        } else {
            this.setValue(newValue);
        }
        return this.getNumberValue();
    }

    public void setMaximum(long max) {
        if (max < this.minimum) {
            throw new IllegalArgumentException("max < min");
        }
        if (max != this.getMaximum()) {
            long oldMax = this.maximum;
            this.maximum = max;
            this.firePropertyChange("maximum", new Long(oldMax), new Long(this.maximum));
            this.firePropertyChange("maximumNumber", new Long(oldMax), new Long(this.maximum));
            long range = this.maximum - this.getMinimum();
            if (range > 0L && range < this.getUnitIncrement()) {
                this.setUnitIncrement(range);
            }
            if (range > 0L && range < this.getBlockIncrement()) {
                this.setBlockIncrement(range);
            }
            if (this.value > max) {
                this.setValue(max);
            }
        }
    }

    public void setMinimum(long min) {
        if (min > this.maximum) {
            throw new IllegalArgumentException("min > max");
        }
        if (min != this.getMinimum()) {
            long oldMin = this.minimum;
            this.minimum = min;
            this.firePropertyChange("minimum", new Long(oldMin), new Long(this.minimum));
            this.firePropertyChange("minimumNumber", new Long(oldMin), new Long(this.minimum));
            long range = this.maximum - this.getMinimum();
            if (range > 0L && range < this.getUnitIncrement()) {
                this.setUnitIncrement(range);
            }
            if (range > 0L && range < this.getBlockIncrement()) {
                this.setBlockIncrement(range);
            }
            if (this.value < min) {
                this.setValue(min);
            }
        }
    }

    public void setBlockIncrement(long block) {
        long range = this.maximum - this.minimum;
        if (block < 0L) {
            throw new IllegalArgumentException("block < 0");
        }
        if (range > 0L && block > range) {
            throw new IllegalArgumentException("block > range");
        }
        if (block != this.getBlockIncrement()) {
            long oldBlockIncrement = this.blockIncrement;
            this.blockIncrement = block;
            this.firePropertyChange("blockIncrement", new Long(oldBlockIncrement), new Long(this.blockIncrement));
            this.firePropertyChange("blockIncrementNumber", new Long(oldBlockIncrement), new Long(this.blockIncrement));
        }
    }

    public void setUnitIncrement(long unit) {
        long range = this.maximum - this.minimum;
        if (unit < 0L) {
            throw new IllegalArgumentException("unit < 0");
        }
        if (range > 0L && unit > range) {
            throw new IllegalArgumentException("unit > range");
        }
        if (unit != this.getUnitIncrement()) {
            long oldUnitIncrement = this.unitIncrement;
            this.unitIncrement = unit;
            this.firePropertyChange("unitIncrement", new Long(oldUnitIncrement), new Long(this.unitIncrement));
            this.firePropertyChange("unitIncrementNumber", new Long(oldUnitIncrement), new Long(this.unitIncrement));
        }
    }

    public void setValue(long newValue) {
        if (newValue != this.getValue()) {
            long oldValue = this.value;
            this.value = newValue > this.getMaximum() ? this.getMaximum() : (newValue < this.getMinimum() ? this.getMinimum() : newValue);
            this.firePropertyChange("value", new Long(oldValue), new Long(this.value));
            this.firePropertyChange("numberValue", new Long(oldValue), new Long(this.value));
        }
    }

    public void setValues(long value, long min, long max) {
        this.setValues(value, min, max, this.unitIncrement, this.blockIncrement);
    }

    public void setValues(long value, long min, long max, long unit, long block) {
        long oldMin = this.minimum;
        long oldMax = this.maximum;
        long oldValue = this.value;
        long oldUnit = this.unitIncrement;
        long oldBlock = this.blockIncrement;
        if (value < min) {
            value = min;
        } else if (value > max) {
            value = max;
        }
        long range = max - min;
        if (min > max) {
            throw new IllegalArgumentException("min > max");
        }
        if (unit < 0L) {
            throw new IllegalArgumentException("unit < 0");
        }
        if (block < 0L) {
            throw new IllegalArgumentException("block < 0");
        }
        if (range > 0L && unit > range) {
            throw new IllegalArgumentException("unit > range");
        }
        if (range > 0L && block > range) {
            throw new IllegalArgumentException("block > range");
        }
        this.value = value;
        this.unitIncrement = unit;
        this.blockIncrement = block;
        this.maximum = max;
        this.minimum = min;
        if (oldValue != value) {
            this.firePropertyChange("value", new Long(oldValue), new Long(value));
            this.firePropertyChange("numberValue", new Long(oldValue), new Long(value));
        }
        if (oldMax != this.maximum) {
            this.firePropertyChange("maximum", new Long(oldMax), new Long(this.maximum));
            this.firePropertyChange("maximumNumber", new Long(oldMax), new Long(this.maximum));
        }
        if (oldMin != this.minimum) {
            this.firePropertyChange("minimum", new Long(oldMin), new Long(this.minimum));
            this.firePropertyChange("minimumNumber", new Long(oldMin), new Long(this.minimum));
        }
        if (oldUnit != this.unitIncrement) {
            this.firePropertyChange("unitIncrement", new Long(oldUnit), new Long(this.unitIncrement));
            this.firePropertyChange("unitIncrementNumber", new Long(oldUnit), new Long(this.unitIncrement));
        }
        if (oldBlock != this.blockIncrement) {
            this.firePropertyChange("blockIncrement", new Long(oldBlock), new Long(this.blockIncrement));
            this.firePropertyChange("blockIncrementNumber", new Long(oldBlock), new Long(this.blockIncrement));
        }
    }

    @Override
    public final Number getBlockIncrementNumber() {
        return new Long(this.getBlockIncrement());
    }

    @Override
    public final Number getMaximumNumber() {
        return new Long(this.getMaximum());
    }

    @Override
    public final Number getMinimumNumber() {
        return new Long(this.getMinimum());
    }

    @Override
    public final Number getNumberValue() {
        return new Long(this.getValue());
    }

    @Override
    public final Number getUnitIncrementNumber() {
        return new Long(this.getUnitIncrement());
    }

    @Override
    public final void setBlockIncrementNumber(Number block) {
        this.setBlockIncrement(block.longValue());
    }

    @Override
    public final void setMaximumNumber(Number max) {
        this.setMaximum(max.longValue());
    }

    @Override
    public final void setMinimumNumber(Number min) {
        this.setMinimum(min.longValue());
    }

    @Override
    public final void setNumberValue(Number newValue) {
        this.setValue(newValue.longValue());
    }

    @Override
    public final void setNumberValues(Number newValue, Number min, Number max) {
        this.setValues(newValue.longValue(), min.longValue(), max.longValue(), this.unitIncrement, this.blockIncrement);
    }

    @Override
    public final void setNumberValues(Number newValue, Number min, Number max, Number unit, Number block) {
        this.setValues(newValue.longValue(), min.longValue(), max.longValue(), unit.longValue(), block.longValue());
    }

    @Override
    public final void setUnitIncrementNumber(Number unit) {
        this.setUnitIncrement(unit.longValue());
    }

    public boolean validateValue(Object component, Object value) {
        Message message;
        long longValue;
        if (value instanceof String) {
            try {
                String string = (String)value;
                string = string.trim();
                longValue = Long.valueOf(string);
            }
            catch (NumberFormatException e) {
                Message message2 = (Message)messages.get(2);
                message2.toString((Object[])new String[]{"java.lang.Long"});
                this.setValidationMessage(message2);
                this.setValidationMessageCode(invalidFormat);
                return false;
            }
        } else if (value instanceof Number) {
            longValue = ((Number)value).longValue();
        } else {
            Message message3 = (Message)messages.get(3);
            message3.toString((Object[])new String[]{"com.sas.models.BoundedLong", "java.lang.Long"});
            this.setValidationMessage(message3);
            this.setValidationMessageCode(onlyValidateString);
            return false;
        }
        if (longValue > this.maximum) {
            message = (Message)messages.get(1);
            message.toString((Object[])new Long[]{new Long(this.maximum)});
            this.setValidationMessage(message);
            this.setValidationMessageCode(valueAboveMax);
            return false;
        }
        if (longValue < this.minimum) {
            message = (Message)messages.get(0);
            message.toString((Object[])new Long[]{new Long(this.minimum)});
            this.setValidationMessage(message);
            this.setValidationMessageCode(valueBelowMin);
            return false;
        }
        return true;
    }

    public Object normalizeValue(Object component, Object value) {
        String string = (String)value;
        string = string.trim();
        return string;
    }

    public String getValidationMessageCode() {
        return this.validationMessageCode;
    }

    public void setValidationMessageCode(String code) {
        this.validationMessageCode = code;
    }

    public Message getValidationMessage() {
        return this.validationMessageObj;
    }

    public void setValidationMessage(Message message) {
        this.validationMessageObj = message;
    }

    public void createValidationMessages() {
        if (messages == null) {
            messages = new OrderedCollection();
            messages.add(this.newValidationMessage(RB.getStringResource((String)"BoundedNumberValidation.valueBelowMin.txt")));
            messages.add(this.newValidationMessage(RB.getStringResource((String)"BoundedNumberValidation.valueAboveMax.txt")));
            messages.add(this.newValidationMessage(RB.getStringResource((String)"BoundedNumberValidation.invalidFormat.txt")));
            messages.add(this.newValidationMessage(RB.getStringResource((String)"BoundedNumberValidation.onlyValidateString.txt")));
        }
    }

    public Message newValidationMessage(String template) {
        return new Message(template);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.createValidationMessages();
    }
}

