/*
 * Decompiled with CFR 0.152.
 */
package com.sas.models;

import com.sas.Component;
import com.sas.PublicClonable;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.OrderedCollection;
import com.sas.lang.DoubleData;
import com.sas.lang.DoubleDataInterface;
import com.sas.models.BoundedNumberInterface;
import com.sas.models.RB;
import com.sas.text.Message;
import com.sas.util.validators.ValidationInterface;
import java.io.IOException;
import java.io.ObjectInputStream;

public class BoundedDouble
extends Component
implements BoundedNumberInterface,
PublicClonable,
DoubleDataInterface,
ValidationInterface {
    public static final String RB_KEY = "BoundedDouble.";
    static final long serialVersionUID = 5483311779715293062L;
    private double blockIncrement;
    private double unitIncrement;
    private double minimum;
    private double maximum;
    private double value;
    private String validationMessage;
    private Message validationMessageObj;
    protected String validationMessageCode;
    protected static OrderedCollection messages;
    public static final String valueBelowMin = "BoundedLong.ValueBelowMin";
    public static final String valueAboveMax = "BoundedLong.ValueAboveMax";
    public static final String invalidFormat = "BoundedLong.InvalidFormat";
    public static final String onlyValidateString = "BoundedLong.OnlyValidateString";
    protected static final int VALUE_BELOW_MIN = 0;
    protected static final int VALUE_ABOVE_MAX = 1;
    protected static final int INVALID_FORMAT = 2;
    protected static final int ONLY_VALIDATE_STRING = 3;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "blockIncrement"}, {"Default value", "10.0"}, {"Short description", "block increment"}, {"Description", "Block amount the value increments"}}, {{"Name", "maximum"}, {"Default value", "100.0"}, {"Short description", "maximum"}, {"Description", "Maximum amount of range value"}}, {{"Name", "minimum"}, {"Default value", "0.0"}, {"Short description", "minimum"}, {"Description", "Minimum amount of range value"}}, {{"Name", "unitIncrement"}, {"Default value", "1.0"}, {"Short description", "unit increment"}, {"Description", "Unit amount the value increments"}}, {{"Name", "value"}, {"Default value", "0.0"}, {"Short description", "value"}, {"Description", "Value of range"}}, {{"Name", "validationMessage"}, {"Hidden", "true"}}, {{"Name", "validationMessageCode"}, {"Hidden", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "value";
        ebi.defaultOutputPropertyName = "value";
        ebi.shortDescription = RB.getStringResource((String)RB_KEY, (String)"description.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public BoundedDouble() {
        this.initializeComponent();
        this.createValidationMessages();
    }

    public BoundedDouble(double value, double min, double max) {
        this.initializeComponent();
        this.createValidationMessages();
        double range = max - min;
        double unit = this.unitIncrement;
        double block = this.blockIncrement;
        if (range > 0.0 && this.unitIncrement > range) {
            unit = 1.0;
        }
        if (range > 0.0 && this.blockIncrement > range) {
            block = 1.0;
        }
        this.setValues(value, min, max, unit, block);
    }

    public BoundedDouble(double value, double min, double max, double unit, double block) {
        this.initializeComponent();
        this.createValidationMessages();
        this.setValues(value, min, max, unit, block);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof BoundedDouble) {
            return this.equals((BoundedDouble)object);
        }
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Object clone = super.clone();
        BoundedDouble range = (BoundedDouble)clone;
        range.setValues(this.getValue(), this.getMinimum(), this.getMaximum(), this.getUnitIncrement(), this.getBlockIncrement());
        return range;
    }

    public boolean equals(BoundedDouble otherRange) {
        if (otherRange == null) {
            return false;
        }
        return this.getMinimum() == otherRange.getMinimum() && this.getValue() == otherRange.getValue() && this.getMaximum() == otherRange.getMaximum() && this.getBlockIncrement() == otherRange.getBlockIncrement() && this.getUnitIncrement() == otherRange.getUnitIncrement();
    }

    public String toString() {
        return "com.sas.models.BoundedDouble[" + this.getMinimum() + "," + this.getValue() + "," + this.getMaximum() + "]," + this.getUnitIncrement() + "," + this.getBlockIncrement();
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        this.blockIncrement = 10.0;
        this.unitIncrement = 1.0;
        this.maximum = 100.0;
        this.minimum = 0.0;
        this.value = 0.0;
    }

    public final double getDoubleData() {
        return this.getValue();
    }

    public final void setDoubleData(double newValue) {
        this.setValue(newValue);
    }

    public double getMaximum() {
        return this.maximum;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public double getBlockIncrement() {
        return this.blockIncrement;
    }

    public double getUnitIncrement() {
        return this.unitIncrement;
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public Number incrementBy(int increment, int incrementType) {
        double incrementAmount = incrementType == 0 ? this.getUnitIncrement() : this.getBlockIncrement();
        if (this.getValue() == this.getMinimum() && increment < 0 || this.getValue() == this.getMaximum() && increment > 0) {
            return this.getNumberValue();
        }
        double incrementValue = (double)increment * incrementAmount;
        double newValue = this.getValue() + incrementValue;
        this.setValue(newValue);
        return this.getNumberValue();
    }

    public void setMaximum(double max) {
        if (max < this.minimum) {
            throw new IllegalArgumentException("max < min");
        }
        if (max != this.getMaximum()) {
            double oldMax = this.maximum;
            this.maximum = max;
            this.firePropertyChange("maximum", new Double(oldMax), new Double(this.maximum));
            this.firePropertyChange("maximumNumber", new Double(oldMax), new Double(this.maximum));
            double range = this.maximum - this.getMinimum();
            if (range > 0.0 && range < this.getUnitIncrement()) {
                this.setUnitIncrement(range);
            }
            if (range > 0.0 && range < this.getBlockIncrement()) {
                this.setBlockIncrement(range);
            }
            if (this.value > max) {
                this.setValue(max);
            }
        }
    }

    public void setMinimum(double min) {
        if (min > this.maximum) {
            throw new IllegalArgumentException("min > max");
        }
        if (min != this.getMinimum()) {
            double oldMin = this.minimum;
            this.minimum = min;
            this.firePropertyChange("minimum", new Double(oldMin), new Double(this.minimum));
            this.firePropertyChange("minimumNumber", new Double(oldMin), new Double(this.minimum));
            double range = this.maximum - this.getMinimum();
            if (range > 0.0 && range < this.getUnitIncrement()) {
                this.setUnitIncrement(range);
            }
            if (range > 0.0 && range < this.getBlockIncrement()) {
                this.setBlockIncrement(range);
            }
            if (this.value < min) {
                this.setValue(min);
            }
        }
    }

    public void setBlockIncrement(double block) {
        double range = this.maximum - this.minimum;
        if (block < 0.0) {
            throw new IllegalArgumentException("block < 0");
        }
        if (range > 0.0 && block > range) {
            throw new IllegalArgumentException("block > range");
        }
        if (block != this.getBlockIncrement()) {
            double oldBlockIncrement = this.blockIncrement;
            this.blockIncrement = block;
            this.firePropertyChange("blockIncrement", new Double(oldBlockIncrement), new Double(this.blockIncrement));
            this.firePropertyChange("blockIncrementNumber", new Double(oldBlockIncrement), new Double(this.blockIncrement));
        }
    }

    public void setUnitIncrement(double unit) {
        double range = this.maximum - this.minimum;
        if (unit < 0.0) {
            throw new IllegalArgumentException("unit < 0");
        }
        if (range > 0.0 && unit > range) {
            throw new IllegalArgumentException("unit > range");
        }
        if (unit != this.getUnitIncrement()) {
            double oldUnitIncrement = this.unitIncrement;
            this.unitIncrement = unit;
            this.firePropertyChange("unitIncrement", new Double(oldUnitIncrement), new Double(this.unitIncrement));
            this.firePropertyChange("unitIncrementNumber", new Double(oldUnitIncrement), new Double(this.unitIncrement));
        }
    }

    public void setValue(double newValue) {
        if (newValue != this.getValue()) {
            double oldValue = this.value;
            this.value = newValue > this.getMaximum() ? this.getMaximum() : (newValue < this.getMinimum() ? this.getMinimum() : newValue);
            this.firePropertyChange("value", new Double(oldValue), new Double(this.value));
            this.firePropertyChange("numberValue", new Double(oldValue), new Double(this.value));
        }
    }

    public void setValues(double value, double min, double max) {
        this.setValues(value, min, max, this.unitIncrement, this.blockIncrement);
    }

    public void setValues(double value, double min, double max, double unit, double block) {
        double oldMin = this.minimum;
        double oldMax = this.maximum;
        double oldValue = this.value;
        double oldUnit = this.unitIncrement;
        double oldBlock = this.blockIncrement;
        if (value < min) {
            value = min;
        } else if (value > max) {
            value = max;
        }
        double range = max - min;
        if (min > max) {
            throw new IllegalArgumentException("min > max");
        }
        if (unit < 0.0) {
            throw new IllegalArgumentException("unit < 0");
        }
        if (block < 0.0) {
            throw new IllegalArgumentException("block < 0");
        }
        if (range > 0.0 && unit > range) {
            throw new IllegalArgumentException("unit > range");
        }
        if (range > 0.0 && block > range) {
            throw new IllegalArgumentException("block > range");
        }
        this.value = value;
        this.unitIncrement = unit;
        this.blockIncrement = block;
        this.maximum = max;
        this.minimum = min;
        if (oldValue != value) {
            this.firePropertyChange("value", new Double(oldValue), new Double(value));
            this.firePropertyChange("numberValue", new Double(oldValue), new Double(value));
        }
        if (oldMax != this.maximum) {
            this.firePropertyChange("maximum", new Double(oldMax), new Double(this.maximum));
            this.firePropertyChange("maximumNumber", new Double(oldMax), new Double(this.maximum));
        }
        if (oldMin != this.minimum) {
            this.firePropertyChange("minimum", new Double(oldMin), new Double(this.minimum));
            this.firePropertyChange("minimumNumber", new Double(oldMin), new Double(this.minimum));
        }
        if (oldUnit != this.unitIncrement) {
            this.firePropertyChange("unitIncrement", new Double(oldUnit), new Double(this.unitIncrement));
            this.firePropertyChange("unitIncrementNumber", new Double(oldUnit), new Double(this.unitIncrement));
        }
        if (oldBlock != this.blockIncrement) {
            this.firePropertyChange("blockIncrement", new Double(oldBlock), new Double(this.blockIncrement));
            this.firePropertyChange("blockIncrementNumber", new Double(oldBlock), new Double(this.blockIncrement));
        }
    }

    @Override
    public final Number getMaximumNumber() {
        return new Double(this.getMaximum());
    }

    @Override
    public final Number getMinimumNumber() {
        return new Double(this.getMinimum());
    }

    @Override
    public final Number getBlockIncrementNumber() {
        return new Double(this.getBlockIncrement());
    }

    @Override
    public final Number getUnitIncrementNumber() {
        return new Double(this.getUnitIncrement());
    }

    @Override
    public final Number getNumberValue() {
        return new Double(this.getValue());
    }

    @Override
    public final void setMaximumNumber(Number max) {
        this.setMaximum(max.doubleValue());
    }

    @Override
    public final void setMinimumNumber(Number min) {
        this.setMinimum(min.doubleValue());
    }

    @Override
    public final void setBlockIncrementNumber(Number block) {
        this.setBlockIncrement(block.doubleValue());
    }

    @Override
    public final void setUnitIncrementNumber(Number unit) {
        this.setUnitIncrement(unit.doubleValue());
    }

    @Override
    public final void setNumberValue(Number newValue) {
        this.setValue(newValue.doubleValue());
    }

    @Override
    public final void setNumberValues(Number newValue, Number min, Number max) {
        this.setValues(newValue.doubleValue(), min.doubleValue(), max.doubleValue(), this.unitIncrement, this.blockIncrement);
    }

    @Override
    public final void setNumberValues(Number newValue, Number min, Number max, Number unit, Number block) {
        this.setValues(newValue.doubleValue(), min.doubleValue(), max.doubleValue(), unit.doubleValue(), block.doubleValue());
    }

    public boolean validateValue(Object component, Object value) {
        Message message;
        double doubleValue;
        if (value instanceof String) {
            try {
                String string = (String)value;
                string = string.trim();
                doubleValue = DoubleData.valueOf(string);
            }
            catch (NumberFormatException e) {
                Message message2 = (Message)messages.get(2);
                message2.toString((Object[])new String[]{"java.lang.Double"});
                this.setValidationMessage(message2);
                this.setValidationMessageCode(invalidFormat);
                return false;
            }
        } else if (value instanceof Number) {
            doubleValue = ((Number)value).doubleValue();
        } else {
            Message message3 = (Message)messages.get(3);
            message3.toString((Object[])new String[]{"com.sas.models.BoundedDouble", "java.lang.Double"});
            this.setValidationMessage(message3);
            this.setValidationMessageCode(onlyValidateString);
            return false;
        }
        if (doubleValue > this.maximum) {
            message = (Message)messages.get(1);
            message.toString((Object)new Double(this.maximum));
            this.setValidationMessage(message);
            this.setValidationMessageCode(valueAboveMax);
            return false;
        }
        if (doubleValue < this.minimum) {
            message = (Message)messages.get(0);
            message.toString((Object)new Double(this.minimum));
            this.setValidationMessage(message);
            this.setValidationMessageCode(valueBelowMin);
            return false;
        }
        return true;
    }

    public Object normalizeValue(Object component, Object value) {
        String string = (String)value;
        string = string.trim();
        return string;
    }

    public String getValidationMessageCode() {
        return this.validationMessageCode;
    }

    public void setValidationMessageCode(String code) {
        this.validationMessageCode = code;
    }

    public Message getValidationMessage() {
        return this.validationMessageObj;
    }

    public void setValidationMessage(Message message) {
        this.validationMessageObj = message;
    }

    public void createValidationMessages() {
        if (messages == null) {
            messages = new OrderedCollection();
            messages.add(this.newValidationMessage(RB.getStringResource((String)"BoundedNumberValidation.valueBelowMin.txt")));
            messages.add(this.newValidationMessage(RB.getStringResource((String)"BoundedNumberValidation.valueAboveMax.txt")));
            messages.add(this.newValidationMessage(RB.getStringResource((String)"BoundedNumberValidation.invalidFormat.txt")));
            messages.add(this.newValidationMessage(RB.getStringResource((String)"BoundedNumberValidation.onlyValidateString.txt")));
        }
    }

    public Message newValidationMessage(String template) {
        return new Message(template);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.createValidationMessages();
    }
}

