/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lang;

import com.sas.Component;
import com.sas.ComponentInterfaceSupport;

public class BooleanOperator
extends Component {
    static final long serialVersionUID = -3690860263006631309L;
    private boolean leftOperand;
    private boolean rightOperand;
    private byte function;
    public static final int FALSE = 0;
    public static final int NOR = 1;
    public static final int NOTA_AND_B = 2;
    public static final int NOTA = 3;
    public static final int A_AND_NOTB = 4;
    public static final int NOTB = 5;
    public static final int NAND = 7;
    public static final int XOR = 6;
    public static final int AND = 8;
    public static final int XNOR = 9;
    public static final int B = 10;
    public static final int NOTA_OR_B = 11;
    public static final int A = 12;
    public static final int A_OR_NOTB = 13;
    public static final int OR = 14;
    public static final int TRUE = 15;
    public static final int NOT = 3;
    static String[] names = new String[]{"false", "!(a|b)", "!a&b", "!a", "a&!b", "!b", "a^b", "!(a&b)", "a&b", "!(a^b)", "b", "!a|b", "a", "a|!b", "a|b", "true"};

    public BooleanOperator(int function) {
        this.setFunction(function);
    }

    public BooleanOperator() {
        this(14);
    }

    public void setLeftOperand(boolean leftOp) {
        boolean oldLeftOperand = this.getLeftOperand();
        if (oldLeftOperand == leftOp) {
            return;
        }
        boolean oldResult = this.getResult();
        this.leftOperand = leftOp;
        this.firePropertyChanges("leftOperand", oldLeftOperand, this.getLeftOperand(), oldResult);
    }

    public boolean getLeftOperand() {
        return this.leftOperand;
    }

    public void setRightOperand(boolean rightOp) {
        boolean oldRightOperand = this.getRightOperand();
        if (oldRightOperand == rightOp) {
            return;
        }
        boolean oldResult = this.getResult();
        this.rightOperand = rightOp;
        this.firePropertyChanges("rightOperand", oldRightOperand, this.getRightOperand(), oldResult);
    }

    public boolean getRightOperand() {
        return this.rightOperand;
    }

    public boolean getResult() {
        return this.getResult(this.getLeftOperand(), this.getRightOperand());
    }

    public boolean getResult(boolean a, boolean b) {
        int shift = 0;
        if (a) {
            shift += 2;
        }
        if (b) {
            ++shift;
        }
        return (this.function >> shift & 1) == 1;
    }

    protected void firePropertyChanges(String propertyName, boolean oldValue, boolean newValue, boolean oldResult) {
        if (oldValue != newValue) {
            ComponentInterfaceSupport.firePropertyChange(this, propertyName, newValue);
        }
        this.maybeFireResult(oldResult);
    }

    protected void maybeFireResult(boolean oldResult) {
        boolean newResult = this.getResult();
        if (oldResult != newResult) {
            ComponentInterfaceSupport.firePropertyChange(this, "result", newResult);
        }
    }

    public void setFunction(int functionID) {
        int oldFunction = this.getFunction();
        if (oldFunction == functionID) {
            return;
        }
        boolean oldResult = this.getResult();
        this.function = (byte)(0xF & functionID);
        this.firePropertyChange("function", new Integer(oldFunction), new Integer(this.getFunction()));
        this.maybeFireResult(oldResult);
    }

    public int getFunction() {
        return this.function;
    }

    public int hashCode() {
        return this.getFunction();
    }

    public boolean equals(BooleanOperator other) {
        if (other == null) {
            return false;
        }
        return other.getFunction() == this.getFunction();
    }

    public boolean equals(Object object) {
        return object instanceof BooleanOperator && this.equals((BooleanOperator)object);
    }

    public String toString(boolean logicalName) {
        String string;
        String string2 = string = logicalName ? names[0xF & this.getFunction()] : null;
        if (string == null) {
            StringBuffer b = new StringBuffer();
            b.append("{");
            b.append(this.getResult(true, true));
            b.append(",");
            b.append(this.getResult(true, false));
            b.append(",");
            b.append(this.getResult(false, true));
            b.append(",");
            b.append(this.getResult(false, false));
            b.append("}");
            string = b.toString();
        }
        return string;
    }

    public String toString() {
        return this.toString(true);
    }
}

