/*
 * Decompiled with CFR 0.152.
 */
package com.sas.collection.hlist;

import com.sas.collection.hlist.RB;
import com.sas.io.Encoder;
import com.sas.io.EncoderInterface;
import com.sas.text.Message;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class StreamEnv {
    private static final boolean DEBUG = false;
    static final String UTF8_ENCODING = "UTF8";
    static final String DEFAULT_ENCODING = "UTF8";
    String encoding;
    EncoderInterface encoder;
    Hashtable strings;
    Vector vector;
    int stringIndex;
    int version;
    boolean root;
    boolean readNextItemAttrs;
    boolean readNextItemName;
    public static final String RB_KEY = "StreamEnv.";
    protected static Stack environments = new Stack();

    public StreamEnv(String encoding) throws IOException {
        this(3, encoding);
    }

    public StreamEnv(int version, String encoding) throws IOException {
        if (version != 1 && version != 2 && version != 3) {
            throw new IOException(Message.format((String)RB.getStringResource(RB_KEY, "invalidStreamVersionNumber.ex.txt"), (Object)new Integer(version)));
        }
        this.setEncoding(encoding);
        this.version = version;
        this.root = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StreamEnv getInstance(String encoding) throws IOException {
        Stack stack = environments;
        synchronized (stack) {
            if (environments.empty()) {
                return new StreamEnv(encoding);
            }
            StreamEnv env = (StreamEnv)environments.pop();
            env.setEncoding(encoding);
            return env;
        }
    }

    public static StreamEnv getInstance(int version, String encoding) throws IOException {
        StreamEnv env = StreamEnv.getInstance(encoding);
        env.setVersion(version);
        return env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void returnInstance(StreamEnv env) {
        Stack stack = environments;
        synchronized (stack) {
            environments.push(env);
            env.close();
        }
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    public void setEncoding(String encoding) throws IOException {
        if (encoding == null) {
            encoding = "UTF8";
        }
        if (encoding.equalsIgnoreCase(this.encoding)) {
            return;
        }
        this.encoding = encoding;
        this.encoder = "UTF8".equalsIgnoreCase(encoding) ? null : Encoder.getInstance((String)encoding);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void close() {
        if (this.encoder != null) {
            Encoder.returnInstance((EncoderInterface)this.encoder);
            this.encoder = null;
        }
        this.reset();
    }

    public void reset() {
        this.root = true;
        this.strings = null;
        this.vector = null;
        this.stringIndex = 0;
        this.encoder = null;
        this.encoding = null;
    }

    public boolean contains(String string) {
        return this.strings.get(string) != null;
    }

    public int stringIndex(String string) {
        Integer i;
        if (this.strings == null) {
            this.strings = new Hashtable();
        }
        if ((i = (Integer)this.strings.get(string)) == null) {
            i = new Integer(++this.stringIndex);
            this.strings.put(string, i);
            return this.stringIndex;
        }
        return -i.intValue();
    }

    public void add(String string) {
        if (this.vector == null) {
            this.vector = new Vector(20);
            this.vector.addElement("");
        }
        this.vector.addElement(string);
    }

    public String get(int stringDescriptor) {
        int index = Math.abs(stringDescriptor);
        String s = (String)this.vector.elementAt(index);
        return s;
    }

    public void writeStringDefaultEncoding(String string, DataOutputStream stream) throws IOException {
        Encoder.writeUTF((String)string, (DataOutputStream)stream);
    }

    public void writeString(String string, DataOutputStream stream) throws IOException {
        if (this.version >= 3) {
            int stringLength;
            if (string == null) {
                string = "";
            }
            if ((stringLength = string.length()) == 0) {
                stream.writeInt(0);
                return;
            }
            int stringIndex = this.stringIndex(string);
            if (stringIndex < 0) {
                stream.writeInt(stringIndex);
                return;
            }
            if (this.encoder == null) {
                Encoder.writeUTF32((String)string, (DataOutputStream)stream);
            } else {
                byte[] bytes = this.encoder.toByteArray(string, 0, string.length());
                int nBytes = bytes.length;
                stream.writeInt(nBytes);
                stream.write(bytes, 0, nBytes);
            }
        } else {
            Encoder.writeUTF((String)string, (DataOutputStream)stream);
        }
    }

    public String readStringDefaultEncoding(DataInputStream stream) throws IOException {
        return Encoder.readUTF((DataInput)stream);
    }

    public String readString(DataInputStream stream) throws IOException {
        if (this.version >= 3) {
            String string;
            int stringDescriptor = stream.readInt();
            if (stringDescriptor == 0) {
                return "";
            }
            if (stringDescriptor < 0) {
                try {
                    String string2 = this.get(stringDescriptor);
                    return string2;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IOException(e.getMessage());
                }
            }
            int nBytes = stringDescriptor;
            if (this.encoder == null) {
                string = Encoder.readUTF((DataInput)stream, (int)nBytes);
            } else {
                if (nBytes == 0) {
                    return "";
                }
                byte[] bytes = this.encoder.getByteArray(nBytes);
                nBytes = stream.read(bytes, 0, nBytes);
                string = this.encoder.toString(bytes, 0, nBytes);
            }
            this.add(string);
            return string;
        }
        return Encoder.readUTF((DataInput)stream);
    }

    public String toString() {
        return "(" + this.getVersion() + "," + this.getEncoding() + ")";
    }

    public boolean equals(StreamEnv other) {
        if (other == null) {
            return false;
        }
        return this.getVersion() == other.getVersion() && (this.getEncoding() == other.getEncoding() || this.getEncoding() != null && this.getEncoding().equals(other.getEncoding()));
    }

    public boolean equals(Object object) {
        if (object instanceof StreamEnv) {
            return this.equals((StreamEnv)object);
        }
        return false;
    }

    public int hashCode() {
        return this.getEncoding() != null ? this.getEncoding().hashCode() + this.version : this.version;
    }

    public Object clone() throws CloneNotSupportedException {
        StreamEnv clone = (StreamEnv)super.clone();
        clone.reset();
        try {
            clone.setEncoding(this.getEncoding());
        }
        catch (IOException e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
        return clone;
    }
}

