/*
 * Decompiled with CFR 0.152.
 */
package com.sas.collection.hlist;

import com.sas.MissingValues;
import com.sas.collection.LongKeyDictionary;
import com.sas.collection.OrderedCollection;
import com.sas.collection.Permuter;
import com.sas.collection.hlist.ArrayItem;
import com.sas.collection.hlist.DoubleItem;
import com.sas.collection.hlist.HListAttributes;
import com.sas.collection.hlist.HListInterface;
import com.sas.collection.hlist.HListItem;
import com.sas.collection.hlist.ListItem;
import com.sas.collection.hlist.ObjectItem;
import com.sas.collection.hlist.RB;
import com.sas.collection.hlist.StreamEnv;
import com.sas.collection.hlist.StringItem;
import com.sas.text.Message;
import com.sas.util.Strings;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Vector;

public class HList
extends OrderedCollection
implements HListInterface {
    public static final String RB_KEY = "HList.";
    static final long serialVersionUID = 6781672087264149182L;
    public static final int IO_VERSION_1 = 1;
    public static final int IO_VERSION_2 = 2;
    public static final int IO_VERSION_3 = 3;
    public static final int LATEST_IO_VERSION = 3;
    private static int nextId = -1;
    private static final boolean DEBUG = false;
    protected int id;
    protected int attributes;
    protected static int GLOBAL = 0x40000000;
    protected static int VISITED = Integer.MIN_VALUE;
    protected static int VISITED2 = 0x10000000;

    @Override
    public int getId() {
        return this.id;
    }

    public HList() {
        this.newId();
    }

    public HList(int id) {
        this.id = id;
    }

    public HList(DataInputStream stream) throws IOException {
        super(0);
        this.read(stream);
    }

    public HList(DataInputStream stream, StreamEnv env) throws IOException {
        super(0);
        this.read(stream, env);
    }

    @Override
    public synchronized Object clone() {
        try {
            HList clone = (HList)super.clone();
            this.newId();
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError(cnse.getMessage());
        }
    }

    @Override
    public synchronized void set(int index, Object item) {
        this.setItem(index, (HListItem)item);
    }

    @Override
    public synchronized void add(Object item, int index) {
        this.addItem((HListItem)item, index);
    }

    @Override
    public void addItem(String string, int index, String name) {
        this.addItem(new StringItem(string, name), index);
    }

    @Override
    public void addItem(double value, int index, String name) {
        if (Double.isNaN(value)) {
            this.addItem(MissingValues.Dot, index, name);
        } else {
            this.addItem(new DoubleItem(value, name), index);
        }
    }

    @Override
    public void addItem(MissingValues missingValue, int index, String name) {
        this.addItem(new DoubleItem(missingValue, name), index);
    }

    @Override
    public void addItem(HListInterface list, int index, String name) {
        this.addItem(new ListItem(list, name), index);
    }

    @Override
    public void addItem(Object object, int index, String name) {
        this.addItem(new ObjectItem(object, name), index);
    }

    @Override
    public synchronized void add(Object item) {
        this.addItem((HListItem)item, this.count());
    }

    private void newId() {
        this.id = nextId--;
    }

    @Override
    public void write(DataOutputStream stream) throws IOException {
        this.write(stream, 1, "UTF8");
    }

    public void write(DataOutputStream stream, int streamVersion) throws IOException {
        StreamEnv env = StreamEnv.getInstance(null);
        env.setVersion(streamVersion);
        this.write(stream, env);
        StreamEnv.returnInstance(env);
    }

    public void write(DataOutputStream stream, int streamVersion, String encoding) throws IOException {
        StreamEnv env = StreamEnv.getInstance(streamVersion, encoding);
        this.write(stream, env);
        StreamEnv.returnInstance(env);
    }

    public void write(DataOutputStream stream, StreamEnv env) throws IOException {
        if (this.visited()) {
            throw new IOException(RB.getStringResource(RB_KEY, "noRecursiveStreaming.ex.txt"));
        }
        this.visit(null);
        if (env.root || env.version < 3) {
            stream.writeInt(env.version);
            env.root = false;
            if (env.version >= 3) {
                env.writeStringDefaultEncoding(env.encoding, stream);
            }
        }
        stream.writeInt(this.id);
        if (env.version < 2) {
            stream.writeShort(this.attributes);
        } else {
            stream.writeInt(this.attributes);
        }
        long nItems = this.count();
        stream.writeLong(nItems);
        int i = 0;
        while ((long)i < nItems) {
            this.getItem(i).write(stream, env);
            ++i;
        }
        this.unvisit();
    }

    @Override
    public void read(DataInputStream stream) throws IOException {
        Object encoding = null;
        this.read(stream, "UTF8");
    }

    public void read(DataInputStream stream, String encoding) throws IOException {
        StreamEnv env = StreamEnv.getInstance(encoding);
        this.read(stream, env);
        StreamEnv.returnInstance(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(DataInputStream stream, StreamEnv env) throws IOException {
        boolean isRoot = env.root;
        if (env.root || env.version < 3) {
            env.root = false;
            env.version = stream.readInt();
            if (env.version >= 3) {
                String newEncoding = env.readStringDefaultEncoding(stream);
                if (newEncoding == null || newEncoding.length() == 0 || "UTF8".equalsIgnoreCase(newEncoding)) {
                    newEncoding = "UTF8";
                }
                env.setEncoding(newEncoding);
            }
        }
        switch (env.version) {
            case 1: 
            case 2: 
            case 3: {
                this.id = stream.readInt();
                if (env.version < 2) {
                    this.attributes = stream.readShort();
                    if ((this.attributes & 0xFF) == 255) {
                        this.attributes = 0;
                    }
                } else {
                    this.attributes = stream.readInt();
                }
                long nItems = stream.readLong();
                HList hList = this;
                synchronized (hList) {
                    DataInputStream dataInputStream = stream;
                    synchronized (dataInputStream) {
                        try {
                            int c = this.count();
                            this.disableEvents();
                            super.setSize((int)((long)c + nItems));
                            int end = (int)((long)c + nItems);
                            for (int i = c; i < end; ++i) {
                                HListItem item = HListItem.newFromStream(stream, env);
                                if (item == null) {
                                    this.setSize(i);
                                    throw new IOException(Message.format((String)RB.getStringResource(RB_KEY, "invalidStreamVersion.ex.txt"), (Object)new Integer(env.version)));
                                }
                                this.setItem(i, item);
                            }
                            break;
                        }
                        finally {
                            this.enableEvents(null);
                        }
                    }
                }
            }
            default: {
                throw new IOException(Message.format((String)RB.getStringResource(RB_KEY, "invalidStreamVersion.ex.txt"), (Object)new Integer(env.version)));
            }
        }
    }

    @Override
    public void setSize(int newSize) {
        int c = this.count();
        super.setSize(newSize);
        while (c < this.count()) {
            this.setItem(c++, (HListItem)new DoubleItem(MissingValues.Dot));
        }
    }

    @Override
    public final HListItem getItem(String name) {
        return this.getItem(name, 1, 0);
    }

    @Override
    public String getString(int index) {
        return ((StringItem)this.getItem(index)).getValue();
    }

    @Override
    public String getString(String name, int nth, int start) {
        int index = this.find(name, nth, start);
        if (index == -1) {
            throw this.newIndexException(name, nth, start);
        }
        return this.getString(index);
    }

    @Override
    public final String getString(String name) {
        return this.getString(name, 1, 0);
    }

    public Object getArray(int index) {
        return ((ArrayItem)this.getItem(index)).getValue();
    }

    public Object getArray(String name, int nth, int start) {
        int index = this.find(name, nth, start);
        if (index == -1) {
            throw this.newIndexException(name, nth, start);
        }
        return this.getArray(index);
    }

    IndexOutOfBoundsException newIndexException(String name, int nth, int start) {
        return new IndexOutOfBoundsException(Message.format((String)RB.getStringResource(RB_KEY, "noSuchItem.ex.txt"), (Object)name, (Object)new Integer(nth), (Object)new Integer(start)));
    }

    public final Object getArray(String name) {
        return this.getArray(name, 1, 0);
    }

    @Override
    public double getDouble(int index) {
        DoubleItem d = (DoubleItem)this.getItem(index);
        if (d.isMissing()) {
            return Double.NaN;
        }
        return d.getValue();
    }

    @Override
    public double getDouble(String name, int nth, int start) {
        int index = this.find(name, nth, start);
        if (index == -1) {
            throw this.newIndexException(name, nth, start);
        }
        return this.getDouble(index);
    }

    @Override
    public final double getDouble(String name) {
        return this.getDouble(name, 1, 0);
    }

    @Override
    public MissingValues getMissingValue(int index) {
        DoubleItem d = (DoubleItem)this.getItem(index);
        return d.getMissingValue();
    }

    @Override
    public MissingValues getMissingValue(String name, int nth, int start) {
        int index = this.find(name, nth, start);
        if (index == -1) {
            throw this.newIndexException(name, nth, start);
        }
        return this.getMissingValue(index);
    }

    @Override
    public final MissingValues getMissingValue(String name) {
        return this.getMissingValue(name, 1, 0);
    }

    @Override
    public HListInterface getList(int index) {
        return ((ListItem)this.getItem(index)).getValue();
    }

    @Override
    public HListInterface getList(String name, int nth, int start) {
        int index = this.find(name, nth, start);
        if (index == -1) {
            throw this.newIndexException(name, nth, start);
        }
        return this.getList(index);
    }

    @Override
    public final HListInterface getList(String name) {
        return this.getList(name, 1, 0);
    }

    @Override
    public Object getObject(int index) {
        return ((ObjectItem)this.getItem(index)).getValue();
    }

    @Override
    public Object getObject(String name, int nth, int start) {
        int index = this.find(name, nth, start);
        if (index == -1) {
            throw this.newIndexException(name, nth, start);
        }
        return this.getObject(index);
    }

    @Override
    public final Object getObject(String name) {
        return this.getObject(this.find(name, 1, 0));
    }

    @Override
    public synchronized HListItem getItem(String name, int nth, int start) {
        return this.getAt(name, nth, start);
    }

    public boolean itemExists(String name, int nth, int start) {
        return HList.itemExists(this, name, nth, start);
    }

    public static boolean itemExists(HListInterface list, String name, int nth, int start) {
        return list.find(name, nth, start) != -1;
    }

    @Override
    public synchronized int find(String name, int nth, int start) {
        int len = this.count();
        if (start < 0 || len > 0 && start >= len) {
            throw new IndexOutOfBoundsException(Message.format((String)RB.getStringResource(RB_KEY, "invalidIndex.ex.txt"), (Object)"start", (Object)new Integer(start)));
        }
        for (int i = start; i < len; ++i) {
            HListItem item = this.getItem(i);
            if (!this.sameName(item.getName(), name) || --nth != 0) continue;
            return i;
        }
        return -1;
    }

    private boolean sameName(String a, String b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equalsIgnoreCase(b);
    }

    protected static String intern(String string) {
        return Strings.intern((String)string);
    }

    @Override
    public synchronized void setItem(String name, int nth, int start, HListItem item) {
        int index = this.find(name, nth, start);
        item.setName(name);
        if (index == -1) {
            this.add(item);
        } else {
            this.setItem(index, item);
        }
    }

    @Override
    public synchronized void setItem(String name, int nth, int start, String string) {
        int index = this.find(name, nth, start);
        if (index >= 0) {
            this.setItem(index, string);
        } else {
            this.addItem(string, this.count(), name);
        }
    }

    @Override
    public synchronized void setItem(String name, int nth, int start, double value) {
        int index = this.find(name, nth, start);
        if (index >= 0) {
            this.setItem(index, value);
        } else {
            this.addItem(value, this.count(), name);
        }
    }

    @Override
    public synchronized void setItem(String name, int nth, int start, MissingValues missingValue) {
        int index = this.find(name, nth, start);
        if (index >= 0) {
            this.setItem(index, missingValue);
        } else {
            this.addItem(missingValue, this.count(), name);
        }
    }

    @Override
    public synchronized void setItem(String name, int nth, int start, HListInterface list) {
        int index = this.find(name, nth, start);
        if (index >= 0) {
            this.setItem(index, list);
        } else {
            this.addItem(list, this.count(), name);
        }
    }

    @Override
    public synchronized void setItem(String name, int nth, int start, Object object) {
        int index = this.find(name, nth, start);
        if (index >= 0) {
            this.setItem(index, object);
        } else {
            this.addItem(object, this.count(), name);
        }
    }

    @Override
    public final synchronized void setItem(String name, String string) {
        this.setItem(name, 1, 0, string);
    }

    @Override
    public final synchronized void setItem(String name, double value) {
        this.setItem(name, 1, 0, value);
    }

    @Override
    public final synchronized void setItem(String name, MissingValues missingValue) {
        this.setItem(name, 1, 0, missingValue);
    }

    @Override
    public final synchronized void setItem(String name, HListInterface list) {
        this.setItem(name, 1, 0, list);
    }

    @Override
    public final synchronized void setItem(String name, Object object) {
        this.setItem(name, 1, 0, object);
    }

    public final synchronized void setItem(String name, HListItem item) {
        this.setItem(name, 1, 0, item);
    }

    @Override
    public synchronized void setItem(int index, String string) {
        HListItem oldItem = this.getItem(index);
        if (oldItem instanceof StringItem) {
            ((StringItem)oldItem).setValue(string);
        } else {
            StringItem newItem = new StringItem(string, oldItem.getName(), oldItem.attributes);
            this.setItem(index, (HListItem)newItem);
        }
    }

    @Override
    public synchronized void setItem(int index, double value) {
        HListItem oldItem = this.getItem(index);
        if (Double.isNaN(value)) {
            this.setItem(index, MissingValues.Dot);
        } else if (oldItem instanceof DoubleItem) {
            ((DoubleItem)oldItem).setValue(value);
        } else {
            DoubleItem newItem = new DoubleItem(value, oldItem.getName(), oldItem.attributes);
            this.setItem(index, (HListItem)newItem);
        }
    }

    @Override
    public synchronized void setItem(int index, MissingValues missingValue) {
        HListItem oldItem = this.getItem(index);
        if (oldItem instanceof DoubleItem) {
            ((DoubleItem)oldItem).setValue(missingValue);
        } else {
            DoubleItem newItem = new DoubleItem(missingValue, oldItem.getName(), oldItem.attributes);
            this.setItem(index, (HListItem)newItem);
        }
    }

    @Override
    public synchronized void setItem(int index, HListInterface list) {
        HListItem oldItem = this.getItem(index);
        if (oldItem instanceof ListItem) {
            ((ListItem)oldItem).setValue(list);
        } else {
            ListItem newItem = new ListItem(list, oldItem.getName(), oldItem.attributes);
            this.setItem(index, (HListItem)newItem);
        }
    }

    @Override
    public synchronized void setItem(int index, Object object) {
        ObjectItem newItem = new ObjectItem(object, this.getItem(index).getName());
        this.setItem(index, (HListItem)newItem);
    }

    public synchronized HListItem getAt(String name, int nth, int start) {
        int index = this.find(name, nth, start);
        if (index == -1) {
            return null;
        }
        return this.getItem(index);
    }

    public HListItem getAt(String name) {
        return this.getAt(name, 1, 0);
    }

    @Override
    public synchronized Object removeAt(String name, int nth, int start) {
        int index = this.find(name, nth, start);
        if (index > -1) {
            return this.removeAt(index);
        }
        return null;
    }

    @Override
    public Object removeAt(String name) {
        return this.removeAt(name, 1, 0);
    }

    protected final boolean visited() {
        return (this.attributes & VISITED) == VISITED;
    }

    protected final synchronized void visit(Vector visitedLists) {
        this.attributes |= VISITED;
        if (visitedLists != null) {
            visitedLists.addElement(this);
        }
    }

    protected final void unvisit() {
        this.attributes &= ~VISITED;
    }

    protected static synchronized void unvisitAll(Vector visitedLists) {
        int length = visitedLists.size();
        for (int i = 0; i < length; ++i) {
            ((HList)visitedLists.elementAt(i)).unvisit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Object[] toObjectArray(HListInterface list) {
        HListInterface hListInterface = list;
        synchronized (hListInterface) {
            int len = list.count();
            Object[] array = new Object[len];
            for (int i = 0; i < len; ++i) {
                array[i] = list.getItem(i).toObject();
            }
            return array;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized HListItem[] toArray(HListInterface list) {
        HListInterface hListInterface = list;
        synchronized (hListInterface) {
            int len = list.count();
            HListItem[] array = new HListItem[len];
            for (int i = 0; i < len; ++i) {
                array[i] = list.getItem(i);
            }
            return array;
        }
    }

    public static synchronized String[] toStringArray(HListInterface list) {
        return HList.toStringArray(list, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized String[] toStringArray(HListInterface list, boolean includeNames) {
        HListInterface hListInterface = list;
        synchronized (hListInterface) {
            int len = list.count();
            String[] array = new String[len];
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < len; ++i) {
                buffer.setLength(0);
                HListItem item = list.getItem(i);
                String name = item.getName();
                Object object = item.toObject();
                if (includeNames && name != null) {
                    buffer.append(name);
                    buffer.append("=");
                }
                buffer.append(object == null ? "null" : object.toString());
                array[i] = buffer.toString();
            }
            return array;
        }
    }

    @Override
    public synchronized String toString() {
        return this.toString(null, 1, false);
    }

    protected String toString(Vector visitedLists) {
        return this.toString(null, 1, false);
    }

    protected String toString(String label, int indent, boolean quoteStrings) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(new OutputStreamWriter(baos));
        this.print(out, label, indent, quoteStrings);
        return baos.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof HListInterface) {
            return this.equals((HListInterface)object);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(HListInterface otherList) {
        if (this == otherList) {
            return true;
        }
        if (otherList == null) {
            return false;
        }
        int length = this.count();
        if (length != otherList.count()) {
            return false;
        }
        HListInterface hListInterface = otherList;
        synchronized (hListInterface) {
            for (int i = 0; i < length; ++i) {
                HListItem lhs = this.getItem(i);
                HListItem rhs = otherList.getItem(i);
                if (lhs == null && rhs == null) continue;
                if (lhs == null || rhs == null) {
                    return false;
                }
                if (lhs.equals(rhs)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public synchronized void print(PrintWriter out) {
        this.print(out, null, 1, false);
    }

    public synchronized void print(PrintWriter out, String label, int indent, boolean quoteStrings) {
        HList.print(out, this, label, indent, quoteStrings);
    }

    public static synchronized void print(PrintWriter out, HListInterface list, String label, int indent, boolean quoteStrings) {
        out = out == null ? new PrintWriter(System.out) : out;
        new Writer(out, label, indent, quoteStrings).print(list);
        out.flush();
    }

    protected void print(PrintWriter out, Vector visitedLists) {
        this.print(out, null, 0, false);
    }

    @Override
    public synchronized void setAttribute(HListAttributes attr, boolean state) {
        short attrValue = (short)attr.getValue();
        this.attributes = state ? (this.attributes |= attrValue) : (this.attributes &= ~attrValue);
    }

    @Override
    public synchronized void setAttribute(int index, HListAttributes attr, boolean state) {
        this.getItem(index).setAttribute(attr, state);
    }

    protected synchronized void setAttributes(int attrs, int mask) {
        this.attributes = this.attributes & ~mask | attrs & mask;
    }

    protected synchronized void setAttributes(int attrs, boolean state) {
        if (state) {
            this.attributes |= attrs;
        } else {
            attrs &= ~attrs;
        }
    }

    @Override
    public synchronized boolean hasAttribute(HListAttributes attr) {
        int attrValue = attr.getValue();
        return (this.attributes & attrValue) != 0;
    }

    @Override
    public synchronized boolean hasAttribute(int index, HListAttributes attr) {
        return this.getItem(index).hasAttribute(attr);
    }

    @Override
    public synchronized HListItem getItem(int index) {
        HListItem item = (HListItem)super.get(this.at(index));
        return item;
    }

    private final int at(int index) {
        return index >= 0 ? index : this.count() + index;
    }

    private final int insertIndex(int index) {
        return index >= 0 ? index : this.count() + index + 1;
    }

    @Override
    public synchronized String getName(int index) {
        HListItem item = this.getItem(index);
        return item.getName();
    }

    @Override
    public synchronized void setName(String name, int index) {
        HListItem item = this.getItem(index);
        item.setName(name);
    }

    @Override
    public synchronized void addItem(HListItem item) {
        this.addItem(item, this.count());
    }

    @Override
    public synchronized void addItem(HListItem item, int index) {
        if (item == null) {
            throw new IllegalArgumentException();
        }
        super.add(item, this.insertIndex(index));
    }

    @Override
    public synchronized void setItem(int index, HListItem item) {
        if (item == null) {
            throw new IllegalArgumentException();
        }
        super.set(this.at(index), item);
    }

    @Override
    public synchronized void reverse() {
        Permuter.reverse(this, 0, this.count());
    }

    @Override
    public synchronized void rotate(int n) {
        Permuter.rotate(this, 0, this.count(), n);
    }

    public static class Writer {
        String prefix;
        int indentation;
        int currentIndentation;
        boolean first;
        boolean quoteStrings;
        int depth;
        Vector visitedLists;
        PrintWriter out;
        String printLabel;
        boolean multiline = false;
        LongKeyDictionary d;

        Writer(PrintWriter out, String label, int indent, boolean quoteStrings) {
            this.out = out;
            this.indentation = indent;
            this.quoteStrings = quoteStrings;
            this.printLabel = label;
            this.multiline = this.printLabel != null;
            this.visitedLists = new Vector();
            this.d = new LongKeyDictionary();
        }

        void visit(HListInterface list) {
            this.d.set(this.key(list), (Object)list);
            this.visitedLists.addElement(list);
        }

        long key(HListInterface list) {
            return list.hashCode();
        }

        boolean visited(HListInterface list) {
            return this.d.containsKey(this.key(list));
        }

        void print(HListInterface list) {
            try {
                this.print(list, this.printLabel);
            }
            finally {
                HList.unvisitAll(this.visitedLists);
            }
        }

        void print(HListInterface list, String label) {
            if (list != null && this.visited(list)) {
                this.out.print("(...)[" + list.getId() + "]");
            } else {
                this.first = true;
                if (label == null) {
                    label = "";
                }
                int indent = label.length() + 1 + this.indentation;
                if (this.multiline) {
                    this.currentIndentation += indent;
                }
                --this.depth;
                this.visit(list);
                this.out.print(label);
                this.out.print("(");
                int length = list.count();
                for (int i = 0; i < length; ++i) {
                    HListItem item = list.getItem(i);
                    this.print(item);
                }
                this.indent(false);
                this.out.print(")");
                this.out.print("[" + list.getId() + "]");
                if (this.multiline) {
                    this.currentIndentation -= indent;
                }
                ++this.depth;
            }
        }

        void print(HListItem item) {
            this.indent(true);
            if (item instanceof ListItem) {
                HList sublist;
                String name = item.getName();
                if (name != null) {
                    name = name + "=";
                }
                if ((sublist = (HList)((ListItem)item).getValue()) != null) {
                    this.print(sublist, name);
                } else {
                    this.out.print(RB.getStringResource(HList.RB_KEY, "invalidListId.txt"));
                }
            } else if (this.quoteStrings && item instanceof StringItem) {
                StringItem stringItem = (StringItem)item;
                this.printName(stringItem);
                this.out.print(Strings.quote((String)stringItem.getValue()));
            } else {
                this.out.print(item.toString());
            }
        }

        void indent(boolean forItem) {
            if (this.indentation >= 0) {
                if (this.multiline) {
                    if (!this.first) {
                        this.out.println();
                        this.indent(this.currentIndentation + (forItem ? 0 : -1));
                    } else if (forItem) {
                        this.indent(this.indentation);
                    }
                } else if (!this.first) {
                    this.indent(this.indentation);
                }
            }
            this.first = false;
        }

        void indent(int count) {
            while (count-- > 0) {
                this.out.print(" ");
            }
        }

        String printName(HListItem item) {
            String name = item.getName();
            if (name != null) {
                this.out.print(name);
                this.out.print("=");
            }
            return name;
        }
    }
}

