/*
 * Decompiled with CFR 0.152.
 */
package com.sas.collection.hlist;

import com.sas.MissingValues;
import com.sas.collection.hlist.HListItem;
import com.sas.collection.hlist.StreamEnv;
import com.sas.lang.DoubleData;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class DoubleItem
extends HListItem {
    static final long serialVersionUID = 4800497325386489316L;
    protected transient double value;
    protected transient MissingValues miss;
    private static final int DOT = MissingValues.Dot.getValue();
    public static final char streamCode = 'D';
    public static final byte itemType = 1;

    public DoubleItem() {
        this.value = 0.0;
        this.miss = null;
    }

    public DoubleItem(DoubleItem item) {
        this.value = item.value;
        this.miss = item.miss;
    }

    public DoubleItem(double value) {
        this.setValue(value);
    }

    public DoubleItem(MissingValues value) {
        this.setValue(value);
    }

    public DoubleItem(double value, String name, short attributes) {
        super(name, attributes);
        this.setValue(value);
    }

    public DoubleItem(double value, String name) {
        super(name);
        this.setValue(value);
    }

    public DoubleItem(MissingValues value, String name, short attributes) {
        super(name, attributes);
        this.setValue(value);
    }

    public DoubleItem(MissingValues value, String name) {
        super(name);
        this.setValue(value);
    }

    public void setValue(double value) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            this.miss = MissingValues.Dot;
            this.value = value;
        } else {
            this.miss = null;
            this.value = value;
        }
    }

    public void setValue(MissingValues miss) {
        this.value = Double.NaN;
        this.miss = miss == null ? MissingValues.Dot : miss;
    }

    public double getValue() {
        return this.value;
    }

    public boolean isMissing() {
        return this.miss != null;
    }

    public MissingValues getMissingValue() {
        return this.miss;
    }

    public boolean equals(Object other) {
        if (other instanceof DoubleItem) {
            DoubleItem otherDouble = (DoubleItem)other;
            return this.miss != null || otherDouble.miss != null ? this.miss == otherDouble.miss : this.value == otherDouble.value;
        }
        return false;
    }

    @Override
    public String toString() {
        String result = super.toString();
        if (this.miss == null) {
            result = result + DoubleData.toString(this.value);
        } else if (this.miss != MissingValues.Dot) {
            result = result + this.miss.toString();
        }
        return result;
    }

    @Override
    public Object toObject() {
        if (this.miss == null) {
            return new Double(this.value);
        }
        return this.miss;
    }

    @Override
    public void read(DataInputStream stream) throws IOException {
        super.read(stream);
        this.readValue(stream);
    }

    @Override
    public void read(DataInputStream stream, StreamEnv env) throws IOException {
        super.read(stream, env);
        this.readValue(stream);
    }

    private void readValue(DataInputStream stream) throws IOException {
        this.miss = null;
        this.value = stream.readDouble();
        if (Double.isNaN(this.value) || Double.isInfinite(this.value)) {
            byte missing = stream.readByte();
            this.miss = missing == DOT ? MissingValues.Dot : MissingValues.getEnum((int)missing);
        }
    }

    @Override
    public void write(DataOutputStream stream) throws IOException {
        super.write(stream);
        stream.writeDouble(this.value);
        if (this.miss != null) {
            stream.writeByte((byte)this.miss.getValue());
        }
    }

    @Override
    public void write(DataOutputStream stream, StreamEnv env) throws IOException {
        super.write(stream, env);
        stream.writeDouble(this.value);
        if (this.miss != null) {
            stream.writeByte((byte)this.miss.getValue());
        }
    }

    @Override
    protected final char streamCode() {
        return 'D';
    }

    @Override
    protected final byte itemType() {
        return 1;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        if (this.miss != null) {
            stream.writeByte((byte)this.miss.getIndex());
        } else {
            stream.writeByte(127);
            stream.writeDouble(this.value);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException {
        try {
            stream.defaultReadObject();
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe.getMessage());
        }
        byte missing = stream.readByte();
        if (missing != 127) {
            this.miss = MissingValues.getEnum((int)missing);
            this.value = Double.NaN;
        } else {
            this.value = stream.readDouble();
        }
    }
}

