/*
 * Decompiled with CFR 0.152.
 */
package com.sas.collection.hlist;

import com.sas.GlobalInfoTable;
import com.sas.MissingValues;
import com.sas.collection.hlist.HList;
import com.sas.collection.hlist.HListInterface;
import com.sas.collection.hlist.HListItem;
import com.sas.collection.hlist.RB;
import com.sas.collection.hlist.StreamEnv;
import com.sas.text.Message;
import com.sas.util.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;

public class ArrayItem
extends HListItem {
    public static final String RB_KEY = "ArrayItem.";
    static final long serialVersionUID = 3036331836519439149L;
    protected Object array;
    public static final char streamCode = 'A';
    public static final byte itemType = 5;
    static final int UNKNOWN = 0;
    static final int BOOLEAN = 10;
    static final int BYTE = 11;
    static final int CHARACTER = 12;
    static final int SHORT = 13;
    static final int INT = 14;
    static final int LONG = 15;
    static final int FLOAT = 16;
    static final int DOUBLE = 17;
    static final int STRING = 18;
    static final int LIST = 19;
    static final int NULL = 127;
    static Class HListInterfaceClass = GlobalInfoTable._loadClass((String)"com.sas.collection.hlist.HListInterface");

    public ArrayItem() {
    }

    public ArrayItem(ArrayItem item) {
        this.array = item.array;
    }

    public ArrayItem(Object array) {
        this.array = array;
    }

    public ArrayItem(Object array, String name) {
        super(name);
        this.array = array;
    }

    public ArrayItem(Object array, String name, short attributes) {
        super(name, attributes);
        this.array = array;
    }

    public Object getValue() {
        return this.array;
    }

    public void setValue(Object object) {
        this.array = object;
    }

    public boolean equals(Object other) {
        if (other instanceof ArrayItem) {
            ArrayItem otherObject = (ArrayItem)other;
            return Util.arrayEqual((Object)this.getValue(), (Object)otherObject.getValue());
        }
        return false;
    }

    @Override
    protected final char streamCode() {
        return 'A';
    }

    @Override
    protected final byte itemType() {
        return 5;
    }

    @Override
    public final Object toObject() {
        return this.getValue();
    }

    @Override
    public String toString() {
        ToStringVisitor visitor = new ToStringVisitor(super.toString());
        visitor.visit(this.getValue());
        return visitor.toString();
    }

    @Override
    public void write(DataOutputStream stream, StreamEnv env) throws IOException {
        super.write(stream, env);
        WriteVisitor visitor = new WriteVisitor(this.getValue(), stream, env);
        visitor.visit(this.getValue());
    }

    @Override
    public void read(DataInputStream stream, StreamEnv env) throws IOException {
        super.read(stream, env);
        int nDims = stream.readByte();
        byte eltType = stream.readByte();
        for (int d = nDims; d > 0; --d) {
            int n = stream.readInt();
        }
        Class elementType = this.elementType(eltType);
        Class[] types = this.types(nDims, elementType);
        this.setValue(this.readArray(nDims, types, elementType, eltType, stream, env));
    }

    Class[] types(int nDims, Class elementType) {
        Class[] types = new Class[nDims];
        if (nDims > 0) {
            types[0] = elementType;
            for (int d = 1; d < nDims; ++d) {
                Object array = Array.newInstance(types[d - 1], 0);
                types[d] = array.getClass();
            }
        }
        return types;
    }

    static String typeName(Class c) {
        if (c.isArray()) {
            return ArrayItem.typeName(c.getComponentType()) + "[]";
        }
        return c.getName();
    }

    Class elementType(int eltType) {
        if (eltType == 10) {
            return Boolean.TYPE;
        }
        if (eltType == 11) {
            return Byte.TYPE;
        }
        if (eltType == 12) {
            return Character.TYPE;
        }
        if (eltType == 13) {
            return Short.TYPE;
        }
        if (eltType == 14) {
            return Integer.TYPE;
        }
        if (eltType == 15) {
            return Long.TYPE;
        }
        if (eltType == 16) {
            return Float.TYPE;
        }
        if (eltType == 17) {
            return Double.TYPE;
        }
        if (eltType == 18) {
            return String.class;
        }
        if (eltType == 19) {
            return HListInterfaceClass;
        }
        if (eltType == 127) {
            return Void.TYPE;
        }
        return null;
    }

    Object readArray(int nDims, Class[] types, Class elementType, int eltType, DataInputStream stream, StreamEnv env) throws IOException {
        int len = 0;
        if (nDims == 0) {
            return null;
        }
        len = stream.readInt();
        Object[] array = Array.newInstance(types[nDims - 1], len);
        if (nDims == 1) {
            switch (eltType) {
                case 0: {
                    break;
                }
                case 10: {
                    boolean[] items = ArrayItem.readBooleanArray(stream, len);
                    array = items;
                    break;
                }
                case 11: {
                    byte[] items = new byte[len];
                    for (int i = 0; i < len; ++i) {
                        items[i] = stream.readByte();
                    }
                    array = items;
                    break;
                }
                case 12: {
                    byte[] bytes = new byte[len];
                    for (int i = 0; i < len; ++i) {
                        bytes[i] = stream.readByte();
                    }
                    char[] items = env.encoder.toCharArray(bytes, 0, len);
                    array = items;
                    break;
                }
                case 13: {
                    short[] items = new short[len];
                    for (int i = 0; i < len; ++i) {
                        items[i] = stream.readShort();
                    }
                    array = items;
                    break;
                }
                case 14: {
                    int[] items = new int[len];
                    for (int i = 0; i < len; ++i) {
                        items[i] = stream.readInt();
                    }
                    array = items;
                    break;
                }
                case 15: {
                    long[] items = new long[len];
                    for (int i = 0; i < len; ++i) {
                        items[i] = stream.readLong();
                    }
                    array = items;
                    break;
                }
                case 16: {
                    float[] items = new float[len];
                    for (int i = 0; i < len; ++i) {
                        float f;
                        items[i] = f = stream.readFloat();
                        if (!Float.isNaN(f)) continue;
                        stream.readByte();
                    }
                    array = items;
                    break;
                }
                case 17: {
                    double[] items = new double[len];
                    for (int i = 0; i < len; ++i) {
                        double dbl;
                        items[i] = dbl = stream.readDouble();
                        if (!Double.isNaN(dbl)) continue;
                        stream.readByte();
                    }
                    array = items;
                    break;
                }
                case 18: {
                    String[] items = new String[len];
                    for (int i = 0; i < len; ++i) {
                        items[i] = env.readString(stream);
                    }
                    array = items;
                    break;
                }
                case 19: {
                    HListInterface[] items = new HListInterface[len];
                    for (int i = 0; i < len; ++i) {
                        items[i] = new HList(stream, env);
                    }
                    array = items;
                    break;
                }
            }
        } else {
            for (int i = 0; i < len; ++i) {
                Array.set(array, i, this.readArray(nDims - 1, types, elementType, eltType, stream, env));
            }
        }
        return array;
    }

    static boolean[] readBooleanArray(InputStream stream, int len) throws IOException {
        boolean[] array = new boolean[len];
        int b = 0;
        for (int i = 0; i < len; ++i) {
            if (i % 8 == 0) {
                b = stream.read();
            }
            array[i] = (b & 1) == 1;
            b >>= 1;
        }
        return array;
    }

    static void writeBooleanArray(OutputStream stream, boolean[] array) throws IOException {
        int len = array.length;
        int b = 0;
        int mask = 1;
        for (int i = 0; i < len; ++i) {
            if (array[i]) {
                b |= mask;
            }
            mask <<= 1;
            if (i % 8 != 7) continue;
            stream.write(b);
            b = 0;
            mask = 1;
        }
        if (len > 0 && (len - 1) % 8 != 7) {
            stream.write((byte)(b & 0xFF));
        }
    }

    static class ToStringVisitor {
        StringBuffer buffer = new StringBuffer();

        public ToStringVisitor(String initial) {
            this.buffer.append(initial);
        }

        public void visit(Object array) {
            int length = Array.getLength(array);
            this.buffer.append("{");
            for (int i = 0; i < length; ++i) {
                Object element = Array.get(array, i);
                if (element.getClass().isArray()) {
                    this.visit(element);
                    continue;
                }
                this.buffer.append(element.toString());
                if (i >= length - 1) continue;
                this.buffer.append(".");
            }
        }

        public String toString() {
            return this.buffer.toString();
        }
    }

    static class WriteVisitor {
        DataOutputStream stream;
        int eltType;
        int depth;
        StreamEnv env;

        public WriteVisitor(Object array, DataOutputStream stream, StreamEnv env) throws IOException {
            this.stream = stream;
            this.env = env;
            this.eltType = WriteVisitor.baseType(array);
            if (this.eltType == 0) {
                throw new IOException(Message.format((String)RB.getStringResource(ArrayItem.RB_KEY, "cannotWriteArrayType.ex.txt"), (Object)ArrayItem.typeName(array.getClass())));
            }
            this.depth = WriteVisitor.depth(array);
            stream.write(this.depth);
            stream.write(this.eltType);
            this.writeMaxDims(array);
        }

        public void visit(Object array) throws IOException {
            this.visit(array, this.depth);
        }

        public void visit(Object array, int d) throws IOException {
            if (array == null) {
                return;
            }
            int length = Array.getLength(array);
            this.stream.writeInt(length);
            if (d > 1) {
                for (int i = 0; i < length; ++i) {
                    Object element = Array.get(array, i);
                    if (!element.getClass().isArray()) continue;
                    this.visit(element, d - 1);
                }
            } else {
                switch (this.eltType) {
                    case 0: {
                        break;
                    }
                    case 127: {
                        break;
                    }
                    case 10: {
                        boolean[] items = (boolean[])array;
                        ArrayItem.writeBooleanArray(this.stream, items);
                        break;
                    }
                    case 11: {
                        byte[] items = (byte[])array;
                        int len = items.length;
                        for (int i = 0; i < len; ++i) {
                            this.stream.writeByte(items[i]);
                        }
                        break;
                    }
                    case 12: {
                        char[] items = (char[])array;
                        byte[] bytes = this.env.encoder.toByteArray(items, 0, items.length);
                        int len = bytes.length;
                        for (int i = 0; i < len; ++i) {
                            this.stream.writeByte(bytes[i]);
                        }
                        break;
                    }
                    case 13: {
                        short[] items = (short[])array;
                        int len = items.length;
                        for (int i = 0; i < len; ++i) {
                            this.stream.writeShort(items[i]);
                        }
                        break;
                    }
                    case 14: {
                        int[] items = (int[])array;
                        int len = items.length;
                        for (int i = 0; i < len; ++i) {
                            this.stream.writeInt(items[i]);
                        }
                        break;
                    }
                    case 15: {
                        long[] items = (long[])array;
                        int len = items.length;
                        for (int i = 0; i < len; ++i) {
                            this.stream.writeLong(items[i]);
                        }
                        break;
                    }
                    case 16: {
                        for (float f : (float[])array) {
                            this.stream.writeFloat(f);
                            if (!Float.isNaN(f)) continue;
                            this.stream.writeByte(MissingValues.Dot.getValue());
                        }
                        break;
                    }
                    case 17: {
                        for (double dbl : (double[])array) {
                            this.stream.writeDouble(dbl);
                            if (!Double.isNaN(dbl)) continue;
                            this.stream.writeByte(MissingValues.Dot.getValue());
                        }
                        break;
                    }
                    case 18: {
                        String[] items = (String[])array;
                        int len = items.length;
                        for (int i = 0; i < len; ++i) {
                            this.env.writeString(items[i], this.stream);
                        }
                        break;
                    }
                    case 19: {
                        HListInterface[] items = (HListInterface[])array;
                        int len = items.length;
                        for (int i = 0; i < len; ++i) {
                            ((HList)items[i]).write(this.stream, this.env);
                        }
                        break;
                    }
                }
            }
        }

        void writeMaxDims(Object array) throws IOException {
            int[] maxDims = WriteVisitor.maxDims(array);
            int len = maxDims.length - 1;
            for (int i = 0; i <= len; ++i) {
                this.stream.writeInt(maxDims[i]);
            }
        }

        static int[] maxDims(Object array) {
            int depth = WriteVisitor.depth(array);
            int[] maxDims = new int[depth];
            WriteVisitor.maxDims(array, maxDims, 0);
            return maxDims;
        }

        static void maxDims(Object array, int[] maxDims, int dimension) {
            if (array == null) {
                return;
            }
            int len = Array.getLength(array);
            maxDims[dimension] = Math.max(maxDims[dimension], len);
            if (dimension < maxDims.length - 1) {
                for (int i = 0; i < len; ++i) {
                    Object subarray = Array.get(array, i);
                    WriteVisitor.maxDims(subarray, maxDims, dimension + 1);
                }
            }
        }

        static int baseType(Object array) {
            if (array == null) {
                return 127;
            }
            Class<?> arrayClass = array.getClass();
            return WriteVisitor.baseType(arrayClass);
        }

        static int baseType(Class arrayClass) {
            if (arrayClass.isArray()) {
                return WriteVisitor.baseType(arrayClass.getComponentType());
            }
            if (arrayClass == Void.TYPE) {
                return 127;
            }
            if (arrayClass == Boolean.TYPE) {
                return 10;
            }
            if (arrayClass == Byte.TYPE) {
                return 11;
            }
            if (arrayClass == Character.TYPE) {
                return 12;
            }
            if (arrayClass == Short.TYPE) {
                return 13;
            }
            if (arrayClass == Integer.TYPE) {
                return 14;
            }
            if (arrayClass == Long.TYPE) {
                return 15;
            }
            if (arrayClass == Float.TYPE) {
                return 16;
            }
            if (arrayClass == Double.TYPE) {
                return 17;
            }
            if (arrayClass == String.class) {
                return 18;
            }
            if (arrayClass.getName().equals("com.sas.collection.hlist.HListInterface")) {
                return 19;
            }
            if (arrayClass.getName().equals("com.sas.collection.hlist.HList")) {
                return 19;
            }
            return 0;
        }

        static int depth(Object array) {
            if (array == null) {
                return 0;
            }
            return WriteVisitor.depth(array.getClass());
        }

        static int depth(Class arrayClass) {
            if (!arrayClass.isArray()) {
                return 0;
            }
            return 1 + WriteVisitor.depth(arrayClass.getComponentType());
        }
    }
}

