/*
 * Decompiled with CFR 0.152.
 */
package com.sas.collection;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.BaseCollection;
import com.sas.collection.CollectionChangedInfo;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.OrderedCollection;
import com.sas.collection.OrderedCollectionEnumeration;
import com.sas.collection.RB;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.collection.StaticStringListInterface;
import com.sas.collection.StringCollectionInterface;
import com.sas.util.ApplyInterface;
import com.sas.util.Comparator;
import com.sas.util.StringComparator;
import com.sas.util.Util;
import com.sas.util.transforms.StringListInterfaceToStringTransform;
import com.sas.util.transforms.StringToStringListInterfaceTransform;
import com.sas.util.transforms.TransformException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;

public class StringCollection
extends BaseCollection
implements StringCollectionInterface,
ContentsChangedListener {
    public static final String RB_KEY = "StringCollection.";
    static final long serialVersionUID = 656535327677201561L;
    protected OrderedCollection collection;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "size"}, {"Hidden", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.shortDescription = "ordered collection of Strings";
        ebi.propertyMetadata = propertyMetadata;
        ebi.shortDescription = RB.getStringResource((String)RB_KEY, (String)"description.txt");
        return ebi;
    }

    public StringCollection() {
        this.collection = new OrderedCollection();
        this.init();
    }

    public StringCollection(String source) {
        this(source, ',');
    }

    public StringCollection(String source, char separator) {
        this();
        try {
            StringToStringListInterfaceTransform.transform(this, source, separator);
        }
        catch (TransformException te) {
            throw new IllegalArgumentException(te.getMessage());
        }
    }

    public StringCollection(int initialCapacity) {
        this.collection = new OrderedCollection(initialCapacity);
        this.init();
    }

    public StringCollection(StaticStringListInterface strings) {
        this.collection = new OrderedCollection(strings.count(), 10);
        this.addItems(strings);
        this.init();
    }

    public StringCollection(String[] strings) {
        int n = strings.length;
        this.collection = new OrderedCollection(n);
        for (int i = 0; i < n; ++i) {
            this.collection.add(strings[i]);
        }
        this.init();
    }

    private void init() {
        this.collection.addContentsChangedListener(this);
    }

    @Override
    public void add(String item, int index) {
        this.collection.add(item, index);
    }

    public synchronized void append(int index, Object item) {
        this.append(index, (String)item);
    }

    public synchronized void append(int index, String string) {
        if (index >= this.count()) {
            this.setSize(index + 1);
        }
        this.set(index, string);
    }

    public void contentsChanged(ContentsChangedEvent event) {
        if (event.getSource() != this.collection || !this.anyContentsChangedListeners()) {
            return;
        }
        if (event instanceof CollectionChangedInfo) {
            CollectionChangedInfo ccInfo = (CollectionChangedInfo)event;
            this.fireContentsChanged(new CollectionChangedInfo(this, ccInfo.whatChanged, ccInfo.howChanged, ccInfo.start, ccInfo.end));
        } else {
            this.fireContentsChanged(new ContentsChangedEvent((Object)this));
        }
    }

    @Override
    public synchronized void add(String item) {
        this.collection.add(item);
    }

    @Override
    public synchronized void addItems(StaticStringListInterface items) {
        try {
            this.disableEvents();
            Enumeration enumer = items.getItems();
            while (enumer.hasMoreElements()) {
                this.add(enumer.nextElement());
            }
        }
        finally {
            this.enableEvents();
        }
    }

    @Override
    public synchronized void addItems(Enumeration items) {
        this.addItems(items, this.collection.count());
    }

    @Override
    public synchronized void addItems(Enumeration items, int index) {
        if (!items.hasMoreElements()) {
            return;
        }
        try {
            this.disableEvents();
            while (items.hasMoreElements()) {
                this.add((String)items.nextElement(), index++);
            }
        }
        finally {
            this.enableEvents();
        }
    }

    @Override
    public synchronized void add(Object item) {
        this.collection.add((String)item);
    }

    @Override
    public synchronized void add(Object item, int index) {
        this.collection.add((String)item, index);
    }

    @Override
    public synchronized void apply(ApplyInterface action) {
        for (int index = 0; index < this.collection.count(); ++index) {
            action.apply(this.collection.get(index));
        }
    }

    @Override
    public synchronized void removeAll() {
        this.collection.removeAll();
    }

    @Override
    public synchronized boolean contains(Object element) {
        return this.collection.contains(element);
    }

    @Override
    public synchronized int count() {
        return this.collection.count();
    }

    @Override
    public boolean equals(StaticStringListInterface list) {
        if (this.count() != list.count()) {
            return false;
        }
        for (int index = 0; index < this.count(); ++index) {
            if (!Util.unequal((Object)this.getString(index), (Object)list.getString(index))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(StaticOrderedCollectionInterface orderedCollection) {
        if (this.count() != orderedCollection.count()) {
            return false;
        }
        Enumeration items = this.getItems();
        Enumeration otherItems = orderedCollection.getItems();
        return Util.equal((Enumeration)items, (Enumeration)otherItems);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof StaticStringListInterface) {
            return this.equals((StaticStringListInterface)obj);
        }
        if (obj != null && obj instanceof StaticOrderedCollectionInterface) {
            return this.equals((StaticOrderedCollectionInterface)obj);
        }
        return super.equals(obj);
    }

    @Override
    public synchronized Object get(int index) {
        return this.getString(index);
    }

    @Override
    public synchronized int getIndex(String item, int startIndex) {
        return this.getIndex((Object)item, startIndex);
    }

    @Override
    public synchronized int getIndex(Object element, int startIndex) {
        int position = this.collection.getIndex(element, startIndex);
        if (position < 0) {
            return -1;
        }
        return position;
    }

    @Override
    public synchronized StaticStringListInterface getStringItems(int start, int end) {
        StringCollection stringCollection = new StringCollection();
        stringCollection.addItems(this.getItems(start, end));
        return stringCollection;
    }

    @Override
    public synchronized String[] getStringItems() {
        int n = this.count();
        String[] array = new String[n];
        for (int i = n - 1; i >= 0; --i) {
            array[i] = this.getString(i);
        }
        return array;
    }

    public final String[] toStringArray() {
        return this.getStringItems();
    }

    @Override
    public synchronized Enumeration getItems() {
        return this.collection.getItems();
    }

    @Override
    public synchronized Enumeration getItems(int start, int end) {
        return new OrderedCollectionEnumeration(this, start, end);
    }

    @Override
    public synchronized int getLastIndex(String string, int startIndex) {
        return this.getLastIndex((Object)string, startIndex);
    }

    @Override
    public synchronized int getLastIndex(Object element, int startIndex) {
        return this.collection.getLastIndex(element, startIndex);
    }

    @Override
    public synchronized String getString(int index) {
        return (String)this.collection.get(index);
    }

    @Override
    public synchronized boolean remove(Object string) {
        return this.collection.remove(string);
    }

    @Override
    public synchronized int removeAll(Object element) {
        return this.collection.removeAll(element);
    }

    @Override
    public synchronized void removeAt(int start, int n) {
        int count = this.collection.count();
        int end = start + n - 1;
        if (start < 0 || start > count - 1 || end < 0 || end > count - 1) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = start; i <= end; ++i) {
            this.collection.removeAt(start);
        }
    }

    @Override
    public synchronized Object removeAt(int index) {
        Object returnValue = this.collection.get(index);
        this.collection.removeAt(index);
        return returnValue;
    }

    @Override
    public synchronized String removeStringAt(int index) {
        String str = (String)this.collection.get(index);
        this.collection.removeAt(index);
        return str;
    }

    @Override
    public synchronized void set(int index, Object item) {
        this.setString(index, (String)item);
    }

    @Override
    public void setString(int index, String item) {
        this.collection.set(index, item);
    }

    @Override
    public synchronized void setSize(int newSize) {
        this.collection.setSize(newSize);
    }

    @Override
    public synchronized void sort(Comparator comparator, int start, int end) {
        this.collection.sort(comparator, start, end);
    }

    @Override
    public synchronized void sort(Comparator comparator) {
        this.sort(comparator, 0, this.count());
    }

    @Override
    public synchronized void sort(boolean ascending) {
        this.sort(new StringComparator(ascending));
    }

    @Override
    public synchronized void sort(boolean ascending, int start, int end) {
        this.sort(new StringComparator(ascending), start, end);
    }

    public String toString() {
        return (String)StringListInterfaceToStringTransform.defaultInstance.transform(this);
    }

    public synchronized String toString(char delimiter, boolean alwaysQuote) {
        if (delimiter == ',' && alwaysQuote) {
            return (String)StringListInterfaceToStringTransform.defaultInstance.transform(this);
        }
        return (String)new StringListInterfaceToStringTransform(delimiter, alwaysQuote).transform(this);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.init();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        StringCollection sc = (StringCollection)super.clone();
        sc.collection = (OrderedCollection)this.collection.clone();
        sc.init();
        return sc;
    }
}

