/*
 * Decompiled with CFR 0.152.
 */
package com.sas.collection;

import com.sas.Component;
import com.sas.DeepClonable;
import com.sas.DeepCloneSupport;
import com.sas.beans.Util;
import com.sas.collection.Dictionary;
import com.sas.collection.DictionaryInterface;
import com.sas.collection.HowChanged;
import com.sas.collection.PropertyBagChangedEvent;
import com.sas.collection.PropertyBagChangedListener;
import com.sas.collection.PropertyBagChangedListenerList;
import com.sas.collection.PropertyBagChangedSource;
import com.sas.collection.PropertyBagInterface;
import com.sas.collection.StaticPropertyBagInterface;
import com.sas.lang.ObjectData;
import com.sas.util.Strings;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;

public class PropertyBag
implements PropertyBagInterface,
PropertyBagChangedListener,
Serializable,
ObjectInputValidation,
PropertyChangeListener,
DeepClonable {
    static final long serialVersionUID = -7610893931152064811L;
    public static final Object NO_SUCH_ELEMENT = new ObjectData("NO_SUCH_ELEMENT");
    protected String[] keys;
    protected Object[] values;
    protected int numProperties;
    protected transient PropertyBagChangedListenerList allPropertyBagChangedListeners;
    protected int pendingEventGateCount = 0;
    protected StaticPropertyBagInterface defaults;
    private transient String[] keyList;

    public PropertyBag() {
        this.init();
    }

    public PropertyBag(StaticPropertyBagInterface defaults) {
        this.init();
        this.setDefaults(defaults);
    }

    private void init() {
        this.keys = new String[8];
        this.values = new Object[8];
    }

    public void setDefaults(StaticPropertyBagInterface defaults) {
        this.defaults = defaults;
    }

    public StaticPropertyBagInterface getDefaults() {
        return this.defaults;
    }

    @Override
    public void set(String key, Object property) {
        this.set(key, property, false);
    }

    public synchronized void set(String key, Object property, boolean aggressive) {
        int index = this.propertyIndex(key);
        Object oldValue = null;
        if (index > -1) {
            if (this.values[index] != property) {
                oldValue = this.values[index];
                this.values[index] = property;
                this.swapSources(oldValue, property, aggressive);
                this.firePropertyBagChanged(key, oldValue, property, HowChanged.REPLACED);
            }
        } else {
            if (this.numProperties == this.values.length) {
                this.growPropertyBag();
            }
            index = this.numProperties++;
            this.values[index] = property;
            this.invalidateKeyList();
            this.keys[index] = key;
            this.swapSources(null, property, aggressive);
            this.firePropertyBagChanged(key, null, property, HowChanged.ADDED);
        }
    }

    protected final void invalidateKeyList() {
        this.keyList = null;
    }

    protected void swapSources(Object oldProperty, Object newProperty, boolean aggressive) {
        if (oldProperty != null) {
            if (oldProperty instanceof PropertyBagChangedSource) {
                ((PropertyBagChangedSource)oldProperty).removePropertyBagChangedListener(this);
            } else if (aggressive) {
                Util.removePropertyChangeListener((Object)oldProperty, (PropertyChangeListener)this);
            }
        }
        if (newProperty != null) {
            if (newProperty instanceof PropertyBagChangedSource) {
                ((PropertyBagChangedSource)newProperty).addPropertyBagChangedListener(this);
            } else if (aggressive) {
                Util.addPropertyChangeListener((Object)newProperty, (PropertyChangeListener)this);
            }
        }
    }

    protected void growPropertyBag() {
        int newSize = 4 + 5 * this.numProperties / 4;
        this.resize(newSize);
    }

    protected synchronized void resize(int newSize) {
        String[] newKeys = new String[newSize];
        System.arraycopy(this.keys, 0, newKeys, 0, this.numProperties);
        this.keys = newKeys;
        Object[] newValues = new Object[newSize];
        System.arraycopy(this.values, 0, newValues, 0, this.numProperties);
        this.values = newValues;
    }

    protected synchronized int propertyIndex(String key) {
        String[] keyArray = this.keys;
        int n = this.numProperties;
        for (int i = 0; i < n; ++i) {
            if (keyArray[i] != key) continue;
            if (i != 0) {
                Object[] valueArray = this.values;
                String k = keyArray[0];
                Object v = valueArray[0];
                keyArray[0] = key;
                valueArray[0] = valueArray[i];
                keyArray[i] = k;
                valueArray[i] = v;
            }
            return 0;
        }
        return -1;
    }

    protected synchronized void swap(int i, int j) {
        String k = this.keys[j];
        Object v = this.values[j];
        this.keys[j] = this.keys[i];
        this.values[j] = this.values[i];
        this.keys[i] = k;
        this.values[i] = v;
    }

    @Override
    public boolean containsKey(String key) {
        if (this.propertyIndex(key) != -1) {
            return true;
        }
        if (this.getDefaults() != null) {
            return this.getDefaults().containsKey(key);
        }
        return false;
    }

    @Override
    public void remove(String key) {
        this.remove(key, false);
    }

    public synchronized void remove(String key, boolean aggressive) {
        try {
            int index = this.propertyIndex(key);
            Object oldProperty = this.values[index];
            int i = this.numProperties - 1;
            this.invalidateKeyList();
            this.values[index] = this.values[i];
            this.keys[index] = this.keys[i];
            this.values[i] = null;
            this.keys[i] = null;
            this.swapSources(oldProperty, null, aggressive);
            --this.numProperties;
            this.firePropertyBagChanged(key, oldProperty, null, HowChanged.REMOVED);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NoSuchElementException(key);
        }
    }

    @Override
    public synchronized void removeAll() {
        if (this.numProperties == 0) {
            return;
        }
        this.invalidateKeyList();
        while (--this.numProperties >= 0) {
            this.keys[this.numProperties] = null;
            this.values[this.numProperties] = null;
        }
        this.numProperties = 0;
        this.firePropertyBagChanged(null, null, null, HowChanged.REMOVED);
    }

    @Override
    public synchronized Object get(String key) {
        int index = this.propertyIndex(key);
        if (index == -1) {
            if (this.getDefaults() != null) {
                return this.getDefaults().get(key);
            }
            throw new NoSuchElementException(key);
        }
        return this.values[index];
    }

    @Override
    public synchronized Object get(String key, Object defaultValue) {
        int index = this.propertyIndex(key);
        if (index == -1) {
            if (this.getDefaults() != null) {
                return this.getDefaults().get(key, defaultValue);
            }
            return defaultValue;
        }
        return this.values[index];
    }

    @Override
    public DictionaryInterface toDictionary(DictionaryInterface initialDictionary) {
        DictionaryInterface dictionary = initialDictionary == null ? new Dictionary() : initialDictionary;
        for (int i = 0; i < this.numProperties; ++i) {
            dictionary.set(this.keys[i], this.values[i]);
        }
        return dictionary;
    }

    @Override
    public synchronized String[] listKeys() {
        if (this.keyList == null) {
            this.keyList = new String[this.numProperties];
            System.arraycopy(this.keys, 0, this.keyList, 0, this.numProperties);
        }
        return this.keyList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(StaticPropertyBagInterface other) {
        try {
            this.disableEvents();
            if (other instanceof PropertyBag) {
                PropertyBag otherBag = (PropertyBag)other;
                int n = otherBag.numProperties;
                for (int i = 0; i < n; ++i) {
                    this.set(otherBag.keys[i], otherBag.values[i]);
                }
            } else {
                for (String key : other.listKeys()) {
                    this.set(key, other.get(key));
                }
            }
        }
        finally {
            this.enableEvents(HowChanged.OTHER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(StaticPropertyBagInterface other) {
        if (this == other) {
            return;
        }
        try {
            this.disableEvents();
            if (other instanceof PropertyBag) {
                PropertyBag otherBag = (PropertyBag)other;
                String[] keyList = otherBag.keys;
                int n = otherBag.numProperties;
                for (int i = 0; i < n; ++i) {
                    this.merge(keyList[i], otherBag.values[i]);
                }
            } else {
                for (String key : other.listKeys()) {
                    this.merge(key, other.get(key));
                }
            }
        }
        finally {
            this.enableEvents(HowChanged.OTHER);
        }
    }

    public void merge(String key, Object otherValue) {
        Object thisValue = this.get(key, NO_SUCH_ELEMENT);
        if (thisValue == NO_SUCH_ELEMENT) {
            this.set(key, otherValue);
        } else if (thisValue instanceof PropertyBagInterface && otherValue instanceof StaticPropertyBagInterface) {
            ((PropertyBagInterface)thisValue).merge((StaticPropertyBagInterface)otherValue);
        }
    }

    @Override
    public int count() {
        return this.numProperties;
    }

    protected boolean anyListeners() {
        return this.allPropertyBagChangedListeners != null && this.allPropertyBagChangedListeners.count() > 0;
    }

    protected final boolean firingEvents() {
        return this.anyListeners() && this.eventsEnabled();
    }

    public void firePropertyBagChanged(String propertyName, Object oldValue, Object newValue, HowChanged howChanged) {
        if (!this.firingEvents()) {
            return;
        }
        PropertyBagChangedEvent propertyBagChangedEvent = new PropertyBagChangedEvent(this, propertyName, oldValue, newValue, howChanged);
        this.firePropertyBagChanged(propertyBagChangedEvent);
    }

    @Override
    public void addPropertyBagChangedListener(PropertyBagChangedListener listener) {
        if (this.allPropertyBagChangedListeners == null) {
            this.allPropertyBagChangedListeners = new PropertyBagChangedListenerList();
        }
        this.allPropertyBagChangedListeners.add(listener);
    }

    @Override
    public void removePropertyBagChangedListener(PropertyBagChangedListener listener) {
        if (this.allPropertyBagChangedListeners != null) {
            this.allPropertyBagChangedListeners.remove(listener);
        }
    }

    public void firePropertyBagChanged(PropertyBagChangedEvent propertyBagChangedEvent) {
        if (!this.firingEvents()) {
            return;
        }
        for (PropertyBagChangedListener listener : this.allPropertyBagChangedListeners.getListeners()) {
            listener.propertyBagChanged(propertyBagChangedEvent);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Object source = event.getSource();
        this.notifyListeners(source);
    }

    @Override
    public void propertyBagChanged(PropertyBagChangedEvent event) {
        Object source = event.getSource();
        this.notifyListeners(source);
    }

    protected void notifyListeners(Object source) {
        int n = this.values.length;
        for (int i = 0; i < n; ++i) {
            if (this.values[i] != source) continue;
            this.firePropertyBagChanged(this.keys[i], null, source, HowChanged.OTHER);
            return;
        }
    }

    public void disableEvents() {
        ++this.pendingEventGateCount;
    }

    public synchronized void enableEvents(HowChanged howChanged) {
        if (this.pendingEventGateCount > 0) {
            --this.pendingEventGateCount;
            if (this.pendingEventGateCount == 0) {
                this.firePropertyBagChanged(null, null, null, howChanged);
            }
        }
    }

    protected boolean eventsEnabled() {
        return this.pendingEventGateCount == 0;
    }

    public synchronized boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof PropertyBag && this.equals((PropertyBag)o);
    }

    public synchronized boolean equals(PropertyBag bag) {
        if (this == bag) {
            return true;
        }
        if (bag == null || bag.count() != this.count()) {
            return false;
        }
        for (int i = 0; i < this.count(); ++i) {
            Object thisValue = this.values[i];
            String thisKey = this.keys[i];
            Object otherValue = bag.get(thisKey, NO_SUCH_ELEMENT);
            if (!com.sas.util.Util.unequal((Object)thisValue, (Object)otherValue)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PropertyBag clone = (PropertyBag)super.clone();
        String[] oldKeys = this.keys;
        Object[] oldValues = this.values;
        clone.allPropertyBagChangedListeners = null;
        this.resize(this.numProperties);
        clone.keys = this.keys;
        clone.values = this.values;
        clone.pendingEventGateCount = 0;
        this.keys = oldKeys;
        this.values = oldValues;
        return clone;
    }

    public synchronized Object clone(DeepCloneSupport support, boolean deeply) throws CloneNotSupportedException {
        PropertyBag newBag = (PropertyBag)this.clone();
        if (support != null) {
            support.register((Object)this, (Object)newBag);
        }
        if (deeply) {
            for (int i = 0; i < this.keys.length; ++i) {
                Object otherValue = this.values[i];
                if (!(otherValue instanceof StaticPropertyBagInterface)) continue;
                Object other = support != null ? support.clone(otherValue, deeply) : (otherValue instanceof PropertyBag ? ((PropertyBag)otherValue).clone(null, deeply) : Component.clone(otherValue));
                this.values[i] = other;
            }
        }
        return newBag;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.pendingEventGateCount = 0;
        for (int i = 0; i < this.numProperties; ++i) {
            this.keys[i] = this.keys[i].intern();
        }
        stream.registerValidation(this, 1);
    }

    @Override
    public void validateObject() {
        for (int i = 0; i < this.numProperties; ++i) {
            this.swapSources(null, this.values[i], false);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this.resize(this.numProperties);
        stream.defaultWriteObject();
    }

    public synchronized String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[# ");
        buffer.append(System.identityHashCode(this));
        buffer.append(" ");
        for (int i = 0; i < this.numProperties; ++i) {
            if (i > 0) {
                buffer.append(',');
            }
            String key = this.keys[i];
            buffer.append(Strings.quote((String)key));
            buffer.append('=');
            Object value = this.values[i];
            if (value != null && value instanceof String) {
                buffer.append(Strings.quote((String)((String)value)));
                continue;
            }
            if (value instanceof PropertyBagInterface) {
                buffer.append("{");
                buffer.append(this.values[i]);
                buffer.append("}");
                continue;
            }
            buffer.append(this.values[i]);
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static int collect(PropertyBagInterface target, PropertyBagInterface query, StaticPropertyBagInterface source) {
        int count = 0;
        for (String key : query.listKeys()) {
            Object sourceItem = source.get(key, NO_SUCH_ELEMENT);
            if (sourceItem == NO_SUCH_ELEMENT) continue;
            Object queryItem = query.get(key);
            Object targetItem = target.get(key, NO_SUCH_ELEMENT);
            if (!(queryItem instanceof PropertyBagInterface)) {
                if (targetItem != NO_SUCH_ELEMENT) continue;
                if (sourceItem instanceof StaticPropertyBagInterface) {
                    StaticPropertyBagInterface sourcePB = (StaticPropertyBagInterface)sourceItem;
                    PropertyBag copy = new PropertyBag();
                    copy.set(sourcePB);
                    sourceItem = copy;
                }
                target.set(key, sourceItem);
                query.remove(key);
                ++count;
                continue;
            }
            PropertyBagInterface queryBag = (PropertyBagInterface)queryItem;
            PropertyBagInterface targetBag = null;
            if (targetItem == NO_SUCH_ELEMENT) {
                targetBag = new PropertyBag();
                target.set(key, targetBag);
            } else if (targetItem instanceof PropertyBagInterface) {
                targetBag = (PropertyBagInterface)targetItem;
            }
            if (targetBag == null || !(sourceItem instanceof StaticPropertyBagInterface)) continue;
            int n = PropertyBag.collect(targetBag, queryBag, (StaticPropertyBagInterface)sourceItem);
            if (n > 0) {
                ++count;
            }
            if (queryBag.count() != 0) continue;
            query.remove(key);
        }
        return count;
    }

    public void setProperties(Object bean) {
        PropertyBag.setProperties(bean, this);
    }

    public static void setProperties(Object bean, StaticPropertyBagInterface properties) {
        String[] props = properties.listKeys();
        if (props == null) {
            return;
        }
        for (String propertyName : props) {
            Object object = properties.get(propertyName);
            boolean recurse = false;
            StaticPropertyBagInterface nestedProperties = null;
            if (object instanceof StaticPropertyBagInterface) {
                String name;
                nestedProperties = (StaticPropertyBagInterface)object;
                if (nestedProperties.count() == 1 && ((name = nestedProperties.listKeys()[0]) == null || name.length() == 0)) {
                    recurse = false;
                    object = nestedProperties;
                } else {
                    Class propType = Util.getPropertyType((Object)bean, (String)propertyName);
                    if (propType != null && !propType.isPrimitive() && !propType.isArray()) {
                        recurse = true;
                    }
                }
            }
            if (recurse) {
                Object propertyValue = Util.getPropertyValue((Object)bean, (String)propertyName);
                PropertyBag.setProperties(propertyValue, nestedProperties);
                continue;
            }
            Util.setPropertyValue((Object)bean, (String)propertyName, (Object)object);
        }
    }

    public void load(InputStream stream) throws IOException {
        PropertyBag.load(this, stream);
    }

    public static void load(PropertyBagInterface properties, InputStream stream) throws IOException {
        Properties props = new Properties();
        props.load(stream);
        PropertyBag.addItems(properties, props);
    }

    public void save(OutputStream stream, String header) throws IOException {
        PropertyBag.save(this, stream, header);
    }

    public static void save(StaticPropertyBagInterface properties, OutputStream stream, String header) throws IOException {
        PropertyBag.toProperties(properties, null).save(stream, header);
    }

    public PropertyBagInterface addItems(Properties props) {
        return PropertyBag.addItems(this, props);
    }

    public static PropertyBagInterface addItems(PropertyBagInterface bag, Properties properties) {
        bag = bag == null ? new PropertyBag() : bag;
        Enumeration<Object> e = properties.keys();
        while (e.hasMoreElements()) {
            Object object = e.nextElement();
            String key = object instanceof String ? ((String)object).intern() : object.toString().intern();
            bag.set(key, properties.get(key));
        }
        return bag;
    }

    public Properties toProperties(Properties properties) {
        return PropertyBag.toProperties(this, properties);
    }

    public static Properties toProperties(StaticPropertyBagInterface propertyBag, Properties properties) {
        properties = properties == null ? new Properties() : properties;
        for (String key : propertyBag.listKeys()) {
            properties.put(key, propertyBag.get(key));
        }
        return properties;
    }
}

