/*
 * Decompiled with CFR 0.152.
 */
package com.sas.collection;

import com.sas.collection.AssociationListInterface;
import com.sas.util.EventGateInterface;
import com.sas.util.IndexedSetInterface;

public class Permuter {
    private IndexedSetInterface collection;
    private int count;
    private boolean haveSize;
    private int[] permutation;
    private AssociationListInterface aList;

    public Permuter() {
    }

    public Permuter(IndexedSetInterface collection, int[] permutation) {
        this.setCollection(collection);
        this.count = -1;
        this.setPermutation(permutation);
    }

    public Permuter(int[] permutation) {
        this.setPermutation(permutation);
    }

    public Permuter(IndexedSetInterface collection) {
        this.setCollection(collection);
    }

    public Permuter(IndexedSetInterface collection, int size) {
        this.setCollection(collection);
        this.count = size;
        this.haveSize = true;
    }

    public IndexedSetInterface getCollection() {
        return this.collection;
    }

    public void setCollection(IndexedSetInterface collection) {
        this.collection = collection;
        this.aList = collection instanceof AssociationListInterface ? (AssociationListInterface)collection : null;
    }

    public void setCollection(IndexedSetInterface collection, int size) {
        this.collection = collection;
        this.count = size;
        this.haveSize = true;
    }

    public int[] getPermutation() {
        return this.permutation;
    }

    public void setPermutation(int[] permutation) {
        this.validatePermutation(permutation);
        this.permutation = permutation;
    }

    protected void disableEvents() {
        if (this.collection instanceof EventGateInterface) {
            ((EventGateInterface)this.collection).disableEvents();
        }
    }

    protected void enableEvents() {
        if (this.collection instanceof EventGateInterface) {
            ((EventGateInterface)this.collection).enableEvents();
        }
    }

    private int count() {
        return this.haveSize ? this.count : this.collection.count();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validatePermutation(int[] permutation) {
        if (permutation == null) {
            return;
        }
        IndexedSetInterface indexedSetInterface = this.collection;
        synchronized (indexedSetInterface) {
            int[] nArray = permutation;
            synchronized (permutation) {
                int i;
                int length = permutation.length;
                int count = this.count();
                if (length != count) {
                    throw new IllegalArgumentException("permutation.length {" + length + "} != collection.count {" + count + "}");
                }
                int[] permuted = new int[length];
                for (i = 0; i < length; ++i) {
                    permuted[i] = -1;
                }
                i = 0;
                while (i < length) {
                    int j = permutation[i];
                    if (j < 0 || j >= length) {
                        throw new IllegalArgumentException("permutation[" + i + "] == " + j + " ! in [0," + (length - 1) + "]");
                    }
                    if (permuted[j] != -1) {
                        throw new IllegalArgumentException("permutation[" + i + "] == permutation[" + permuted[j] + "]");
                    }
                    permuted[j] = i++;
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void permute() {
        int[] nArray = this.permutation;
        synchronized (this.permutation) {
            int end;
            int start;
            int length = this.permutation.length;
            for (start = 0; start < length - 1 && this.permutation[start] == start; ++start) {
            }
            for (end = length - 1; end > 0 && this.permutation[end] == end; --end) {
            }
            if (end - start < 1) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.permute(start, end + 1);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void validateIndex(int index, int length) {
        if (index < 0 || index >= length) {
            throw new IllegalArgumentException("index < 0 || index >= collection.count()");
        }
    }

    private void validateStartEnd(int start, int end, int length) {
        if (start < 0 || start >= length) {
            throw new IllegalArgumentException("start < 0 || start >= collection.count()");
        }
        if (end < 0 || end > length) {
            throw new IllegalArgumentException("end < - || end > collection.count()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void permute(int start, int end) {
        IndexedSetInterface indexedSetInterface = this.collection;
        synchronized (indexedSetInterface) {
            int[] nArray = this.permutation;
            synchronized (this.permutation) {
                try {
                    int length = this.permutation.length;
                    this.validateStartEnd(start, end, length);
                    this.disableEvents();
                    int count = end - start;
                    Object[] objects = new Object[count];
                    if (this.aList != null) {
                        Object[] keys = new Object[count];
                        int i = start;
                        int j = 0;
                        while (i < end) {
                            int k = this.permutation[i];
                            objects[j] = this.collection.get(k);
                            keys[j] = this.aList.getKey(k);
                            ++i;
                            ++j;
                        }
                        i = start;
                        j = 0;
                        while (i < end) {
                            this.aList.set(i, keys[j], objects[j]);
                            ++i;
                            ++j;
                        }
                    } else {
                        int i = start;
                        int j = 0;
                        while (i < end) {
                            int k = this.permutation[i];
                            objects[j] = this.collection.get(k);
                            ++i;
                            ++j;
                        }
                        i = start;
                        j = 0;
                        while (i < end) {
                            this.collection.set(i, objects[j]);
                            ++i;
                            ++j;
                        }
                    }
                }
                finally {
                    this.enableEvents();
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        }
    }

    public void permute(int[] permutation) {
        this.setPermutation(permutation);
        this.permute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void permute(IndexedSetInterface collection, int[] permutation) {
        IndexedSetInterface indexedSetInterface = collection;
        synchronized (indexedSetInterface) {
            new Permuter(collection, permutation).permute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reverse(IndexedSetInterface collection, int start, int end) {
        IndexedSetInterface indexedSetInterface = collection;
        synchronized (indexedSetInterface) {
            new Permuter(collection).reverse(start, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reverse(int start, int end) {
        IndexedSetInterface indexedSetInterface = this.collection;
        synchronized (indexedSetInterface) {
            this.permute(this.newReversePermutation(start, end));
        }
    }

    public int[] newReversePermutation(int start, int end) {
        int i;
        int length = this.count();
        int[] indices = new int[length];
        for (i = 0; i < start; ++i) {
            indices[i] = i;
        }
        int j = end - 1;
        for (i = start; i < end; ++i) {
            indices[i] = j--;
        }
        for (i = end; i < length; ++i) {
            indices[i] = i;
        }
        return indices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void swap(IndexedSetInterface collection, int i, int j) {
        if (i == j) {
            return;
        }
        IndexedSetInterface indexedSetInterface = collection;
        synchronized (indexedSetInterface) {
            if (collection instanceof AssociationListInterface) {
                AssociationListInterface aList = (AssociationListInterface)collection;
                Object tempValueI = aList.get(i);
                Object tempKeyI = aList.getKey(i);
                aList.set(i, aList.getKey(j), aList.get(j));
                aList.set(j, tempKeyI, tempValueI);
            } else {
                Object temp = collection.get(i);
                collection.set(i, collection.get(j));
                collection.set(j, temp);
            }
        }
    }

    public static void rotate(IndexedSetInterface collection, int start, int end, int n) {
        new Permuter(collection).rotate(start, end, n);
    }

    public void rotate(int start, int end, int n) {
        if (n == 0) {
            return;
        }
        this.setPermutation(this.newRotatePermutation(start, end, n));
        this.permute();
    }

    public int[] newRotatePermutation(int start, int end, int n) {
        int count = this.count();
        this.validateStartEnd(start, end, count);
        int length = end - start;
        if (n < 0) {
            n = length + n;
        }
        int[] indices = this.identityPermutation();
        if ((n %= length) == 0) {
            return indices;
        }
        int[] rotation = new int[length];
        System.arraycopy(indices, start, rotation, length - n, n);
        System.arraycopy(indices, start + n, rotation, 0, length - n);
        System.arraycopy(rotation, 0, indices, start, length);
        return indices;
    }

    public static void move(IndexedSetInterface collection, int index, int offset) {
        new Permuter(collection).move(index, offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(int index, int offset) {
        if (offset == 0) {
            return;
        }
        IndexedSetInterface indexedSetInterface = this.collection;
        synchronized (indexedSetInterface) {
            this.validateIndex(index, this.count());
            this.validateMove(index, offset);
            if (offset == 1 || offset == -1) {
                Permuter.swap(this.collection, index + offset, index);
                return;
            }
            this.setPermutation(this.newMovePermutation(index, offset));
            this.permute();
        }
    }

    public int[] newMovePermutation(int index, int offset) {
        int[] indices = this.identityPermutation();
        this.moveIndex(indices, index, offset);
        return indices;
    }

    private void validateMove(int index, int offset) {
        int target = index + offset;
        if (target < 0 || target >= this.count()) {
            throw new IllegalArgumentException("index + offset < 0 || index + offset >= length; index == " + index + ", offset = " + offset);
        }
    }

    private void moveIndex(int[] indices, int index, int offset) {
        int target = index + offset;
        if (offset < 0) {
            System.arraycopy(indices, target, indices, target + 1, -offset);
        } else {
            System.arraycopy(indices, index + 1, indices, index, offset);
        }
        indices[target] = index;
    }

    public static void move(IndexedSetInterface collection, int[] items, int offset) {
        new Permuter(collection).move(items, offset);
    }

    public void move(int[] items, int offset) {
        if (offset == 0) {
            return;
        }
        this.permute(this.newMovePermutation(items, offset));
    }

    public int[] newMovePermutation(int[] items, int offset) {
        int length = this.count();
        int[] indices = this.identityPermutation();
        this.validateItems(items, offset, length);
        if (offset < 0) {
            for (int i = 0; i < items.length; ++i) {
                int index = items[i];
                this.moveIndex(indices, index, offset);
            }
        } else {
            for (int i = items.length - 1; i >= 0; --i) {
                int index = items[i];
                this.moveIndex(indices, index, offset);
            }
        }
        return indices;
    }

    protected void validateItems(int[] items, int offset, int length) {
        for (int i = 0; i < items.length; ++i) {
            int previous;
            int index = items[i];
            this.validateIndex(index, length);
            this.validateMove(index, offset);
            if (i <= 0 || (previous = items[i - 1]) < index) continue;
            throw new IllegalArgumentException("items[ + " + (i - 1) + "] >= items[" + i + "]");
        }
    }

    public int[] identityPermutation() {
        int length = this.count();
        int[] permutation = new int[length];
        for (int i = 0; i < length; ++i) {
            permutation[i] = i;
        }
        return permutation;
    }

    public static int[] identityPermutation(int length) {
        int[] permutation = new int[length];
        for (int i = 0; i < length; ++i) {
            permutation[i] = i;
        }
        return permutation;
    }
}

