/*
 * Decompiled with CFR 0.152.
 */
package com.sas.collection;

import com.sas.DeepClonable;
import com.sas.DeepCloneSupport;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.BaseCollection;
import com.sas.collection.HowChanged;
import com.sas.collection.OrderedCollection;
import com.sas.collection.OrderedCollectionInterface;
import com.sas.collection.OrderedListChangedInfo;
import com.sas.collection.OrderedListCollectionEnumeration;
import com.sas.collection.PrintContents;
import com.sas.collection.RB;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.text.Message;
import com.sas.util.Comparator;
import com.sas.util.Util;
import com.sas.util.transforms.StaticOrderedCollectionInterfaceToStringTransform;
import com.sas.util.transforms.StringToOrderedCollectionInterfaceTransform;
import com.sas.util.transforms.TransformException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.ResourceBundle;

public class OrderedListCollection
extends BaseCollection
implements OrderedCollectionInterface,
DeepClonable {
    static final String RB_KEY = "OrderedListCollection.";
    static final long serialVersionUID = 9193435229898417589L;
    protected transient Node items;
    private transient Node recent;
    private transient int recentIndex;
    int length;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "size"}, {"Hidden", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.propertyMetadata = propertyMetadata;
        ebi.shortDescription = RB.getStringResource((String)RB_KEY, (String)"description.txt");
        return ebi;
    }

    public OrderedListCollection() {
        this.init();
    }

    public OrderedListCollection(String data) {
        this();
        try {
            new StringToOrderedCollectionInterfaceTransform().transform(this, data);
        }
        catch (TransformException te) {
            te.printStackTrace();
            throw new IllegalArgumentException(te.getMessage());
        }
    }

    private void init() {
        this.items = new Node(null);
        this.items.item = this.items;
        this.recent = this.items;
        this.recentIndex = -1;
        this.length = 0;
    }

    private Node newNode(Object item, Node previous, int previousIndex) {
        this.recent = previous;
        this.recentIndex = previousIndex;
        return new Node(item, previous);
    }

    @Override
    public synchronized void add(Object item) {
        this.add(item, this.count());
    }

    Node nodeAt(int index) {
        if (index == this.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.nodeBefore((int)index).next;
    }

    Node nodeBefore(int index) {
        boolean movePointerForward;
        if (index == 0) {
            return this.items;
        }
        if (index == this.length) {
            return this.items.previous;
        }
        if (index < 0 || index > this.length) {
            throw new IndexOutOfBoundsException();
        }
        if (index == this.recentIndex) {
            return this.recent.previous;
        }
        if (index < this.recentIndex) {
            if (index >= this.recentIndex - index) {
                movePointerForward = false;
            } else {
                this.recent = this.items;
                this.recentIndex = -1;
                movePointerForward = true;
            }
        } else if (index <= (this.length + this.recentIndex) / 2) {
            movePointerForward = true;
        } else {
            this.recent = this.items;
            this.recentIndex = this.length;
            movePointerForward = false;
        }
        if (movePointerForward) {
            int previousIndex = index - 1;
            while (this.recentIndex < previousIndex) {
                ++this.recentIndex;
                this.recent = this.recent.next;
            }
            return this.recent;
        }
        while (this.recentIndex >= index) {
            --this.recentIndex;
            this.recent = this.recent.previous;
        }
        return this.recent;
    }

    @Override
    public synchronized void add(Object item, int index) {
        Node newNode = this.newNode(item, this.nodeBefore(index), index - 1);
        ++this.length;
        if (this.anyContentsChangedListeners()) {
            this.fireContentsChanged(new OrderedListChangedInfo((Object)this, newNode, item, HowChanged.ADDED, index));
        }
    }

    @Override
    public synchronized void addItems(Enumeration items, int index) {
        Node previous;
        int origIndex = index;
        Node first = previous = this.nodeBefore(index);
        while (items.hasMoreElements()) {
            previous = this.newNode(items.nextElement(), previous, index - 1);
            ++this.length;
            ++index;
        }
        if (index != origIndex && this.anyContentsChangedListeners()) {
            this.fireContentsChanged(new OrderedListChangedInfo((Object)this, first, HowChanged.ADDED, origIndex, index));
        }
    }

    @Override
    public synchronized void addItems(Enumeration items) {
        this.addItems(items, this.length);
    }

    @Override
    public synchronized void removeAll() {
        if (this.length > 0) {
            int origLen = this.length;
            this.items.previous = this.items;
            this.items.next = this.items;
            this.length = 0;
            this.recent = this.items;
            this.recentIndex = -1;
            if (this.anyContentsChangedListeners()) {
                this.fireContentsChanged(new OrderedListChangedInfo((Object)this, null, (Object)null, HowChanged.REMOVED, 0, origLen));
            }
        }
    }

    @Override
    public synchronized boolean contains(Object item) {
        Node node = this.items.next;
        while (node != this.items) {
            if (Util.equal((Object)node.item, (Object)item)) {
                return true;
            }
            node = node.next;
        }
        return false;
    }

    @Override
    public synchronized int count() {
        return this.length;
    }

    @Override
    public void dumpComponent() {
        System.out.println(Message.format((ResourceBundle)com.sas.RB.getResources(), (String)"ComponentInterface.dumpStarting.txt", (Object)RB_KEY));
        super.dumpComponent();
        this.apply(new PrintContents(new PrintWriter(System.out)));
        System.out.println(Message.format((ResourceBundle)com.sas.RB.getResources(), (String)"ComponentInterface.dumpDone.txt", (Object)RB_KEY));
    }

    @Override
    public synchronized boolean equals(StaticOrderedCollectionInterface orderedCollection) {
        if (this.count() != orderedCollection.count()) {
            return false;
        }
        Enumeration items = this.getItems();
        Enumeration otherItems = orderedCollection.getItems();
        return Util.equal((Enumeration)items, (Enumeration)otherItems);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof StaticOrderedCollectionInterface) {
            return this.equals((StaticOrderedCollectionInterface)obj);
        }
        return super.equals(obj);
    }

    @Override
    public synchronized Object get(int index) {
        return this.nodeAt((int)index).item;
    }

    @Override
    public synchronized int getIndex(Object item, int startIndex) {
        if (startIndex == this.length) {
            throw new IndexOutOfBoundsException();
        }
        Node node = this.nodeAt(startIndex);
        while (node != this.items) {
            if (Util.equal((Object)node.item, (Object)item)) {
                this.recent = node;
                this.recentIndex = startIndex;
                return startIndex;
            }
            node = node.next;
            ++startIndex;
        }
        return -1;
    }

    @Override
    public synchronized Enumeration getItems(int start, int end) {
        return new OrderedListCollectionEnumeration(this, start, end);
    }

    @Override
    public synchronized Enumeration getItems() {
        return new OrderedListCollectionEnumeration(this);
    }

    @Override
    public synchronized int getLastIndex(Object item, int startIndex) {
        if (startIndex == this.length) {
            throw new IndexOutOfBoundsException();
        }
        Node node = this.nodeBefore((int)startIndex).next;
        while (node != this.items) {
            if (Util.equal((Object)node.item, (Object)item)) {
                this.recent = node;
                this.recentIndex = startIndex;
                return startIndex;
            }
            node = node.previous;
            --startIndex;
        }
        return -1;
    }

    private void removeNode(Node node, int index) {
        node.previous.next = node.next;
        node.next.previous = node.previous;
        if (index == this.recentIndex) {
            this.recent = this.recent.previous;
            --this.recentIndex;
        } else if (index < this.recentIndex) {
            --this.recentIndex;
        }
        --this.length;
        node.previous = null;
        node.next = null;
        if (this.anyContentsChangedListeners()) {
            this.fireContentsChanged(new OrderedListChangedInfo((Object)this, node, node.item, HowChanged.REMOVED, index));
        }
    }

    @Override
    public synchronized boolean remove(Object item) {
        int index = 0;
        Node node = this.items.next;
        while (node != this.items) {
            if (Util.equal((Object)node.item, (Object)item)) {
                this.removeNode(node, index);
                return true;
            }
            ++index;
            node = node.next;
        }
        return false;
    }

    @Override
    public synchronized int removeAll(Object item) {
        int count = 0;
        int index = 0;
        Node node = this.items.next;
        Node next = node.next;
        while (node != this.items) {
            if (Util.equal((Object)node.item, (Object)item)) {
                ++count;
                this.removeNode(node, index);
            } else {
                ++index;
            }
            node = next;
            next = node.next;
        }
        return count;
    }

    @Override
    public synchronized Object removeAt(int index) {
        Node node = this.nodeAt(index);
        this.removeNode(node, index);
        return node.item;
    }

    @Override
    public synchronized void set(int index, Object item) {
        Node node = this.nodeAt(index);
        if (item != node.item) {
            node.item = item;
            if (this.anyContentsChangedListeners()) {
                this.fireContentsChanged(new OrderedListChangedInfo((Object)this, node, HowChanged.REPLACED, index));
            }
        }
    }

    public synchronized void append(int index, Object item) {
        if (index >= this.count()) {
            this.setSize(index + 1);
        }
        this.set(index, item);
    }

    @Override
    public synchronized void setSize(int newSize) {
        if (newSize < 0) {
            throw new IndexOutOfBoundsException();
        }
        int origLen = this.length;
        if (newSize > origLen) {
            Node last;
            Node first = last = this.items.previous;
            while (this.length < newSize) {
                last = new Node(null, last);
                ++this.length;
            }
            if (this.anyContentsChangedListeners()) {
                this.fireContentsChanged(new OrderedListChangedInfo((Object)this, first, HowChanged.ADDED, origLen, newSize));
            }
        } else {
            OrderedListChangedInfo event = new OrderedListChangedInfo((Object)this, null, HowChanged.REMOVED, this.length - 1);
            while (this.length > newSize) {
                event.node = this.items.previous;
                this.removeNode(this.items.previous, this.length - 1);
                event.start = this.length - 1;
                event.end = this.length - 1;
                if (!this.anyContentsChangedListeners()) continue;
                this.fireContentsChanged(event);
            }
        }
    }

    @Override
    public synchronized void sort(Comparator comparator) {
        this.sort(comparator, 0, this.length);
    }

    @Override
    public synchronized void sort(Comparator comparator, int start, int end) {
        OrderedCollection.sort(this, comparator, start, end);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        OrderedListCollection newCollection = (OrderedListCollection)super.clone();
        newCollection.init();
        newCollection.allContentsChangedListeners = null;
        newCollection.addItems(this.getItems());
        return newCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone(DeepCloneSupport support, boolean deeply) throws CloneNotSupportedException {
        OrderedListCollection orderedListCollection = this;
        synchronized (orderedListCollection) {
            OrderedListCollection clone = (OrderedListCollection)this.clone();
            if (support != null) {
                support.register((Object)this, (Object)clone);
            }
            if (deeply) {
                try {
                    OrderedListCollection orderedListCollection2 = clone;
                    synchronized (orderedListCollection2) {
                        for (int i = this.count() - 1; i >= 0; --i) {
                            clone.set(i, support.clone(this.get(i), true));
                        }
                    }
                }
                catch (NullPointerException e) {
                    throw new CloneNotSupportedException("support == null");
                }
            }
            return clone;
        }
    }

    public String toString() {
        return (String)StaticOrderedCollectionInterfaceToStringTransform.defaultInstance.transform(this);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        Node node = this.items.next;
        while (node != this.items) {
            out.writeObject(node.item);
            node = node.next;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.init();
        in.defaultReadObject();
        for (int i = 0; i < this.length; ++i) {
            Object object = in.readObject();
            new Node(object, this.items.previous);
        }
    }

    class Node {
        Node previous;
        Node next;
        Object item;

        Node(Object item) {
            this.previous = this;
            this.item = item;
            this.next = this;
        }

        Node(Object item, Node previous) {
            Node next = previous.next;
            this.previous = previous;
            previous.next = this;
            this.item = item;
            this.next = next;
            next.previous = this;
        }
    }
}

