/*
 * Decompiled with CFR 0.152.
 */
package com.sas.collection;

import com.sas.collection.BaseEnumerator;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.OrderedCollectionInterface;
import com.sas.util.Enumerator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.NoSuchElementException;

class OrderedCollectionEnumeration
extends BaseEnumerator {
    static final long serialVersionUID = -5112491121669090447L;
    protected int index;
    protected int end;
    private OrderedCollectionInterface orderedCollection;

    OrderedCollectionEnumeration(OrderedCollectionInterface orderedCollection, int start, int end) throws IndexOutOfBoundsException {
        this(orderedCollection);
        this.end = end;
        int count = orderedCollection.count();
        if (start < 0 || count > 0 && start >= count || end < -1 || end > count || end != -1 && start > end) {
            throw new IndexOutOfBoundsException();
        }
        this.index = start;
    }

    OrderedCollectionEnumeration(OrderedCollectionInterface orderedCollection) {
        super(orderedCollection);
        this.orderedCollection = orderedCollection;
        this.index = 0;
        this.end = -1;
    }

    @Override
    public boolean hasMoreElements() {
        if (this.orderedCollection != null && this.index < this.orderedCollection.count() && (this.end == -1 || this.index < this.end)) {
            return true;
        }
        this.orderedCollection = null;
        return false;
    }

    public Object nextElement() {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        try {
            ++this.index;
            return this.orderedCollection.get(this.index - 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    public void contentsChanged(ContentsChangedEvent contentsChanged) {
    }

    @Override
    public Enumerator finish() {
        this.orderedCollection = null;
        return super.finish();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.getCollection() == null) {
            this.setCollection(this.orderedCollection);
        }
    }
}

