/*
 * Decompiled with CFR 0.152.
 */
package com.sas.collection;

import com.sas.DeepClonable;
import com.sas.DeepCloneSupport;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.BaseCollection;
import com.sas.collection.CollectionChangedInfo;
import com.sas.collection.HowChanged;
import com.sas.collection.OrderedCollectionEnumeration;
import com.sas.collection.OrderedCollectionInterface;
import com.sas.collection.PrintContents;
import com.sas.collection.RB;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.text.Message;
import com.sas.util.ApplyInterface;
import com.sas.util.ArrayAccess;
import com.sas.util.Comparator;
import com.sas.util.EventGateInterface;
import com.sas.util.IndexedGetInterface;
import com.sas.util.IndexedSetInterface;
import com.sas.util.Sort;
import com.sas.util.Util;
import com.sas.util.transforms.StaticOrderedCollectionInterfaceToStringTransform;
import com.sas.util.transforms.StringToOrderedCollectionInterfaceTransform;
import com.sas.util.transforms.TransformException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.ResourceBundle;

public class OrderedCollection
extends BaseCollection
implements OrderedCollectionInterface,
DeepClonable {
    public static final String RB_KEY = "OrderedCollection.";
    static final long serialVersionUID = -836832229016709409L;
    private Object[] data;
    private int count;
    private transient int holePosition;
    private int increment;
    private static final Object EMPTY_VALUE = null;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "size"}, {"Hidden", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.propertyMetadata = propertyMetadata;
        ebi.shortDescription = RB.getStringResource((String)RB_KEY, (String)"description.txt");
        return ebi;
    }

    public OrderedCollection() {
        this(8, 0);
    }

    public OrderedCollection(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public OrderedCollection(int initialSize, int capacityIncrement) {
        this.data = new Object[initialSize];
        this.increment = capacityIncrement;
        this.initializeComponent();
    }

    public OrderedCollection(Object[] array) {
        this(array, -1);
    }

    public OrderedCollection(Object[] array, int capacityIncrement) {
        this.data = array;
        this.count = this.data.length;
        this.increment = capacityIncrement;
        this.initializeComponent();
    }

    public OrderedCollection(String data) {
        this();
        try {
            new StringToOrderedCollectionInterfaceTransform().transform(this, data);
        }
        catch (TransformException te) {
            throw new IllegalArgumentException(te.getMessage());
        }
    }

    private void fillData(int start, int end, Object o) {
        for (int i = start; i < end; ++i) {
            this.data[i] = o;
        }
    }

    private Object internalGet(int i) {
        if (i >= this.holePosition) {
            return this.data[i + this.holeSize()];
        }
        return this.data[i];
    }

    private final void internalSet(int i, Object o) {
        if (i >= this.holePosition) {
            this.data[i + this.holeSize()] = o;
        } else {
            this.data[i] = o;
        }
    }

    private final int holeSize() {
        return this.data.length - this.count();
    }

    protected int computeNewCapacity() {
        if (this.increment < 0) {
            throw new IndexOutOfBoundsException(RB.getStringResource((String)RB_KEY, (String)"fixedCapacity.ex.txt"));
        }
        int newSize = this.increment == 0 ? this.data.length * 2 : this.data.length + this.increment;
        return newSize;
    }

    protected final void moveHole(int newHolePosition) {
        if (newHolePosition == this.holePosition) {
            return;
        }
        int holeSize = this.holeSize();
        if (holeSize > 0) {
            if (newHolePosition < this.holePosition) {
                int to = this.holePosition + holeSize - 1;
                int from = this.holePosition - 1;
                for (int nItems = this.holePosition - newHolePosition; nItems > 0; --nItems) {
                    this.data[to] = this.data[from];
                    this.data[from] = EMPTY_VALUE;
                    --to;
                    --from;
                }
            } else {
                int to = this.holePosition;
                int from = this.holePosition + holeSize;
                for (int nItems = newHolePosition - this.holePosition; nItems > 0; --nItems) {
                    this.data[to] = this.data[from];
                    this.data[from] = EMPTY_VALUE;
                    ++to;
                    ++from;
                }
            }
        }
        this.holePosition = newHolePosition;
    }

    protected final void moveHoleEnsureCapacity(int newHolePosition, int capacity) {
        if (this.holePosition == newHolePosition && this.data.length >= capacity) {
            return;
        }
        if (this.data.length >= capacity) {
            this.moveHole(newHolePosition);
        } else {
            if (newHolePosition < 0) {
                throw new IndexOutOfBoundsException(newHolePosition + "<" + 0);
            }
            int newSize = this.computeNewCapacity();
            if (newSize < capacity) {
                newSize = capacity;
            }
            Object[] newData = new Object[newSize];
            int newHoleSize = newSize - this.count;
            if (this.holePosition == newHolePosition && this.holePosition == this.count) {
                System.arraycopy(this.data, 0, newData, 0, this.count);
                this.data = newData;
                this.fillData(this.count, newSize, EMPTY_VALUE);
            } else {
                int from = 0;
                int to = 0;
                while (from < newHolePosition) {
                    newData[to] = this.internalGet(from);
                    ++from;
                    ++to;
                }
                to += newHoleSize;
                while (from < this.count) {
                    newData[to] = this.internalGet(from);
                    ++to;
                    ++from;
                }
                this.data = newData;
                this.holePosition = newHolePosition;
                this.fillData(this.holePosition, this.holePosition + this.holeSize(), EMPTY_VALUE);
            }
        }
    }

    @Override
    public synchronized void add(Object item) {
        this.add(item, this.count());
    }

    @Override
    public synchronized void add(Object item, int index) {
        try {
            this.insertElementAt(item, index);
            if (this.anyContentsChangedListeners()) {
                this.fireContentsChanged(new CollectionChangedInfo((Object)this, item, HowChanged.ADDED, index));
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    private synchronized void insertElementAt(Object o, int index) {
        int c = this.count();
        if (index > c) {
            throw new IndexOutOfBoundsException(index + ">" + c);
        }
        this.moveHoleEnsureCapacity(index, c + 1);
        ++this.holePosition;
        this.internalSet(index, o);
        ++this.count;
    }

    @Override
    public synchronized void addItems(Enumeration items, int index) {
        try {
            int origIndex = index;
            boolean anyAdded = false;
            while (items.hasMoreElements()) {
                anyAdded = true;
                this.insertElementAt(items.nextElement(), index++);
            }
            if (anyAdded && this.anyContentsChangedListeners()) {
                this.fireContentsChanged(new CollectionChangedInfo((Object)this, HowChanged.ADDED, origIndex, index));
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    @Override
    public synchronized void addItems(Enumeration items) {
        this.addItems(items, this.count());
    }

    @Override
    public synchronized void apply(ApplyInterface action) {
        int c = this.count();
        for (int index = 0; index < c && 1 != action.apply(this.internalGet(index)); ++index) {
        }
    }

    @Override
    public synchronized void removeAll() {
        this.setSize(0);
    }

    @Override
    public synchronized boolean contains(Object item) {
        return this.getIndex(item, 0) >= 0;
    }

    @Override
    public synchronized int count() {
        return this.count;
    }

    @Override
    public void dumpComponent() {
        System.out.println(Message.format((ResourceBundle)com.sas.RB.getResources(), (String)"ComponentInterface.dumpStarting.txt", (Object)RB_KEY));
        super.dumpComponent();
        PrintWriter pw = new PrintWriter(System.out);
        this.apply(new PrintContents(pw));
        System.out.println(Message.format((ResourceBundle)com.sas.RB.getResources(), (String)"ComponentInterface.dumpDone.txt", (Object)RB_KEY));
    }

    public synchronized Object[] toArray() {
        int n = this.count();
        Object[] items = new Object[n];
        this.moveHole(n);
        System.arraycopy(this.data, 0, items, 0, n);
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object toArray(IndexedGetInterface collection) {
        if (collection instanceof OrderedCollection) {
            return ((OrderedCollection)collection).toArray();
        }
        IndexedGetInterface indexedGetInterface = collection;
        synchronized (indexedGetInterface) {
            int n = collection.count();
            Object[] array = new Object[n];
            for (int i = 0; i < n; ++i) {
                array[i] = collection.get(i);
            }
            return array;
        }
    }

    @Override
    public synchronized boolean equals(StaticOrderedCollectionInterface orderedCollection) {
        if (this.count() != orderedCollection.count()) {
            return false;
        }
        Enumeration items = this.getItems();
        Enumeration otherItems = orderedCollection.getItems();
        return Util.equal((Enumeration)items, (Enumeration)otherItems);
    }

    public synchronized boolean equals(Object object) {
        return object != null && object instanceof StaticOrderedCollectionInterface && this.equals((StaticOrderedCollectionInterface)object);
    }

    @Override
    public synchronized Object get(int index) {
        try {
            if (index >= this.count()) {
                throw new IndexOutOfBoundsException(index + ">=" + this.count());
            }
            return this.internalGet(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    @Override
    public synchronized int getIndex(Object item, int startIndex) {
        try {
            if (startIndex > 0 && startIndex >= this.count()) {
                throw new IndexOutOfBoundsException(startIndex + ">=" + this.count());
            }
            int c = this.count();
            for (int position = startIndex; position < c; ++position) {
                if (!Util.equal((Object)item, (Object)this.internalGet(position))) continue;
                return position;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
        return -1;
    }

    @Override
    public synchronized Enumeration getItems(int start, int end) {
        return new OrderedCollectionEnumeration(this, start, end);
    }

    @Override
    public synchronized Enumeration getItems() {
        return new OrderedCollectionEnumeration(this, 0, -1);
    }

    @Override
    public synchronized int getLastIndex(Object item, int startIndex) {
        try {
            if (startIndex >= this.count()) {
                throw new IndexOutOfBoundsException(startIndex + ">=" + this.count());
            }
            if (startIndex < 0) {
                throw new IndexOutOfBoundsException(startIndex + "<" + 0);
            }
            for (int position = startIndex; position >= 0; --position) {
                if (!Util.equal((Object)item, (Object)this.internalGet(position))) continue;
                return position;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
        return -1;
    }

    @Override
    public synchronized boolean remove(Object item) {
        int index = this.getIndex(item, 0);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    private void removeElementAt(int index) {
        this.moveHole(index + 1);
        this.internalSet(index, EMPTY_VALUE);
        --this.count;
        --this.holePosition;
    }

    @Override
    public synchronized int removeAll(Object item) {
        int n = 0;
        int index = this.getIndex(item, 0);
        while (index >= 0) {
            ++n;
            this.removeAt(index);
            if (index >= this.count()) break;
            index = this.getIndex(item, index);
        }
        return n;
    }

    @Override
    public synchronized Object removeAt(int index) {
        Object returnValue = null;
        try {
            if (index >= this.count()) {
                throw new IndexOutOfBoundsException(index + ">=" + this.count());
            }
            returnValue = this.internalGet(index);
            this.removeElementAt(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
        if (this.anyContentsChangedListeners()) {
            this.fireContentsChanged(new CollectionChangedInfo((Object)this, returnValue, HowChanged.REMOVED, index));
        }
        return returnValue;
    }

    @Override
    public synchronized void set(int index, Object item) {
        try {
            if (index >= this.count()) {
                throw new IndexOutOfBoundsException(index + ">=" + this.count());
            }
            this.internalSet(index, item);
            if (this.anyContentsChangedListeners()) {
                this.fireContentsChanged(new CollectionChangedInfo((Object)this, HowChanged.REPLACED, index));
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    public synchronized void append(int index, Object item) {
        if (index >= this.count()) {
            this.setSize(index + 1);
        }
        this.internalSet(index, item);
        if (this.anyContentsChangedListeners()) {
            this.fireContentsChanged(new CollectionChangedInfo((Object)this, HowChanged.ADDED, index));
        }
    }

    @Override
    public synchronized void setSize(int newSize) {
        int originalSize = this.count();
        if (newSize > originalSize) {
            this.moveHoleEnsureCapacity(this.holePosition, newSize);
            this.count = newSize;
            this.holePosition += newSize - originalSize;
            if (this.anyContentsChangedListeners()) {
                this.fireContentsChanged(new CollectionChangedInfo((Object)this, HowChanged.ADDED, originalSize, newSize));
            }
        } else if (newSize < originalSize) {
            if (newSize < 0) {
                throw new IndexOutOfBoundsException(newSize + "<" + 0);
            }
            int holeSize = this.holeSize();
            this.moveHole(newSize);
            this.fillData(newSize + holeSize, this.count() + holeSize, EMPTY_VALUE);
            this.count = newSize;
            if (this.anyContentsChangedListeners()) {
                this.fireContentsChanged(new CollectionChangedInfo((Object)this, HowChanged.REMOVED, newSize, originalSize));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void sort(OrderedCollectionInterface collection, Comparator comparator, int start, int end) {
        EventGateInterface gate = null;
        try {
            if (collection instanceof EventGateInterface) {
                gate = (EventGateInterface)collection;
                gate.disableEvents();
            }
            if (collection.getClass() == OrderedCollection.class) {
                ((OrderedCollection)collection).sort(comparator, start, end);
            } else {
                new Sort((IndexedSetInterface)collection, comparator).sort(start, end);
            }
        }
        finally {
            if (gate != null) {
                gate.enableEvents();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized int[] sort(OrderedCollectionInterface collection, int algorithm, Comparator comparator, int start, int end, int[] permutation) {
        OrderedCollectionInterface orderedCollectionInterface = collection;
        synchronized (orderedCollectionInterface) {
            int[] nArray;
            block8: {
                EventGateInterface gate = null;
                try {
                    if (collection instanceof EventGateInterface) {
                        gate = (EventGateInterface)collection;
                        gate.disableEvents();
                    }
                    Sort sort = new Sort((IndexedSetInterface)collection, comparator, algorithm);
                    sort.sort(start, end, permutation);
                    nArray = permutation;
                    if (gate == null) break block8;
                }
                catch (Throwable throwable) {
                    if (gate != null) {
                        gate.enableEvents();
                    }
                    throw throwable;
                }
                gate.enableEvents();
            }
            return nArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void sort(Comparator comparator, int start, int end) {
        if (this.holePosition < end) {
            this.moveHole(end);
        }
        try {
            this.disableEvents();
            new Sort((IndexedSetInterface)new ArrayAccess(this.data), comparator).sort(start, end);
        }
        finally {
            this.enableEvents();
        }
    }

    @Override
    public synchronized void sort(Comparator comparator) {
        this.sort(comparator, 0, this.count());
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        this.moveHole(this.count());
        OrderedCollection newCollection = (OrderedCollection)super.clone();
        newCollection.data = new Object[this.count()];
        System.arraycopy(this.data, 0, newCollection.data, 0, this.count());
        newCollection.allContentsChangedListeners = null;
        return newCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone(DeepCloneSupport support, boolean deeply) throws CloneNotSupportedException {
        OrderedCollection orderedCollection = this;
        synchronized (orderedCollection) {
            OrderedCollection clone = (OrderedCollection)this.clone();
            if (support != null) {
                support.register((Object)this, (Object)clone);
            }
            if (deeply) {
                try {
                    OrderedCollection orderedCollection2 = clone;
                    synchronized (orderedCollection2) {
                        for (int i = this.count() - 1; i >= 0; --i) {
                            clone.set(i, support.clone(this.get(i), true));
                        }
                    }
                }
                catch (NullPointerException e) {
                    throw new CloneNotSupportedException("support == null");
                }
            }
            return clone;
        }
    }

    public String toString() {
        return (String)StaticOrderedCollectionInterfaceToStringTransform.defaultInstance.transform(this);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.holePosition = this.count();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this.moveHole(this.count());
        stream.defaultWriteObject();
    }
}

