/*
 * Decompiled with CFR 0.152.
 */
package com.sas.collection;

import com.sas.DeepClonable;
import com.sas.DeepCloneSupport;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.BaseCollection;
import com.sas.collection.DictionaryChangedInfo;
import com.sas.collection.DictionaryEnumeration;
import com.sas.collection.DictionaryInterface;
import com.sas.collection.HowChanged;
import com.sas.collection.KeyEnum;
import com.sas.collection.RB;
import com.sas.text.Message;
import com.sas.util.Util;
import com.sas.util.transforms.StaticDictionaryInterfaceToStringTransform;
import com.sas.util.transforms.StringToDictionaryInterfaceTransform;
import com.sas.util.transforms.TransformException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;

public class Dictionary
extends BaseCollection
implements DictionaryInterface,
DeepClonable {
    public static final String RB_KEY = "Dictionary.";
    static final long serialVersionUID = 2777159783138754279L;
    protected Hashtable table;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "items"}, {"Default value", "null"}, {"Description", RB.getStringResource((String)"items.pd.txt")}, {"Hidden", "true"}}, {{"Name", "keys"}, {"Default value", "null"}, {"Description", RB.getStringResource((String)"keys.pd.txt")}, {"Hidden", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.shortDescription = RB.getStringResource((String)RB_KEY, (String)"description.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public Dictionary() {
        this.initializeComponent();
        this.table = new Hashtable();
    }

    public Dictionary(int initialCapacity, float loadFactor) {
        this.initializeComponent();
        this.table = new Hashtable(initialCapacity, loadFactor);
    }

    public Dictionary(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public Dictionary(String data) {
        this();
        try {
            StringToDictionaryInterfaceTransform.defaultInstance.transform(this, data);
        }
        catch (TransformException te) {
            throw new IllegalArgumentException(te.getMessage());
        }
    }

    @Override
    public synchronized void add(Object item) {
        this.set(item, item);
        if (this.anyContentsChangedListeners()) {
            this.fireContentsChanged(new DictionaryChangedInfo(this, HowChanged.ADDED, item));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addItems(Enumeration items) {
        boolean added = false;
        try {
            this.disableEvents();
            Enumeration enumeration = items;
            synchronized (enumeration) {
                while (items.hasMoreElements()) {
                    Object item = items.nextElement();
                    this.set(item, item);
                    added = true;
                }
            }
        }
        finally {
            this.enableEvents(null);
            if (added && this.anyContentsChangedListeners()) {
                this.fireContentsChanged(new DictionaryChangedInfo(this, HowChanged.ADDED));
            }
        }
    }

    @Override
    public synchronized void removeAll() {
        if (this.count() > 0) {
            this.table.clear();
            if (this.anyContentsChangedListeners()) {
                this.fireContentsChanged(new DictionaryChangedInfo(this, HowChanged.REMOVED));
            }
        }
    }

    @Override
    public synchronized boolean contains(Object item) {
        return this.table.contains(Dictionary.map(item));
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return this.table.containsKey(Dictionary.map(key));
    }

    @Override
    public synchronized int count() {
        return this.table.size();
    }

    public int countKey(Object key) {
        return this.containsKey(key) ? 1 : 0;
    }

    public synchronized int count(Object value) {
        int n = 0;
        Enumeration enumer = this.getItems();
        while (enumer.hasMoreElements()) {
            Object item = enumer.nextElement();
            if (!Util.equal((Object)value, item)) continue;
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dumpComponent() {
        System.out.println(Message.format((ResourceBundle)com.sas.RB.getResources(), (String)"ComponentInterface.dumpStarting.txt", (Object)RB_KEY));
        super.dumpComponent();
        Enumeration keys = this.table.keys();
        Hashtable hashtable = this.table;
        synchronized (hashtable) {
            while (keys.hasMoreElements()) {
                Object key = Dictionary.unmap(keys.nextElement());
                Object value = Dictionary.unmap(this.table.get(key));
                System.out.println(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"key.txt"), (Object)key));
                System.out.println(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"value.txt"), (Object)value));
            }
        }
        System.out.println(Message.format((ResourceBundle)com.sas.RB.getResources(), (String)"ComponentInterface.dumpDone.txt", (Object)RB_KEY));
    }

    @Override
    public synchronized Object get(Object key) {
        Object result = this.table.get(Dictionary.map(key));
        if (result == null) {
            throw new NoSuchElementException();
        }
        return Dictionary.unmap(result);
    }

    @Override
    public synchronized Enumeration getItems() {
        return new DictionaryEnumeration(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object getKey(Object item) {
        Object mappedItem = Dictionary.map(item);
        Enumeration enumer = this.table.keys();
        Hashtable hashtable = this.table;
        synchronized (hashtable) {
            while (enumer.hasMoreElements()) {
                Object key = enumer.nextElement();
                Object object = this.table.get(key);
                if (!Util.equal(object, (Object)mappedItem)) continue;
                return key;
            }
        }
        throw new NoSuchElementException();
    }

    @Override
    public synchronized Enumeration getKeys(Object item) {
        return new KeyEnum(this, item);
    }

    @Override
    public Enumeration getKeys() {
        return new Enumeration(){
            Enumeration keys;
            {
                this.keys = Dictionary.this.table.keys();
            }

            @Override
            public boolean hasMoreElements() {
                return this.keys.hasMoreElements();
            }

            public Object nextElement() {
                return BaseCollection.unmap(this.keys.nextElement());
            }
        };
    }

    @Override
    public synchronized boolean remove(Object item) {
        Object key = this.getKey(Dictionary.map(item));
        if (key != null) {
            this.table.remove(Dictionary.map(key));
            if (this.anyContentsChangedListeners()) {
                this.fireContentsChanged(new DictionaryChangedInfo(this, HowChanged.REMOVED, item));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int removeAll(Object item) {
        int itemsRemoved = 0;
        Hashtable hashtable = this.table;
        synchronized (hashtable) {
            while (this.contains(item)) {
                Object key = this.getKey(item);
                this.table.remove(Dictionary.map(key));
                ++itemsRemoved;
            }
        }
        if (itemsRemoved > 0 && this.anyContentsChangedListeners()) {
            this.fireContentsChanged(new DictionaryChangedInfo(this, HowChanged.REMOVED, item));
        }
        return itemsRemoved;
    }

    @Override
    public synchronized void removeAt(Object key) {
        Object value = null;
        try {
            boolean anyListeners = this.anyContentsChangedListeners();
            if (anyListeners) {
                value = this.get(key);
            }
            this.table.remove(Dictionary.map(key));
            if (anyListeners) {
                this.fireContentsChanged(new DictionaryChangedInfo(this, HowChanged.REMOVED, key, value, null));
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void set(Object key, Object item) {
        Object item_ = Dictionary.map(item);
        Object key_ = Dictionary.map(key);
        Object oldValue = null;
        boolean anyListeners = this.anyContentsChangedListeners();
        boolean containsKey = false;
        if (anyListeners && (containsKey = this.table.containsKey(key_))) {
            oldValue = Dictionary.unmap(this.table.get(key_));
        }
        this.table.put(key_, item_);
        if (anyListeners) {
            if (containsKey) {
                this.fireContentsChanged(new DictionaryChangedInfo(this, HowChanged.REPLACED, key, oldValue, item));
            } else {
                this.fireContentsChanged(new DictionaryChangedInfo(this, HowChanged.ADDED, item, null, item));
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Dictionary newDict = (Dictionary)super.clone();
        newDict.table = (Hashtable)this.table.clone();
        return newDict;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone(DeepCloneSupport support, boolean deeply) throws CloneNotSupportedException {
        Dictionary dictionary = this;
        synchronized (dictionary) {
            Dictionary clone = (Dictionary)super.clone();
            if (support != null) {
                support.register((Object)this, (Object)clone);
            }
            if (deeply) {
                try {
                    Dictionary dictionary2 = clone;
                    synchronized (dictionary2) {
                        clone.table = new Hashtable();
                        Enumeration keys = this.getKeys();
                        while (keys.hasMoreElements()) {
                            Object key = keys.nextElement();
                            Object clonedKey = support.clone(key, true);
                            Object value = this.get(key);
                            Object clonedValue = support.clone(value, true);
                            clone.set(clonedKey, clonedValue);
                        }
                    }
                }
                catch (NullPointerException e) {
                    throw new CloneNotSupportedException("support == null");
                }
            }
            return clone;
        }
    }

    public String toString() {
        return (String)StaticDictionaryInterfaceToStringTransform.defaultInstance.transform(this);
    }

    public synchronized String toString(char delimiter, char separator, boolean alwaysQuote) {
        if (delimiter == ',' && separator == '=' && alwaysQuote) {
            return (String)StaticDictionaryInterfaceToStringTransform.defaultInstance.transform(this);
        }
        return (String)new StaticDictionaryInterfaceToStringTransform(delimiter, separator, alwaysQuote).transform(this);
    }
}

