/*
 * Decompiled with CFR 0.152.
 */
package com.sas.collection;

import com.sas.Component;
import com.sas.collection.BaseCollection;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedListenerList;
import com.sas.collection.ContentsChangedSource;

public abstract class CollectionMirror
extends BaseCollection
implements ContentsChangedListener {
    static final long serialVersionUID = 5755295607940619156L;
    private ContentsChangedSource source;

    protected CollectionMirror(ContentsChangedSource source) {
        if (source == null) {
            throw new IllegalArgumentException("source == null");
        }
        this.source = source;
    }

    protected final ContentsChangedSource getSource() {
        return this.source;
    }

    @Override
    public void addContentsChangedListener(ContentsChangedListener listener) {
        if (this.allContentsChangedListeners == null) {
            this.allContentsChangedListeners = new ContentsChangedListenerList();
            this.source.addContentsChangedListener((ContentsChangedListener)this);
        }
        this.allContentsChangedListeners.add(listener);
    }

    @Override
    public void removeContentsChangedListener(ContentsChangedListener listener) {
        if (this.allContentsChangedListeners != null) {
            this.allContentsChangedListeners.remove(listener);
            if (0 == this.allContentsChangedListeners.count()) {
                this.source.removeContentsChangedListener((ContentsChangedListener)this);
                this.allContentsChangedListeners = null;
            }
        }
    }

    public void contentsChanged(ContentsChangedEvent event) {
        if (event.getSource() == this.source && this.anyContentsChangedListeners()) {
            this.fireContentsChanged(new ContentsChangedEvent((Object)this));
        }
    }

    public String toString() {
        return this.source.toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CollectionMirror clone = (CollectionMirror)super.clone();
        this.source = (ContentsChangedSource)Component.clone(this.source);
        return clone;
    }

    public int hashCode() {
        return this.source.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return this.source.equals(object);
    }
}

