/*
 * Decompiled with CFR 0.152.
 */
package com.sas.collection;

import com.sas.DeepClonable;
import com.sas.DeepCloneSupport;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.BaseCollection;
import com.sas.collection.CollectionChangedInfo;
import com.sas.collection.CollectionInterface;
import com.sas.collection.Dictionary;
import com.sas.collection.HowChanged;
import com.sas.collection.OrderedCollection;
import com.sas.collection.PrintContents;
import com.sas.collection.RB;
import com.sas.collection.StaticCollectionInterface;
import com.sas.text.Message;
import com.sas.util.ApplyInterface;
import com.sas.util.IndexedGetInterface;
import com.sas.util.transforms.StaticCollectionInterfaceToStringTransform;
import com.sas.util.transforms.StringToCollectionInterfaceTransform;
import com.sas.util.transforms.TransformException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.ResourceBundle;

public class Collection
extends BaseCollection
implements CollectionInterface,
DeepClonable {
    public static final String RB_KEY = "Collection.";
    static final long serialVersionUID = -91820685694960135L;
    private OrderedCollection orderedCollection;
    private Dictionary dictionary;
    private boolean isSet;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "set"}, {"Default value", "false"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"set.pd.txt")}, {"Hidden", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.shortDescription = RB.getStringResource((String)RB_KEY, (String)"description.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public Collection() {
        this(false);
    }

    public Collection(boolean isSet) {
        this.isSet = isSet;
        if (isSet) {
            this.dictionary = new Dictionary();
        } else {
            this.orderedCollection = new OrderedCollection();
        }
    }

    public Collection(String data, boolean isSet) {
        this(isSet);
        try {
            new StringToCollectionInterfaceTransform().transform(this, data);
        }
        catch (TransformException te) {
            throw new IllegalArgumentException(te.getMessage());
        }
    }

    public Collection(String data) {
        this(data, false);
    }

    public boolean isSet() {
        return this.isSet;
    }

    @Override
    public synchronized void add(Object item) {
        if (this.isSet() && this.contains(item)) {
            return;
        }
        int lengthBefore = this.count();
        if (this.isSet()) {
            this.dictionary.set(this.key(item), item);
        } else {
            this.orderedCollection.add(item);
        }
        int lengthAfter = this.count();
        if (lengthAfter != lengthBefore && this.anyContentsChangedListeners()) {
            this.fireContentsChanged(new CollectionChangedInfo((Object)this, item, HowChanged.ADDED, lengthAfter - 1));
        }
    }

    @Override
    public synchronized void addItems(Enumeration items) {
        int lengthAfter;
        int lengthBefore = this.count();
        if (this.isSet()) {
            while (items.hasMoreElements()) {
                Object item = items.nextElement();
                this.dictionary.set(this.key(item), item);
            }
        } else {
            this.orderedCollection.addItems(items);
        }
        if ((lengthAfter = this.count()) != lengthBefore && this.anyContentsChangedListeners()) {
            this.fireContentsChanged(new CollectionChangedInfo((Object)this, HowChanged.ADDED, lengthBefore, lengthAfter));
        }
    }

    @Override
    public synchronized void apply(ApplyInterface action) {
        if (this.isSet()) {
            this.dictionary.apply(action);
        } else {
            this.orderedCollection.apply(action);
        }
    }

    @Override
    public synchronized void removeAll() {
        int len = this.count();
        if (len > 0) {
            if (this.isSet()) {
                this.dictionary.removeAll();
            } else {
                this.orderedCollection.removeAll();
            }
            if (this.anyContentsChangedListeners()) {
                this.fireContentsChanged(new CollectionChangedInfo((Object)this, HowChanged.REMOVED, 0, len));
            }
        }
    }

    private Object key(Object item) {
        return item == null ? null : new Integer(System.identityHashCode(item));
    }

    @Override
    public synchronized boolean contains(Object item) {
        return this.isSet() ? this.dictionary.containsKey(this.key(item)) : this.orderedCollection.contains(item);
    }

    @Override
    public synchronized int count() {
        return this.isSet() ? this.dictionary.count() : this.orderedCollection.count();
    }

    @Override
    public void dumpComponent() {
        System.out.println(Message.format((ResourceBundle)com.sas.RB.getResources(), (String)"ComponentInterface.dumpStarting.txt", (Object)RB_KEY));
        super.dumpComponent();
        this.apply(new PrintContents(new PrintWriter(System.out)));
        System.out.println(Message.format((ResourceBundle)com.sas.RB.getResources(), (String)"ComponentInterface.dumpDone.txt", (Object)RB_KEY));
    }

    @Override
    public synchronized Enumeration getItems() {
        return this.isSet() ? this.dictionary.getItems() : this.orderedCollection.getItems();
    }

    @Override
    public synchronized boolean remove(Object item) {
        if (this.isSet()) {
            if (this.dictionary.contains(item)) {
                this.dictionary.remove(item);
                if (this.anyContentsChangedListeners()) {
                    this.fireContentsChanged(new CollectionChangedInfo((Object)this, item, HowChanged.REMOVED));
                }
                return true;
            }
        } else {
            int index = this.orderedCollection.getIndex(item, 0);
            if (index >= 0) {
                this.orderedCollection.removeAt(index);
                if (this.anyContentsChangedListeners()) {
                    this.fireContentsChanged(new CollectionChangedInfo((Object)this, item, HowChanged.REMOVED, index));
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized int removeAll(Object item) {
        int numRemoved;
        int n = numRemoved = this.isSet() ? this.dictionary.removeAll(item) : this.orderedCollection.removeAll(item);
        if (numRemoved > 0 && this.anyContentsChangedListeners()) {
            this.fireContentsChanged(new CollectionChangedInfo((Object)this, item, HowChanged.REMOVED));
        }
        return numRemoved;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Collection newCollection = (Collection)super.clone();
        if (this.isSet()) {
            newCollection.dictionary = (Dictionary)this.dictionary.clone();
        } else {
            newCollection.orderedCollection = (OrderedCollection)this.orderedCollection.clone();
        }
        newCollection.allContentsChangedListeners = null;
        return newCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone(DeepCloneSupport support, boolean deeply) throws CloneNotSupportedException {
        Collection collection = this;
        synchronized (collection) {
            Collection clone = (Collection)this.clone();
            if (support != null) {
                support.register((Object)this, (Object)clone);
            }
            if (deeply) {
                try {
                    Collection collection2 = clone;
                    synchronized (collection2) {
                        if (this.orderedCollection != null) {
                            clone.orderedCollection = (OrderedCollection)support.clone((DeepClonable)this.orderedCollection, true);
                        } else if (this.dictionary != null) {
                            clone.dictionary = (Dictionary)support.clone((DeepClonable)this.dictionary, true);
                        }
                    }
                }
                catch (NullPointerException e) {
                    throw new CloneNotSupportedException("support == null");
                }
            }
            return clone;
        }
    }

    public String toString() {
        return (String)StaticCollectionInterfaceToStringTransform.defaultInstance.transform(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object toArray(StaticCollectionInterface collection) {
        Collection coll;
        if (collection instanceof IndexedGetInterface) {
            return OrderedCollection.toArray((IndexedGetInterface)((Object)collection));
        }
        if (collection instanceof Collection && !(coll = (Collection)collection).isSet()) {
            return coll.orderedCollection.toArray();
        }
        StaticCollectionInterface staticCollectionInterface = collection;
        synchronized (staticCollectionInterface) {
            OrderedCollection oc = new OrderedCollection();
            oc.addItems(collection.getItems());
            return oc.toArray();
        }
    }
}

