/*
 * Decompiled with CFR 0.152.
 */
package com.sas.collection;

import com.sas.Component;
import com.sas.GlobalInfoTable;
import com.sas.PublicClonable;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedListenerList;
import com.sas.collection.NullWrapper;
import com.sas.collection.StaticCollectionInterface;
import com.sas.util.ApplyInterface;
import com.sas.util.EventGateInterface;
import com.sas.util.Util;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;

public abstract class BaseCollection
extends Component
implements StaticCollectionInterface,
Serializable,
EventGateInterface,
PublicClonable {
    static final long serialVersionUID = 130278849639871334L;
    private int pendingEventGateCount = 0;
    protected static final Object mappingObject = new NullWrapper();
    private static Class nullWrapperClass;
    protected transient ContentsChangedListenerList allContentsChangedListeners;

    public abstract int count();

    public abstract Enumeration getItems();

    @Override
    public boolean contains(Object element) {
        Enumeration enumer = this.getItems();
        while (enumer.hasMoreElements()) {
            if (!Util.equal((Object)element, enumer.nextElement())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        BaseCollection cloned = (BaseCollection)super.clone();
        cloned.allContentsChangedListeners = null;
        cloned.pendingEventGateCount = 0;
        return cloned;
    }

    @Override
    public void apply(ApplyInterface action) {
        Object object;
        Enumeration e = this.getItems();
        if (e == null) {
            return;
        }
        while (e.hasMoreElements() && 1 != action.apply(object = e.nextElement())) {
        }
        if (this.anyContentsChangedListeners()) {
            this.fireContentsChanged(new ContentsChangedEvent((Object)this));
        }
    }

    protected static Object map(Object o) {
        return o == null ? mappingObject : o;
    }

    protected static Object unmap(Object o) {
        return o.getClass() == nullWrapperClass ? null : o;
    }

    public void addContentsChangedListener(ContentsChangedListener listener) {
        if (this.allContentsChangedListeners == null) {
            this.allContentsChangedListeners = new ContentsChangedListenerList();
        }
        this.allContentsChangedListeners.add(listener);
    }

    public void removeContentsChangedListener(ContentsChangedListener listener) {
        if (this.allContentsChangedListeners != null) {
            this.allContentsChangedListeners.remove(listener);
        }
    }

    protected void fireContentsChanged(ContentsChangedEvent event) {
        if (this.pendingEventGateCount > 0) {
            return;
        }
        if (this.allContentsChangedListeners != null) {
            this.allContentsChangedListeners.contentsChanged(event);
        }
        this.firePropertyChange((PropertyChangeEvent)event);
    }

    protected boolean anyContentsChangedListeners() {
        return this.pendingEventGateCount == 0 && (this.allContentsChangedListeners != null && this.allContentsChangedListeners.count() > 0 || this.anyPropertyChangeListeners());
    }

    public void disableEvents() {
        ++this.pendingEventGateCount;
    }

    public synchronized void enableEvents() {
        if (this.pendingEventGateCount > 0) {
            --this.pendingEventGateCount;
            if (this.anyContentsChangedListeners()) {
                this.fireContentsChanged(new ContentsChangedEvent((Object)this));
            }
        }
    }

    public synchronized void enableEvents(ContentsChangedEvent event) {
        if (this.pendingEventGateCount > 0) {
            --this.pendingEventGateCount;
            if (event != null && this.anyContentsChangedListeners()) {
                this.fireContentsChanged(event);
            }
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.pendingEventGateCount = 0;
    }

    static {
        try {
            nullWrapperClass = GlobalInfoTable._loadClass((String)"com.sas.collection.NullWrapper");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

