/*
 * Decompiled with CFR 0.152.
 */
package com.sas.collection;

import com.sas.DeepClonable;
import com.sas.DeepCloneSupport;
import com.sas.GlobalInfoTable;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.ALEnum;
import com.sas.collection.ALPairEnum;
import com.sas.collection.AssociationListInterface;
import com.sas.collection.BaseCollection;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.OrderedCollection;
import com.sas.collection.OrderedCollectionInterface;
import com.sas.collection.Pair;
import com.sas.collection.RB;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.lang.IntegerData;
import com.sas.text.Message;
import com.sas.util.ApplyInterface;
import com.sas.util.ArrayAccess;
import com.sas.util.Classes;
import com.sas.util.Comparator;
import com.sas.util.IndexedSetInterface;
import com.sas.util.Sort;
import com.sas.util.Util;
import com.sas.util.transforms.StaticDictionaryInterfaceToStringTransform;
import com.sas.util.transforms.StringToDictionaryInterfaceTransform;
import com.sas.util.transforms.TransformException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;

public class AssociationList
extends BaseCollection
implements AssociationListInterface,
DeepClonable {
    public static final String RB_KEY = "AssociationList.";
    static final long serialVersionUID = 4505387688312853125L;
    protected OrderedCollectionInterface items;
    protected OrderedCollectionInterface keys;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "pairs"}, {"Default value", "null"}, {"Description", RB.getStringResource((String)"pairs.pd.txt")}, {"Hidden", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.shortDescription = RB.getStringResource((String)RB_KEY, (String)"description.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public AssociationList() {
        this.items = new OrderedCollection();
        this.keys = new OrderedCollection();
    }

    public AssociationList(Class orderedCollectionClass) {
        Class orderedCollectionInterfaceClass = GlobalInfoTable._loadClass((String)"com.sas.collection.OrderedCollectionInterface");
        if (!Classes.implementsInterface((Class)orderedCollectionClass, (Class)orderedCollectionInterfaceClass)) {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"notImplements.ex.txt"), (Object)orderedCollectionClass.getName(), (Object)orderedCollectionInterfaceClass.getName()));
        }
        try {
            this.items = (OrderedCollectionInterface)orderedCollectionClass.newInstance();
            this.keys = (OrderedCollectionInterface)orderedCollectionClass.newInstance();
        }
        catch (Exception ie) {
            throw new IllegalArgumentException(ie.getMessage());
        }
    }

    public AssociationList(String data) {
        this();
        try {
            StringToDictionaryInterfaceTransform.defaultInstance.transform(this, data);
        }
        catch (TransformException te) {
            throw new IllegalArgumentException(te.getMessage());
        }
    }

    protected void fireContentsChanged(ContentsChangedEvent event, boolean notifyItemsChanged, boolean notifyKeysChanged) {
        super.fireContentsChanged(event);
    }

    @Override
    public synchronized void set(int index, Object key, Object item) {
        this.keys.set(index, key);
        this.items.set(index, item);
        if (this.anyContentsChangedListeners()) {
            this.fireContentsChanged(new ContentsChangedEvent((Object)this), true, true);
        }
    }

    @Override
    public synchronized void add(int index, Object key, Object item) {
        this.keys.add(key, index);
        this.items.add(item, index);
        if (this.anyContentsChangedListeners()) {
            this.fireContentsChanged(new ContentsChangedEvent((Object)this), true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void removeAllAt(Object key) {
        OrderedCollectionInterface orderedCollectionInterface = this.items;
        synchronized (orderedCollectionInterface) {
            int length = this.items.count();
            if (length == 0) {
                return;
            }
            OrderedCollectionInterface orderedCollectionInterface2 = this.keys;
            synchronized (orderedCollectionInterface2) {
                OrderedCollectionInterface orderedCollectionInterface3 = this.items;
                synchronized (orderedCollectionInterface3) {
                    int index = this.keys.getIndex(key, 0);
                    while (index != -1 && index < length) {
                        this.keys.removeAt(index);
                        this.items.removeAt(index);
                        --length;
                        if (this.anyContentsChangedListeners()) {
                            this.fireContentsChanged(new ContentsChangedEvent((Object)this), true, true);
                        }
                        if (index >= length) break;
                        index = this.keys.getIndex(key, index);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int removeAll(Object item) {
        int itemsRemoved = 0;
        OrderedCollectionInterface orderedCollectionInterface = this.items;
        synchronized (orderedCollectionInterface) {
            int length = this.items.count();
            if (length == 0) {
                return 0;
            }
            int index = this.items.getIndex(item, 0);
            OrderedCollectionInterface orderedCollectionInterface2 = this.keys;
            synchronized (orderedCollectionInterface2) {
                while (index != -1 && index < length) {
                    this.items.removeAt(index);
                    this.keys.removeAt(index);
                    --length;
                    ++itemsRemoved;
                    if (this.anyContentsChangedListeners()) {
                        this.fireContentsChanged(new ContentsChangedEvent((Object)this), true, true);
                    }
                    if (index >= length) continue;
                    index = this.items.getIndex(item, index);
                }
                return itemsRemoved;
            }
        }
    }

    @Override
    public synchronized void add(Object item) {
        this.add(item, this.count());
    }

    @Override
    public synchronized void addItems(Enumeration newItems) {
        this.addItems(newItems, this.count());
    }

    @Override
    public synchronized void apply(ApplyInterface action) {
        this.items.apply(action);
    }

    @Override
    public synchronized void removeAll() {
        if (this.count() == 0) {
            return;
        }
        this.items.removeAll();
        this.keys.removeAll();
        if (this.anyContentsChangedListeners()) {
            this.fireContentsChanged(new ContentsChangedEvent((Object)this), true, true);
        }
    }

    @Override
    public synchronized boolean contains(Object item) {
        return this.items.contains(item);
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return this.keys.contains(key);
    }

    @Override
    public synchronized int count() {
        return this.items.count();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int count(Object value) {
        int n = 0;
        OrderedCollectionInterface orderedCollectionInterface = this.items;
        synchronized (orderedCollectionInterface) {
            int itemsLen = this.items.count();
            for (int i = 0; i < itemsLen; ++i) {
                Object item = this.items.get(i);
                if (!Util.equal((Object)value, (Object)item)) continue;
                ++n;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int countKey(Object key) {
        int n = 0;
        OrderedCollectionInterface orderedCollectionInterface = this.keys;
        synchronized (orderedCollectionInterface) {
            int keysLen = this.keys.count();
            for (int i = 0; i < keysLen; ++i) {
                Object item = this.keys.get(i);
                if (!Util.equal((Object)key, (Object)item)) continue;
                ++n;
            }
        }
        return n;
    }

    @Override
    public synchronized void dumpComponent() {
        System.out.println(Message.format((ResourceBundle)com.sas.RB.getResources(), (String)"ComponentInterface.dumpStarting.txt", (Object)RB_KEY));
        super.dumpComponent();
        IntegerData id = new IntegerData(0);
        for (int i = 0; i < this.count(); ++i) {
            id.setIntegerData(i);
            System.out.println(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"printKey.txt"), (Object)id, (Object)("" + this.getKey(i))));
            System.out.println(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"printValue.txt"), (Object)id, (Object)("" + this.get(i))));
        }
        System.out.println(Message.format((ResourceBundle)com.sas.RB.getResources(), (String)"ComponentInterface.dumpStarting.txt", (Object)RB_KEY));
    }

    @Override
    public Object get(int index) {
        return this.items.get(index);
    }

    @Override
    public synchronized Object get(Object key) {
        int index = this.keys.getIndex(key, 0);
        if (index == -1) {
            throw new NoSuchElementException();
        }
        Object result = this.items.get(index);
        return result;
    }

    @Override
    public synchronized Object get(Object key, int index) {
        int foundIndex = 0;
        foundIndex = this.keys.getIndex(key, index);
        Object result = null;
        try {
            result = this.items.get(foundIndex);
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
        return result;
    }

    @Override
    public synchronized Enumeration getItems() {
        return this.items.getItems();
    }

    @Override
    public synchronized Enumeration getItems(int start, int end) {
        return this.items.getItems(start, end);
    }

    @Override
    public synchronized Object getKey(Object item) {
        return this.getKey(item, 0);
    }

    @Override
    public synchronized Object getKey(Object item, int start) {
        int index = 0;
        index = this.items.getIndex(item, start);
        try {
            return this.keys.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public Object getKey(int index) {
        return this.keys.get(index);
    }

    @Override
    public synchronized void setKey(int index, Object key) {
        this.keys.set(index, key);
    }

    @Override
    public synchronized Enumeration getKeys(Object item) {
        return new ALEnum(this, item);
    }

    @Override
    public Enumeration getKeys() {
        return this.keys.getItems();
    }

    @Override
    public synchronized boolean remove(Object item) {
        int index = this.items.getIndex(item, 0);
        if (index == -1) {
            return false;
        }
        this.removeAt(index);
        return true;
    }

    public synchronized void removeAt(Object key, int start) {
        int index = this.keys.getIndex(key, start);
        if (index >= 0) {
            this.removeAt(index);
        }
    }

    @Override
    public synchronized void removeAt(Object key) {
        this.removeAt(key, 0);
    }

    @Override
    public synchronized int getIndex(Object element, int startIndex) {
        return this.items.getIndex(element, startIndex);
    }

    @Override
    public synchronized int getLastIndex(Object element, int startIndex) {
        return this.items.getLastIndex(element, startIndex);
    }

    @Override
    public synchronized void set(Object key, Object item) {
        int index = this.keys.getIndex(key, 0);
        if (index >= 0) {
            this.items.set(index, item);
            if (this.anyContentsChangedListeners()) {
                this.fireContentsChanged(new ContentsChangedEvent((Object)this), true, true);
            }
        } else {
            this.items.add(item);
            this.keys.add(key);
            if (this.anyContentsChangedListeners()) {
                this.fireContentsChanged(new ContentsChangedEvent((Object)this), true, true);
            }
        }
    }

    @Override
    public synchronized Object clone() throws CloneNotSupportedException {
        AssociationList newAlist = (AssociationList)super.clone();
        newAlist.items = (OrderedCollectionInterface)this.items.clone();
        newAlist.keys = (OrderedCollectionInterface)this.keys.clone();
        return newAlist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone(DeepCloneSupport support, boolean deeply) throws CloneNotSupportedException {
        AssociationList associationList = this;
        synchronized (associationList) {
            AssociationList clone = (AssociationList)this.clone();
            if (support != null) {
                support.register((Object)this, (Object)clone);
            }
            if (deeply) {
                try {
                    AssociationList associationList2 = clone;
                    synchronized (associationList2) {
                        clone.items = (OrderedCollectionInterface)support.clone((Object)this.items, true);
                        clone.keys = (OrderedCollectionInterface)support.clone((Object)this.keys, true);
                    }
                }
                catch (NullPointerException e) {
                    throw new CloneNotSupportedException("support == null");
                }
            }
            return clone;
        }
    }

    @Override
    public synchronized boolean equals(StaticOrderedCollectionInterface orderedCollection) {
        if (orderedCollection == null) {
            return false;
        }
        if (orderedCollection == this) {
            return true;
        }
        if (orderedCollection instanceof AssociationListInterface) {
            return this.equals((AssociationListInterface)orderedCollection);
        }
        return this.items.equals(orderedCollection);
    }

    public synchronized boolean equals(AssociationListInterface otherAssociationList) {
        if (otherAssociationList == null) {
            return false;
        }
        if (otherAssociationList == this) {
            return true;
        }
        if (otherAssociationList instanceof AssociationList) {
            return Util.equal((Object)this.items, (Object)((AssociationList)otherAssociationList).items) && Util.equal((Object)this.keys, (Object)((AssociationList)otherAssociationList).keys);
        }
        return Util.equal((Enumeration)this.getKeys(), (Enumeration)otherAssociationList.getKeys()) && Util.equal((Enumeration)this.getItems(), (Enumeration)otherAssociationList.getItems());
    }

    public synchronized boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof AssociationListInterface) {
            return this.equals((AssociationListInterface)object);
        }
        if (object instanceof StaticOrderedCollectionInterface) {
            return this.equals((StaticOrderedCollectionInterface)object);
        }
        return false;
    }

    @Override
    public void add(Object item, int index) {
        this.items.add(item, index);
        this.keys.add(item, index);
        if (this.anyContentsChangedListeners()) {
            this.fireContentsChanged(new ContentsChangedEvent((Object)this), true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addItems(Enumeration enumer, int index) {
        boolean added = false;
        OrderedCollectionInterface orderedCollectionInterface = this.items;
        synchronized (orderedCollectionInterface) {
            OrderedCollectionInterface orderedCollectionInterface2 = this.keys;
            synchronized (orderedCollectionInterface2) {
                try {
                    this.disableEvents();
                    while (enumer.hasMoreElements()) {
                        Object item = enumer.nextElement();
                        this.add(index, item, item);
                        ++index;
                        added = true;
                    }
                }
                finally {
                    this.enableEvents(null);
                    if (added && this.anyContentsChangedListeners()) {
                        this.fireContentsChanged(new ContentsChangedEvent((Object)this), true, true);
                    }
                }
            }
        }
    }

    @Override
    public synchronized Object removeAt(int index) {
        Object object = this.get(index);
        this.items.removeAt(index);
        this.keys.removeAt(index);
        if (this.anyContentsChangedListeners()) {
            this.fireContentsChanged(new ContentsChangedEvent((Object)this), true, true);
        }
        return object;
    }

    @Override
    public synchronized void set(int index, Object item) {
        this.items.set(index, item);
        if (this.anyContentsChangedListeners()) {
            this.fireContentsChanged(new ContentsChangedEvent((Object)this), true, true);
        }
    }

    @Override
    public synchronized void setSize(int newSize) {
        int oldSize = this.count();
        if (oldSize == newSize) {
            return;
        }
        this.items.setSize(newSize);
        this.keys.setSize(newSize);
        if (this.anyContentsChangedListeners()) {
            this.fireContentsChanged(new ContentsChangedEvent((Object)this), true, true);
        }
    }

    @Override
    public void sort(Comparator comparator) {
        this.sort(comparator, 0, this.count());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sort(Comparator comparator, int start, int end) {
        OrderedCollectionInterface orderedCollectionInterface;
        int nItems = end - start;
        if (nItems == 0) {
            return;
        }
        Object[] pairs = new Pair[nItems];
        OrderedCollectionInterface orderedCollectionInterface2 = this.items;
        synchronized (orderedCollectionInterface2) {
            orderedCollectionInterface = this.keys;
            synchronized (orderedCollectionInterface) {
                int i = end - 1;
                for (int j = nItems - 1; j >= 0; --j) {
                    pairs[j] = new Pair(this.keys.get(i), this.items.get(i));
                    --i;
                }
            }
        }
        Sort sort = new Sort((IndexedSetInterface)new ArrayAccess(pairs), comparator);
        sort.sort(0, nItems);
        orderedCollectionInterface = this.items;
        synchronized (orderedCollectionInterface) {
            OrderedCollectionInterface orderedCollectionInterface3 = this.keys;
            synchronized (orderedCollectionInterface3) {
                int i = end - 1;
                for (int j = nItems - 1; j >= 0; --j) {
                    Object pair = pairs[j];
                    this.keys.set(i, pair.getFirst());
                    this.items.set(i, pair.getSecond());
                    --i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void applyToPairs(ApplyInterface action) {
        Pair pair = new Pair();
        OrderedCollectionInterface orderedCollectionInterface = this.items;
        synchronized (orderedCollectionInterface) {
            OrderedCollectionInterface orderedCollectionInterface2 = this.keys;
            synchronized (orderedCollectionInterface2) {
                for (int i = 0; i < this.count(); ++i) {
                    pair.setcar(this.keys.get(i));
                    pair.setcdr(this.items.get(i));
                    action.apply((Object)pair);
                }
            }
        }
    }

    @Override
    public Enumeration getPairs() {
        return this.getPairs(0, -1);
    }

    @Override
    public Enumeration getPairs(int start, int end) {
        return new ALPairEnum(this, start, end);
    }

    public String toString() {
        return (String)StaticDictionaryInterfaceToStringTransform.defaultInstance.transform(this);
    }

    public synchronized String toString(char delimiter, char separator, boolean alwaysQuote) {
        if (delimiter == ',' && separator == '=' && alwaysQuote) {
            return (String)StaticDictionaryInterfaceToStringTransform.defaultInstance.transform(this);
        }
        return (String)new StaticDictionaryInterfaceToStringTransform(delimiter, separator, alwaysQuote).transform(this);
    }
}

