/*
 * Decompiled with CFR 0.152.
 */
package com.sas.awt;

import com.sas.ComponentInterfaceSupport;
import com.sas.PublicClonable;
import com.sas.awt.ColorComponent;
import com.sas.awt.RB;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.models.NodeIconInterface;
import com.sas.models.RGBList;
import com.sas.models.SimpleNodeInterface;
import com.sas.visuals.IconInterface;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.SystemColor;
import java.io.IOException;
import java.io.ObjectInputStream;

public class Color
extends ColorComponent
implements PublicClonable,
NodeIconInterface,
IconInterface {
    static final long serialVersionUID = -1775887098600931719L;
    private static RGBList colorList = new RGBList();
    public static Color windowBorder = new Color(SystemColor.windowBorder);
    public static Color controlHighlight = new Color(SystemColor.controlHighlight);
    public static Color controlShadow = new Color(SystemColor.controlShadow);
    public static Color control = new Color(SystemColor.control);
    public static Color controlText = new Color(SystemColor.controlText);
    static final String RB_KEY = "Color.";
    protected String name;
    protected static String NODETYPE = RB.getStringResource("Color.", "nodeType.txt");

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = RB.getStringResource(RB_KEY, "default.pd.txt");
        ebi.defaultOutputPropertyName = RB.getStringResource(RB_KEY, "default.pd.txt");
        ebi.shortDescription = RB.getStringResource(RB_KEY, "description.pd.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public static void addColor(String name, int hexValue) {
        name = name.toLowerCase();
        colorList.add(name, hexValue);
    }

    public static Color newColor(java.awt.Color jcolor) {
        int rgb = jcolor.getRGB();
        colorList.add(rgb);
        return new Color(rgb);
    }

    public static Color newColor(String colorName) {
        return Color.getColorObject(colorName);
    }

    private static Color getColorObject(String name) {
        int tempNameLength;
        if (colorList.containsKey(name = name.toLowerCase())) {
            return new Color(name, (Integer)colorList.get(name));
        }
        String tempName = name;
        if (name.startsWith("0x") || name.startsWith("cx")) {
            tempName = name.substring(2, name.length());
        }
        if ((tempNameLength = tempName.length()) > 8) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "illegal.ex.txt"));
        }
        if (tempNameLength > 6) {
            tempName = tempName.substring(tempNameLength - 6, tempNameLength);
        }
        try {
            Integer o = Integer.valueOf(tempName, 16);
            java.awt.Color j = new java.awt.Color(o);
            Integer I = new Integer(j.getRGB());
            if (!colorList.contains(I)) {
                colorList.add(tempName, (int)I);
            }
            return Color.newColor(j);
        }
        catch (NumberFormatException ne) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "illegal.ex.txt"));
        }
    }

    public static Color newColor(int rgb) {
        colorList.add(rgb);
        return new Color(rgb);
    }

    public static void merge(RGBList rgbList) {
        colorList.addItems(rgbList.getPairs());
    }

    public static void removeAll() {
        colorList.removeAll();
    }

    public Color() {
        this.initializeComponent();
    }

    public Color(String name) {
        name = name.toLowerCase();
        if (colorList.containsKey(name)) {
            this.name = name;
        } else {
            int tempNameLength;
            String tempName = name;
            if (name.startsWith("0x") || name.startsWith("cx")) {
                tempName = name.substring(2, name.length());
            }
            if ((tempNameLength = tempName.length()) > 8) {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "illegal.ex.txt"));
            }
            if (tempNameLength > 6) {
                tempName = tempName.substring(tempNameLength - 6, tempNameLength);
            }
            try {
                Integer o = Integer.valueOf(tempName, 16);
                java.awt.Color j = new java.awt.Color(o);
                Integer I = new Integer(j.getRGB());
                if (colorList.contains(I)) {
                    this.name = (String)colorList.getKey(I);
                } else {
                    this.name = tempName;
                    colorList.add(tempName, (int)I);
                }
            }
            catch (NumberFormatException ne) {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "illegal.ex.txt"));
            }
        }
    }

    public Color(int hexValue) {
        super(hexValue);
        colorList.add(this.getName(), hexValue);
    }

    public Color(String name, int hexValue) {
        super(hexValue);
        this.name = name.toLowerCase();
        colorList.add(this);
    }

    public Color(int r, int g, int b) {
        super(r, g, b);
        colorList.add(this.getRGB());
    }

    public Color(java.awt.Color jc) {
        super(jc.getRGB());
        colorList.add(jc);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        try {
            Color clone = (Color)this.getClass().newInstance();
            ComponentInterfaceSupport.clone(this, clone);
            return clone;
        }
        catch (Exception e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
    }

    @Override
    public boolean equals(Object color) {
        if (color instanceof java.awt.Color) {
            return this.getRGB() == ((java.awt.Color)color).getRGB();
        }
        return false;
    }

    public String getName() {
        if (this.name == null) {
            Integer rgbInteger = new Integer(super.getRGB());
            if (colorList.contains(rgbInteger)) {
                this.name = (String)colorList.getKey(rgbInteger);
            } else {
                this.name = Integer.toHexString(super.getRGB());
                this.name = this.name.substring(2, this.name.length());
                this.name = this.name.toUpperCase();
            }
        }
        return this.name;
    }

    @Override
    public int getRGB() {
        if (super.getRGB() == -1 && this.name != null && !this.name.equals("") && colorList.containsKey(this.name)) {
            return (Integer)colorList.get(this.name);
        }
        return super.getRGB();
    }

    public boolean isHexString() {
        if (this.name != null && this.name.startsWith("0x")) {
            return true;
        }
        String hs = Integer.toHexString(this.getRGB());
        return hs == this.name || hs.equalsIgnoreCase(this.name);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        try {
            if (!colorList.containsKey(this.getName())) {
                Color.getColorObject(this.getName());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public String getNodeExpandedText() {
        return this.name;
    }

    @Override
    public String getNodeText() {
        return this.name;
    }

    @Override
    public String getNodeType() {
        return NODETYPE;
    }

    @Override
    public int countNodeChildren(int maximumChildCount) {
        return 0;
    }

    @Override
    public int getNodeChildCount() {
        return 0;
    }

    @Override
    public boolean isLeafNode() {
        return true;
    }

    @Override
    public SimpleNodeInterface getNodeChild(int index) {
        return null;
    }

    @Override
    public SimpleNodeInterface[] getNodeChildren(int startIndex, int count) {
        return null;
    }

    @Override
    public IconInterface getDefaultIcon() {
        return this;
    }

    @Override
    public IconInterface getExpandedIcon() {
        return this;
    }

    @Override
    public IconInterface getSelectedIcon() {
        return this;
    }

    @Override
    public IconInterface getExpandedSelectedIcon() {
        return this;
    }

    public Dimension getPreferredSize() {
        return new Dimension(16, 16);
    }

    public void paint(Component component, Graphics g, int x, int y, int width, int height) {
        g.setColor(this);
        int[] xpoints = new int[]{x + width / 2, x + width, x + width / 2, x};
        int[] ypoints = new int[]{y, y + height / 2, y + height, y + height / 2};
        g.fillPolygon(xpoints, ypoints, 4);
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }
}

